/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.DecompiledLocalVariable;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.LocalVariablesUtil;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiVariable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

class LocalVariableEvaluator
implements Evaluator {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator");
    private final String f;
    private EvaluationContextImpl e;
    private LocalVariableProxyImpl b;
    private DecompiledLocalVariable d;
    private final boolean c;

    public LocalVariableEvaluator(String string, boolean bl2) {
        this.f = string;
        this.c = bl2;
    }

    /*
     * Loose catch block
     */
    @Override
    public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        StackFrameProxyImpl stackFrameProxyImpl = evaluationContextImpl.getFrameProxy();
        try {
            if (stackFrameProxyImpl == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.no.stackframe", (Object[])new Object[0]));
            }
        }
        catch (EvaluateException evaluateException) {
            throw LocalVariableEvaluator.b((Exception)((Object)evaluateException));
        }
        try {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = null;
            int n2 = -1;
            Object object = null;
            DebugProcessImpl debugProcessImpl = evaluationContextImpl.getDebugProcess();
            boolean bl2 = true;
            while (true) {
                int n3;
                block28: {
                    block26: {
                        try {
                            LocalVariableProxyImpl localVariableProxyImpl;
                            block27: {
                                localVariableProxyImpl = stackFrameProxyImpl.visibleVariableByName(this.f);
                                if (localVariableProxyImpl == null) break block26;
                                try {
                                    block29: {
                                        if (bl2) break block27;
                                        break block29;
                                        catch (EvaluateException evaluateException) {
                                            throw LocalVariableEvaluator.b((Exception)((Object)evaluateException));
                                        }
                                    }
                                    if (!object.equals(LocalVariableEvaluator.a(stackFrameProxyImpl, this.f, evaluationContextImpl.getProject(), debugProcessImpl))) break block26;
                                }
                                catch (EvaluateException evaluateException) {
                                    throw LocalVariableEvaluator.b((Exception)((Object)evaluateException));
                                }
                            }
                            this.b = localVariableProxyImpl;
                            this.e = evaluationContextImpl;
                            return stackFrameProxyImpl.getValue(localVariableProxyImpl);
                        }
                        catch (EvaluateException evaluateException) {
                            try {
                                if (!(evaluateException.getCause() instanceof AbsentInformationException)) {
                                    throw evaluateException;
                                }
                            }
                            catch (EvaluateException evaluateException2) {
                                throw LocalVariableEvaluator.b((Exception)((Object)evaluateException2));
                            }
                            try {
                                Map<DecompiledLocalVariable, Value> map = LocalVariablesUtil.fetchValues(stackFrameProxyImpl, debugProcessImpl, true);
                                for (Map.Entry<DecompiledLocalVariable, Value> entry : map.entrySet()) {
                                    DecompiledLocalVariable decompiledLocalVariable = entry.getKey();
                                    try {
                                        if (!decompiledLocalVariable.getMatchedNames().contains(this.f) && !decompiledLocalVariable.getDefaultName().equals(this.f)) continue;
                                    }
                                    catch (EvaluateException evaluateException3) {
                                        throw LocalVariableEvaluator.b((Exception)((Object)evaluateException3));
                                    }
                                    this.d = decompiledLocalVariable;
                                    this.e = evaluationContextImpl;
                                    return entry.getValue();
                                }
                            }
                            catch (Exception exception) {
                                a.info((Throwable)exception);
                            }
                        }
                    }
                    try {
                        if (!this.c) break;
                        if (!bl2) break block28;
                    }
                    catch (EvaluateException evaluateException) {
                        throw LocalVariableEvaluator.b((Exception)((Object)evaluateException));
                    }
                    object = LocalVariableEvaluator.a(stackFrameProxyImpl, this.f, evaluationContextImpl.getProject(), debugProcessImpl);
                    try {
                        if (object == null) {
                            break;
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw LocalVariableEvaluator.b((Exception)((Object)evaluateException));
                    }
                }
                if (threadReferenceProxyImpl == null) {
                    threadReferenceProxyImpl = stackFrameProxyImpl.threadProxy();
                    n2 = threadReferenceProxyImpl.frameCount() - 1;
                }
                if ((n3 = stackFrameProxyImpl.getFrameIndex()) >= n2 || (stackFrameProxyImpl = threadReferenceProxyImpl.frame(n3 + 1)) == null) break;
                bl2 = false;
            }
            throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.local.variable.missing", (Object[])new Object[]{this.f}));
        }
        catch (EvaluateException evaluateException) {
            this.b = null;
            this.e = null;
            throw evaluateException;
        }
    }

    @Override
    public Modifier getModifier() {
        Modifier modifier;
        block4: {
            modifier = null;
            try {
                try {
                    if (this.b == null && this.d == null) break block4;
                }
                catch (RuntimeException runtimeException) {
                    throw LocalVariableEvaluator.b(runtimeException);
                }
                if (this.e == null) break block4;
            }
            catch (RuntimeException runtimeException) {
                throw LocalVariableEvaluator.b(runtimeException);
            }
            modifier = new Modifier(){

                public boolean canInspect() {
                    return true;
                }

                public boolean canSetValue() {
                    return true;
                }

                /*
                 * Loose catch block
                 */
                public void setValue(Value value) throws ClassNotLoadedException, InvalidTypeException {
                    block10: {
                        StackFrameProxyImpl stackFrameProxyImpl = LocalVariableEvaluator.this.e.getFrameProxy();
                        try {
                            block9: {
                                block8: {
                                    if ($assertionsDisabled) break block8;
                                    try {
                                        block11: {
                                            if (stackFrameProxyImpl != null) break block8;
                                            break block11;
                                            catch (EvaluateException evaluateException) {
                                                throw 1.a(evaluateException);
                                            }
                                        }
                                        throw new AssertionError();
                                    }
                                    catch (EvaluateException evaluateException) {
                                        throw 1.a(evaluateException);
                                    }
                                }
                                try {
                                    if (LocalVariableEvaluator.this.b == null) break block9;
                                    stackFrameProxyImpl.setValue(LocalVariableEvaluator.this.b, value);
                                    break block10;
                                }
                                catch (EvaluateException evaluateException) {
                                    throw 1.a(evaluateException);
                                }
                            }
                            LocalVariablesUtil.setValue(stackFrameProxyImpl.getStackFrame(), LocalVariableEvaluator.this.d.getSlot(), value);
                        }
                        catch (EvaluateException evaluateException) {
                            a.error((Throwable)evaluateException);
                        }
                    }
                }

                public Type getExpectedType() throws ClassNotLoadedException {
                    try {
                        return LocalVariableEvaluator.this.b.getType();
                    }
                    catch (EvaluateException evaluateException) {
                        a.error((Throwable)evaluateException);
                        return null;
                    }
                }

                public NodeDescriptorImpl getInspectItem(Project project2) {
                    return new LocalVariableDescriptorImpl(project2, LocalVariableEvaluator.this.b);
                }

                private static EvaluateException a(EvaluateException evaluateException) {
                    return evaluateException;
                }
            };
        }
        return modifier;
    }

    @Nullable
    private static PsiVariable a(StackFrameProxy stackFrameProxy, String string, Project project2, DebugProcess debugProcess) {
        PsiElement psiElement = ContextUtil.getContextElement(new SimpleStackFrameContext(stackFrameProxy, debugProcess));
        try {
            if (psiElement == null) {
                return null;
            }
        }
        catch (RuntimeException runtimeException) {
            throw LocalVariableEvaluator.b(runtimeException);
        }
        return (PsiVariable)ReadAction.compute(() -> JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(string, psiElement));
    }

    public String toString() {
        return this.f;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

