/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.rt.debugger.ImageSerializer;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.Nullable;

public class ClassLoadingUtils {
    private ClassLoadingUtils() {
    }

    public static ClassLoaderReference getClassLoader(EvaluationContext evaluationContext, DebugProcess debugProcess) throws EvaluateException {
        try {
            ClassType classType = (ClassType)debugProcess.findClass(evaluationContext, "java.net.URLClassLoader", evaluationContext.getClassLoader());
            Method method = classType.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
            ClassLoaderReference classLoaderReference = (ClassLoaderReference)debugProcess.newInstance(evaluationContext, classType, method, Arrays.asList(ClassLoadingUtils.a(evaluationContext), evaluationContext.getClassLoader()));
            DebuggerUtilsEx.keep(classLoaderReference, evaluationContext);
            return classLoaderReference;
        }
        catch (Exception exception) {
            throw new EvaluateException("Error creating evaluation class loader: " + exception, (Throwable)exception);
        }
    }

    public static void defineClass(String string, byte[] byArray, EvaluationContext evaluationContext, DebugProcess debugProcess, ClassLoaderReference classLoaderReference) throws EvaluateException {
        try {
            VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy();
            Method method = ((ClassType)classLoaderReference.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
            StringReference stringReference = virtualMachineProxyImpl.mirrorOf(string);
            DebuggerUtilsEx.keep(stringReference, evaluationContext);
            debugProcess.invokeMethod(evaluationContext, (ObjectReference)classLoaderReference, method, Arrays.asList(stringReference, ClassLoadingUtils.a(byArray, evaluationContext, debugProcess), virtualMachineProxyImpl.mirrorOf(0), virtualMachineProxyImpl.mirrorOf(byArray.length)));
        }
        catch (Exception exception) {
            throw new EvaluateException("Error during class " + string + " definition: " + exception, (Throwable)exception);
        }
    }

    /*
     * Loose catch block
     */
    @Nullable
    public static ClassType getHelperClass(String string, EvaluationContext evaluationContext, DebugProcess debugProcess) throws EvaluateException {
        try {
            ClassLoaderReference classLoaderReference = evaluationContext.getClassLoader();
            return (ClassType)debugProcess.findClass(evaluationContext, string, classLoaderReference);
        }
        catch (EvaluateException evaluateException) {
            block24: {
                InputStream inputStream;
                ClassLoaderReference classLoaderReference;
                block25: {
                    Throwable throwable = evaluateException.getCause();
                    try {
                        if (!(throwable instanceof InvocationException) || !"java.lang.ClassNotFoundException".equals(((InvocationException)throwable).exception().type().name())) break block24;
                    }
                    catch (EvaluateException evaluateException2) {
                        throw ClassLoadingUtils.a(evaluateException2);
                    }
                    classLoaderReference = ClassLoadingUtils.getClassLoader(evaluationContext, debugProcess);
                    inputStream = ImageSerializer.class.getResourceAsStream("/" + string.replaceAll("[.]", "/") + ".class");
                    if (inputStream != null) break block25;
                    ClassType classType = null;
                    try {
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (EvaluateException evaluateException3) {
                            throw ClassLoadingUtils.a(evaluateException3);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return classType;
                }
                ClassLoadingUtils.defineClass(string, StreamUtil.loadFromStream((InputStream)inputStream), evaluationContext, debugProcess, classLoaderReference);
                ((EvaluationContextImpl)evaluationContext).setClassLoader(classLoaderReference);
                ClassType classType = (ClassType)debugProcess.findClass(evaluationContext, string, classLoaderReference);
                try {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (EvaluateException evaluateException4) {
                        throw ClassLoadingUtils.a(evaluateException4);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return classType;
                catch (IOException iOException) {
                    try {
                        throw new EvaluateException("Unable to read " + string + " class bytes", (Throwable)iOException);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (EvaluateException evaluateException5) {
                                throw ClassLoadingUtils.a(evaluateException5);
                            }
                        }
                        catch (IOException iOException2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
            }
            throw evaluateException;
        }
    }

    private static ArrayReference a(EvaluationContext evaluationContext) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        DebugProcess debugProcess = evaluationContext.getDebugProcess();
        ArrayType arrayType = (ArrayType)debugProcess.findClass(evaluationContext, "java.net.URL[]", evaluationContext.getClassLoader());
        ArrayReference arrayReference = arrayType.newInstance(1);
        DebuggerUtilsEx.keep(arrayReference, evaluationContext);
        ClassType classType = (ClassType)debugProcess.findClass(evaluationContext, "java.net.URL", evaluationContext.getClassLoader());
        VirtualMachineProxyImpl virtualMachineProxyImpl = (VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy();
        StringReference stringReference = virtualMachineProxyImpl.mirrorOf("file:a");
        DebuggerUtilsEx.keep(stringReference, evaluationContext);
        ObjectReference objectReference = debugProcess.newInstance(evaluationContext, classType, classType.concreteMethodByName("<init>", "(Ljava/lang/String;)V"), Collections.singletonList(stringReference));
        DebuggerUtilsEx.keep(objectReference, evaluationContext);
        arrayReference.setValues(Collections.singletonList(objectReference));
        return arrayReference;
    }

    private static ArrayReference a(byte[] byArray, EvaluationContext evaluationContext, DebugProcess debugProcess) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        ArrayType arrayType = (ArrayType)debugProcess.findClass(evaluationContext, "byte[]", evaluationContext.getClassLoader());
        ArrayReference arrayReference = debugProcess.newInstance(arrayType, byArray.length);
        DebuggerUtilsEx.keep(arrayReference, evaluationContext);
        ArrayList<ByteValue> arrayList = new ArrayList<ByteValue>(byArray.length);
        for (byte by2 : byArray) {
            arrayList.add(((VirtualMachineProxyImpl)debugProcess.getVirtualMachineProxy()).mirrorOf(by2));
        }
        arrayReference.setValues(arrayList);
        return arrayReference;
    }

    private static EvaluateException a(EvaluateException evaluateException) {
        return evaluateException;
    }
}

