/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SourcePositionHighlighter;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.execution.filters.ExceptionFilters;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.content.Content;
import com.intellij.unscramble.ThreadDumpPanel;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.DocumentUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DebuggerUtilsEx
extends DebuggerUtils {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsEx");
    private static Set<String> d;
    private static int a;
    private static int e;
    private static final String c = "Dump";
    private static final Key<Map<String, String>> f;
    public static final Comparator<Method> LAMBDA_ORDINAL_COMPARATOR;

    public static List<CodeFragmentFactory> getCodeFragmentFactories(@Nullable PsiElement psiElement) {
        DefaultCodeFragmentFactory defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
        CodeFragmentFactory[] codeFragmentFactoryArray = (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME);
        ArrayList<CodeFragmentFactory> arrayList = new ArrayList<CodeFragmentFactory>(codeFragmentFactoryArray.length);
        if (codeFragmentFactoryArray.length > 0) {
            for (CodeFragmentFactory codeFragmentFactory : codeFragmentFactoryArray) {
                try {
                    try {
                        if (codeFragmentFactory == defaultCodeFragmentFactory || !codeFragmentFactory.isContextAccepted(psiElement)) continue;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    arrayList.add(codeFragmentFactory);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
        }
        arrayList.add(defaultCodeFragmentFactory);
        return arrayList;
    }

    public static PsiMethod findPsiMethod(PsiFile psiFile, int n2) {
        PsiElement psiElement = null;
        while (n2 >= 0) {
            psiElement = psiFile.findElementAt(n2);
            try {
                if (psiElement != null) {
                    break;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            --n2;
        }
        while (true) {
            block15: {
                try {
                    block14: {
                        try {
                            try {
                                if (psiElement == null) break;
                                if (psiElement instanceof PsiClass) break block14;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                throw DebuggerUtilsEx.b(patternSyntaxException);
                            }
                            if (!(psiElement instanceof PsiLambdaExpression)) break block15;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                    }
                    return null;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            try {
                if (psiElement instanceof PsiMethod) {
                    return (PsiMethod)psiElement;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            psiElement = psiElement.getParent();
        }
        return null;
    }

    public static boolean isAssignableFrom(@NotNull String string, @NotNull ReferenceType referenceType) {
        boolean bl2;
        try {
            if (string == null) {
                DebuggerUtilsEx.a(0);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (referenceType == null) {
                DebuggerUtilsEx.a(1);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if ("java.lang.Object".equals(string)) {
                return true;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            bl2 = DebuggerUtilsEx.getSuperClass(string, referenceType) != null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return bl2;
    }

    public static ReferenceType getSuperClass(@NotNull String string, @NotNull ReferenceType referenceType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        try {
            if (string == null) {
                DebuggerUtilsEx.a(2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (referenceType == null) {
                DebuggerUtilsEx.a(3);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (string.equals(referenceType.name())) {
                return referenceType;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        if (referenceType instanceof ClassType) {
            object4 = (ClassType)referenceType;
            object3 = object4.superclass();
            if (object3 != null) {
                object2 = DebuggerUtilsEx.getSuperClass(string, (ReferenceType)object3);
                try {
                    if (object2 != null) {
                        return object2;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            object2 = object4.allInterfaces();
            object = object2.iterator();
            while (object.hasNext()) {
                InterfaceType interfaceType = (InterfaceType)object.next();
                ReferenceType referenceType2 = DebuggerUtilsEx.getSuperClass(string, interfaceType);
                try {
                    if (referenceType2 == null) continue;
                    return referenceType2;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
        }
        if (referenceType instanceof InterfaceType) {
            object4 = ((InterfaceType)referenceType).superinterfaces();
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (InterfaceType)object3.next();
                object = DebuggerUtilsEx.getSuperClass(string, (ReferenceType)object2);
                try {
                    if (object == null) continue;
                    return object;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
        }
        return null;
    }

    public static boolean valuesEqual(Value value, Value value2) {
        block14: {
            block11: {
                boolean bl2;
                block13: {
                    block12: {
                        try {
                            try {
                                if (value != null) break block11;
                                if (value2 != null) break block12;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                throw DebuggerUtilsEx.b(patternSyntaxException);
                            }
                            bl2 = true;
                            break block13;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                    }
                    bl2 = false;
                }
                return bl2;
            }
            try {
                if (value2 == null) {
                    return false;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            try {
                try {
                    if (!(value instanceof StringReference) || !(value2 instanceof StringReference)) break block14;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                return ((StringReference)value).value().equals(((StringReference)value2).value());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return value.equals(value2);
    }

    public static String getValueOrErrorAsString(EvaluationContext evaluationContext, Value value) {
        try {
            return DebuggerUtilsEx.getValueAsString((EvaluationContext)evaluationContext, (Value)value);
        }
        catch (EvaluateException evaluateException) {
            return evaluateException.getMessage();
        }
    }

    public static boolean isCharOrInteger(Value value) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!(value instanceof CharValue) && !DebuggerUtilsEx.isInteger((Value)value)) break block4;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isCharOrIntegerArray(Value value) {
        try {
            if (value == null) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (d == null) {
                d = new HashSet<String>();
                d.add("C");
                d.add("B");
                d.add("S");
                d.add("I");
                d.add("J");
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        String string = value.type().signature();
        int n2 = 0;
        try {
            while (string.charAt(n2) == '[') {
                ++n2;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (n2 == 0) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        string = string.substring(n2, string.length());
        return d.contains(string);
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter classFilter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)classFilter, (Element)element);
        return classFilter;
    }

    private static boolean a(ClassFilter classFilter, String string) {
        try {
            if (!classFilter.isEnabled()) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (classFilter.matches(string)) {
                return true;
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw DebuggerUtilsEx.b(writeExternalException);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            b.debug((Throwable)patternSyntaxException);
        }
        return false;
    }

    public static boolean isFiltered(@NotNull String string, ClassFilter[] classFilterArray) {
        try {
            if (string == null) {
                DebuggerUtilsEx.a(4);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return DebuggerUtilsEx.isFiltered(string, Arrays.asList(classFilterArray));
    }

    public static boolean isFiltered(@NotNull String string, List<ClassFilter> list) {
        try {
            if (string == null) {
                DebuggerUtilsEx.a(5);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (string.indexOf(91) != -1) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return list.stream().anyMatch(classFilter -> {
            try {
                if (string == null) {
                    DebuggerUtilsEx.a(24);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            return DebuggerUtilsEx.a(classFilter, string);
        });
    }

    public static int getEnabledNumber(ClassFilter[] classFilterArray) {
        return (int)Arrays.stream(classFilterArray).filter(ClassFilter::isEnabled).count();
    }

    public static ClassFilter[] readFilters(List<Element> list) throws InvalidDataException {
        try {
            if (ContainerUtil.isEmpty(list)) {
                return ClassFilter.EMPTY_ARRAY;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DebuggerUtilsEx.b(invalidDataException);
        }
        ClassFilter[] classFilterArray = new ClassFilter[list.size()];
        int n2 = list.size();
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                classFilterArray[i2] = DebuggerUtilsEx.create(list.get(i2));
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DebuggerUtilsEx.b(invalidDataException);
        }
        return classFilterArray;
    }

    public static void writeFilters(Element element, @NonNls String string, ClassFilter[] classFilterArray) throws WriteExternalException {
        for (ClassFilter classFilter : classFilterArray) {
            Element element2 = new Element(string);
            element.addContent(element2);
            DefaultJDOMExternalizer.writeExternal((Object)classFilter, (Element)element2);
        }
    }

    public static boolean filterEquals(ClassFilter[] classFilterArray, ClassFilter[] classFilterArray2) {
        try {
            if (classFilterArray.length != classFilterArray2.length) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        HashSet hashSet = new HashSet(Math.max((int)((float)classFilterArray.length / 0.75f) + 1, 16));
        HashSet hashSet2 = new HashSet(Math.max((int)((float)classFilterArray2.length / 0.75f) + 1, 16));
        Collections.addAll(hashSet, classFilterArray);
        Collections.addAll(hashSet2, classFilterArray2);
        return hashSet2.equals(hashSet);
    }

    private static boolean a(List<Element> list, List<Element> list2) {
        block13: {
            boolean bl2;
            block15: {
                block14: {
                    try {
                        try {
                            if (list != null) break block13;
                            if (list2 != null) break block14;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                        bl2 = true;
                        break block15;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        try {
            if (list2 == null) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (list.size() != list2.size()) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        Iterator<Element> iterator = list.iterator();
        for (Element element : list2) {
            Element element2 = iterator.next();
            try {
                if (DebuggerUtilsEx.elementsEqual(element2, element)) continue;
                return false;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return true;
    }

    private static boolean b(List<Attribute> list, List<Attribute> list2) {
        block15: {
            boolean bl2;
            block17: {
                block16: {
                    try {
                        try {
                            if (list != null) break block15;
                            if (list2 != null) break block16;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                        bl2 = true;
                        break block17;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        try {
            if (list2 == null) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (list.size() != list2.size()) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        Iterator<Attribute> iterator = list.iterator();
        for (Attribute attribute : list2) {
            Attribute attribute2 = iterator.next();
            try {
                try {
                    if (Comparing.equal((String)attribute2.getName(), (String)attribute.getName()) && Comparing.equal((String)attribute2.getValue(), (String)attribute.getValue())) continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                return false;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return true;
    }

    public static boolean elementsEqual(Element element, Element element2) {
        block13: {
            boolean bl2;
            block15: {
                block14: {
                    try {
                        try {
                            if (element != null) break block13;
                            if (element2 != null) break block14;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                        bl2 = true;
                        break block15;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        try {
            if (!Comparing.equal((String)element.getName(), (String)element2.getName())) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (!DebuggerUtilsEx.a(element.getChildren(), element2.getChildren())) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (!DebuggerUtilsEx.b(element.getAttributes(), element2.getAttributes())) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return true;
    }

    public static boolean externalizableEqual(JDOMExternalizable jDOMExternalizable, JDOMExternalizable jDOMExternalizable2) {
        Element element = new Element("root");
        Element element2 = new Element("root");
        try {
            jDOMExternalizable.writeExternal(element);
        }
        catch (WriteExternalException writeExternalException) {
            b.debug((Throwable)writeExternalException);
        }
        try {
            jDOMExternalizable2.writeExternal(element2);
        }
        catch (WriteExternalException writeExternalException) {
            b.debug((Throwable)writeExternalException);
        }
        return DebuggerUtilsEx.elementsEqual(element, element2);
    }

    @NotNull
    public static List<Pair<Breakpoint, Event>> getEventDescriptors(@Nullable SuspendContextImpl suspendContextImpl) {
        List<Pair<Breakpoint, Event>> list;
        EventSet eventSet;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        if (suspendContextImpl != null && !ContainerUtil.isEmpty((Collection)(eventSet = suspendContextImpl.getEventSet()))) {
            List list2;
            List list3 = ContainerUtil.newSmartList();
            RequestManagerImpl requestManagerImpl = suspendContextImpl.getDebugProcess().getRequestsManager();
            for (Event event : eventSet) {
                Requestor requestor = requestManagerImpl.findRequestor(event.request());
                try {
                    if (!(requestor instanceof Breakpoint)) continue;
                    list3.add(Pair.create((Object)((Breakpoint)requestor), (Object)event));
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            try {
                list2 = list3;
                if (list2 == null) {
                    DebuggerUtilsEx.a(6);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            return list2;
        }
        try {
            list = Collections.emptyList();
            if (list == null) {
                DebuggerUtilsEx.a(7);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return list;
    }

    public static TextWithImports getEditorText(Editor editor) {
        try {
            if (editor == null) {
                return null;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        Project project2 = editor.getProject();
        try {
            if (project2 == null) {
                return null;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        String string = editor.getSelectionModel().getSelectedText();
        if (string == null) {
            EditorTextProvider editorTextProvider;
            PsiElement psiElement;
            int n2 = editor.getCaretModel().getOffset();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
            if (psiFile != null && (psiElement = psiFile.findElementAt(n2)) != null && (editorTextProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(psiElement.getLanguage())) != null) {
                TextWithImports textWithImports = editorTextProvider.getEditorText(psiElement);
                try {
                    if (textWithImports != null) {
                        return textWithImports;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
        } else {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string);
        }
        return null;
    }

    public static void addThreadDump(Project project2, List<ThreadState> list, RunnerLayoutUi runnerLayoutUi, DebuggerSession debuggerSession) {
        TextConsoleBuilder textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
        textConsoleBuilder.filters(ExceptionFilters.getFilters((GlobalSearchScope)debuggerSession.getSearchScope()));
        ConsoleView consoleView = textConsoleBuilder.getConsole();
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        consoleView.allowHeavyFilters();
        ThreadDumpPanel threadDumpPanel = new ThreadDumpPanel(project2, consoleView, defaultActionGroup, list);
        String string = "Dump #" + e;
        Content content = runnerLayoutUi.createContent(string, (JComponent)threadDumpPanel, string, null, null);
        try {
            content.putUserData(RunnerContentUi.LIGHTWEIGHT_CONTENT_MARKER, (Object)Boolean.TRUE);
            content.setCloseable(true);
            content.setDescription("Thread Dump");
            runnerLayoutUi.addContent(content);
            runnerLayoutUi.selectAndFocus(content, true, true);
            ++a;
            ++e;
            Disposer.register((Disposable)content, (Disposable)new Disposable(){

                public void dispose() {
                    a--;
                    if (a == 0) {
                        e = 1;
                    }
                }
            });
            Disposer.register((Disposable)content, (Disposable)consoleView);
            runnerLayoutUi.selectAndFocus(content, true, false);
            if (list.size() > 0) {
                threadDumpPanel.selectStackFrame(0);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
    }

    public static void keep(Value value, EvaluationContext evaluationContext) {
        try {
            if (value instanceof ObjectReference) {
                ((SuspendContextImpl)evaluationContext.getSuspendContext()).keep((ObjectReference)value);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
    }

    public abstract DebuggerTreeNode getSelectedNode(DataContext var1);

    public abstract EvaluatorBuilder getEvaluatorBuilder();

    public static CodeFragmentFactory getCodeFragmentFactory(@Nullable PsiElement psiElement, @Nullable FileType fileType) {
        DefaultCodeFragmentFactory defaultCodeFragmentFactory;
        block15: {
            FileType fileType2;
            block16: {
                defaultCodeFragmentFactory = DefaultCodeFragmentFactory.getInstance();
                try {
                    try {
                        if (fileType != null) break block15;
                        if (psiElement != null) break block16;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    return defaultCodeFragmentFactory;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            CodeFragmentFactory[] codeFragmentFactoryArray = psiElement.getContainingFile();
            try {
                fileType2 = codeFragmentFactoryArray != null ? codeFragmentFactoryArray.getFileType() : null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            fileType = fileType2;
        }
        for (CodeFragmentFactory codeFragmentFactory : (CodeFragmentFactory[])ApplicationManager.getApplication().getExtensions(CodeFragmentFactory.EXTENSION_POINT_NAME)) {
            try {
                try {
                    block17: {
                        try {
                            try {
                                if (codeFragmentFactory == defaultCodeFragmentFactory) continue;
                                if (fileType == null) break block17;
                            }
                            catch (PatternSyntaxException patternSyntaxException) {
                                throw DebuggerUtilsEx.b(patternSyntaxException);
                            }
                            if (!codeFragmentFactory.getFileType().equals(fileType)) continue;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                    }
                    if (!codeFragmentFactory.isContextAccepted(psiElement)) continue;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                return codeFragmentFactory;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return defaultCodeFragmentFactory;
    }

    @NotNull
    public static CodeFragmentFactory findAppropriateCodeFragmentFactory(TextWithImports textWithImports, PsiElement psiElement) {
        CodeFragmentFactoryContextWrapper codeFragmentFactoryContextWrapper;
        CodeFragmentFactory codeFragmentFactory = (CodeFragmentFactory)ReadAction.compute(() -> DebuggerUtilsEx.getCodeFragmentFactory(psiElement, textWithImports.getFileType()));
        try {
            codeFragmentFactoryContextWrapper = new CodeFragmentFactoryContextWrapper(codeFragmentFactory);
            if (codeFragmentFactoryContextWrapper == null) {
                DebuggerUtilsEx.a(8);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return codeFragmentFactoryContextWrapper;
    }

    public static String methodNameWithArguments(Method method) {
        return method.name() + "(" + StringUtil.join(method.argumentTypeNames(), DebuggerUtilsEx::getSimpleName, (String)", ") + ")";
    }

    public static String getSimpleName(String string) {
        return string.substring(string.lastIndexOf(46) + 1);
    }

    public static String methodName(Method method) {
        return DebuggerUtilsEx.methodName(DebuggerUtilsEx.signatureToName(method.declaringType().signature()), method.name(), method.signature());
    }

    public static String methodName(final String string, final String string2, String string3) {
        try {
            return new SigReader(string3){

                @Override
                String getMethodName() {
                    return string2;
                }

                @Override
                String getClassName() {
                    return string;
                }
            }.getSignature();
        }
        catch (Exception exception) {
            try {
                if (b.isDebugEnabled()) {
                    b.debug("Internal error : unknown signature" + string3);
                }
            }
            catch (Exception exception2) {
                throw DebuggerUtilsEx.b(exception2);
            }
            return string + "." + string2;
        }
    }

    public static String signatureToName(String string) {
        return new SigReader(string).getSignature();
    }

    @Nullable
    public static List<Location> allLineLocations(Method method) {
        try {
            return method.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
    }

    @Nullable
    public static List<Location> allLineLocations(ReferenceType referenceType) {
        try {
            return referenceType.allLineLocations();
        }
        catch (AbsentInformationException absentInformationException) {
            return null;
        }
        catch (ObjectCollectedException objectCollectedException) {
            return Collections.emptyList();
        }
    }

    public static int getLineNumber(Location location, boolean bl2) {
        try {
            int n2;
            int n3;
            try {
                n3 = location.lineNumber();
                n2 = bl2 ? 1 : 0;
            }
            catch (InternalError internalError) {
                throw DebuggerUtilsEx.b(internalError);
            }
            return n3 - n2;
        }
        catch (IllegalArgumentException | InternalError throwable) {
            return -1;
        }
    }

    public static String getSourceName(Location location, Function<Throwable, String> function) {
        try {
            return location.sourceName();
        }
        catch (AbsentInformationException | InternalError throwable) {
            return function.apply(throwable);
        }
    }

    public static boolean isVoid(@NotNull Method method) {
        try {
            if (method == null) {
                DebuggerUtilsEx.a(9);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return "void".equals(method.returnTypeName());
    }

    @Nullable
    public static Method getMethod(Location location) {
        try {
            return location.method();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            b.info((Throwable)illegalArgumentException);
            return null;
        }
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, double d2) {
        try {
            if (PsiType.DOUBLE.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf(d2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.FLOAT.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((float)d2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return DebuggerUtilsEx.createValue(virtualMachineProxyImpl, string, (long)d2);
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, long l2) {
        try {
            if (PsiType.LONG.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf(l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.INT.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((int)l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.SHORT.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((short)l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.BYTE.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((byte)l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.CHAR.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((char)l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.DOUBLE.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((double)l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.FLOAT.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((float)l2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, boolean bl2) {
        try {
            if (PsiType.BOOLEAN.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf(bl2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return null;
    }

    public static Value createValue(VirtualMachineProxyImpl virtualMachineProxyImpl, String string, char c2) {
        try {
            if (PsiType.CHAR.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf(c2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.LONG.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((long)c2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.INT.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((int)c2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.SHORT.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((short)c2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (PsiType.BYTE.getPresentableText().equals(string)) {
                return virtualMachineProxyImpl.mirrorOf((byte)c2);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return null;
    }

    public static String truncateString(String string) {
        try {
            if (string.length() > 1005) {
                return string.substring(0, 1005);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return string;
    }

    /*
     * Exception decompiling
     */
    public static String getThreadStatusText(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String prepareValueText(String string, Project project2) {
        string = StringUtil.unquoteString((String)string);
        string = StringUtil.unescapeStringCharacters((String)string);
        int n2 = CodeStyleSettingsManager.getSettings((Project)project2).getTabSize((FileType)StdFileTypes.JAVA);
        if (n2 < 0) {
            n2 = 0;
        }
        return string.replace("\t", StringUtil.repeat((String)" ", (int)n2));
    }

    public static void setAlternativeSourceUrl(String string, String string2, Project project2) {
        ConcurrentHashMap<String, String> concurrentHashMap = (ConcurrentHashMap<String, String>)project2.getUserData(f);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<String, String>();
            project2.putUserData(f, concurrentHashMap);
        }
        concurrentHashMap.put(string, string2);
    }

    @Nullable
    public static String getAlternativeSourceUrl(@Nullable String string, Project project2) {
        String string2;
        Map map = (Map)project2.getUserData(f);
        try {
            string2 = map != null ? (String)map.get(string) : null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return string2;
    }

    @Nullable
    public static XSourcePosition toXSourcePosition(@Nullable SourcePosition sourcePosition) {
        if (sourcePosition != null) {
            VirtualFile virtualFile = sourcePosition.getFile().getVirtualFile();
            if (virtualFile == null) {
                virtualFile = sourcePosition.getFile().getOriginalFile().getVirtualFile();
            }
            try {
                if (virtualFile != null) {
                    return new JavaXSourcePosition(sourcePosition, virtualFile);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return null;
    }

    @Nullable
    public static SourcePosition toSourcePosition(@Nullable XSourcePosition xSourcePosition, Project project2) {
        block7: {
            block8: {
                try {
                    try {
                        if (xSourcePosition == null) break block7;
                        if (!(xSourcePosition instanceof JavaXSourcePosition)) break block8;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    return JavaXSourcePosition.access$300((JavaXSourcePosition)xSourcePosition);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            PsiFile psiFile = DebuggerUtilsEx.getPsiFile(xSourcePosition, project2);
            try {
                if (psiFile != null) {
                    return SourcePosition.createFromLine((PsiFile)psiFile, (int)xSourcePosition.getLine());
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return null;
    }

    @Nullable
    public static PsiFile getPsiFile(@Nullable XSourcePosition xSourcePosition, Project project2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (xSourcePosition != null) {
            VirtualFile virtualFile = xSourcePosition.getFile();
            try {
                if (virtualFile.isValid()) {
                    return PsiManager.getInstance((Project)project2).findFile(virtualFile);
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return null;
    }

    @Nullable
    public static PsiElement findElementAt(@Nullable PsiFile psiFile, int n2) {
        PsiElement psiElement;
        try {
            psiElement = psiFile != null ? psiFile.findElementAt(n2) : null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return psiElement;
    }

    public static String getLocationMethodQName(@NotNull Location location) {
        try {
            if (location == null) {
                DebuggerUtilsEx.a(10);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        StringBuilder stringBuilder = new StringBuilder();
        ReferenceType referenceType = location.declaringType();
        try {
            if (referenceType != null) {
                stringBuilder.append(referenceType.name()).append('.');
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        stringBuilder.append(location.method().name());
        return stringBuilder.toString();
    }

    private static PsiElement a(PsiElement psiElement) {
        PsiElement psiElement2 = psiElement.getNextSibling();
        try {
            if (psiElement2 != null) {
                return psiElement2;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        psiElement = psiElement.getParent();
        try {
            if (psiElement != null) {
                return DebuggerUtilsEx.a(psiElement);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return null;
    }

    public static boolean isLambdaClassName(String string) {
        boolean bl2;
        try {
            bl2 = DebuggerUtilsEx.getLambdaBaseClassName(string) != null;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return bl2;
    }

    @Nullable
    public static String getLambdaBaseClassName(String string) {
        return StringUtil.substringBefore((String)string, (String)"$$Lambda$");
    }

    public static boolean isLambdaName(@Nullable String string) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (StringUtil.isEmpty((String)string) || !string.startsWith("lambda$")) break block4;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public static boolean isLambda(@Nullable Method method) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (method == null || !DebuggerUtilsEx.isLambdaName(method.name())) break block4;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getLambdaOrdinal(@NotNull String string) {
        try {
            if (string == null) {
                DebuggerUtilsEx.a(11);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw DebuggerUtilsEx.b(numberFormatException);
        }
        int n2 = string.lastIndexOf(36);
        try {
            if (n2 <= -1) return -1;
            try {
                return Integer.parseInt(string.substring(n2 + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
                return -1;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
    }

    public static List<PsiLambdaExpression> collectLambdas(@NotNull SourcePosition sourcePosition, final boolean bl2) {
        PsiElement psiElement;
        block29: {
            Document document;
            int n2;
            block26: {
                try {
                    if (sourcePosition == null) {
                        DebuggerUtilsEx.a(12);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                ApplicationManager.getApplication().assertReadAccessAllowed();
                PsiFile psiFile = sourcePosition.getFile();
                n2 = sourcePosition.getLine();
                document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
                try {
                    try {
                        if (document != null && n2 < document.getLineCount()) break block26;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    return Collections.emptyList();
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            PsiElement psiElement2 = sourcePosition.getElementAt();
            try {
                if (psiElement2 == null) {
                    return Collections.emptyList();
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            TextRange textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
            while (true) {
                psiElement = psiElement2.getParent();
                try {
                    try {
                        if (psiElement == null || psiElement.getTextOffset() < textRange.getStartOffset()) {
                            break;
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                psiElement2 = psiElement;
            }
            psiElement = new SmartList();
            JavaRecursiveElementVisitor javaRecursiveElementVisitor = new JavaRecursiveElementVisitor((List)psiElement){
                final /* synthetic */ List val$lambdas;
                {
                    this.val$lambdas = list;
                }

                public void visitLambdaExpression(PsiLambdaExpression psiLambdaExpression) {
                    super.visitLambdaExpression(psiLambdaExpression);
                    if (!bl2 || DebuggerUtilsEx.getFirstElementOnTheLine(psiLambdaExpression, document, n2) != null) {
                        this.val$lambdas.add(psiLambdaExpression);
                    }
                }
            };
            psiElement2.accept((PsiElementVisitor)javaRecursiveElementVisitor);
            PsiElement psiElement3 = DebuggerUtilsEx.a(psiElement2);
            while (true) {
                try {
                    try {
                        if (psiElement3 == null || !DebuggerUtilsEx.intersects(textRange, psiElement3)) {
                            break;
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                psiElement3.accept((PsiElementVisitor)javaRecursiveElementVisitor);
                psiElement3 = DebuggerUtilsEx.a(psiElement3);
            }
            psiElement3 = DebuggerUtilsEx.getContainingMethod(psiElement2);
            try {
                try {
                    if (!(psiElement3 instanceof PsiLambdaExpression) || psiElement.contains(psiElement3)) break block29;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                psiElement.add((PsiLambdaExpression)psiElement3);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return psiElement;
    }

    @Nullable
    public static PsiElement getBody(PsiElement psiElement) {
        try {
            if (psiElement instanceof PsiParameterListOwner) {
                return ((PsiParameterListOwner)psiElement).getBody();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (psiElement instanceof PsiClassInitializer) {
                return ((PsiClassInitializer)psiElement).getBody();
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return null;
    }

    @NotNull
    public static PsiParameter[] getParameters(PsiElement psiElement) {
        PsiParameter[] psiParameterArray;
        block7: {
            PsiParameter[] psiParameterArray2;
            block8: {
                try {
                    try {
                        if (!(psiElement instanceof PsiParameterListOwner)) break block7;
                        psiParameterArray2 = ((PsiParameterListOwner)psiElement).getParameterList().getParameters();
                        if (psiParameterArray2 != null) break block8;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    DebuggerUtilsEx.a(13);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            return psiParameterArray2;
        }
        try {
            psiParameterArray = PsiParameter.EMPTY_ARRAY;
            if (PsiParameter.EMPTY_ARRAY == null) {
                DebuggerUtilsEx.a(14);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return psiParameterArray;
    }

    public static boolean evaluateBoolean(ExpressionEvaluator expressionEvaluator, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Object object = UnBoxingEvaluator.unbox(expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl), evaluationContextImpl);
        try {
            if (!(object instanceof BooleanValue)) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.boolean.expected", (Object[])new Object[0]));
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebuggerUtilsEx.b(evaluateException);
        }
        return ((BooleanValue)object).booleanValue();
    }

    public static boolean intersects(@NotNull TextRange textRange, @NotNull PsiElement psiElement) {
        boolean bl2;
        block11: {
            block10: {
                try {
                    if (textRange == null) {
                        DebuggerUtilsEx.a(15);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                try {
                    if (psiElement == null) {
                        DebuggerUtilsEx.a(16);
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                TextRange textRange2 = psiElement.getTextRange();
                try {
                    try {
                        if (textRange2 == null || !textRange2.intersects(textRange)) break block10;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    bl2 = true;
                    break block11;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Nullable
    public static PsiElement getFirstElementOnTheLine(PsiLambdaExpression psiLambdaExpression, Document document, int n2) {
        PsiStatement[] psiStatementArray;
        PsiElement psiElement;
        TextRange textRange;
        block15: {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            textRange = DocumentUtil.getLineTextRange((Document)document, (int)n2);
            try {
                if (!DebuggerUtilsEx.intersects(textRange, (PsiElement)psiLambdaExpression)) {
                    return null;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
            psiElement = psiLambdaExpression.getBody();
            try {
                try {
                    if (psiElement != null && DebuggerUtilsEx.intersects(textRange, psiElement)) break block15;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                return null;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        if (psiElement instanceof PsiCodeBlock && (psiStatementArray = ((PsiCodeBlock)psiElement).getStatements()).length > 0) {
            for (PsiStatement psiStatement : psiStatementArray) {
                try {
                    if (textRange.contains(psiStatement.getTextOffset())) {
                        return psiStatement;
                    }
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
                if (!DebuggerUtilsEx.intersects(textRange, (PsiElement)psiStatement)) continue;
                for (PsiElement psiElement2 : SyntaxTraverser.psiTraverser((PsiElement)psiStatement)) {
                    try {
                        if (!textRange.contains(psiElement2.getTextOffset())) continue;
                        return psiElement2;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
            }
            return null;
        }
        return psiElement;
    }

    public static boolean inTheMethod(@NotNull SourcePosition sourcePosition, @NotNull PsiElement psiElement) {
        try {
            if (sourcePosition == null) {
                DebuggerUtilsEx.a(17);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        try {
            if (psiElement == null) {
                DebuggerUtilsEx.a(18);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        PsiElement psiElement2 = sourcePosition.getElementAt();
        try {
            if (psiElement2 == null) {
                return false;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return Comparing.equal((Object)DebuggerUtilsEx.getContainingMethod(psiElement2), (Object)psiElement);
    }

    public static boolean inTheSameMethod(@NotNull SourcePosition sourcePosition, @NotNull SourcePosition sourcePosition2) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block11: {
            boolean bl2;
            block13: {
                block12: {
                    try {
                        if (sourcePosition == null) {
                            DebuggerUtilsEx.a(19);
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    try {
                        if (sourcePosition2 == null) {
                            DebuggerUtilsEx.a(20);
                        }
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    ApplicationManager.getApplication().assertReadAccessAllowed();
                    psiElement2 = sourcePosition.getElementAt();
                    psiElement = sourcePosition2.getElementAt();
                    try {
                        try {
                            if (psiElement2 != null) break block11;
                            if (psiElement != null) break block12;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw DebuggerUtilsEx.b(patternSyntaxException);
                        }
                        bl2 = true;
                        break block13;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        if (psiElement != null) {
            PsiElement psiElement3 = DebuggerUtilsEx.getContainingMethod(psiElement2);
            PsiElement psiElement4 = DebuggerUtilsEx.getContainingMethod(psiElement);
            return Comparing.equal((Object)psiElement3, (Object)psiElement4);
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static boolean methodMatches(@NotNull PsiMethod psiMethod, String string, String string2, String string3, DebugProcessImpl debugProcessImpl) {
        try {
            if (psiMethod == null) {
                DebuggerUtilsEx.a(21);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebuggerUtilsEx.b(evaluateException);
        }
        PsiClass psiClass = psiMethod.getContainingClass();
        try {
            boolean bl2;
            block14: {
                block13: {
                    block16: {
                        block15: {
                            if (psiClass == null) break block13;
                            if (!Objects.equals(JVMNameUtil.getClassVMName(psiClass), string)) break block13;
                            break block15;
                            catch (EvaluateException evaluateException) {
                                throw DebuggerUtilsEx.b(evaluateException);
                            }
                        }
                        if (!JVMNameUtil.getJVMMethodName(psiMethod).equals(string2)) break block13;
                        break block16;
                        catch (EvaluateException evaluateException) {
                            throw DebuggerUtilsEx.b(evaluateException);
                        }
                    }
                    try {
                        block17: {
                            if (!JVMNameUtil.getJVMSignature(psiMethod).getName(debugProcessImpl).equals(string3)) break block13;
                            break block17;
                            catch (EvaluateException evaluateException) {
                                throw DebuggerUtilsEx.b(evaluateException);
                            }
                        }
                        bl2 = true;
                        break block14;
                    }
                    catch (EvaluateException evaluateException) {
                        throw DebuggerUtilsEx.b(evaluateException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        catch (EvaluateException evaluateException) {
            b.debug((Throwable)evaluateException);
            return false;
        }
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement psiElement) {
        return PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class, PsiClassInitializer.class});
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable SourcePosition sourcePosition) {
        try {
            if (sourcePosition == null) {
                return null;
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return DebuggerUtilsEx.getContainingMethod(sourcePosition.getElementAt());
    }

    public static void disableCollection(ObjectReference objectReference) {
        try {
            objectReference.disableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static void enableCollection(ObjectReference objectReference) {
        try {
            objectReference.enableCollection();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public static int bytecodeToSourceLine(PsiFile psiFile, int n2) {
        LineNumbersMapping lineNumbersMapping;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile != null && (lineNumbersMapping = (LineNumbersMapping)virtualFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null) {
            int n3 = lineNumbersMapping.bytecodeToSource(n2 + 1);
            try {
                if (n3 > -1) {
                    return n3 - 1;
                }
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw DebuggerUtilsEx.b(patternSyntaxException);
            }
        }
        return -1;
    }

    public static boolean isInLibraryContent(@Nullable VirtualFile virtualFile, @NotNull Project project2) {
        try {
            if (project2 == null) {
                DebuggerUtilsEx.a(22);
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw DebuggerUtilsEx.b(patternSyntaxException);
        }
        return (Boolean)ReadAction.compute(() -> {
            boolean bl2;
            block11: {
                block10: {
                    try {
                        if (project2 == null) {
                            DebuggerUtilsEx.a(23);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw DebuggerUtilsEx.b(runtimeException);
                    }
                    try {
                        if (virtualFile == null) {
                            return true;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw DebuggerUtilsEx.b(runtimeException);
                    }
                    ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
                    try {
                        try {
                            if (!projectFileIndex.isInLibraryClasses(virtualFile) && !projectFileIndex.isInLibrarySource(virtualFile)) break block10;
                        }
                        catch (RuntimeException runtimeException) {
                            throw DebuggerUtilsEx.b(runtimeException);
                        }
                        bl2 = true;
                        break block11;
                    }
                    catch (RuntimeException runtimeException) {
                        throw DebuggerUtilsEx.b(runtimeException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        });
    }

    public static boolean isInJavaSession(AnActionEvent anActionEvent) {
        boolean bl2;
        block6: {
            block5: {
                Project project2;
                XDebugSession xDebugSession = (XDebugSession)anActionEvent.getData(XDebugSession.DATA_KEY);
                if (xDebugSession == null && (project2 = anActionEvent.getProject()) != null) {
                    xDebugSession = XDebuggerManager.getInstance((Project)project2).getCurrentSession();
                }
                try {
                    try {
                        if (xDebugSession == null || !(xDebugSession.getDebugProcess() instanceof JavaDebugProcess)) break block5;
                    }
                    catch (PatternSyntaxException patternSyntaxException) {
                        throw DebuggerUtilsEx.b(patternSyntaxException);
                    }
                    bl2 = true;
                    break block6;
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    throw DebuggerUtilsEx.b(patternSyntaxException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    static {
        a = 0;
        e = 1;
        f = Key.create((String)"DEBUGGER_ALTERNATIVE_SOURCE_MAPPING");
        LAMBDA_ORDINAL_COMPARATOR = Comparator.comparingInt(method -> DebuggerUtilsEx.getLambdaOrdinal(method.name()));
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    private static class JavaXSourcePosition
    implements XSourcePosition,
    ExecutionPointHighlighter.HighlighterProvider {
        private final SourcePosition a;
        @NotNull
        private final VirtualFile b;

        public JavaXSourcePosition(@NotNull SourcePosition sourcePosition, @NotNull VirtualFile virtualFile) {
            if (sourcePosition == null) {
                JavaXSourcePosition.a(0);
            }
            if (virtualFile == null) {
                JavaXSourcePosition.a(1);
            }
            this.a = sourcePosition;
            this.b = virtualFile;
        }

        public int getLine() {
            return this.a.getLine();
        }

        public int getOffset() {
            return this.a.getOffset();
        }

        @NotNull
        public VirtualFile getFile() {
            VirtualFile virtualFile;
            try {
                virtualFile = this.b;
                if (virtualFile == null) {
                    JavaXSourcePosition.a(2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JavaXSourcePosition.a(illegalArgumentException);
            }
            return virtualFile;
        }

        @NotNull
        public Navigatable createNavigatable(@NotNull Project project2) {
            OpenFileDescriptor openFileDescriptor;
            try {
                if (project2 == null) {
                    JavaXSourcePosition.a(3);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JavaXSourcePosition.a(illegalArgumentException);
            }
            try {
                openFileDescriptor = XSourcePositionImpl.doCreateOpenFileDescriptor((Project)project2, (XSourcePosition)this);
                if (openFileDescriptor == null) {
                    JavaXSourcePosition.a(4);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JavaXSourcePosition.a(illegalArgumentException);
            }
            return openFileDescriptor;
        }

        @Nullable
        public TextRange getHighlightRange() {
            return SourcePositionHighlighter.getHighlightRangeFor((SourcePosition)this.a);
        }

        static /* synthetic */ SourcePosition access$300(JavaXSourcePosition javaXSourcePosition) {
            return javaXSourcePosition.a;
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void a(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String string) {
            this.buffer = string;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        @NonNls
        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int n2 = this.pos;
                    this.pos = this.buffer.indexOf(59, n2) + 1;
                    b.assertTrue(this.pos > 0);
                    return this.buffer.substring(n2, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder stringBuilder = new StringBuilder("(");
                    String string = "";
                    while (this.peek() != 41) {
                        stringBuilder.append(string);
                        stringBuilder.append(this.getSignature());
                        string = ", ";
                    }
                    this.get();
                    stringBuilder.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + stringBuilder;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

