/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueue;
import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.sun.jdi.VMDisconnectedException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Debugger;
import org.jetbrains.annotations.NotNull;

public abstract class InvokeThread<E extends PrioritizedTask> {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.impl.InvokeThread");
    private static final ThreadLocal<WorkerThreadRequest> a = new ThreadLocal();
    protected final Project myProject;
    protected final EventQueue<E> myEvents;
    private volatile WorkerThreadRequest c = null;

    public InvokeThread(Project project2) {
        this.myProject = project2;
        this.myEvents = new EventQueue(PrioritizedTask.Priority.values().length);
        this.startNewWorkerThread();
    }

    protected abstract void processEvent(E var1);

    protected void startNewWorkerThread() {
        WorkerThreadRequest workerThreadRequest;
        this.c = workerThreadRequest = new WorkerThreadRequest(this);
        workerThreadRequest.setRequestFuture(ApplicationManager.getApplication().executeOnPooledThread(workerThreadRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void a(@NotNull WorkerThreadRequest workerThreadRequest) {
        block28: {
            try {
                if (workerThreadRequest == null) {
                    InvokeThread.a(0);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw InvokeThread.b(vMDisconnectedException);
            }
            String string = Thread.currentThread().getName();
            Thread.currentThread().setName("DebuggerManagerThread");
            try {
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(true);
                while (true) {
                    try {
                        while (true) {
                            block29: {
                                if (workerThreadRequest.isStopRequested()) {
                                    break block28;
                                }
                                WorkerThreadRequest workerThreadRequest2 = this.getCurrentRequest();
                                if (workerThreadRequest2 == workerThreadRequest) break block29;
                                try {
                                    block31: {
                                        b.error("Expected " + workerThreadRequest + " instead of " + workerThreadRequest2);
                                        if (workerThreadRequest2 == null) break block29;
                                        break block31;
                                        catch (VMDisconnectedException vMDisconnectedException) {
                                            throw InvokeThread.b(vMDisconnectedException);
                                        }
                                    }
                                    if (!workerThreadRequest2.isDone()) {
                                        continue;
                                    }
                                }
                                catch (VMDisconnectedException vMDisconnectedException) {
                                    throw InvokeThread.b(vMDisconnectedException);
                                }
                            }
                            this.processEvent((PrioritizedTask)this.myEvents.get());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                    }
                    catch (EventQueueClosedException eventQueueClosedException) {
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        continue;
                    }
                    catch (RuntimeException runtimeException) {
                        block30: {
                            try {
                                if (!(runtimeException.getCause() instanceof InterruptedException)) break block30;
                                break;
                            }
                            catch (VMDisconnectedException vMDisconnectedException) {
                                throw InvokeThread.b(vMDisconnectedException);
                            }
                        }
                        b.error((Throwable)runtimeException);
                        continue;
                    }
                    catch (Throwable throwable) {
                        b.error(throwable);
                        continue;
                    }
                    break;
                }
            }
            finally {
                if (workerThreadRequest == this.getCurrentRequest()) {
                    for (PrioritizedTask prioritizedTask : this.myEvents.clearQueue()) {
                        try {
                            this.processEvent(prioritizedTask);
                        }
                        catch (Throwable throwable) {}
                    }
                }
                b.debug("Request " + this.toString() + " exited");
                DumbService.getInstance((Project)this.myProject).setAlternativeResolveEnabled(false);
                Thread.currentThread().setName(string);
            }
        }
    }

    protected static InvokeThread currentThread() {
        InvokeThread invokeThread;
        WorkerThreadRequest workerThreadRequest = InvokeThread.getCurrentThreadRequest();
        try {
            invokeThread = workerThreadRequest != null ? workerThreadRequest.getOwner() : null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw InvokeThread.b(vMDisconnectedException);
        }
        return invokeThread;
    }

    public boolean schedule(@Debugger.Capture E e2) {
        try {
            if (b.isDebugEnabled()) {
                b.debug("schedule " + e2 + " in " + this);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw InvokeThread.b(vMDisconnectedException);
        }
        return this.myEvents.put(e2, e2.getPriority().ordinal());
    }

    public boolean pushBack(E e2) {
        try {
            if (b.isDebugEnabled()) {
                b.debug("pushBack " + e2 + " in " + this);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw InvokeThread.b(vMDisconnectedException);
        }
        return this.myEvents.pushBack(e2, e2.getPriority().ordinal());
    }

    protected void switchToRequest(WorkerThreadRequest workerThreadRequest) {
        boolean bl2;
        Logger logger;
        WorkerThreadRequest workerThreadRequest2 = InvokeThread.getCurrentThreadRequest();
        try {
            logger = b;
            bl2 = workerThreadRequest2 != null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw InvokeThread.b(vMDisconnectedException);
        }
        try {
            logger.assertTrue(bl2);
            this.c = workerThreadRequest;
            if (b.isDebugEnabled()) {
                b.debug("Closing " + workerThreadRequest2 + " new request = " + workerThreadRequest);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw InvokeThread.b(vMDisconnectedException);
        }
        workerThreadRequest2.requestStop();
    }

    public WorkerThreadRequest getCurrentRequest() {
        return this.c;
    }

    public static WorkerThreadRequest getCurrentThreadRequest() {
        return a.get();
    }

    public void close() {
        this.myEvents.close();
        b.debug("Closing evaluation");
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "threadRequest", "com/intellij/debugger/impl/InvokeThread", "run"));
    }

    private static VMDisconnectedException b(VMDisconnectedException vMDisconnectedException) {
        return vMDisconnectedException;
    }

    public static final class WorkerThreadRequest<E extends PrioritizedTask>
    implements Runnable {
        private final InvokeThread<E> a;
        private volatile Future<?> c;
        private volatile boolean b = false;
        static final /* synthetic */ boolean $assertionsDisabled;

        WorkerThreadRequest(InvokeThread<E> invokeThread) {
            this.a = invokeThread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                try {
                    while (this.c == null) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
                catch (CancellationException cancellationException) {
                    throw WorkerThreadRequest.b(cancellationException);
                }
            }
            a.set(this);
            try {
                ((InvokeThread)this.a).a(this);
                return;
            }
            finally {
                a.set(null);
                boolean bl2 = Thread.interrupted();
            }
        }

        public void requestStop() {
            Future<?> future;
            block4: {
                future = this.c;
                try {
                    try {
                        if ($assertionsDisabled || future != null) break block4;
                    }
                    catch (CancellationException cancellationException) {
                        throw WorkerThreadRequest.b(cancellationException);
                    }
                    throw new AssertionError();
                }
                catch (CancellationException cancellationException) {
                    throw WorkerThreadRequest.b(cancellationException);
                }
            }
            this.b = true;
            future.cancel(true);
        }

        public boolean isStopRequested() {
            boolean bl2;
            block13: {
                block12: {
                    Future<?> future;
                    block10: {
                        future = this.c;
                        try {
                            try {
                                if ($assertionsDisabled || future != null) break block10;
                            }
                            catch (CancellationException cancellationException) {
                                throw WorkerThreadRequest.b(cancellationException);
                            }
                            throw new AssertionError();
                        }
                        catch (CancellationException cancellationException) {
                            throw WorkerThreadRequest.b(cancellationException);
                        }
                    }
                    try {
                        block11: {
                            try {
                                try {
                                    if (this.b || future.isCancelled()) break block11;
                                }
                                catch (CancellationException cancellationException) {
                                    throw WorkerThreadRequest.b(cancellationException);
                                }
                                if (!future.isDone()) break block12;
                            }
                            catch (CancellationException cancellationException) {
                                throw WorkerThreadRequest.b(cancellationException);
                            }
                        }
                        bl2 = true;
                        break block13;
                    }
                    catch (CancellationException cancellationException) {
                        throw WorkerThreadRequest.b(cancellationException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }

        /*
         * Loose catch block
         */
        public void join() throws InterruptedException, ExecutionException {
            block6: {
                if ($assertionsDisabled) break block6;
                try {
                    block7: {
                        if (this.c != null) break block6;
                        break block7;
                        catch (CancellationException cancellationException) {
                            throw WorkerThreadRequest.b(cancellationException);
                        }
                    }
                    throw new AssertionError();
                }
                catch (CancellationException cancellationException) {
                    throw WorkerThreadRequest.b(cancellationException);
                }
            }
            try {
                this.c.get();
            }
            catch (CancellationException cancellationException) {
                // empty catch block
            }
        }

        /*
         * Loose catch block
         */
        public void join(long l2) throws InterruptedException, ExecutionException {
            block6: {
                if ($assertionsDisabled) break block6;
                try {
                    block7: {
                        if (this.c != null) break block6;
                        break block7;
                        catch (TimeoutException timeoutException) {
                            throw WorkerThreadRequest.b(timeoutException);
                        }
                    }
                    throw new AssertionError();
                }
                catch (TimeoutException timeoutException) {
                    throw WorkerThreadRequest.b(timeoutException);
                }
            }
            try {
                this.c.get(l2, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException | TimeoutException exception) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void setRequestFuture(Future<?> future) {
            WorkerThreadRequest workerThreadRequest = this;
            synchronized (workerThreadRequest) {
                this.c = future;
                this.notifyAll();
            }
        }

        public InvokeThread<E> getOwner() {
            return this.a;
        }

        public boolean isDone() {
            boolean bl2;
            block10: {
                block9: {
                    block8: {
                        try {
                            try {
                                if ($assertionsDisabled || this.c != null) break block8;
                            }
                            catch (CancellationException cancellationException) {
                                throw WorkerThreadRequest.b(cancellationException);
                            }
                            throw new AssertionError();
                        }
                        catch (CancellationException cancellationException) {
                            throw WorkerThreadRequest.b(cancellationException);
                        }
                    }
                    try {
                        try {
                            if (!this.c.isDone() || a.get() != null) break block9;
                        }
                        catch (CancellationException cancellationException) {
                            throw WorkerThreadRequest.b(cancellationException);
                        }
                        bl2 = true;
                        break block10;
                    }
                    catch (CancellationException cancellationException) {
                        throw WorkerThreadRequest.b(cancellationException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }

        static {
            boolean bl2;
            try {
                bl2 = !InvokeThread.class.desiredAssertionStatus();
            }
            catch (CancellationException cancellationException) {
                throw WorkerThreadRequest.b(cancellationException);
            }
            $assertionsDisabled = bl2;
        }

        private static Exception b(Exception exception) {
            return exception;
        }
    }
}

