/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.function.IntPredicate;
import one.util.streamex.IntStreamEx;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class SourceCodeChecker {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.impl.SourceCodeChecker");

    private SourceCodeChecker() {
    }

    public static void checkSource(final DebuggerContextImpl debuggerContextImpl) {
        try {
            if (!Registry.is((String)"debugger.check.source")) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw SourceCodeChecker.b(runtimeException);
        }
        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
        try {
            if (suspendContextImpl == null) {
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            throw SourceCodeChecker.b(runtimeException);
        }
        suspendContextImpl.getDebugProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.LOW;
            }

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                try {
                    if (suspendContextImpl == null) {
                        1.b(0);
                    }
                }
                catch (EvaluateException evaluateException) {
                    throw 1.a(evaluateException);
                }
                try {
                    StackFrameProxyImpl stackFrameProxyImpl = debuggerContextImpl.getFrameProxy();
                    if (stackFrameProxyImpl == null) {
                        return;
                    }
                    Location location = stackFrameProxyImpl.location();
                    SourceCodeChecker.a(location, debuggerContextImpl.getSourcePosition(), suspendContextImpl.getDebugProcess().getProject());
                }
                catch (EvaluateException evaluateException) {
                    a.info((Throwable)evaluateException);
                }
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/SourceCodeChecker$1", "contextAction"));
            }

            private static EvaluateException a(EvaluateException evaluateException) {
                return evaluateException;
            }
        });
    }

    private static ThreeState a(Location location, SourcePosition sourcePosition, Project project2) {
        Method method;
        block24: {
            method = DebuggerUtilsEx.getMethod(location);
            try {
                block22: {
                    try {
                        block23: {
                            try {
                                try {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    if (method == null || method.isConstructor()) break block22;
                                                }
                                                catch (RuntimeException runtimeException) {
                                                    throw SourceCodeChecker.b(runtimeException);
                                                }
                                                if (method.isSynthetic()) break block22;
                                            }
                                            catch (RuntimeException runtimeException) {
                                                throw SourceCodeChecker.b(runtimeException);
                                            }
                                            if (method.isBridge()) break block22;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            throw SourceCodeChecker.b(runtimeException);
                                        }
                                        if (method.isStaticInitializer()) break block22;
                                    }
                                    catch (RuntimeException runtimeException) {
                                        throw SourceCodeChecker.b(runtimeException);
                                    }
                                    if (!(method.declaringType() instanceof ClassType)) break block23;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw SourceCodeChecker.b(runtimeException);
                                }
                                if (((ClassType)method.declaringType()).isEnum()) break block22;
                            }
                            catch (RuntimeException runtimeException) {
                                throw SourceCodeChecker.b(runtimeException);
                            }
                        }
                        if (!DebuggerUtilsEx.isLambda(method)) break block24;
                    }
                    catch (RuntimeException runtimeException) {
                        throw SourceCodeChecker.b(runtimeException);
                    }
                }
                return ThreeState.UNSURE;
            }
            catch (RuntimeException runtimeException) {
                throw SourceCodeChecker.b(runtimeException);
            }
        }
        List<Location> list = DebuggerUtilsEx.allLineLocations(method);
        try {
            if (ContainerUtil.isEmpty(list)) {
                return ThreeState.UNSURE;
            }
        }
        catch (RuntimeException runtimeException) {
            throw SourceCodeChecker.b(runtimeException);
        }
        try {
            if (sourcePosition != null) {
                return (ThreeState)ReadAction.compute(() -> SourceCodeChecker.a(sourcePosition, project2, list, method));
            }
        }
        catch (RuntimeException runtimeException) {
            throw SourceCodeChecker.b(runtimeException);
        }
        return ThreeState.YES;
    }

    private static IntStreamEx a(List<Location> list, PsiFile psiFile) {
        IntStreamEx intStreamEx = StreamEx.of(list).mapToInt(Location::lineNumber);
        if (psiFile instanceof PsiCompiledFile) {
            intStreamEx = intStreamEx.map(n2 -> DebuggerUtilsEx.bytecodeToSourceLine(psiFile, n2) + 1);
        }
        return intStreamEx.filter(n2 -> {
            boolean bl2;
            try {
                bl2 = n2 > 0;
            }
            catch (RuntimeException runtimeException) {
                throw SourceCodeChecker.b(runtimeException);
            }
            return bl2;
        });
    }

    /*
     * Loose catch block
     */
    private static void a(DebuggerContextImpl debuggerContextImpl) {
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        VirtualMachine virtualMachine = debugProcessImpl.getVirtualMachineProxy().getVirtualMachine();
        PositionManagerImpl positionManagerImpl = new PositionManagerImpl(debugProcessImpl);
        List<ReferenceType> list = virtualMachine.allClasses();
        System.out.println("Checking " + list.size() + " classes");
        int n2 = 0;
        block12: for (ReferenceType referenceType : list) {
            ++n2;
            try {
                for (Location location : referenceType.allLineLocations()) {
                    SourcePosition sourcePosition = (SourcePosition)ReadAction.compute(() -> {
                        try {
                            return positionManagerImpl.getSourcePosition(location);
                        }
                        catch (NoDataException noDataException) {
                            return null;
                        }
                    });
                    try {
                        if (sourcePosition == null) {
                            continue;
                        }
                    }
                    catch (AbsentInformationException absentInformationException) {
                        throw SourceCodeChecker.b(absentInformationException);
                    }
                    if (sourcePosition.getFile() instanceof PsiCompiledFile) {
                        block18: {
                            VirtualFile virtualFile = sourcePosition.getFile().getVirtualFile();
                            if (virtualFile == null) continue block12;
                            try {
                                if (virtualFile.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY) == null) {
                                    continue block12;
                                }
                                break block18;
                                catch (AbsentInformationException absentInformationException) {
                                    throw SourceCodeChecker.b(absentInformationException);
                                }
                            }
                            catch (AbsentInformationException absentInformationException) {
                                throw SourceCodeChecker.b(absentInformationException);
                            }
                        }
                        try {
                            if (DebuggerUtilsEx.bytecodeToSourceLine(sourcePosition.getFile(), location.lineNumber()) == -1) {
                                continue;
                            }
                        }
                        catch (AbsentInformationException absentInformationException) {
                            throw SourceCodeChecker.b(absentInformationException);
                        }
                    }
                    try {
                        if (SourceCodeChecker.a(location, sourcePosition, debugProcessImpl.getProject()) != ThreeState.NO) continue;
                        System.out.println("failed " + referenceType);
                        continue block12;
                    }
                    catch (AbsentInformationException absentInformationException) {
                        throw SourceCodeChecker.b(absentInformationException);
                    }
                }
            }
            catch (AbsentInformationException absentInformationException) {
            }
        }
        System.out.println("Done checking");
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ ThreeState a(SourcePosition var0, Project var1_1, List var2_2, Method var3_3) throws RuntimeException {
        var4_4 = var0.getFile();
        try {
            if (!var4_4.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
                return ThreeState.UNSURE;
            }
        }
        catch (RuntimeException v0) {
            throw SourceCodeChecker.b(v0);
        }
        var5_5 = PsiDocumentManager.getInstance((Project)var1_1).getDocument(var4_4);
        try {
            if (var5_5 == null) {
                return ThreeState.UNSURE;
            }
        }
        catch (RuntimeException v1) {
            throw SourceCodeChecker.b(v1);
        }
        var6_6 = false;
        var7_7 = DebuggerUtilsEx.getContainingMethod(var0);
        if (var7_7 != null) {
            var8_8 = var7_7.getTextRange();
            if (var7_7 instanceof PsiDocCommentOwner && (var9_9 = ((PsiDocCommentOwner)var7_7).getDocComment()) != null) {
                var8_8 = new TextRange(var9_9.getTextRange().getEndOffset() + 1, var8_8.getEndOffset());
            }
            var9_10 = var5_5.getLineNumber(var8_8.getStartOffset()) + 1;
            var10_11 = var5_5.getLineNumber(var8_8.getEndOffset()) + 1;
            var6_6 = SourceCodeChecker.a(var2_2, var4_4).allMatch((IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, a(int int int ), (I)Z)((int)var9_10, (int)var10_11));
            try {
                if (var6_6) ** GOTO lbl31
                SourceCodeChecker.a.debug("Source check failed: Method " + var3_3.name() + ", source: " + ((NavigationItem)var7_7).getName() + "\nLines: " + SourceCodeChecker.a(var2_2, var4_4).joining((CharSequence)", ") + "\nExpected range: " + var9_10 + "-" + var10_11);
            }
            catch (RuntimeException v2) {
                throw SourceCodeChecker.b(v2);
            }
        } else {
            SourceCodeChecker.a.debug("Source check failed: method " + var3_3.name() + " not found in sources");
        }
lbl31:
        // 3 sources

        if (!var6_6) {
            block15: {
                block14: {
                    var8_8 = FileEditorManager.getInstance((Project)var1_1).getSelectedEditor(var0.getFile().getVirtualFile());
                    try {
                        if (!(var8_8 instanceof TextEditor)) break block14;
                        AppUIUtil.invokeOnEdt((Runnable)(Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.openapi.fileEditor.FileEditor ), ()V)((FileEditor)var8_8));
                        break block15;
                    }
                    catch (RuntimeException v3) {
                        throw SourceCodeChecker.b(v3);
                    }
                }
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0]), NotificationType.WARNING).notify(var1_1);
            }
            return ThreeState.NO;
        }
        return ThreeState.YES;
    }

    private static /* synthetic */ void a(FileEditor fileEditor) {
        HintManager.getInstance().showErrorHint(((TextEditor)fileEditor).getEditor(), DebuggerBundle.message((String)"warning.source.code.not.match", (Object[])new Object[0]));
    }

    private static /* synthetic */ boolean a(int n2, int n3, int n4) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (n2 > n4 || n4 > n3) break block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw SourceCodeChecker.b(runtimeException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (RuntimeException runtimeException) {
                    throw SourceCodeChecker.b(runtimeException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

