/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.util.ThreeState;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ObjectReferenceProxyImpl
extends JdiProxy {
    private final ObjectReference c;
    private ReferenceType d;
    private Type b;
    private ThreeState e;

    public ObjectReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxyImpl, @NotNull ObjectReference objectReference) {
        if (objectReference == null) {
            ObjectReferenceProxyImpl.b(0);
        }
        super(virtualMachineProxyImpl);
        this.e = ThreeState.UNSURE;
        this.c = objectReference;
    }

    public ObjectReference getObjectReference() {
        this.checkValid();
        return this.c;
    }

    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        return (VirtualMachineProxyImpl)this.myTimer;
    }

    public ReferenceType referenceType() {
        try {
            this.checkValid();
            if (this.d == null) {
                this.d = this.getObjectReference().referenceType();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw ObjectReferenceProxyImpl.b(vMDisconnectedException);
        }
        return this.d;
    }

    public Type type() {
        try {
            this.checkValid();
            if (this.b == null) {
                this.b = this.getObjectReference().type();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw ObjectReferenceProxyImpl.b(vMDisconnectedException);
        }
        return this.b;
    }

    @NonNls
    public String toString() {
        String string;
        ObjectReference objectReference = this.getObjectReference();
        try {
            string = objectReference != null ? objectReference.toString() : "[referenced object collected]";
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw ObjectReferenceProxyImpl.b(vMDisconnectedException);
        }
        String string2 = string;
        return "ObjectReferenceProxyImpl: " + string2 + " " + super.toString();
    }

    public Map<Field, Value> getValues(List<? extends Field> list) {
        return this.getObjectReference().getValues(list);
    }

    public void setValue(Field field, Value value) throws InvalidTypeException, ClassNotLoadedException {
        this.getObjectReference().setValue(field, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCollected() {
        try {
            this.checkValid();
            if (this.e == ThreeState.YES) return this.e.toBoolean();
            try {
                this.e = ThreeState.fromBoolean((boolean)VirtualMachineProxyImpl.isCollected(this.c));
                return this.e.toBoolean();
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                this.e = ThreeState.YES;
                return this.e.toBoolean();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ObjectReferenceProxyImpl.b(illegalArgumentException);
        }
    }

    public long uniqueID() {
        return this.getObjectReference().uniqueID();
    }

    public List<ThreadReferenceProxyImpl> waitingThreads() throws IncompatibleThreadStateException {
        return StreamEx.of(this.getObjectReference().waitingThreads()).map(this.getVirtualMachineProxy()::getThreadReferenceProxy).toList();
    }

    public ThreadReferenceProxyImpl owningThread() throws IncompatibleThreadStateException {
        return this.getVirtualMachineProxy().getThreadReferenceProxy(this.getObjectReference().owningThread());
    }

    public int entryCount() throws IncompatibleThreadStateException {
        return this.getObjectReference().entryCount();
    }

    public boolean equals(Object object) {
        try {
            if (!(object instanceof ObjectReferenceProxyImpl)) {
                return false;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw ObjectReferenceProxyImpl.b(vMDisconnectedException);
        }
        try {
            if (this == object) {
                return true;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw ObjectReferenceProxyImpl.b(vMDisconnectedException);
        }
        ObjectReference objectReference = this.c;
        return objectReference.equals(((ObjectReferenceProxyImpl)object).c);
    }

    public int hashCode() {
        return this.c.hashCode();
    }

    @Override
    protected void clearCaches() {
        try {
            if (this.e == ThreeState.NO) {
                this.e = ThreeState.UNSURE;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw ObjectReferenceProxyImpl.b(vMDisconnectedException);
        }
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectReference", "com/intellij/debugger/jdi/ObjectReferenceProxyImpl", "<init>"));
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

