/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.JdiProxy;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ThreeState;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class StackFrameProxyImpl
extends JdiProxy
implements StackFrameProxy {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.jdi.StackFrameProxyImpl");
    private final ThreadReferenceProxyImpl d;
    private final int i;
    private int j;
    private StackFrame c;
    private ObjectReference f;
    private ClassLoaderReference h;
    private ThreeState g;
    private Map<LocalVariable, Value> e;

    public StackFrameProxyImpl(@NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl, @NotNull StackFrame stackFrame, int n2) {
        if (threadReferenceProxyImpl == null) {
            StackFrameProxyImpl.b(0);
        }
        if (stackFrame == null) {
            StackFrameProxyImpl.b(1);
        }
        super(threadReferenceProxyImpl.getVirtualMachine());
        this.j = -1;
        this.g = ThreeState.UNSURE;
        this.d = threadReferenceProxyImpl;
        this.i = n2;
        this.c = stackFrame;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isObsolete() throws EvaluateException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.checkValid();
            if (this.g != ThreeState.UNSURE) {
                return this.g.toBoolean();
            }
        }
        catch (InvalidStackFrameException v0) {
            throw StackFrameProxyImpl.b(v0);
        }
        var1_1 = null;
        for (var2_2 = 0; var2_2 < 2; ++var2_2) {
            try {
                block17: {
                    block16: {
                        block18: {
                            var3_4 = DebuggerUtilsEx.getMethod(this.location());
                            if (!this.getVirtualMachine().canRedefineClasses()) break block16;
                            if (var3_4 == null) ** GOTO lbl26
                            break block18;
                            catch (InvalidStackFrameException v1) {
                                throw StackFrameProxyImpl.b(v1);
                            }
                        }
                        try {
                            block19: {
                                if (!var3_4.isObsolete()) break block16;
                                break block19;
                                catch (InvalidStackFrameException v2) {
                                    throw StackFrameProxyImpl.b(v2);
                                }
                            }
                            v3 = true;
                            break block17;
                        }
                        catch (InvalidStackFrameException v4) {
                            throw StackFrameProxyImpl.b(v4);
                        }
                    }
                    v3 = false;
                }
                var4_6 = v3;
                this.g = ThreeState.fromBoolean((boolean)var4_6);
                return var4_6;
            }
            catch (InvalidStackFrameException var3_3) {
                var1_1 = var3_3;
                this.clearCaches();
                continue;
            }
            catch (InternalException var3_5) {
                try {
                    if (var3_5.errorCode() == 23) {
                        this.g = ThreeState.YES;
                        return true;
                    }
                }
                catch (InvalidStackFrameException v5) {
                    throw StackFrameProxyImpl.b(v5);
                }
                throw var3_5;
            }
        }
        throw new EvaluateException(var1_1.getMessage(), var1_1);
    }

    @Override
    public boolean isValid() {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (!super.isValid()) {
                return false;
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw StackFrameProxyImpl.b(invalidStackFrameException);
        }
        try {
            try {
                if (this.c != null) {
                    this.c.location();
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw StackFrameProxyImpl.b(invalidStackFrameException);
            }
            return true;
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            return false;
        }
    }

    @Override
    protected void clearCaches() {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (b.isDebugEnabled()) {
                b.debug("caches cleared " + super.toString());
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw StackFrameProxyImpl.b(invalidStackFrameException);
        }
        this.j = -1;
        this.c = null;
        this.g = ThreeState.UNSURE;
        this.f = null;
        this.h = null;
        this.e = null;
    }

    public StackFrame getStackFrame() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.c == null) {
            try {
                ThreadReference threadReference = this.d.getThreadReference();
                this.c = threadReference.frame(this.getFrameIndex());
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new EvaluateException(indexOutOfBoundsException.getMessage(), (Throwable)indexOutOfBoundsException);
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.thread.collected", (Object[])new Object[0]));
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
            }
        }
        return this.c;
    }

    public int getFrameIndex() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.j == -1) {
            int n2 = this.d.frameCount();
            try {
                if (this.i > n2) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)new IncompatibleThreadStateException());
                }
            }
            catch (EvaluateException evaluateException) {
                throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
            }
            this.j = n2 - this.i;
        }
        return this.j;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        VirtualMachineProxyImpl virtualMachineProxyImpl;
        try {
            virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
            if (virtualMachineProxyImpl == null) {
                StackFrameProxyImpl.b(2);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw StackFrameProxyImpl.b(invalidStackFrameException);
        }
        return virtualMachineProxyImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location location() throws EvaluateException {
        Throwable throwable = null;
        int n2 = 0;
        try {
            while (n2 < 2) {
                try {
                    return this.getStackFrame().location();
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throwable = invalidStackFrameException;
                    this.clearCaches();
                    ++n2;
                }
            }
            throw new EvaluateException(throwable.getMessage(), throwable);
        }
        catch (EvaluateException evaluateException) {
            throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
        }
    }

    @NotNull
    public ThreadReferenceProxyImpl threadProxy() {
        ThreadReferenceProxyImpl threadReferenceProxyImpl;
        try {
            threadReferenceProxyImpl = this.d;
            if (threadReferenceProxyImpl == null) {
                StackFrameProxyImpl.b(3);
            }
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw StackFrameProxyImpl.b(invalidStackFrameException);
        }
        return threadReferenceProxyImpl;
    }

    @NonNls
    public String toString() {
        try {
            return "StackFrameProxyImpl: " + this.getStackFrame().toString();
        }
        catch (EvaluateException evaluateException) {
            return "StackFrameProxyImpl: " + evaluateException.getMessage() + "; frameFromBottom = " + this.i + " threadName = " + this.threadProxy().name();
        }
    }

    @Nullable
    public ObjectReference thisObject() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        try {
            for (int i2 = 0; i2 < 2; ++i2) {
                try {
                    try {
                        if (this.f == null) {
                            this.f = this.getStackFrame().thisObject();
                        }
                        break;
                    }
                    catch (InternalException internalException) {
                        throw StackFrameProxyImpl.b(internalException);
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    this.clearCaches();
                    continue;
                }
            }
        }
        catch (InternalException internalException) {
            block14: {
                try {
                    try {
                        if (internalException.errorCode() == 23 || internalException.errorCode() == 35) break block14;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw StackFrameProxyImpl.b(invalidStackFrameException);
                    }
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)internalException);
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw StackFrameProxyImpl.b(invalidStackFrameException);
                }
            }
            b.info("Exception while getting this object", (Throwable)internalException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            b.info("Exception while getting this object", (Throwable)illegalArgumentException);
        }
        return this.f;
    }

    @NotNull
    public List<LocalVariableProxyImpl> visibleVariables() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            ArrayList<LocalVariableProxyImpl> arrayList;
            try {
                List<LocalVariable> list = this.getStackFrame().visibleVariables();
                ArrayList<LocalVariableProxyImpl> arrayList2 = new ArrayList<LocalVariableProxyImpl>(list.size());
                for (LocalVariable localVariable : list) {
                    boolean bl2;
                    Logger logger;
                    try {
                        logger = b;
                        bl2 = localVariable != null;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw StackFrameProxyImpl.b(invalidStackFrameException);
                    }
                    logger.assertTrue(bl2);
                    arrayList2.add(new LocalVariableProxyImpl(this, localVariable));
                }
                arrayList = arrayList2;
            }
            catch (InvalidStackFrameException | IllegalArgumentException runtimeException) {
                throwable = runtimeException;
                this.clearCaches();
                continue;
            }
            catch (AbsentInformationException absentInformationException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)absentInformationException);
            }
            if (arrayList == null) {
                StackFrameProxyImpl.b(4);
            }
            return arrayList;
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public LocalVariableProxyImpl visibleVariableByName(String string) throws EvaluateException {
        LocalVariableProxyImpl localVariableProxyImpl;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        LocalVariable localVariable = this.visibleVariableByNameInt(string);
        try {
            localVariableProxyImpl = localVariable != null ? new LocalVariableProxyImpl(this, localVariable) : null;
        }
        catch (EvaluateException evaluateException) {
            throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
        }
        return localVariableProxyImpl;
    }

    @Nullable
    public Value visibleValueByName(@NotNull String string) throws EvaluateException {
        Value value;
        try {
            if (string == null) {
                StackFrameProxyImpl.b(5);
            }
        }
        catch (EvaluateException evaluateException) {
            throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
        }
        LocalVariable localVariable = this.visibleVariableByNameInt(string);
        try {
            value = localVariable != null ? this.getValue(new LocalVariableProxyImpl(this, localVariable)) : null;
        }
        catch (EvaluateException evaluateException) {
            throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
        }
        return value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected LocalVariable visibleVariableByNameInt(String string) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        int n2 = 0;
        while (true) {
            try {
                if (n2 >= 2) throw new EvaluateException(throwable.getMessage(), throwable);
                try {
                    return this.getStackFrame().visibleVariableByName(string);
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    try {
                        throwable = invalidStackFrameException;
                        this.clearCaches();
                    }
                    catch (AbsentInformationException | InvalidStackFrameException exception) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
            }
            ++n2;
        }
    }

    public Value getValue(LocalVariableProxyImpl localVariableProxyImpl) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                Map<LocalVariable, Value> map = this.a();
                LocalVariable localVariable = localVariableProxyImpl.getVariable();
                if (map.containsKey(localVariable)) {
                    return map.get(localVariable);
                }
                return this.getStackFrame().getValue(localVariable);
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                this.clearCaches();
                throw EvaluateExceptionUtil.INCONSISTEND_DEBUG_INFO;
            }
            catch (InternalException internalException) {
                block10: {
                    try {
                        try {
                            if (internalException.errorCode() != 35 && internalException.errorCode() != 101) break block10;
                        }
                        catch (InvalidStackFrameException invalidStackFrameException) {
                            throw StackFrameProxyImpl.b(invalidStackFrameException);
                        }
                        throw new EvaluateException(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{internalException.getMessage()}), (Throwable)internalException);
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw StackFrameProxyImpl.b(invalidStackFrameException);
                    }
                }
                throw internalException;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public List<Value> getArgumentValues() throws EvaluateException {
        List<Value> list;
        block13: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            Throwable throwable = null;
            int i2 = 0;
            while (i2 < 2) {
                try {
                    block12: {
                        StackFrame stackFrame = this.getStackFrame();
                        try {
                            if (stackFrame == null) break block12;
                            list = stackFrame.getArgumentValues();
                            break block13;
                        }
                        catch (InternalException internalException) {
                            throw StackFrameProxyImpl.b(internalException);
                        }
                    }
                    list = Collections.emptyList();
                    break block13;
                }
                catch (InternalException internalException) {
                    try {
                        List<Value> list2;
                        try {
                            if (internalException.errorCode() != 32) throw internalException;
                            List<Value> list3 = Collections.emptyList();
                            list2 = list3;
                            if (list3 != null) return list2;
                        }
                        catch (InternalException internalException2) {
                            throw StackFrameProxyImpl.b(internalException2);
                        }
                        StackFrameProxyImpl.b(7);
                        return list2;
                    }
                    catch (InternalException internalException3) {
                        throw StackFrameProxyImpl.b(internalException3);
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throwable = invalidStackFrameException;
                    this.clearCaches();
                    ++i2;
                }
            }
            throw new EvaluateException(throwable.getMessage(), throwable);
        }
        try {
            if (list != null) List<Value> list4;
            return list4;
            StackFrameProxyImpl.b(6);
            return list;
        }
        catch (InternalException internalException) {
            throw StackFrameProxyImpl.b(internalException);
        }
    }

    private Map<LocalVariable, Value> a() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.e == null) {
            try {
                StackFrame stackFrame = this.getStackFrame();
                this.e = new THashMap(stackFrame.getValues(stackFrame.visibleVariables()));
            }
            catch (AbsentInformationException absentInformationException) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)absentInformationException);
            }
            catch (InternalException internalException) {
                block8: {
                    try {
                        try {
                            if (internalException.errorCode() != 35 && internalException.errorCode() != 101) break block8;
                        }
                        catch (AbsentInformationException absentInformationException) {
                            throw StackFrameProxyImpl.b(absentInformationException);
                        }
                        b.info((Throwable)internalException);
                        this.e = new THashMap();
                    }
                    catch (AbsentInformationException absentInformationException) {
                        throw StackFrameProxyImpl.b(absentInformationException);
                    }
                }
                throw internalException;
            }
        }
        return this.e;
    }

    public void setValue(LocalVariableProxyImpl localVariableProxyImpl, Value value) throws EvaluateException, ClassNotLoadedException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Throwable throwable = null;
        for (int i2 = 0; i2 < 2; ++i2) {
            try {
                Value value2;
                LocalVariable localVariable;
                StackFrame stackFrame;
                LocalVariable localVariable2 = localVariableProxyImpl.getVariable();
                StackFrame stackFrame2 = this.getStackFrame();
                try {
                    stackFrame = stackFrame2;
                    localVariable = localVariable2;
                    value2 = value instanceof ObjectReference ? (ObjectReference)value : value;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw StackFrameProxyImpl.b(invalidStackFrameException);
                }
                try {
                    stackFrame.setValue(localVariable, value2);
                    if (this.e != null) {
                        this.e.put(localVariable2, stackFrame2.getValue(localVariable2));
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw StackFrameProxyImpl.b(invalidStackFrameException);
                }
                return;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throwable = invalidStackFrameException;
                this.clearCaches();
                continue;
            }
        }
        throw new EvaluateException(throwable.getMessage(), throwable);
    }

    public int hashCode() {
        return 31 * this.d.hashCode() + this.i;
    }

    public boolean equals(Object object) {
        boolean bl2;
        block11: {
            block10: {
                try {
                    if (!(object instanceof StackFrameProxyImpl)) {
                        return false;
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw StackFrameProxyImpl.b(invalidStackFrameException);
                }
                StackFrameProxyImpl stackFrameProxyImpl = (StackFrameProxyImpl)object;
                try {
                    if (stackFrameProxyImpl == this) {
                        return true;
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw StackFrameProxyImpl.b(invalidStackFrameException);
                }
                try {
                    try {
                        if (this.i != stackFrameProxyImpl.i || !this.d.equals(stackFrameProxyImpl.d)) break block10;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw StackFrameProxyImpl.b(invalidStackFrameException);
                    }
                    bl2 = true;
                    break block11;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw StackFrameProxyImpl.b(invalidStackFrameException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public boolean isLocalVariableVisible(LocalVariableProxyImpl localVariableProxyImpl) throws EvaluateException {
        try {
            return localVariableProxyImpl.getVariable().isVisible(this.getStackFrame());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public ClassLoaderReference getClassLoader() throws EvaluateException {
        try {
            if (this.h == null) {
                this.h = this.location().declaringType().classLoader();
            }
        }
        catch (EvaluateException evaluateException) {
            throw StackFrameProxyImpl.b((Exception)((Object)evaluateException));
        }
        return this.h;
    }

    public boolean isBottom() {
        boolean bl2;
        try {
            bl2 = this.i == 1;
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            throw StackFrameProxyImpl.b(invalidStackFrameException);
        }
        return bl2;
    }

    public int getIndexFromBottom() {
        return this.i;
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void b(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

