/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

@State(name="DebuggerSettings", defaultStateAsResource=true, storages={@Storage(value="debugger.xml"), @Storage(value="other.xml", deprecated=true)})
public class DebuggerSettings
implements Cloneable,
PersistentStateComponent<Element> {
    private static final Logger c = Logger.getInstance(DebuggerSettings.class);
    public static final int SOCKET_TRANSPORT = 0;
    public static final int SHMEM_TRANSPORT = 1;
    @NonNls
    public static final String SUSPEND_ALL = "SuspendAll";
    @NonNls
    public static final String SUSPEND_THREAD = "SuspendThread";
    @NonNls
    public static final String SUSPEND_NONE = "SuspendNone";
    @NonNls
    public static final String RUN_HOTSWAP_ALWAYS = "RunHotswapAlways";
    @NonNls
    public static final String RUN_HOTSWAP_NEVER = "RunHotswapNever";
    @NonNls
    public static final String RUN_HOTSWAP_ASK = "RunHotswapAsk";
    @NonNls
    public static final String EVALUATE_FINALLY_ALWAYS = "EvaluateFinallyAlways";
    @NonNls
    public static final String EVALUATE_FINALLY_NEVER = "EvaluateFinallyNever";
    @NonNls
    public static final String EVALUATE_FINALLY_ASK = "EvaluateFinallyAsk";
    public boolean TRACING_FILTERS_ENABLED = true;
    public int DEBUGGER_TRANSPORT;
    public boolean FORCE_CLASSIC_VM = true;
    public boolean DISABLE_JIT;
    public boolean SHOW_ALTERNATIVE_SOURCE = true;
    public boolean HOTSWAP_IN_BACKGROUND = true;
    public boolean SKIP_SYNTHETIC_METHODS = true;
    public boolean SKIP_CONSTRUCTORS;
    public boolean SKIP_GETTERS;
    public boolean SKIP_CLASSLOADERS = true;
    public String RUN_HOTSWAP_AFTER_COMPILE = "RunHotswapAsk";
    public boolean COMPILE_BEFORE_HOTSWAP = true;
    public boolean HOTSWAP_HANG_WARNING_ENABLED = false;
    public volatile boolean WATCH_RETURN_VALUES = false;
    public volatile boolean AUTO_VARIABLES_MODE = false;
    public volatile boolean KILL_PROCESS_IMMEDIATELY = false;
    public String EVALUATE_FINALLY_ON_POP_FRAME = "EvaluateFinallyAsk";
    public boolean RESUME_ONLY_CURRENT_THREAD = false;
    private ClassFilter[] a = ClassFilter.EMPTY_ARRAY;
    public boolean INSTRUMENTING_AGENT = true;
    private List<CapturePoint> b = new ArrayList<CapturePoint>();
    public boolean CAPTURE_VARIABLES;
    private final EventDispatcher<CapturePointsSettingsListener> e = EventDispatcher.create(CapturePointsSettingsListener.class);
    private Map<String, ContentState> d = new LinkedHashMap();

    @Transient
    public ClassFilter[] getSteppingFilters() {
        ClassFilter[] classFilterArray = new ClassFilter[this.a.length];
        try {
            for (int i2 = 0; i2 < classFilterArray.length; ++i2) {
                classFilterArray[i2] = this.a[i2].clone();
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw DebuggerSettings.b((Exception)((Object)writeExternalException));
        }
        return classFilterArray;
    }

    public static DebuggerSettings getInstance() {
        return (DebuggerSettings)ServiceManager.getService(DebuggerSettings.class);
    }

    public void setSteppingFilters(ClassFilter[] classFilterArray) {
        ClassFilter[] classFilterArray2;
        try {
            DebuggerSettings debuggerSettings = this;
            classFilterArray2 = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
        }
        catch (WriteExternalException writeExternalException) {
            throw DebuggerSettings.b((Exception)((Object)writeExternalException));
        }
        debuggerSettings.a = classFilterArray2;
    }

    @Nullable
    public Element getState() {
        Element element = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultsSerializationFilter());
        try {
            DebuggerUtilsEx.writeFilters(element, "filter", this.a);
        }
        catch (WriteExternalException writeExternalException) {
            c.error((Throwable)writeExternalException);
            return null;
        }
        for (ContentState contentState : this.d.values()) {
            Element element2 = new Element("content");
            try {
                if (!contentState.write(element2)) continue;
                element.addContent(element2);
            }
            catch (WriteExternalException writeExternalException) {
                throw DebuggerSettings.b((Exception)((Object)writeExternalException));
            }
        }
        return element;
    }

    public void loadState(Element element) {
        XmlSerializer.deserializeInto((Object)this, (Element)element);
        try {
            this.setSteppingFilters(DebuggerUtilsEx.readFilters(element.getChildren("filter")));
        }
        catch (InvalidDataException invalidDataException) {
            c.error((Throwable)invalidDataException);
        }
        this.d.clear();
        for (Element element2 : element.getChildren("content")) {
            ContentState contentState = new ContentState(element2);
            this.d.put(contentState.getType(), contentState);
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object var1_1) {
        block45: {
            block43: {
                block44: {
                    try {
                        if (!(var1_1 instanceof DebuggerSettings)) {
                            return false;
                        }
                    }
                    catch (WriteExternalException v0) {
                        throw DebuggerSettings.b((Exception)v0);
                    }
                    var2_2 = (DebuggerSettings)var1_1;
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    try {
                                                        try {
                                                            try {
                                                                try {
                                                                    try {
                                                                        try {
                                                                            try {
                                                                                try {
                                                                                    try {
                                                                                        if (this.TRACING_FILTERS_ENABLED != var2_2.TRACING_FILTERS_ENABLED || this.DEBUGGER_TRANSPORT != var2_2.DEBUGGER_TRANSPORT) break block43;
                                                                                    }
                                                                                    catch (WriteExternalException v1) {
                                                                                        throw DebuggerSettings.b((Exception)v1);
                                                                                    }
                                                                                    if (!StringUtil.equals((CharSequence)this.EVALUATE_FINALLY_ON_POP_FRAME, (CharSequence)var2_2.EVALUATE_FINALLY_ON_POP_FRAME)) break block43;
                                                                                }
                                                                                catch (WriteExternalException v2) {
                                                                                    throw DebuggerSettings.b((Exception)v2);
                                                                                }
                                                                                if (this.FORCE_CLASSIC_VM != var2_2.FORCE_CLASSIC_VM) break block43;
                                                                            }
                                                                            catch (WriteExternalException v3) {
                                                                                throw DebuggerSettings.b((Exception)v3);
                                                                            }
                                                                            if (this.DISABLE_JIT != var2_2.DISABLE_JIT) break block43;
                                                                        }
                                                                        catch (WriteExternalException v4) {
                                                                            throw DebuggerSettings.b((Exception)v4);
                                                                        }
                                                                        if (this.SHOW_ALTERNATIVE_SOURCE != var2_2.SHOW_ALTERNATIVE_SOURCE) break block43;
                                                                    }
                                                                    catch (WriteExternalException v5) {
                                                                        throw DebuggerSettings.b((Exception)v5);
                                                                    }
                                                                    if (this.KILL_PROCESS_IMMEDIATELY != var2_2.KILL_PROCESS_IMMEDIATELY) break block43;
                                                                }
                                                                catch (WriteExternalException v6) {
                                                                    throw DebuggerSettings.b((Exception)v6);
                                                                }
                                                                if (this.HOTSWAP_IN_BACKGROUND != var2_2.HOTSWAP_IN_BACKGROUND) break block43;
                                                            }
                                                            catch (WriteExternalException v7) {
                                                                throw DebuggerSettings.b((Exception)v7);
                                                            }
                                                            if (this.SKIP_SYNTHETIC_METHODS != var2_2.SKIP_SYNTHETIC_METHODS) break block43;
                                                        }
                                                        catch (WriteExternalException v8) {
                                                            throw DebuggerSettings.b((Exception)v8);
                                                        }
                                                        if (this.SKIP_CLASSLOADERS != var2_2.SKIP_CLASSLOADERS) break block43;
                                                    }
                                                    catch (WriteExternalException v9) {
                                                        throw DebuggerSettings.b((Exception)v9);
                                                    }
                                                    if (this.SKIP_CONSTRUCTORS != var2_2.SKIP_CONSTRUCTORS) break block43;
                                                }
                                                catch (WriteExternalException v10) {
                                                    throw DebuggerSettings.b((Exception)v10);
                                                }
                                                if (this.SKIP_GETTERS != var2_2.SKIP_GETTERS) break block43;
                                            }
                                            catch (WriteExternalException v11) {
                                                throw DebuggerSettings.b((Exception)v11);
                                            }
                                            if (this.RESUME_ONLY_CURRENT_THREAD != var2_2.RESUME_ONLY_CURRENT_THREAD) break block43;
                                        }
                                        catch (WriteExternalException v12) {
                                            throw DebuggerSettings.b((Exception)v12);
                                        }
                                        if (this.COMPILE_BEFORE_HOTSWAP != var2_2.COMPILE_BEFORE_HOTSWAP) break block43;
                                    }
                                    catch (WriteExternalException v13) {
                                        throw DebuggerSettings.b((Exception)v13);
                                    }
                                    if (this.HOTSWAP_HANG_WARNING_ENABLED != var2_2.HOTSWAP_HANG_WARNING_ENABLED) break block43;
                                }
                                catch (WriteExternalException v14) {
                                    throw DebuggerSettings.b((Exception)v14);
                                }
                                if (this.RUN_HOTSWAP_AFTER_COMPILE == null) break block44;
                            }
                            catch (WriteExternalException v15) {
                                throw DebuggerSettings.b((Exception)v15);
                            }
                            if (!this.RUN_HOTSWAP_AFTER_COMPILE.equals(var2_2.RUN_HOTSWAP_AFTER_COMPILE)) break block43;
                            ** GOTO lbl96
                        }
                        catch (WriteExternalException v16) {
                            throw DebuggerSettings.b((Exception)v16);
                        }
                    }
                    catch (WriteExternalException v17) {
                        throw DebuggerSettings.b((Exception)v17);
                    }
                }
                try {
                    try {
                        try {
                            if (var2_2.RUN_HOTSWAP_AFTER_COMPILE != null) break block43;
lbl96:
                            // 2 sources

                            if (!DebuggerUtilsEx.filterEquals(this.a, var2_2.a)) break block43;
                        }
                        catch (WriteExternalException v18) {
                            throw DebuggerSettings.b((Exception)v18);
                        }
                        if (!this.b.equals(((DebuggerSettings)var1_1).b)) break block43;
                    }
                    catch (WriteExternalException v19) {
                        throw DebuggerSettings.b((Exception)v19);
                    }
                    v20 = true;
                    break block45;
                }
                catch (WriteExternalException v21) {
                    throw DebuggerSettings.b((Exception)v21);
                }
            }
            v20 = false;
        }
        return v20;
    }

    public DebuggerSettings clone() {
        try {
            DebuggerSettings debuggerSettings = (DebuggerSettings)super.clone();
            debuggerSettings.d = new HashMap<String, ContentState>();
            for (Map.Entry<String, ContentState> entry : this.d.entrySet()) {
                debuggerSettings.d.put(entry.getKey(), entry.getValue().clone());
            }
            debuggerSettings.a = new ClassFilter[this.a.length];
            try {
                for (int i2 = 0; i2 < this.a.length; ++i2) {
                    debuggerSettings.a[i2] = this.a[i2].clone();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw DebuggerSettings.b(cloneNotSupportedException);
            }
            debuggerSettings.b = this.cloneCapturePoints();
            return debuggerSettings;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            c.error((Throwable)cloneNotSupportedException);
            return null;
        }
    }

    List<CapturePoint> cloneCapturePoints() {
        try {
            ArrayList<CapturePoint> arrayList = new ArrayList<CapturePoint>(this.b.size());
            for (CapturePoint capturePoint : this.b) {
                arrayList.add(capturePoint.clone());
            }
            return arrayList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            c.error((Throwable)cloneNotSupportedException);
            return Collections.emptyList();
        }
    }

    @XCollection(propertyElementName="capture-points")
    public List<CapturePoint> getCapturePoints() {
        return this.b;
    }

    public void setCapturePoints(List<CapturePoint> list) {
        this.b = list;
        ((CapturePointsSettingsListener)this.e.getMulticaster()).capturePointsChanged();
    }

    public void addCapturePointsSettingsListener(CapturePointsSettingsListener capturePointsSettingsListener, Disposable disposable) {
        this.e.addListener((EventListener)capturePointsSettingsListener, disposable);
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    public static interface CapturePointsSettingsListener
    extends EventListener {
        public void capturePointsChanged();
    }

    public static class ContentState
    implements Cloneable {
        private final String a;
        private boolean g;
        private String d;
        private double e;
        private boolean c;
        private boolean b;
        private boolean f;

        public ContentState(String string) {
            this.a = string;
        }

        public ContentState(Element element) {
            this.a = element.getAttributeValue("type");
            this.g = Boolean.parseBoolean(element.getAttributeValue("minimized"));
            this.f = Boolean.parseBoolean(element.getAttributeValue("maximized"));
            this.d = element.getAttributeValue("selected");
            String string = element.getAttributeValue("split");
            if (string != null) {
                this.e = Double.valueOf(string);
            }
            this.c = Boolean.parseBoolean(element.getAttributeValue("detached"));
            this.b = !"false".equalsIgnoreCase(element.getAttributeValue("horizontal"));
        }

        public boolean write(Element element) {
            element.setAttribute("type", this.a);
            element.setAttribute("minimized", Boolean.valueOf(this.g).toString());
            element.setAttribute("maximized", Boolean.valueOf(this.f).toString());
            if (this.d != null) {
                element.setAttribute("selected", this.d);
            }
            element.setAttribute("split", Double.toString(this.e));
            element.setAttribute("detached", Boolean.valueOf(this.c).toString());
            element.setAttribute("horizontal", Boolean.valueOf(this.b).toString());
            return true;
        }

        public String getType() {
            return this.a;
        }

        public String getSelectedTab() {
            return this.d;
        }

        public boolean isMinimized() {
            return this.g;
        }

        public void setMinimized(boolean bl2) {
            this.g = bl2;
        }

        public void setMaximized(boolean bl2) {
            this.f = bl2;
        }

        public boolean isMaximized() {
            return this.f;
        }

        public void setSelectedTab(String string) {
            this.d = string;
        }

        public void setSplitProportion(double d2) {
            this.e = d2;
        }

        public double getSplitProportion(double d2) {
            return this.e <= 0.0 || this.e >= 1.0 ? d2 : this.e;
        }

        public void setDetached(boolean bl2) {
            this.c = bl2;
        }

        public boolean isDetached() {
            return this.c;
        }

        public boolean isHorizontalToolbar() {
            return this.b;
        }

        public void setHorizontalToolbar(boolean bl2) {
            this.b = bl2;
        }

        public ContentState clone() throws CloneNotSupportedException {
            return (ContentState)super.clone();
        }
    }
}

