/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.InternalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdom.Element;

public class RendererConfiguration
implements Cloneable,
JDOMExternalizable {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.settings.NodeRendererSettings");
    private static final int b = 8;
    private List<NodeRenderer> d = new CopyOnWriteArrayList<NodeRenderer>();
    private final NodeRendererSettings c;

    protected RendererConfiguration(NodeRendererSettings nodeRendererSettings) {
        this.c = nodeRendererSettings;
    }

    public RendererConfiguration clone() {
        RendererConfiguration rendererConfiguration = null;
        try {
            rendererConfiguration = (RendererConfiguration)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            a.error((Throwable)cloneNotSupportedException);
        }
        rendererConfiguration.d = new CopyOnWriteArrayList<NodeRenderer>();
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>();
        for (NodeRenderer nodeRenderer : this.d) {
            arrayList.add((NodeRenderer)nodeRenderer.clone());
        }
        rendererConfiguration.setRenderers(arrayList);
        return rendererConfiguration;
    }

    public boolean equals(Object object) {
        try {
            if (!(object instanceof RendererConfiguration)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RendererConfiguration.b(numberFormatException);
        }
        return DebuggerUtilsEx.externalizableEqual(this, (RendererConfiguration)object);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        for (NodeRenderer nodeRenderer : this.d) {
            element.addContent(this.c.writeRenderer(nodeRenderer));
        }
        element.setAttribute("VERSION", String.valueOf(8));
    }

    public void readExternal(Element element) {
        String string = element.getAttributeValue("VERSION");
        int n2 = -1;
        if (string != null) {
            try {
                n2 = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        try {
            if (n2 != 8) {
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RendererConfiguration.b(numberFormatException);
        }
        List list = element.getChildren("Renderer");
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>(list.size());
        for (Element element2 : list) {
            try {
                arrayList.add((NodeRenderer)this.c.readRenderer(element2));
            }
            catch (Exception exception) {
                a.debug((Throwable)exception);
            }
        }
        this.setRenderers(arrayList);
    }

    public void addRenderer(NodeRenderer nodeRenderer) {
        this.d.add(0, nodeRenderer);
    }

    public void removeRenderer(NodeRenderer nodeRenderer) {
        this.d.remove(nodeRenderer);
    }

    public void setRenderers(Collection<NodeRenderer> collection) {
        this.d.clear();
        this.d.addAll(collection);
    }

    public void iterateRenderers(InternalIterator<NodeRenderer> internalIterator) {
        for (NodeRenderer nodeRenderer : this.d) {
            boolean bl2 = internalIterator.visit((Object)nodeRenderer);
            try {
                if (bl2) continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
                throw RendererConfiguration.b(numberFormatException);
            }
        }
    }

    public int getRendererCount() {
        return this.d.size();
    }

    public boolean contains(NodeRenderer nodeRenderer) {
        return this.d.contains(nodeRenderer);
    }

    private static NumberFormatException b(NumberFormatException numberFormatException) {
        return numberFormatException;
    }
}

