/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.settings.FieldDataBinding;
import java.lang.reflect.Field;
import javax.swing.JToggleButton;
import org.jetbrains.annotations.NonNls;

public class ToggleButtonBinding
extends FieldDataBinding {
    private final JToggleButton b;

    public ToggleButtonBinding(@NonNls String string, JToggleButton jToggleButton) {
        super(string);
        this.b = jToggleButton;
    }

    @Override
    public void doLoadData(Object object, Field field) throws IllegalAccessException {
        Boolean bl2 = (Boolean)field.get(object);
        this.b.setSelected(bl2);
    }

    @Override
    public void doSaveData(Object object, Field field) throws IllegalAccessException {
        field.set(object, this.b.isSelected());
    }

    @Override
    protected boolean isModified(Object object, Field field) throws IllegalAccessException {
        boolean bl2;
        Boolean bl3 = (Boolean)field.get(object);
        try {
            bl2 = this.b.isSelected() != bl3.booleanValue();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ToggleButtonBinding.b(illegalAccessException);
        }
        return bl2;
    }

    private static IllegalAccessException b(IllegalAccessException illegalAccessException) {
        return illegalAccessException;
    }
}

