/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.Nullable;

public abstract class EditorEvaluationCommand<T>
extends DebuggerContextCommandImpl {
    protected final PsiElement myElement;
    @Nullable
    private final Editor h;
    protected final ProgressIndicator myProgressIndicator;

    public EditorEvaluationCommand(@Nullable Editor editor, PsiElement psiElement, DebuggerContextImpl debuggerContextImpl, ProgressIndicator progressIndicator) {
        super(debuggerContextImpl);
        this.myProgressIndicator = progressIndicator;
        this.h = editor;
        this.myElement = psiElement;
    }

    @Override
    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    protected abstract T evaluate(EvaluationContextImpl var1) throws EvaluateException;

    public T evaluate() throws EvaluateException {
        Object[] objectArray = new Object[1];
        objectArray[0] = ReadAction.compute(() -> ((PsiElement)this.myElement).getText());
        this.myProgressIndicator.setText(DebuggerBundle.message((String)"progress.evaluating", (Object[])objectArray));
        try {
            T t2 = this.evaluate(this.getDebuggerContext().createEvaluationContext());
            try {
                if (this.myProgressIndicator.isCanceled()) {
                    throw new ProcessCanceledException();
                }
            }
            catch (EvaluateException evaluateException) {
                throw EditorEvaluationCommand.c((Exception)((Object)evaluateException));
            }
            return t2;
        }
        catch (EvaluateException evaluateException) {
            try {
                if (this.h != null) {
                    DebuggerInvocationUtil.invokeLater(this.myElement.getProject(), () -> EditorEvaluationCommand.showEvaluationHint(this.h, this.myElement, evaluateException), this.myProgressIndicator.getModalityState());
                }
            }
            catch (EvaluateException evaluateException2) {
                throw EditorEvaluationCommand.c((Exception)((Object)evaluateException2));
            }
            throw evaluateException;
        }
    }

    public static void showEvaluationHint(Editor editor, PsiElement psiElement, EvaluateException evaluateException) {
        block4: {
            try {
                try {
                    if (!editor.isDisposed() && editor.getComponent().isVisible()) break block4;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw EditorEvaluationCommand.c((Exception)((Object)processCanceledException));
                }
                return;
            }
            catch (ProcessCanceledException processCanceledException) {
                throw EditorEvaluationCommand.c((Exception)((Object)processCanceledException));
            }
        }
        HintManager.getInstance().showErrorHint(editor, evaluateException.getMessage(), psiElement.getTextRange().getStartOffset(), psiElement.getTextRange().getEndOffset(), (short)2, 9, 1500);
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

