/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.ReferenceType;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class AnyExceptionBreakpoint
extends ExceptionBreakpoint {
    @NonNls
    public static final Key<AnyExceptionBreakpoint> ANY_EXCEPTION_BREAKPOINT = BreakpointCategory.lookup("breakpoint_any");

    protected AnyExceptionBreakpoint(Project project2, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, null, null, xBreakpoint);
    }

    @Override
    public Key<AnyExceptionBreakpoint> getCategory() {
        return ANY_EXCEPTION_BREAKPOINT;
    }

    @Override
    public String getDisplayName() {
        return DebuggerBundle.message((String)"breakpoint.any.exception.display.name", (Object[])new Object[0]);
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcessImpl) {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (!this.shouldCreateRequest(debugProcessImpl)) {
                return;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw AnyExceptionBreakpoint.b(invalidDataException);
        }
        super.processClassPrepare(debugProcessImpl, null);
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        try {
            super.readExternal(element);
        }
        catch (InvalidDataException invalidDataException) {
            try {
                if (!READ_NO_CLASS_NAME.equals(invalidDataException.getMessage())) {
                    throw invalidDataException;
                }
            }
            catch (InvalidDataException invalidDataException2) {
                throw AnyExceptionBreakpoint.b(invalidDataException2);
            }
        }
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

