/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestorImpl;
import com.intellij.debugger.ui.impl.watch.CompilingEvaluatorImpl;
import com.intellij.debugger.ui.overhead.OverheadProducer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.EventRequest;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class Breakpoint<P extends JavaBreakpointProperties>
implements FilteredRequestor,
ClassPrepareRequestor,
OverheadProducer {
    public static final Key<Breakpoint> DATA_KEY = Key.create((String)"JavaBreakpoint");
    private static final Key<Long> b = Key.create((String)"HIT_COUNTER");
    final XBreakpoint<P> myXBreakpoint;
    protected final Project myProject;
    @NonNls
    private static final String a = "LOG_MESSAGE";
    protected boolean myCachedVerifiedState;

    protected Breakpoint(@NotNull Project project2, XBreakpoint<P> xBreakpoint) {
        if (project2 == null) {
            Breakpoint.a(0);
        }
        this.myCachedVerifiedState = false;
        this.myProject = project2;
        this.myXBreakpoint = xBreakpoint;
    }

    @NotNull
    public Project getProject() {
        Project project2;
        try {
            project2 = this.myProject;
            if (project2 == null) {
                Breakpoint.a(1);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        return project2;
    }

    @NotNull
    protected P getProperties() {
        JavaBreakpointProperties javaBreakpointProperties;
        try {
            javaBreakpointProperties = (JavaBreakpointProperties)this.myXBreakpoint.getProperties();
            if (javaBreakpointProperties == null) {
                Breakpoint.a(2);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        return (P)((Object)javaBreakpointProperties);
    }

    public XBreakpoint<P> getXBreakpoint() {
        return this.myXBreakpoint;
    }

    @Nullable
    public abstract PsiClass getPsiClass();

    public abstract void createRequest(DebugProcessImpl var1);

    static boolean shouldCreateRequest(Requestor requestor, XBreakpoint xBreakpoint, DebugProcessImpl debugProcessImpl, boolean bl2) {
        return (Boolean)ReadAction.compute(() -> {
            boolean bl3;
            block15: {
                block12: {
                    JavaDebugProcess javaDebugProcess = debugProcessImpl.getXdebugProcess();
                    try {
                        block14: {
                            try {
                                try {
                                    block13: {
                                        try {
                                            try {
                                                try {
                                                    if (javaDebugProcess == null || !debugProcessImpl.isAttached()) break block12;
                                                }
                                                catch (RuntimeException runtimeException) {
                                                    throw Breakpoint.b(runtimeException);
                                                }
                                                if (xBreakpoint == null) break block13;
                                            }
                                            catch (RuntimeException runtimeException) {
                                                throw Breakpoint.b(runtimeException);
                                            }
                                            if (!((XDebugSessionImpl)javaDebugProcess.getSession()).isBreakpointActive(xBreakpoint)) break block12;
                                        }
                                        catch (RuntimeException runtimeException) {
                                            throw Breakpoint.b(runtimeException);
                                        }
                                    }
                                    if (bl2) break block14;
                                }
                                catch (RuntimeException runtimeException) {
                                    throw Breakpoint.b(runtimeException);
                                }
                                if (!debugProcessImpl.getRequestsManager().findRequests(requestor).isEmpty()) break block12;
                            }
                            catch (RuntimeException runtimeException) {
                                throw Breakpoint.b(runtimeException);
                            }
                        }
                        bl3 = true;
                        break block15;
                    }
                    catch (RuntimeException runtimeException) {
                        throw Breakpoint.b(runtimeException);
                    }
                }
                bl3 = false;
            }
            return bl3;
        });
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcessImpl, boolean bl2) {
        return Breakpoint.shouldCreateRequest(this, this.getXBreakpoint(), debugProcessImpl, bl2);
    }

    protected final boolean shouldCreateRequest(DebugProcessImpl debugProcessImpl) {
        return this.shouldCreateRequest(debugProcessImpl, false);
    }

    public abstract void processClassPrepare(DebugProcess var1, ReferenceType var2);

    @Override
    public void customizeRenderer(SimpleColoredComponent simpleColoredComponent) {
        block3: {
            block2: {
                try {
                    if (this.myXBreakpoint == null) break block2;
                    simpleColoredComponent.setIcon(this.myXBreakpoint.getType().getEnabledIcon());
                    break block3;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    throw Breakpoint.b(vMDisconnectedException);
                }
            }
            simpleColoredComponent.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
        simpleColoredComponent.append(this.getDisplayName());
    }

    public abstract String getDisplayName();

    public String getShortName() {
        return this.getDisplayName();
    }

    @Nullable
    public String getClassName() {
        return null;
    }

    public void markVerified(boolean bl2) {
        this.myCachedVerifiedState = bl2;
    }

    public boolean isRemoveAfterHit() {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!(this.myXBreakpoint instanceof XLineBreakpoint) || !((XLineBreakpoint)this.myXBreakpoint).isTemporary()) break block4;
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        throw Breakpoint.b(vMDisconnectedException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    throw Breakpoint.b(vMDisconnectedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public void setRemoveAfterHit(boolean bl2) {
        try {
            if (this.myXBreakpoint instanceof XLineBreakpoint) {
                ((XLineBreakpoint)this.myXBreakpoint).setTemporary(bl2);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Nullable
    public String getShortClassName() {
        String string;
        block8: {
            String string2;
            block7: {
                string2 = this.getClassName();
                try {
                    if (string2 == null) {
                        return null;
                    }
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    throw Breakpoint.b(vMDisconnectedException);
                }
                int n2 = string2.lastIndexOf(46);
                try {
                    try {
                        if (n2 < 0 || n2 + 1 >= string2.length()) break block7;
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        throw Breakpoint.b(vMDisconnectedException);
                    }
                    string = string2.substring(n2 + 1);
                    break block8;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    throw Breakpoint.b(vMDisconnectedException);
                }
            }
            string = string2;
        }
        return string;
    }

    @Nullable
    public String getPackageName() {
        return null;
    }

    public abstract Icon getIcon();

    public abstract void reload();

    public abstract String getEventMessage(LocatableEvent var1);

    protected String getStackTrace(LocatableEvent locatableEvent) {
        StringBuilder stringBuilder = new StringBuilder(DebuggerBundle.message((String)"status.line.breakpoint.reached.full.trace", (Object[])new Object[0]));
        try {
            locatableEvent.thread().frames().forEach(stackFrame -> stringBuilder.append("\n\t  ").append(ThreadDumpAction.renderLocation(stackFrame.location())));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            stringBuilder.append("Stacktrace not available: ").append(incompatibleThreadStateException.getMessage());
        }
        return stringBuilder.toString();
    }

    public abstract boolean isValid();

    public abstract Key<? extends Breakpoint> getCategory();

    protected void createOrWaitPrepare(DebugProcessImpl debugProcessImpl, String string) {
        debugProcessImpl.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, string);
        this.a(debugProcessImpl, debugProcessImpl.getVirtualMachineProxy().classesByName(string).stream());
    }

    protected void createOrWaitPrepare(DebugProcessImpl debugProcessImpl, @NotNull SourcePosition sourcePosition) {
        try {
            if (sourcePosition == null) {
                Breakpoint.a(3);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        debugProcessImpl.getRequestsManager().callbackOnPrepareClasses((ClassPrepareRequestor)this, sourcePosition);
        this.a(debugProcessImpl, debugProcessImpl.getPositionManager().getAllClasses(sourcePosition).stream());
    }

    private void a(DebugProcessImpl debugProcessImpl, Stream<ReferenceType> stream2) {
        stream2.filter(ReferenceType::isPrepared).forEach(referenceType -> this.processClassPrepare(debugProcessImpl, (ReferenceType)referenceType));
    }

    protected ObjectReference getThisObject(SuspendContextImpl suspendContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
        if (threadReferenceProxyImpl != null) {
            StackFrameProxyImpl stackFrameProxyImpl = threadReferenceProxyImpl.frame(0);
            try {
                if (stackFrameProxyImpl != null) {
                    return stackFrameProxyImpl.thisObject();
                }
            }
            catch (EvaluateException evaluateException) {
                throw Breakpoint.b((Exception)((Object)evaluateException));
            }
        }
        return null;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
        SuspendContextImpl suspendContextImpl = suspendContextCommandImpl.getSuspendContext();
        try {
            if (!this.isValid()) {
                suspendContextImpl.getDebugProcess().getRequestsManager().deleteRequest(this);
                return false;
            }
        }
        catch (EvaluateException evaluateException) {
            throw Breakpoint.b((Exception)((Object)evaluateException));
        }
        String string = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.condition", (Object[])new Object[0]);
        try {
            StackFrameProxyImpl stackFrameProxyImpl = suspendContextImpl.getThread().frame(0);
            if (stackFrameProxyImpl == null) {
                return false;
            }
            EvaluationContextImpl evaluationContextImpl = new EvaluationContextImpl(suspendContextImpl, stackFrameProxyImpl, () -> this.getThisObject(suspendContextImpl, locatableEvent));
            if (!this.evaluateCondition(evaluationContextImpl, locatableEvent)) {
                return false;
            }
            string = DebuggerBundle.message((String)"title.error.evaluating.breakpoint.action", (Object[])new Object[0]);
            this.a(evaluationContextImpl, locatableEvent);
        }
        catch (EvaluateException evaluateException) {
            try {
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    System.out.println(evaluateException.getMessage());
                    return false;
                }
            }
            catch (EvaluateException evaluateException2) {
                throw Breakpoint.b((Exception)((Object)evaluateException2));
            }
            throw new LocatableEventRequestor.EventProcessingException(string, evaluateException.getMessage(), evaluateException);
        }
        return true;
    }

    /*
     * Loose catch block
     */
    private void a(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) {
        DebugProcessImpl debugProcessImpl;
        block25: {
            StringBuilder stringBuilder;
            block26: {
                block27: {
                    block24: {
                        debugProcessImpl = evaluationContextImpl.getDebugProcess();
                        if (this.isLogEnabled()) break block24;
                        try {
                            block28: {
                                if (this.isLogExpressionEnabled()) break block24;
                                break block28;
                                catch (EvaluateException evaluateException) {
                                    throw Breakpoint.b((Exception)((Object)evaluateException));
                                }
                            }
                            if (!this.isLogStack()) break block25;
                        }
                        catch (EvaluateException evaluateException) {
                            throw Breakpoint.b((Exception)((Object)evaluateException));
                        }
                    }
                    stringBuilder = new StringBuilder();
                    try {
                        if (this.myXBreakpoint.isLogMessage()) {
                            stringBuilder.append(this.getEventMessage(locatableEvent)).append("\n");
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw Breakpoint.b((Exception)((Object)evaluateException));
                    }
                    try {
                        if (this.isLogStack()) {
                            stringBuilder.append(this.getStackTrace(locatableEvent)).append("\n");
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw Breakpoint.b((Exception)((Object)evaluateException));
                    }
                    if (!this.isLogExpressionEnabled()) break block26;
                    try {
                        block29: {
                            if (debugProcessImpl.isAttached()) break block27;
                            break block29;
                            catch (EvaluateException evaluateException) {
                                throw Breakpoint.b((Exception)((Object)evaluateException));
                            }
                        }
                        return;
                    }
                    catch (EvaluateException evaluateException) {
                        throw Breakpoint.b((Exception)((Object)evaluateException));
                    }
                }
                TextWithImports textWithImports = this.getLogMessage();
                try {
                    String string;
                    StringBuilder stringBuilder2;
                    SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
                    PsiElement psiElement = ContextUtil.getContextElement((StackFrameContext)evaluationContextImpl, sourcePosition);
                    ExpressionEvaluator expressionEvaluator = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> EvaluatorCache.cacheOrGet("LogMessageEvaluator", locatableEvent.request(), psiElement, textWithImports, () -> Breakpoint.a(this.myProject, psiElement, sourcePosition, textWithImports, this::b)));
                    Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
                    try {
                        stringBuilder2 = stringBuilder;
                        string = value instanceof VoidValue ? "void" : DebuggerUtils.getValueAsString((EvaluationContext)evaluationContextImpl, (Value)value);
                    }
                    catch (EvaluateException evaluateException) {
                        throw Breakpoint.b((Exception)((Object)evaluateException));
                    }
                    stringBuilder2.append(string);
                }
                catch (EvaluateException evaluateException) {
                    stringBuilder.append(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0])).append(" \"").append(textWithImports).append("\"").append(" : ").append(evaluateException.getMessage());
                }
                stringBuilder.append("\n");
            }
            try {
                if (stringBuilder.length() > 0) {
                    debugProcessImpl.printToConsole(stringBuilder.toString());
                }
            }
            catch (EvaluateException evaluateException) {
                throw Breakpoint.b((Exception)((Object)evaluateException));
            }
        }
        try {
            if (this.isRemoveAfterHit()) {
                this.a(debugProcessImpl);
            }
        }
        catch (EvaluateException evaluateException) {
            throw Breakpoint.b((Exception)((Object)evaluateException));
        }
    }

    private boolean a(long l2) {
        return Arrays.stream(this.getInstanceFilters()).anyMatch(instanceFilter -> {
            boolean bl2;
            try {
                bl2 = instanceFilter.getId() == l2;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw Breakpoint.b(vMDisconnectedException);
            }
            return bl2;
        });
    }

    /*
     * Loose catch block
     */
    public boolean evaluateCondition(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        block35: {
            boolean bl2;
            Object object;
            block31: {
                ThreeState threeState;
                Location location;
                block32: {
                    boolean bl3;
                    block34: {
                        block33: {
                            Object object2;
                            DebugProcessImpl debugProcessImpl;
                            block30: {
                                block29: {
                                    debugProcessImpl = evaluationContextImpl.getDebugProcess();
                                    if (!this.isCountFilterEnabled()) break block29;
                                    try {
                                        block36: {
                                            if (this.isConditionEnabled()) break block29;
                                            break block36;
                                            catch (EvaluateException evaluateException) {
                                                throw Breakpoint.b((Exception)((Object)evaluateException));
                                            }
                                        }
                                        debugProcessImpl.getVirtualMachineProxy().suspend();
                                        debugProcessImpl.getRequestsManager().deleteRequest(this);
                                        this.createRequest(debugProcessImpl);
                                        debugProcessImpl.getVirtualMachineProxy().resume();
                                    }
                                    catch (EvaluateException evaluateException) {
                                        throw Breakpoint.b((Exception)((Object)evaluateException));
                                    }
                                }
                                if (this.isInstanceFiltersEnabled() && (object = evaluationContextImpl.computeThisObject()) != null) {
                                    object2 = (ObjectReference)object;
                                    try {
                                        if (!this.a(object2.uniqueID())) {
                                            return false;
                                        }
                                    }
                                    catch (EvaluateException evaluateException) {
                                        throw Breakpoint.b((Exception)((Object)evaluateException));
                                    }
                                }
                                if (!this.isClassFiltersEnabled()) break block30;
                                try {
                                    block37: {
                                        if (Breakpoint.typeMatchesClassFilters(this.calculateEventClass(evaluationContextImpl, locatableEvent), this.getClassFilters(), this.getClassExclusionFilters())) break block30;
                                        break block37;
                                        catch (EvaluateException evaluateException) {
                                            throw Breakpoint.b((Exception)((Object)evaluateException));
                                        }
                                    }
                                    return false;
                                }
                                catch (EvaluateException evaluateException) {
                                    throw Breakpoint.b((Exception)((Object)evaluateException));
                                }
                            }
                            if (!this.isConditionEnabled()) break block31;
                            object = this.getCondition();
                            try {
                                if (object.isEmpty()) {
                                    return true;
                                }
                            }
                            catch (EvaluateException evaluateException) {
                                throw Breakpoint.b((Exception)((Object)evaluateException));
                            }
                            object2 = evaluationContextImpl.getFrameProxy();
                            if (object2 == null || (location = ((StackFrameProxyImpl)object2).location()) == null) break block32;
                            threeState = debugProcessImpl.getPositionManager().evaluateCondition(evaluationContextImpl, (StackFrameProxyImpl)object2, location, object.getText());
                            if (threeState == ThreeState.UNSURE) break block32;
                            try {
                                block38: {
                                    if (threeState != ThreeState.YES) break block33;
                                    break block38;
                                    catch (EvaluateException evaluateException) {
                                        throw Breakpoint.b((Exception)((Object)evaluateException));
                                    }
                                }
                                bl3 = true;
                                break block34;
                            }
                            catch (EvaluateException evaluateException) {
                                throw Breakpoint.b((Exception)((Object)evaluateException));
                            }
                        }
                        bl3 = false;
                    }
                    return bl3;
                }
                try {
                    location = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
                    threeState = DebuggerInvocationUtil.commitAndRunReadAction(this.myProject, () -> this.a((SourcePosition)location, locatableEvent, (TextWithImports)object));
                    if (!DebuggerUtilsEx.evaluateBoolean((ExpressionEvaluator)threeState, evaluationContextImpl)) {
                        return false;
                    }
                }
                catch (EvaluateException evaluateException) {
                    try {
                        if (evaluateException.getCause() instanceof VMDisconnectedException) {
                            return false;
                        }
                    }
                    catch (EvaluateException evaluateException2) {
                        throw Breakpoint.b((Exception)((Object)evaluateException2));
                    }
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.failed.evaluating.breakpoint.condition", (Object[])new Object[]{object, evaluateException.getMessage()}));
                }
            }
            try {
                if (!this.isCountFilterEnabled() || !this.isConditionEnabled()) break block35;
            }
            catch (EvaluateException evaluateException) {
                throw Breakpoint.b((Exception)((Object)evaluateException));
            }
            object = (Long)ObjectUtils.notNull((Object)((Long)locatableEvent.request().getProperty(b)), (Object)0L) + 1L;
            try {
                locatableEvent.request().putProperty(b, object);
                bl2 = (Long)object % (long)this.getCountFilter() == 0L;
            }
            catch (EvaluateException evaluateException) {
                throw Breakpoint.b((Exception)((Object)evaluateException));
            }
            return bl2;
        }
        return true;
    }

    private static ExpressionEvaluator a(Project project2, PsiElement psiElement, SourcePosition sourcePosition, TextWithImports textWithImports, Function<PsiElement, PsiCodeFragment> function) throws EvaluateException {
        try {
            return EvaluatorBuilderImpl.build(textWithImports, psiElement, sourcePosition, project2);
        }
        catch (UnsupportedExpressionException unsupportedExpressionException) {
            ExpressionEvaluator expressionEvaluator = CompilingEvaluatorImpl.create(project2, psiElement, function);
            try {
                if (expressionEvaluator != null) {
                    return expressionEvaluator;
                }
            }
            catch (UnsupportedExpressionException unsupportedExpressionException2) {
                throw Breakpoint.b((Exception)((Object)unsupportedExpressionException2));
            }
            throw unsupportedExpressionException;
        }
    }

    private PsiCodeFragment a(PsiElement psiElement) {
        return Breakpoint.a(this.myProject, this.getCondition(), psiElement);
    }

    private PsiCodeFragment b(PsiElement psiElement) {
        return Breakpoint.a(this.myProject, this.getLogMessage(), psiElement);
    }

    private static PsiCodeFragment a(Project project2, TextWithImports textWithImports, PsiElement psiElement) {
        return DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement).createCodeFragment(textWithImports, psiElement, project2);
    }

    protected String calculateEventClass(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        return locatableEvent.location().declaringType().name();
    }

    protected static boolean typeMatchesClassFilters(@Nullable String string, ClassFilter[] classFilterArray, ClassFilter[] classFilterArray2) {
        block8: {
            try {
                if (string == null) {
                    return true;
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw Breakpoint.b(vMDisconnectedException);
            }
            boolean bl2 = false;
            boolean bl3 = false;
            for (ClassFilter classFilter2 : classFilterArray) {
                if (!classFilter2.isEnabled()) continue;
                bl3 = true;
                if (!classFilter2.matches(string)) continue;
                bl2 = true;
                break;
            }
            try {
                try {
                    if (!bl3 || bl2) break block8;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    throw Breakpoint.b(vMDisconnectedException);
                }
                return false;
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw Breakpoint.b(vMDisconnectedException);
            }
        }
        return Arrays.stream(classFilterArray2).noneMatch(classFilter -> {
            boolean bl2;
            block5: {
                block4: {
                    try {
                        try {
                            if (!classFilter.isEnabled() || !classFilter.matches(string)) break block4;
                        }
                        catch (VMDisconnectedException vMDisconnectedException) {
                            throw Breakpoint.b(vMDisconnectedException);
                        }
                        bl2 = true;
                        break block5;
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        throw Breakpoint.b(vMDisconnectedException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        });
    }

    private void a(final DebugProcessImpl debugProcessImpl) {
        debugProcessImpl.getRequestsManager().deleteRequest(this);
        debugProcessImpl.addDebugProcessListener(new DebugProcessListener(){

            public void resumed(SuspendContext suspendContext) {
                this.a();
            }

            public void processDetached(DebugProcess debugProcess, boolean bl2) {
                this.a();
            }

            private void a() {
                AppUIUtil.invokeOnEdt(() -> DebuggerManagerEx.getInstanceEx(Breakpoint.this.myProject).getBreakpointManager().removeBreakpoint(Breakpoint.this));
                debugProcessImpl.removeDebugProcessListener(this);
            }
        });
    }

    public void updateUI() {
    }

    public void readExternal(Element element) throws InvalidDataException {
        block10: {
            FilteredRequestorImpl filteredRequestorImpl = new FilteredRequestorImpl(this.myProject);
            filteredRequestorImpl.readTo(element, this);
            try {
                this.setEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"ENABLED")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.setLogEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"LOG_ENABLED")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String string = JDOMExternalizerUtil.readField((Element)element, (String)"LOG_MESSAGE");
                try {
                    if (string == null || string.isEmpty()) break block10;
                }
                catch (Exception exception) {
                    throw Breakpoint.b(exception);
                }
                XExpressionImpl xExpressionImpl = XExpressionImpl.fromText((String)string);
                XDebuggerHistoryManager.getInstance((Project)this.myProject).addRecentExpression("breakpointLogExpression", (XExpression)xExpressionImpl);
                this.myXBreakpoint.setLogExpressionObject((XExpression)xExpressionImpl);
                ((XBreakpointBase)this.myXBreakpoint).setLogExpressionEnabled(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"LOG_EXPRESSION_ENABLED")).booleanValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.setRemoveAfterHit(Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"REMOVE_AFTER_HIT")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Nullable
    public abstract PsiElement getEvaluationElement();

    protected TextWithImports getLogMessage() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getLogExpressionObject());
    }

    protected TextWithImports getCondition() {
        return TextWithImportsImpl.fromXExpression(this.myXBreakpoint.getConditionExpression());
    }

    @Override
    public boolean isEnabled() {
        return this.myXBreakpoint.isEnabled();
    }

    @Override
    public void setEnabled(boolean bl2) {
        this.myXBreakpoint.setEnabled(bl2);
    }

    protected boolean isLogEnabled() {
        return this.myXBreakpoint.isLogMessage();
    }

    public void setLogEnabled(boolean bl2) {
        this.myXBreakpoint.setLogMessage(bl2);
    }

    protected boolean isLogStack() {
        return this.myXBreakpoint.isLogStack();
    }

    protected boolean isLogExpressionEnabled() {
        boolean bl2;
        try {
            if (XDebuggerUtilImpl.isEmptyExpression((XExpression)this.myXBreakpoint.getLogExpressionObject())) {
                return false;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        try {
            bl2 = !this.getLogMessage().isEmpty();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        return bl2;
    }

    @Override
    public boolean isCountFilterEnabled() {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!((JavaBreakpointProperties)((Object)this.getProperties())).isCOUNT_FILTER_ENABLED() || this.getCountFilter() <= 0) break block4;
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        throw Breakpoint.b(vMDisconnectedException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    throw Breakpoint.b(vMDisconnectedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public void setCountFilterEnabled(boolean bl2) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER_ENABLED(bl2)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Override
    public int getCountFilter() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getCOUNT_FILTER();
    }

    public void setCountFilter(int n2) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setCOUNT_FILTER(n2)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isCLASS_FILTERS_ENABLED();
    }

    public void setClassFiltersEnabled(boolean bl2) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setCLASS_FILTERS_ENABLED(bl2)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Override
    public ClassFilter[] getClassFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassFilters();
    }

    public void setClassFilters(ClassFilter[] classFilterArray) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassFilters(classFilterArray)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getClassExclusionFilters();
    }

    public void setClassExclusionFilters(ClassFilter[] classFilterArray) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setClassExclusionFilters(classFilterArray)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).isINSTANCE_FILTERS_ENABLED();
    }

    public void setInstanceFiltersEnabled(boolean bl2) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setINSTANCE_FILTERS_ENABLED(bl2)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return ((JavaBreakpointProperties)((Object)this.getProperties())).getInstanceFilters();
    }

    public void setInstanceFilters(InstanceFilter[] instanceFilterArray) {
        try {
            if (((JavaBreakpointProperties)((Object)this.getProperties())).setInstanceFilters(instanceFilterArray)) {
                this.fireBreakpointChanged();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
    }

    /*
     * Exception decompiling
     */
    private static String a(XBreakpoint var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static SuspendPolicy transformSuspendPolicy(String string) {
        try {
            if ("SuspendAll".equals(string)) {
                return SuspendPolicy.ALL;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        try {
            if ("SuspendThread".equals(string)) {
                return SuspendPolicy.THREAD;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        try {
            if ("SuspendNone".equals(string)) {
                return SuspendPolicy.NONE;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        throw new IllegalArgumentException("unknown suspend policy");
    }

    protected boolean isSuspend() {
        boolean bl2;
        try {
            bl2 = this.myXBreakpoint.getSuspendPolicy() != SuspendPolicy.NONE;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        return bl2;
    }

    @Override
    public String getSuspendPolicy() {
        return Breakpoint.a(this.myXBreakpoint);
    }

    public void setSuspendPolicy(String string) {
        this.myXBreakpoint.setSuspendPolicy(Breakpoint.transformSuspendPolicy(string));
    }

    @Override
    public boolean isConditionEnabled() {
        boolean bl2;
        XExpression xExpression = this.myXBreakpoint.getConditionExpression();
        try {
            if (XDebuggerUtilImpl.isEmptyExpression((XExpression)xExpression)) {
                return false;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        try {
            bl2 = !this.getCondition().isEmpty();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw Breakpoint.b(vMDisconnectedException);
        }
        return bl2;
    }

    public void setCondition(@Nullable TextWithImports textWithImports) {
        this.myXBreakpoint.setConditionExpression(TextWithImportsImpl.toXExpression(textWithImports));
    }

    public void addInstanceFilter(long l2) {
        ((JavaBreakpointProperties)((Object)this.getProperties())).addInstanceFilter(l2);
    }

    protected void fireBreakpointChanged() {
        ((XBreakpointBase)this.myXBreakpoint).fireBreakpointChanged();
    }

    private /* synthetic */ ExpressionEvaluator a(SourcePosition sourcePosition, LocatableEvent locatableEvent, TextWithImports textWithImports) throws EvaluateException {
        PsiElement psiElement;
        PsiElement psiElement2 = ContextUtil.getContextElement(sourcePosition);
        try {
            psiElement = psiElement2 != null ? psiElement2 : this.getEvaluationElement();
        }
        catch (EvaluateException evaluateException) {
            throw Breakpoint.b((Exception)((Object)evaluateException));
        }
        PsiElement psiElement3 = psiElement;
        return EvaluatorCache.cacheOrGet("ConditionEvaluator", locatableEvent.request(), psiElement3, textWithImports, () -> Breakpoint.a(this.myProject, psiElement3, sourcePosition, textWithImports, this::a));
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private static class EvaluatorCache {
        private final PsiElement c;
        private final TextWithImports a;
        private final ExpressionEvaluator b;

        private EvaluatorCache(PsiElement psiElement, TextWithImports textWithImports, ExpressionEvaluator expressionEvaluator) {
            this.c = psiElement;
            this.a = textWithImports;
            this.b = expressionEvaluator;
        }

        @Nullable
        static ExpressionEvaluator cacheOrGet(String string, EventRequest eventRequest, PsiElement psiElement, TextWithImports textWithImports, EvaluatingComputable<ExpressionEvaluator> evaluatingComputable) throws EvaluateException {
            block6: {
                EvaluatorCache evaluatorCache = (EvaluatorCache)eventRequest.getProperty(string);
                try {
                    try {
                        try {
                            if (evaluatorCache == null || !Objects.equals(evaluatorCache.c, psiElement)) break block6;
                        }
                        catch (EvaluateException evaluateException) {
                            throw EvaluatorCache.a(evaluateException);
                        }
                        if (!Objects.equals(evaluatorCache.a, textWithImports)) break block6;
                    }
                    catch (EvaluateException evaluateException) {
                        throw EvaluatorCache.a(evaluateException);
                    }
                    return evaluatorCache.b;
                }
                catch (EvaluateException evaluateException) {
                    throw EvaluatorCache.a(evaluateException);
                }
            }
            ExpressionEvaluator expressionEvaluator = evaluatingComputable.compute();
            eventRequest.putProperty(string, new EvaluatorCache(psiElement, textWithImports, expressionEvaluator));
            return expressionEvaluator;
        }

        private static EvaluateException a(EvaluateException evaluateException) {
            return evaluateException;
        }
    }
}

