/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Field;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.debugger.breakpoints.properties.JavaFieldBreakpointProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public class FieldBreakpoint
extends BreakpointWithHighlighter<JavaFieldBreakpointProperties> {
    private static final Logger j = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.FieldBreakpoint");
    private boolean k;
    @NonNls
    public static final Key<FieldBreakpoint> CATEGORY = BreakpointCategory.lookup("field_breakpoints");

    protected FieldBreakpoint(Project project2, XBreakpoint xBreakpoint) {
        super(project2, xBreakpoint);
    }

    private FieldBreakpoint(Project project2, @NotNull String string, XBreakpoint xBreakpoint) {
        if (string == null) {
            FieldBreakpoint.c(0);
        }
        super(project2, xBreakpoint);
        this.setFieldName(string);
    }

    public boolean isStatic() {
        return this.k;
    }

    public String getFieldName() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName;
    }

    @Override
    protected Icon getDisabledIcon(boolean bl2) {
        block4: {
            Icon icon;
            block6: {
                block5: {
                    try {
                        try {
                            if (DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this) == null) break block4;
                            if (!bl2) break block5;
                        }
                        catch (IndexNotReadyException indexNotReadyException) {
                            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                        }
                        icon = AllIcons.Debugger.Db_muted_dep_field_breakpoint;
                        break block6;
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                    }
                }
                icon = AllIcons.Debugger.Db_dep_field_breakpoint;
            }
            return icon;
        }
        return null;
    }

    @Override
    protected Icon getInvalidIcon(boolean bl2) {
        Icon icon;
        try {
            icon = bl2 ? AllIcons.Debugger.Db_muted_invalid_field_breakpoint : AllIcons.Debugger.Db_invalid_field_breakpoint;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        return icon;
    }

    @Override
    protected Icon getVerifiedIcon(boolean bl2) {
        Icon icon;
        try {
            icon = bl2 ? AllIcons.Debugger.Db_muted_verified_field_breakpoint : AllIcons.Debugger.Db_verified_field_breakpoint;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        return icon;
    }

    @Override
    protected Icon getVerifiedWarningsIcon(boolean bl2) {
        Icon icon;
        try {
            icon = bl2 ? AllIcons.Debugger.Db_muted_field_warning_breakpoint : AllIcons.Debugger.Db_field_warning_breakpoint;
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        return icon;
    }

    @Override
    public Key<FieldBreakpoint> getCategory() {
        return CATEGORY;
    }

    public PsiField getPsiField() {
        SourcePosition sourcePosition = this.getSourcePosition();
        try {
            PsiField psiField = (PsiField)ReadAction.compute(() -> {
                PsiField psiField;
                PsiClass psiClass = FieldBreakpoint.getPsiClassAt(sourcePosition);
                try {
                    psiField = psiClass != null ? psiClass.findFieldByName(this.getFieldName(), true) : null;
                }
                catch (RuntimeException runtimeException) {
                    throw FieldBreakpoint.c(runtimeException);
                }
                return psiField;
            });
            if (psiField != null) {
                return psiField;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            // empty catch block
        }
        return PositionUtil.getPsiElementAt(this.myProject, PsiField.class, sourcePosition);
    }

    @Override
    protected void reload(PsiFile psiFile) {
        super.reload(psiFile);
        PsiField psiField = PositionUtil.getPsiElementAt(this.myProject, PsiField.class, this.getSourcePosition());
        if (psiField != null) {
            this.setFieldName(psiField.getName());
            PsiClass psiClass = psiField.getContainingClass();
            try {
                if (psiClass != null) {
                    ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myClassName = psiClass.getQualifiedName();
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
            }
            this.k = psiField.hasModifierProperty("static");
        }
        try {
            if (this.k) {
                this.setInstanceFiltersEnabled(false);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl suspendContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        block8: {
            if (locatableEvent instanceof ModificationWatchpointEvent) {
                ObjectReference objectReference = ((ModificationWatchpointEvent)locatableEvent).object();
                try {
                    if (objectReference != null) {
                        return objectReference;
                    }
                    break block8;
                }
                catch (EvaluateException evaluateException) {
                    throw FieldBreakpoint.c((Exception)((Object)evaluateException));
                }
            }
            if (locatableEvent instanceof AccessWatchpointEvent) {
                ObjectReference objectReference = ((AccessWatchpointEvent)locatableEvent).object();
                try {
                    if (objectReference != null) {
                        return objectReference;
                    }
                }
                catch (EvaluateException evaluateException) {
                    throw FieldBreakpoint.c((Exception)((Object)evaluateException));
                }
            }
        }
        return super.getThisObject(suspendContextImpl, locatableEvent);
    }

    /*
     * Loose catch block
     */
    @Override
    public void createRequestForPreparedClass(DebugProcessImpl debugProcessImpl, ReferenceType referenceType) {
        block14: {
            VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
            try {
                Field field;
                RequestManagerImpl requestManagerImpl;
                block16: {
                    block13: {
                        requestManagerImpl = debugProcessImpl.getRequestsManager();
                        field = referenceType.fieldByName(this.getFieldName());
                        if (field == null) {
                            requestManagerImpl.setInvalid(this, DebuggerBundle.message((String)"error.invalid.breakpoint.missing.field.in.class", (Object[])new Object[]{this.getFieldName(), referenceType.name()}));
                            return;
                        }
                        if (!this.b()) break block13;
                        try {
                            block15: {
                                if (!virtualMachineProxyImpl.canWatchFieldModification()) break block13;
                                break block15;
                                catch (Exception exception) {
                                    throw FieldBreakpoint.c(exception);
                                }
                            }
                            requestManagerImpl.enableRequest(requestManagerImpl.createModificationWatchpointRequest(this, field));
                            j.debug("Modification request added");
                        }
                        catch (Exception exception) {
                            throw FieldBreakpoint.c(exception);
                        }
                    }
                    if (!this.a()) break block14;
                    if (!virtualMachineProxyImpl.canWatchFieldAccess()) break block14;
                    break block16;
                    catch (Exception exception) {
                        throw FieldBreakpoint.c(exception);
                    }
                }
                try {
                    block17: {
                        requestManagerImpl.enableRequest(requestManagerImpl.createAccessWatchpointRequest(this, field));
                        if (!j.isDebugEnabled()) break block14;
                        break block17;
                        catch (Exception exception) {
                            throw FieldBreakpoint.c(exception);
                        }
                    }
                    j.debug("Access request added field = " + field.name() + "; refType = " + referenceType.name());
                }
                catch (Exception exception) {
                    throw FieldBreakpoint.c(exception);
                }
            }
            catch (Exception exception) {
                j.debug((Throwable)exception);
            }
        }
    }

    @Override
    public String getEventMessage(LocatableEvent locatableEvent) {
        Location location = locatableEvent.location();
        String string = DebuggerUtilsEx.getLocationMethodQName(location);
        String string2 = DebuggerUtilsEx.getSourceName(location, throwable -> this.getFileName());
        int n2 = location.lineNumber();
        if (locatableEvent instanceof ModificationWatchpointEvent) {
            ModificationWatchpointEvent modificationWatchpointEvent = (ModificationWatchpointEvent)locatableEvent;
            ObjectReference objectReference = modificationWatchpointEvent.object();
            Field field = modificationWatchpointEvent.field();
            try {
                if (objectReference != null) {
                    return DebuggerBundle.message((String)"status.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationWatchpointEvent.valueCurrent(), modificationWatchpointEvent.valueToBe(), string, string2, n2, objectReference.uniqueID()});
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.modification", (Object[])new Object[]{field.declaringType().name(), field.name(), modificationWatchpointEvent.valueCurrent(), modificationWatchpointEvent.valueToBe(), string, string2, n2});
        }
        if (locatableEvent instanceof AccessWatchpointEvent) {
            AccessWatchpointEvent accessWatchpointEvent = (AccessWatchpointEvent)locatableEvent;
            ObjectReference objectReference = accessWatchpointEvent.object();
            Field field = accessWatchpointEvent.field();
            try {
                if (objectReference != null) {
                    return DebuggerBundle.message((String)"status.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), string, string2, n2, objectReference.uniqueID()});
                }
            }
            catch (IndexNotReadyException indexNotReadyException) {
                throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
            }
            return DebuggerBundle.message((String)"status.static.field.watchpoint.reached.access", (Object[])new Object[]{field.declaringType().name(), field.name(), string, string2, n2});
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        String string;
        block8: {
            block7: {
                try {
                    if (!this.isValid()) {
                        return DebuggerBundle.message((String)"status.breakpoint.invalid", (Object[])new Object[0]);
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                }
                String string2 = this.getClassName();
                try {
                    try {
                        if (string2 == null || string2.isEmpty()) break block7;
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                    }
                    string = string2 + "." + this.getFieldName();
                    break block8;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                }
            }
            string = this.getFieldName();
        }
        return string;
    }

    public static FieldBreakpoint create(@NotNull Project project2, String string, XBreakpoint xBreakpoint) {
        try {
            if (project2 == null) {
                FieldBreakpoint.c(1);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        FieldBreakpoint fieldBreakpoint = new FieldBreakpoint(project2, string, xBreakpoint);
        return (FieldBreakpoint)fieldBreakpoint.init();
    }

    @Override
    public boolean isValid() {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!super.isValid() || this.getPsiField() == null) break block4;
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public boolean isAt(@NotNull Document document, int n2) {
        boolean bl2;
        try {
            if (document == null) {
                FieldBreakpoint.c(2);
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        PsiField psiField = FieldBreakpoint.findField(this.myProject, document, n2);
        try {
            bl2 = psiField == this.getPsiField();
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        return bl2;
    }

    public static PsiField findField(Project project2, Document document, int n2) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        try {
            if (psiFile == null) {
                return null;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        n2 = CharArrayUtil.shiftForward((CharSequence)document.getCharsSequence(), (int)n2, (String)" \t");
        PsiElement psiElement2 = psiFile.findElementAt(n2);
        try {
            if (psiElement2 == null) {
                return null;
            }
        }
        catch (IndexNotReadyException indexNotReadyException) {
            throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
        }
        PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiElement2, PsiField.class, (boolean)false);
        int n3 = document.getLineNumber(n2);
        if (psiField == null) {
            PsiField[] psiFieldArray = new PsiField[]{null};
            XDebuggerUtil.getInstance().iterateLine(project2, document, n3, psiElement -> {
                PsiField psiField = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiField.class, (boolean)false);
                try {
                    if (psiField != null) {
                        psiFieldArray[0] = psiField;
                        return false;
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    throw FieldBreakpoint.c((Exception)((Object)indexNotReadyException));
                }
                return true;
            });
            psiField = psiFieldArray[0];
        }
        return psiField;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        try {
            if (element == null) {
                FieldBreakpoint.c(3);
            }
        }
        catch (Exception exception) {
            throw FieldBreakpoint.c(exception);
        }
        try {
            super.readExternal(element);
            this.setFieldName(element.getAttributeValue("field_name"));
            if (this.getFieldName() == null) {
                throw new InvalidDataException("No field name for field breakpoint");
            }
        }
        catch (Exception exception) {
            throw FieldBreakpoint.c(exception);
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"WATCH_MODIFICATION"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"WATCH_ACCESS"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public PsiElement getEvaluationElement() {
        return this.getPsiClass();
    }

    private boolean b() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_MODIFICATION;
    }

    private boolean a() {
        return ((JavaFieldBreakpointProperties)((Object)this.getProperties())).WATCH_ACCESS;
    }

    void setFieldName(String string) {
        ((JavaFieldBreakpointProperties)((Object)this.getProperties())).myFieldName = string;
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void c(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

