/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.ui.impl.UpdatableDebuggerView;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.PopupHandler;
import com.intellij.util.SingleAlarm;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.VMDisconnectedException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public abstract class DebuggerTreePanel
extends UpdatableDebuggerView
implements DataProvider,
Disposable {
    public static final DataKey<DebuggerTreePanel> DATA_KEY = DataKey.create((String)"DebuggerPanel");
    private final SingleAlarm f = new SingleAlarm(() -> {
        try {
            DebuggerContextImpl debuggerContextImpl = this.getContext();
            try {
                if (debuggerContextImpl.getDebuggerSession() != null) {
                    this.getTree().rebuild(debuggerContextImpl);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw DebuggerTreePanel.b(vMDisconnectedException);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }, 100);
    protected DebuggerTree myTree = this.createTreeView();

    public DebuggerTreePanel(Project project2, DebuggerStateManager debuggerStateManager) {
        super(project2, debuggerStateManager);
        final PopupHandler popupHandler = new PopupHandler(){

            public void invokePopup(Component component, int n2, int n3) {
                ActionPopupMenu actionPopupMenu = DebuggerTreePanel.this.createPopupMenu();
                if (actionPopupMenu != null) {
                    DebuggerTreePanel.this.myTree.myTipManager.registerPopup(actionPopupMenu.getComponent()).show(component, n2, n3);
                }
            }
        };
        this.myTree.addMouseListener((MouseListener)popupHandler);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)new IdeFocusTraversalPolicy(){

            public Component getDefaultComponentImpl(Container container) {
                return DebuggerTreePanel.this.myTree;
            }
        });
        this.registerDisposable(new Disposable(){

            public void dispose() {
                DebuggerTreePanel.this.myTree.removeMouseListener((MouseListener)popupHandler);
            }
        });
        DebuggerUIUtil.registerActionOnComponent((String)"Debugger.MarkObject", (JComponent)((Object)this.myTree), (Disposable)this);
    }

    protected abstract DebuggerTree createTreeView();

    @Override
    protected void changeEvent(DebuggerContextImpl debuggerContextImpl, DebuggerSession.Event event) {
        try {
            super.changeEvent(debuggerContextImpl, event);
            if (event == DebuggerSession.Event.DISPOSE) {
                this.getTree().getNodeFactory().dispose();
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw DebuggerTreePanel.b(vMDisconnectedException);
        }
    }

    @Override
    protected void rebuild(DebuggerSession.Event event) {
        this.f.cancelAndRequest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dispose() {
        DebuggerTree debuggerTree;
        Disposer.dispose((Disposable)this.f);
        try {
            super.dispose();
            debuggerTree = this.myTree;
        }
        catch (Throwable throwable) {
            DebuggerTree debuggerTree2 = this.myTree;
            try {
                if (debuggerTree2 != null) {
                    Disposer.dispose((Disposable)debuggerTree2);
                }
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw DebuggerTreePanel.b(vMDisconnectedException);
            }
            this.myTree = null;
            throw throwable;
        }
        try {
            if (debuggerTree != null) {
                Disposer.dispose((Disposable)debuggerTree);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw DebuggerTreePanel.b(vMDisconnectedException);
        }
        this.myTree = null;
    }

    protected abstract ActionPopupMenu createPopupMenu();

    public final DebuggerTree getTree() {
        return this.myTree;
    }

    public void clear() {
        this.myTree.removeAllChildren();
    }

    public Object getData(String string) {
        try {
            if (DATA_KEY.is(string)) {
                return this;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw DebuggerTreePanel.b(vMDisconnectedException);
        }
        return null;
    }

    @Override
    public void requestFocus() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.getTree()), true));
    }

    private static VMDisconnectedException b(VMDisconnectedException vMDisconnectedException) {
        return vMDisconnectedException;
    }
}

