/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.ArgumentValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.MethodReturnValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThrownExceptionValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.UserExpressionDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DebuggerTreeRenderer
extends ColoredTreeCellRenderer {
    private static final SimpleTextAttributes b = new SimpleTextAttributes(0, null);
    private static final SimpleTextAttributes c = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));
    private static final SimpleTextAttributes a = new SimpleTextAttributes(0, (Color)new JBColor(Color.lightGray, (Color)Gray._130));

    public void customizeCellRenderer(@NotNull JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
        try {
            if (jTree == null) {
                DebuggerTreeRenderer.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DebuggerTreeRenderer.b(illegalArgumentException);
        }
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)object;
        if (debuggerTreeNodeImpl != null) {
            SimpleColoredText simpleColoredText = debuggerTreeNodeImpl.getText();
            try {
                if (simpleColoredText != null) {
                    simpleColoredText.appendToComponent((ColoredTextContainer)this);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DebuggerTreeRenderer.b(illegalArgumentException);
            }
            this.setIcon(debuggerTreeNodeImpl.getIcon());
        }
    }

    @Nullable
    public static Icon getDescriptorIcon(NodeDescriptor nodeDescriptor) {
        Icon icon;
        block21: {
            block18: {
                Icon icon2;
                block20: {
                    block19: {
                        icon = null;
                        try {
                            try {
                                if (!(nodeDescriptor instanceof ThreadGroupDescriptorImpl)) break block18;
                                if (!((ThreadGroupDescriptorImpl)nodeDescriptor).isCurrent()) break block19;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                            }
                            icon2 = AllIcons.Debugger.ThreadGroupCurrent;
                            break block20;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                    }
                    icon2 = AllIcons.Debugger.ThreadGroup;
                }
                icon = icon2;
                break block21;
            }
            if (nodeDescriptor instanceof ThreadDescriptorImpl) {
                ThreadDescriptorImpl threadDescriptorImpl = (ThreadDescriptorImpl)nodeDescriptor;
                icon = threadDescriptorImpl.getIcon();
            } else if (nodeDescriptor instanceof StackFrameDescriptorImpl) {
                StackFrameDescriptorImpl stackFrameDescriptorImpl = (StackFrameDescriptorImpl)nodeDescriptor;
                icon = stackFrameDescriptorImpl.getIcon();
            } else if (nodeDescriptor instanceof ValueDescriptorImpl) {
                icon = DebuggerTreeRenderer.getValueIcon((ValueDescriptorImpl)nodeDescriptor, null);
            } else if (nodeDescriptor instanceof MessageDescriptor) {
                MessageDescriptor messageDescriptor = (MessageDescriptor)nodeDescriptor;
                if (messageDescriptor.getKind() == 0) {
                    icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                } else if (messageDescriptor.getKind() == 2) {
                    icon = XDebuggerUIConstants.INFORMATION_MESSAGE_ICON;
                } else if (messageDescriptor.getKind() == 3) {
                    icon = null;
                }
            } else if (nodeDescriptor instanceof StaticDescriptorImpl) {
                icon = AllIcons.Nodes.Static;
            }
        }
        return icon;
    }

    public static Icon getValueIcon(ValueDescriptorImpl valueDescriptorImpl, @Nullable ValueDescriptorImpl valueDescriptorImpl2) {
        Icon icon;
        block20: {
            Object object;
            block19: {
                Value value;
                block18: {
                    if (valueDescriptorImpl instanceof FieldDescriptorImpl) {
                        block17: {
                            object = (FieldDescriptorImpl)valueDescriptorImpl;
                            icon = PlatformIcons.FIELD_ICON;
                            if (valueDescriptorImpl2 != null) {
                                value = valueDescriptorImpl.getValue();
                                try {
                                    if (!(value instanceof ObjectReference) || !value.equals(valueDescriptorImpl2.getValue())) break block17;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                }
                                icon = AllIcons.Debugger.Selfreference;
                            }
                        }
                        if (((FieldDescriptorImpl)object).getField().isFinal()) {
                            icon = new LayeredIcon(new Icon[]{icon, AllIcons.Nodes.FinalMark});
                        }
                        if (((FieldDescriptorImpl)object).isStatic()) {
                            icon = new LayeredIcon(new Icon[]{icon, AllIcons.Nodes.StaticMark});
                        }
                    } else {
                        icon = valueDescriptorImpl instanceof ThrownExceptionValueDescriptorImpl ? AllIcons.Nodes.ExceptionClass : (valueDescriptorImpl instanceof MethodReturnValueDescriptorImpl ? AllIcons.Debugger.WatchLastReturnValue : (DebuggerTreeRenderer.a(valueDescriptorImpl) ? PlatformIcons.PARAMETER_ICON : (valueDescriptorImpl.isEnumConstant() ? PlatformIcons.ENUM_ICON : (valueDescriptorImpl.isArray() ? AllIcons.Debugger.Db_array : (valueDescriptorImpl.isPrimitive() ? AllIcons.Debugger.Db_primitive : (valueDescriptorImpl instanceof WatchItemDescriptor ? AllIcons.Debugger.Watch : AllIcons.Debugger.Value))))));
                    }
                    if (valueDescriptorImpl instanceof UserExpressionDescriptorImpl) {
                        object = EnumerationChildrenRenderer.getCurrent(((UserExpressionDescriptorImpl)valueDescriptorImpl).getParentDescriptor());
                        try {
                            if (object == null || !((EnumerationChildrenRenderer)object).isAppendDefaultChildren()) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                        icon = AllIcons.Debugger.Watch;
                    }
                }
                try {
                    if (!(valueDescriptorImpl instanceof WatchItemDescriptor) || icon == AllIcons.Debugger.Watch) break block19;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                }
                object = XDebuggerManager.getInstance((Project)valueDescriptorImpl.getProject()).getCurrentSession();
                if (object != null) {
                    value = ((XDebugSessionImpl)object).getSessionTab();
                    try {
                        if (value == null || !value.isWatchesInVariables()) break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                    }
                    icon = AllIcons.Debugger.Watch;
                }
            }
            object = valueDescriptorImpl.getValueIcon();
            try {
                if (icon == null || object == null) break block20;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DebuggerTreeRenderer.b(illegalArgumentException);
            }
            icon = new RowIcon(new Icon[]{icon, object});
        }
        return icon;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean a(ValueDescriptorImpl valueDescriptorImpl) {
        try {
            if (valueDescriptorImpl instanceof LocalVariableDescriptorImpl) {
                try {
                    return ((LocalVariableDescriptorImpl)valueDescriptorImpl).getLocalVariable().getVariable().isArgument();
                }
                catch (EvaluateException evaluateException) {
                    return false;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DebuggerTreeRenderer.b(illegalArgumentException);
        }
        try {
            if (!(valueDescriptorImpl instanceof ArgumentValueDescriptorImpl)) return false;
            return ((ArgumentValueDescriptorImpl)valueDescriptorImpl).isParameter();
        }
        catch (EvaluateException evaluateException) {
            throw DebuggerTreeRenderer.b((Exception)((Object)evaluateException));
        }
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, EditorColorsScheme editorColorsScheme, boolean bl2) {
        return DebuggerTreeRenderer.a(debuggerContextImpl, nodeDescriptorImpl, editorColorsScheme, bl2, true);
    }

    public static SimpleColoredText getDescriptorText(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, boolean bl2) {
        return DebuggerTreeRenderer.a(debuggerContextImpl, nodeDescriptorImpl, DebuggerUIUtil.getColorScheme(null), bl2, true);
    }

    public static SimpleColoredText getDescriptorTitle(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl) {
        return DebuggerTreeRenderer.a(debuggerContextImpl, nodeDescriptorImpl, DebuggerUIUtil.getColorScheme(null), false, false);
    }

    private static SimpleColoredText a(DebuggerContextImpl debuggerContextImpl, NodeDescriptorImpl nodeDescriptorImpl, EditorColorsScheme editorColorsScheme, boolean bl2, boolean bl3) {
        SimpleColoredText simpleColoredText;
        block55: {
            String[] stringArray;
            block56: {
                SimpleTextAttributes simpleTextAttributes;
                Object object;
                String string;
                ValueDescriptorImpl valueDescriptorImpl;
                block58: {
                    block57: {
                        block53: {
                            block54: {
                                String string2;
                                String string3;
                                simpleColoredText = new SimpleColoredText();
                                if (nodeDescriptorImpl == null) {
                                    string3 = "";
                                    string2 = null;
                                } else {
                                    string3 = nodeDescriptorImpl.getLabel();
                                    string2 = nodeDescriptorImpl.getName();
                                }
                                try {
                                    if (string3.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) {
                                        simpleColoredText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                                        return simpleColoredText;
                                    }
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                }
                                if (nodeDescriptorImpl instanceof ValueDescriptor) {
                                    stringArray = ((ValueDescriptor)((Object)nodeDescriptorImpl)).getMarkup(debuggerContextImpl.getDebugProcess());
                                    try {
                                        if (stringArray != null) {
                                            simpleColoredText.append("[" + stringArray.getText() + "] ", new SimpleTextAttributes(1, stringArray.getColor()));
                                        }
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                                    }
                                }
                                stringArray = DebuggerTreeRenderer.a(string3, string2);
                                try {
                                    try {
                                        try {
                                            if (stringArray[0] == null) break block53;
                                            if (!(nodeDescriptorImpl instanceof MessageDescriptor)) break block54;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                                        }
                                        if (((MessageDescriptor)nodeDescriptorImpl).getKind() != 3) break block54;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                                    }
                                    simpleColoredText.append((String)stringArray[0], c);
                                    break block53;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                }
                            }
                            simpleColoredText.append((String)stringArray[0], b);
                        }
                        try {
                            if (stringArray[1] != null) {
                                simpleColoredText.append((String)stringArray[1], XDebuggerUIConstants.VALUE_NAME_ATTRIBUTES);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                        try {
                            try {
                                try {
                                    if (stringArray[2] == null) break block55;
                                    if (!(nodeDescriptorImpl instanceof ValueDescriptorImpl)) break block56;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                }
                                if (!bl2) break block57;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                            }
                            if (stringArray[2].indexOf(10) < 0) break block57;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                        stringArray = DebuggerTreeRenderer.a((String)stringArray[2], "=");
                        try {
                            if (stringArray[2] != null) {
                                stringArray[2] = stringArray[0] + stringArray[1] + "\n" + stringArray[2];
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                    }
                    valueDescriptorImpl = (ValueDescriptorImpl)nodeDescriptorImpl;
                    string = valueDescriptorImpl.getValueLabel();
                    stringArray = DebuggerTreeRenderer.a((String)stringArray[2], string);
                    try {
                        if (stringArray[0] != null) {
                            simpleColoredText.append(stringArray[0], b);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                    }
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl3 || stringArray[1] == null) break block55;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                                    }
                                    if (string == null) break block58;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                }
                                if (!StringUtil.startsWithChar((CharSequence)string, (char)'{')) break block58;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                            }
                            if (string.indexOf(125) <= 0) break block58;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                        if (StringUtil.endsWithChar((CharSequence)string, (char)'}')) break block58;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                    }
                    int n2 = string.indexOf(125);
                    object = string.substring(0, n2 + 1);
                    string = string.substring(n2 + 1);
                    simpleColoredText.append((String)object, a);
                }
                string = DebuggerUtilsEx.truncateString(string);
                if (valueDescriptorImpl.isDirty()) {
                    simpleTextAttributes = XDebuggerUIConstants.CHANGED_VALUE_ATTRIBUTES;
                } else {
                    SimpleTextAttributes simpleTextAttributes2;
                    object = null;
                    if (valueDescriptorImpl.isNull()) {
                        object = editorColorsScheme.getAttributes(JavaHighlightingColors.KEYWORD);
                    } else if (valueDescriptorImpl.isString()) {
                        object = editorColorsScheme.getAttributes(JavaHighlightingColors.STRING);
                    }
                    try {
                        simpleTextAttributes2 = object != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)object) : b;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                    }
                    simpleTextAttributes = simpleTextAttributes2;
                }
                object = nodeDescriptorImpl.getEvaluateException();
                if (object != null) {
                    String string4;
                    block59: {
                        string4 = object.getMessage();
                        try {
                            if (!string.endsWith(string4)) break block59;
                            DebuggerTreeRenderer.a(simpleColoredText, string.substring(0, string.length() - string4.length()), simpleTextAttributes, editorColorsScheme);
                            simpleColoredText.append(string4, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                            break block55;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                    }
                    DebuggerTreeRenderer.a(simpleColoredText, string, simpleTextAttributes, editorColorsScheme);
                    simpleColoredText.append(string4, XDebuggerUIConstants.EXCEPTION_ATTRIBUTES);
                } else {
                    block60: {
                        try {
                            if (!string.equals(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE)) break block60;
                            simpleColoredText.append(XDebuggerUIConstants.COLLECTING_DATA_MESSAGE, XDebuggerUIConstants.COLLECTING_DATA_HIGHLIGHT_ATTRIBUTES);
                            break block55;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                    }
                    DebuggerTreeRenderer.a(simpleColoredText, string, simpleTextAttributes, editorColorsScheme);
                }
                break block55;
            }
            simpleColoredText.append((String)stringArray[2], b);
        }
        return simpleColoredText;
    }

    private static void a(SimpleColoredText simpleColoredText, String string, SimpleTextAttributes simpleTextAttributes, EditorColorsScheme editorColorsScheme) {
        SimpleTextAttributes simpleTextAttributes2 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (bl2) {
                block28: {
                    block30: {
                        block29: {
                            bl2 = false;
                            try {
                                try {
                                    block27: {
                                        try {
                                            try {
                                                try {
                                                    try {
                                                        try {
                                                            try {
                                                                if (c2 == '\\' || c2 == '\"') break block27;
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                                                            }
                                                            if (c2 == 'b') break block27;
                                                        }
                                                        catch (IllegalArgumentException illegalArgumentException) {
                                                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                                                        }
                                                        if (c2 == 't') break block27;
                                                    }
                                                    catch (IllegalArgumentException illegalArgumentException) {
                                                        throw DebuggerTreeRenderer.b(illegalArgumentException);
                                                    }
                                                    if (c2 == 'n') break block27;
                                                }
                                                catch (IllegalArgumentException illegalArgumentException) {
                                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                                }
                                                if (c2 == 'f') break block27;
                                            }
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                                            }
                                            if (c2 != 'r') break block28;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                                        }
                                    }
                                    if (stringBuilder.length() <= 0) break block29;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DebuggerTreeRenderer.b(illegalArgumentException);
                                }
                                simpleColoredText.append(stringBuilder.toString(), simpleTextAttributes);
                                stringBuilder.setLength(0);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                            }
                        }
                        if (simpleTextAttributes2 == null) {
                            TextAttributes textAttributes = editorColorsScheme.getAttributes(JavaHighlightingColors.VALID_STRING_ESCAPE);
                            simpleTextAttributes2 = textAttributes != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)textAttributes) : b.derive(1, (Color)JBColor.GRAY, null, null);
                        }
                        try {
                            try {
                                if (c2 == '\\' || c2 == '\"') break block30;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DebuggerTreeRenderer.b(illegalArgumentException);
                            }
                            simpleColoredText.append("\\", simpleTextAttributes2);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DebuggerTreeRenderer.b(illegalArgumentException);
                        }
                    }
                    simpleColoredText.append(String.valueOf(c2), simpleTextAttributes2);
                    continue;
                }
                stringBuilder.append('\\').append(c2);
                continue;
            }
            if (c2 == '\\') {
                bl2 = true;
                continue;
            }
            stringBuilder.append(c2);
        }
        try {
            if (stringBuilder.length() > 0) {
                simpleColoredText.append(stringBuilder.toString(), simpleTextAttributes);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DebuggerTreeRenderer.b(illegalArgumentException);
        }
    }

    private static String[] a(String string, String string2) {
        block6: {
            String string3;
            String string4;
            try {
                if (string2 == null || string2.length() <= 0) break block6;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DebuggerTreeRenderer.b(illegalArgumentException);
            }
            int n2 = Math.max(string.indexOf(string2), 0);
            try {
                string4 = n2 > 0 ? string.substring(0, n2) : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DebuggerTreeRenderer.b(illegalArgumentException);
            }
            String string5 = string4;
            n2 += string2.length();
            try {
                string3 = n2 < string.length() - 1 ? string.substring(n2) : null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DebuggerTreeRenderer.b(illegalArgumentException);
            }
            String string6 = string3;
            return new String[]{string5, string2, string6};
        }
        return new String[]{string, null, null};
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/debugger/ui/impl/DebuggerTreeRenderer", "customizeCellRenderer"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

