/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.watch.DebuggerTree;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

public class ThreadsDebuggerTree
extends DebuggerTree {
    private static final Logger g = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.ThreadsDebuggerTree");

    public ThreadsDebuggerTree(Project project2) {
        super(project2);
        this.getEmptyText().setText(XDebuggerBundle.message((String)"debugger.threads.not.available", (Object[])new Object[0]));
    }

    @Override
    protected NodeManagerImpl createNodeManager(Project project2) {
        return new NodeManagerImpl(project2, this){

            @Override
            public String getContextKey(StackFrameProxyImpl stackFrameProxyImpl) {
                return "ThreadsView";
            }
        };
    }

    @Override
    protected boolean isExpandable(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (nodeDescriptorImpl instanceof StackFrameDescriptorImpl) {
            return false;
        }
        return nodeDescriptorImpl.isExpandable();
    }

    @Override
    protected void build(DebuggerContextImpl debuggerContextImpl) {
        DebuggerSession.State state;
        DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
        RefreshThreadsTreeCommand refreshThreadsTreeCommand = new RefreshThreadsTreeCommand(debuggerSession);
        DebuggerSession.State state2 = state = debuggerSession != null ? debuggerSession.getState() : DebuggerSession.State.DISPOSED;
        if (ApplicationManager.getApplication().isUnitTestMode() || state == DebuggerSession.State.PAUSED || state == DebuggerSession.State.RUNNING) {
            this.showMessage(MessageDescriptor.EVALUATING);
            debuggerContextImpl.getDebugProcess().getManagerThread().schedule(refreshThreadsTreeCommand);
        } else {
            this.showMessage(debuggerSession != null ? debuggerSession.getStateDescription() : DebuggerBundle.message((String)"status.debug.stopped", (Object[])new Object[0]));
        }
    }

    private class RefreshThreadsTreeCommand
    extends DebuggerCommandImpl {
        private final DebuggerSession b;

        public RefreshThreadsTreeCommand(DebuggerSession debuggerSession) {
            this.b = debuggerSession;
        }

        @Override
        protected void action() throws Exception {
            boolean bl2;
            ArrayList<Object> arrayList;
            ThreadReferenceProxyImpl threadReferenceProxyImpl;
            DebuggerTreeNodeImpl debuggerTreeNodeImpl;
            block34: {
                block33: {
                    boolean bl3;
                    Object object;
                    boolean bl4;
                    block32: {
                        ThreadReferenceProxyImpl threadReferenceProxyImpl2;
                        debuggerTreeNodeImpl = ThreadsDebuggerTree.this.getNodeFactory().getDefaultNode();
                        DebugProcessImpl debugProcessImpl = this.b.getProcess();
                        try {
                            if (!debugProcessImpl.isAttached()) {
                                return;
                            }
                        }
                        catch (Exception exception) {
                            throw RefreshThreadsTreeCommand.b(exception);
                        }
                        DebuggerContextImpl debuggerContextImpl = this.b.getContextManager().getContext();
                        SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
                        try {
                            threadReferenceProxyImpl2 = suspendContextImpl != null ? suspendContextImpl.getThread() : null;
                        }
                        catch (Exception exception) {
                            throw RefreshThreadsTreeCommand.b(exception);
                        }
                        threadReferenceProxyImpl = threadReferenceProxyImpl2;
                        bl4 = ThreadsViewSettings.getInstance().SHOW_THREAD_GROUPS;
                        try {
                            Object object2;
                            Object object3;
                            EvaluationContextImpl evaluationContextImpl;
                            ThreadReferenceProxyImpl threadReferenceProxyImpl3;
                            try {
                                threadReferenceProxyImpl3 = ThreadsViewSettings.getInstance().SHOW_CURRENT_THREAD ? threadReferenceProxyImpl : null;
                            }
                            catch (Exception exception) {
                                throw RefreshThreadsTreeCommand.b(exception);
                            }
                            ThreadReferenceProxyImpl threadReferenceProxyImpl4 = threadReferenceProxyImpl3;
                            arrayList = debugProcessImpl.getVirtualMachineProxy();
                            try {
                                evaluationContextImpl = suspendContextImpl != null ? ThreadsDebuggerTree.this.getDebuggerContext().createEvaluationContext() : null;
                            }
                            catch (Exception exception) {
                                throw RefreshThreadsTreeCommand.b(exception);
                            }
                            object = evaluationContextImpl;
                            NodeManagerImpl nodeManagerImpl = ThreadsDebuggerTree.this.getNodeFactory();
                            if (bl4) {
                                block31: {
                                    object3 = null;
                                    if (threadReferenceProxyImpl4 != null) {
                                        block30: {
                                            object3 = threadReferenceProxyImpl4.threadGroupProxy();
                                            if (object3 != null) {
                                                for (object2 = ((ThreadGroupReferenceProxyImpl)object3).parent(); object2 != null; object2 = ((ThreadGroupReferenceProxyImpl)object2).parent()) {
                                                    object3 = object2;
                                                }
                                            }
                                            try {
                                                if (object3 == null) break block30;
                                                debuggerTreeNodeImpl.add(nodeManagerImpl.createNode(nodeManagerImpl.getThreadGroupDescriptor(null, (ThreadGroupReferenceProxyImpl)object3), (EvaluationContext)object));
                                                break block31;
                                            }
                                            catch (Exception exception) {
                                                throw RefreshThreadsTreeCommand.b(exception);
                                            }
                                        }
                                        debuggerTreeNodeImpl.add(nodeManagerImpl.createNode(nodeManagerImpl.getThreadDescriptor(null, threadReferenceProxyImpl4), (EvaluationContext)object));
                                    }
                                }
                                for (ThreadGroupReferenceProxyImpl objectReferenceProxyImpl : ((VirtualMachineProxyImpl)((Object)arrayList)).topLevelThreadGroups()) {
                                    if (objectReferenceProxyImpl == object3) continue;
                                    DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = nodeManagerImpl.createNode(nodeManagerImpl.getThreadGroupDescriptor(null, objectReferenceProxyImpl), (EvaluationContext)object);
                                    debuggerTreeNodeImpl.add(debuggerTreeNodeImpl2);
                                }
                                break block32;
                            }
                            try {
                                if (threadReferenceProxyImpl4 != null) {
                                    debuggerTreeNodeImpl.insert(nodeManagerImpl.createNode(nodeManagerImpl.getThreadDescriptor(null, threadReferenceProxyImpl4), (EvaluationContext)object), 0);
                                }
                            }
                            catch (Exception exception) {
                                throw RefreshThreadsTreeCommand.b(exception);
                            }
                            object3 = new ArrayList<ThreadReferenceProxyImpl>(((VirtualMachineProxyImpl)((Object)arrayList)).allThreads());
                            object3.sort(ThreadReferenceProxyImpl.ourComparator);
                            object2 = object3.iterator();
                            while (object2.hasNext()) {
                                ThreadReferenceProxyImpl threadReferenceProxyImpl5 = (ThreadReferenceProxyImpl)object2.next();
                                try {
                                    if (threadReferenceProxyImpl5.equals(threadReferenceProxyImpl4)) {
                                        continue;
                                    }
                                }
                                catch (Exception exception) {
                                    throw RefreshThreadsTreeCommand.b(exception);
                                }
                                debuggerTreeNodeImpl.add(nodeManagerImpl.createNode(nodeManagerImpl.getThreadDescriptor(null, threadReferenceProxyImpl5), (EvaluationContext)object));
                            }
                        }
                        catch (Exception exception) {
                            debuggerTreeNodeImpl.add(MessageDescriptor.DEBUG_INFO_UNAVAILABLE);
                            g.debug((Throwable)exception);
                        }
                    }
                    try {
                        bl3 = threadReferenceProxyImpl != null;
                    }
                    catch (Exception exception) {
                        throw RefreshThreadsTreeCommand.b(exception);
                    }
                    bl2 = bl3;
                    try {
                        if (!bl2 || !bl4) break block33;
                    }
                    catch (Exception exception) {
                        throw RefreshThreadsTreeCommand.b(exception);
                    }
                    arrayList = new ArrayList<Object>();
                    for (object = threadReferenceProxyImpl.threadGroupProxy(); object != null; object = ((ThreadGroupReferenceProxyImpl)object).parent()) {
                        arrayList.add(object);
                    }
                    Collections.reverse(arrayList);
                    break block34;
                }
                arrayList = Collections.emptyList();
            }
            DebuggerInvocationUtil.swingInvokeLater(ThreadsDebuggerTree.this.getProject(), () -> {
                ThreadsDebuggerTree.this.getMutableModel().setRoot(debuggerTreeNodeImpl);
                ThreadsDebuggerTree.this.treeChanged();
                if (bl2) {
                    this.a(arrayList, threadReferenceProxyImpl, true);
                }
            });
        }

        private void a(final List<ThreadGroupReferenceProxyImpl> list, final ThreadReferenceProxyImpl threadReferenceProxyImpl, final boolean bl2) {
            g.assertTrue(SwingUtilities.isEventDispatchThread());
            class MyTreeModelAdapter
            extends TreeModelAdapter {
                MyTreeModelAdapter() {
                }

                private void a(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
                    Enumeration enumeration = debuggerTreeNodeImpl.children();
                    while (enumeration.hasMoreElements()) {
                        DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = (DebuggerTreeNodeImpl)enumeration.nextElement();
                        this.b(debuggerTreeNodeImpl2);
                    }
                }

                private void b(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
                    if (list.size() == 0) {
                        if (debuggerTreeNodeImpl.getDescriptor() instanceof ThreadDescriptorImpl && ((ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).getThreadReference() == threadReferenceProxyImpl) {
                            this.a();
                            TreePath treePath = new TreePath(debuggerTreeNodeImpl.getPath());
                            ThreadsDebuggerTree.this.setSelectionPath(treePath);
                            if (bl2 && !ThreadsDebuggerTree.this.isExpanded(treePath)) {
                                ThreadsDebuggerTree.this.expandPath(treePath);
                            }
                        }
                    } else if (debuggerTreeNodeImpl.getDescriptor() instanceof ThreadGroupDescriptorImpl && ((ThreadGroupDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).getThreadGroupReference() == list.get(0)) {
                        list.remove(0);
                        ThreadsDebuggerTree.this.expandPath(new TreePath(debuggerTreeNodeImpl.getPath()));
                    }
                }

                private void a() {
                    MyTreeModelAdapter myTreeModelAdapter = this;
                    SwingUtilities.invokeLater(() -> ThreadsDebuggerTree.this.getModel().removeTreeModelListener((TreeModelListener)((Object)myTreeModelAdapter)));
                }

                public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                    if (treeModelEvent.getPath().length <= 1) {
                        this.a();
                        return;
                    }
                    this.a((DebuggerTreeNodeImpl)treeModelEvent.getTreePath().getLastPathComponent());
                }
            }
            MyTreeModelAdapter myTreeModelAdapter = new MyTreeModelAdapter();
            myTreeModelAdapter.a((DebuggerTreeNodeImpl)ThreadsDebuggerTree.this.getModel().getRoot());
            ThreadsDebuggerTree.this.getModel().addTreeModelListener((TreeModelListener)((Object)myTreeModelAdapter));
        }

        private static Exception b(Exception exception) {
            return exception;
        }
    }
}

