/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Weighted;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.openapi.wm.IdeGlassPaneUtil;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class TipManager
implements Disposable,
PopupMenuListener {
    private volatile boolean m = false;
    private boolean g;
    private MyAwtPreprocessor k;
    private MouseEvent e;
    boolean myInsideComponent;
    private JComponent l;
    private Popup f;
    private final TipFactory b;
    private final JComponent a;
    private MouseListener d = new MyMouseListener();
    private MouseMotionListener h = new MyMouseMotionListener();
    private FrameStateListener i = new MyFrameStateListener();
    private final Alarm n = new Alarm();
    private final Alarm c = new Alarm();
    private IdeGlassPane j;

    private boolean a(MouseEvent mouseEvent) {
        if (this.l != null) {
            if (!this.l.isShowing()) {
                this.hideTooltip(true);
                return false;
            }
            Component component = mouseEvent.getComponent();
            if (component == null) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            SwingUtilities.convertPointToScreen(point, component);
            Rectangle rectangle = this.l.getBounds();
            Point point2 = this.l.getLocationOnScreen();
            rectangle.setLocation(point2.x, point2.y);
            return rectangle.contains(point);
        }
        return false;
    }

    public JPopupMenu registerPopup(JPopupMenu jPopupMenu) {
        jPopupMenu.addPopupMenuListener(this);
        return jPopupMenu;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        this.g = true;
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        this.a(popupMenuEvent);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        this.a(popupMenuEvent);
    }

    private void a(PopupMenuEvent popupMenuEvent) {
        this.g = false;
        if (popupMenuEvent.getSource() instanceof JPopupMenu) {
            ((JPopupMenu)popupMenuEvent.getSource()).removePopupMenuListener(this);
        }
    }

    private boolean b(MouseEvent mouseEvent) {
        Rectangle rectangle = this.a.getVisibleRect();
        Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), this.a);
        return rectangle.contains(point);
    }

    private void a(InputEvent inputEvent, boolean bl2) {
        this.n.cancelAllRequests();
        this.c.cancelAllRequests();
        this.n.addRequest(() -> {
            if (!this.m && !this.g) {
                this.b(inputEvent, bl2);
            }
        }, bl2 ? XDebuggerSettingsManager.getInstance().getDataViewSettings().getValueLookupDelay() : 10);
    }

    private void b(InputEvent inputEvent, boolean bl2) {
        if (bl2 && !Registry.is((String)"debugger.valueTooltipAutoShow")) {
            return;
        }
        MouseEvent mouseEvent = null;
        JComponent jComponent = null;
        if (inputEvent instanceof MouseEvent) {
            mouseEvent = (MouseEvent)inputEvent;
        } else if (inputEvent instanceof KeyEvent) {
            mouseEvent = this.b.createTooltipEvent(this.e);
        }
        MouseEvent mouseEvent2 = null;
        if (mouseEvent != null) {
            mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.a);
            jComponent = this.b.createToolTip(mouseEvent2);
        }
        if (jComponent == null || bl2 && !this.b.isFocusOwner()) {
            this.hideTooltip(false);
            return;
        }
        if (jComponent == this.l) {
            if (!bl2) {
                this.hideTooltip(true);
                return;
            }
            return;
        }
        this.hideTooltip(true);
        if (this.a.isShowing()) {
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            Point point = mouseEvent2.getPoint();
            Component component = mouseEvent2.getComponent();
            if (component != null) {
                SwingUtilities.convertPointToScreen(point, component);
            }
            this.f = popupFactory.getPopup(this.a, jComponent, point.x, point.y);
            this.myInsideComponent = false;
            this.f.show();
            this.l = jComponent;
        }
    }

    public void hideTooltip() {
        this.hideTooltip(true);
    }

    public void hideTooltip(boolean bl2) {
        if (this.f == null) {
            return;
        }
        if (bl2) {
            this.c.cancelAllRequests();
            this.f.hide();
            this.f = null;
            this.l = null;
        } else {
            this.c.addRequest(() -> {
                if (this.myInsideComponent) {
                    this.hideTooltip(true);
                }
            }, 100);
        }
    }

    public TipManager(JComponent jComponent, TipFactory tipFactory) {
        this.b = tipFactory;
        this.a = jComponent;
        new UiNotifyConnector.Once((Component)jComponent, new Activatable(){

            public void showNotify() {
                TipManager.this.b();
            }

            public void hideNotify() {
            }
        });
        final HideTooltipAction hideTooltipAction = new HideTooltipAction();
        hideTooltipAction.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.a);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                hideTooltipAction.unregisterCustomShortcutSet(TipManager.this.a);
            }
        });
    }

    private void b() {
        if (this.m) {
            return;
        }
        this.j = IdeGlassPaneUtil.find((Component)this.a);
        assert (this.j != null);
        this.j.addMousePreprocessor(this.d, (Disposable)this);
        this.j.addMouseMotionPreprocessor(this.h, (Disposable)this);
        this.k = new MyAwtPreprocessor();
        Toolkit.getDefaultToolkit().addAWTEventListener(this.k, 56L);
        FrameStateManager.getInstance().addListener(this.i);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
        this.hideTooltip(true);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.k);
        this.m = true;
        this.n.cancelAllRequests();
        this.d = null;
        this.h = null;
        FrameStateManager.getInstance().removeListener(this.i);
        this.i = null;
    }

    private class MyAwtPreprocessor
    implements AWTEventListener {
        private MyAwtPreprocessor() {
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getID() == 503) {
                this.a(aWTEvent);
            } else if (aWTEvent.getID() == 501 || aWTEvent.getID() == 502) {
                this.a((MouseEvent)aWTEvent);
            } else if (aWTEvent instanceof KeyEvent) {
                this.a((KeyEvent)aWTEvent);
            }
        }

        private void a(MouseEvent mouseEvent) {
            if (TipManager.this.l == null) {
                return;
            }
            if (this.b(mouseEvent) && UIUtil.isCloseClick((MouseEvent)mouseEvent)) {
                TipManager.this.hideTooltip(true);
            }
        }

        private void a(KeyEvent keyEvent) {
            if (KeymapUtil.isTooltipRequest((KeyEvent)keyEvent)) {
                TipManager.this.a(keyEvent, false);
            } else if (keyEvent.getID() == 401) {
                TipManager.this.e = null;
            }
        }

        private void a(AWTEvent aWTEvent) {
            MouseEvent mouseEvent;
            if (TipManager.this.l == null) {
                return;
            }
            if (aWTEvent.getID() == 503 && this.b(mouseEvent = (MouseEvent)aWTEvent)) {
                TipManager.this.c.cancelAllRequests();
            }
        }

        private boolean b(MouseEvent mouseEvent) {
            return TipManager.this.l == mouseEvent.getComponent() || SwingUtilities.isDescendingFrom(mouseEvent.getComponent(), TipManager.this.l);
        }
    }

    private class HideTooltipAction
    extends AnAction {
        private HideTooltipAction() {
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            TipManager.this.hideTooltip(true);
        }

        public void update(AnActionEvent anActionEvent) {
            anActionEvent.getPresentation().setEnabled(TipManager.this.f != null);
        }
    }

    private class MyMouseMotionListener
    extends MouseMotionAdapter
    implements Weighted {
        private MyMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            TipManager.this.e = mouseEvent;
            if (!TipManager.this.a.isShowing()) {
                return;
            }
            TipManager.this.myInsideComponent = true;
            if (TipManager.this.l == null) {
                if (TipManager.this.b(mouseEvent)) {
                    TipManager.this.a(mouseEvent, true);
                }
            } else if (!TipManager.this.a(mouseEvent)) {
                TipManager.this.a(mouseEvent, true);
            }
        }

        public double getWeight() {
            return 0.0;
        }
    }

    private class MyFrameStateListener
    extends FrameStateListener.Adapter {
        private MyFrameStateListener() {
        }

        public void onFrameDeactivated() {
            TipManager.this.hideTooltip(true);
        }
    }

    private class MyMouseListener
    extends MouseAdapter
    implements Weighted {
        private MyMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            TipManager.this.myInsideComponent = false;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (TipManager.this.myInsideComponent) {
                TipManager.this.hideTooltip(true);
            }
        }

        public double getWeight() {
            return 0.0;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            TipManager.this.myInsideComponent = true;
        }
    }

    public static interface TipFactory {
        public JComponent createToolTip(MouseEvent var1);

        public MouseEvent createTooltipEvent(MouseEvent var1);

        public boolean isFocusOwner();
    }
}

