/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.LocalVariableProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ThreadsViewSettings;
import com.intellij.debugger.ui.impl.DebuggerTreeBase;
import com.intellij.debugger.ui.impl.tree.TreeBuilder;
import com.intellij.debugger.ui.impl.tree.TreeBuilderNode;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.DefaultNodeDescriptor;
import com.intellij.debugger.ui.impl.watch.FieldDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.LocalVariableDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.StaticDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ThreadGroupDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerTree
extends DebuggerTreeBase
implements DataProvider {
    private static final Logger d = Logger.getInstance(DebuggerTree.class);
    protected static final Key<Rectangle> VISIBLE_RECT = Key.create((String)"VISIBLE_RECT");
    public static final DataKey<DebuggerTree> DATA_KEY = DataKey.create((String)"DebuggerTree");
    protected final NodeManagerImpl myNodeManager;
    private DebuggerContextImpl f = DebuggerContextImpl.EMPTY_CONTEXT;
    private DebuggerTreeNodeImpl e;

    public DebuggerTree(Project project2) {
        super(null, project2);
        this.setScrollsOnExpand(false);
        this.myNodeManager = this.createNodeManager(project2);
        TreeBuilder treeBuilder = new TreeBuilder((Object)this){

            @Override
            public void buildChildren(TreeBuilderNode treeBuilderNode) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)treeBuilderNode;
                if (debuggerTreeNodeImpl.getDescriptor() instanceof DefaultNodeDescriptor) {
                    return;
                }
                DebuggerTree.this.a(debuggerTreeNodeImpl);
            }

            @Override
            public boolean isExpandable(TreeBuilderNode treeBuilderNode) {
                return DebuggerTree.this.isExpandable((DebuggerTreeNodeImpl)treeBuilderNode);
            }
        };
        treeBuilder.setRoot(this.getNodeFactory().getDefaultNode());
        treeBuilder.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                DebuggerTree.this.hideTooltip();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                DebuggerTree.this.hideTooltip();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                DebuggerTree.this.hideTooltip();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                DebuggerTree.this.hideTooltip();
            }
        });
        this.setModel(treeBuilder);
        TreeSpeedSearch treeSpeedSearch = new TreeSpeedSearch((JTree)((Object)this));
        treeSpeedSearch.setComparator(new SpeedSearchComparator(false));
    }

    protected NodeManagerImpl createNodeManager(Project project2) {
        return new NodeManagerImpl(project2, this);
    }

    @Override
    public void dispose() {
        this.myNodeManager.dispose();
        this.f = DebuggerContextImpl.EMPTY_CONTEXT;
        super.dispose();
    }

    protected boolean isExpandable(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        return nodeDescriptorImpl.isExpandable();
    }

    public Object getData(String string) {
        if (DATA_KEY.is(string)) {
            return this;
        }
        return null;
    }

    private void a(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        DebuggerCommandImpl debuggerCommandImpl;
        if (debuggerTreeNodeImpl == null || debuggerTreeNodeImpl.getDescriptor() == null) {
            return;
        }
        DebugProcessImpl debugProcessImpl = this.getDebuggerContext().getDebugProcess();
        if (debugProcessImpl != null && (debuggerCommandImpl = this.getBuildNodeCommand(debuggerTreeNodeImpl)) != null) {
            debuggerTreeNodeImpl.add(this.myNodeManager.createMessageNode(MessageDescriptor.EVALUATING));
            debugProcessImpl.getManagerThread().schedule(debuggerCommandImpl);
        }
    }

    protected DebuggerCommandImpl getBuildNodeCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        if (debuggerTreeNodeImpl.getDescriptor() instanceof StackFrameDescriptorImpl) {
            return new BuildStackFrameCommand(debuggerTreeNodeImpl);
        }
        if (debuggerTreeNodeImpl.getDescriptor() instanceof ValueDescriptorImpl) {
            return new BuildValueNodeCommand(debuggerTreeNodeImpl);
        }
        if (debuggerTreeNodeImpl.getDescriptor() instanceof StaticDescriptorImpl) {
            return new BuildStaticNodeCommand(debuggerTreeNodeImpl);
        }
        if (debuggerTreeNodeImpl.getDescriptor() instanceof ThreadDescriptorImpl) {
            return new BuildThreadCommand(debuggerTreeNodeImpl);
        }
        if (debuggerTreeNodeImpl.getDescriptor() instanceof ThreadGroupDescriptorImpl) {
            return new BuildThreadGroupCommand(debuggerTreeNodeImpl);
        }
        d.assertTrue(false);
        return null;
    }

    public void saveState(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        Cloneable cloneable;
        Object object;
        if (debuggerTreeNodeImpl.getDescriptor() != null) {
            object = new TreePath(debuggerTreeNodeImpl.getPath());
            debuggerTreeNodeImpl.getDescriptor().myIsExpanded = this.isExpanded((TreePath)object);
            debuggerTreeNodeImpl.getDescriptor().myIsSelected = this.getSelectionModel().isPathSelected((TreePath)object);
            cloneable = this.getRowBounds(this.getRowForPath((TreePath)object));
            if (cloneable != null && this.getVisibleRect().contains((Rectangle)cloneable)) {
                debuggerTreeNodeImpl.getDescriptor().putUserData(VISIBLE_RECT, this.getVisibleRect());
                debuggerTreeNodeImpl.getDescriptor().myIsVisible = true;
            } else {
                debuggerTreeNodeImpl.getDescriptor().putUserData(VISIBLE_RECT, null);
                debuggerTreeNodeImpl.getDescriptor().myIsVisible = false;
            }
        }
        object = debuggerTreeNodeImpl.rawChildren();
        while (object.hasMoreElements()) {
            cloneable = (DebuggerTreeNodeImpl)object.nextElement();
            this.saveState((DebuggerTreeNodeImpl)cloneable);
        }
    }

    public void restoreState(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        this.b(debuggerTreeNodeImpl);
        this.scrollToVisible(debuggerTreeNodeImpl);
    }

    protected final void scrollToVisible(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        TreePath treePath = new TreePath(debuggerTreeNodeImpl.getPath());
        int n2 = this.getRowCount();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            DebuggerTreeNodeImpl debuggerTreeNodeImpl2;
            NodeDescriptorImpl nodeDescriptorImpl;
            TreePath treePath2 = this.getPathForRow(i2);
            if (treePath2 == null || !treePath.isDescendant(treePath2) || (nodeDescriptorImpl = (debuggerTreeNodeImpl2 = (DebuggerTreeNodeImpl)treePath2.getLastPathComponent()).getDescriptor()) == null || !nodeDescriptorImpl.myIsVisible) continue;
            Rectangle rectangle = nodeDescriptorImpl.getUserData(VISIBLE_RECT);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
                break;
            }
            this.scrollPathToVisible(treePath2);
            break;
        }
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        rectangle.width += rectangle.x;
        rectangle.x = 0;
        super.scrollRectToVisible(rectangle);
    }

    private void b(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        this.restoreNodeState(debuggerTreeNodeImpl);
        if (debuggerTreeNodeImpl.getDescriptor().myIsExpanded) {
            Enumeration enumeration = debuggerTreeNodeImpl.rawChildren();
            while (enumeration.hasMoreElements()) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = (DebuggerTreeNodeImpl)enumeration.nextElement();
                this.b(debuggerTreeNodeImpl2);
            }
        }
    }

    public void restoreState() {
        this.clearSelection();
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        if (debuggerTreeNodeImpl != null) {
            this.restoreState(debuggerTreeNodeImpl);
        }
    }

    protected void restoreNodeState(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        if (nodeDescriptorImpl != null) {
            if (debuggerTreeNodeImpl.getParent() == null) {
                nodeDescriptorImpl.myIsExpanded = true;
            }
            TreePath treePath = new TreePath(debuggerTreeNodeImpl.getPath());
            if (nodeDescriptorImpl.myIsExpanded) {
                this.expandPath(treePath);
            }
            if (nodeDescriptorImpl.myIsSelected) {
                this.addSelectionPath(treePath);
            }
        }
    }

    public NodeManagerImpl getNodeFactory() {
        return this.myNodeManager;
    }

    public TreeBuilder getMutableModel() {
        return (TreeBuilder)this.getModel();
    }

    public void removeAllChildren() {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        debuggerTreeNodeImpl.removeAllChildren();
        this.treeChanged();
    }

    public void showMessage(MessageDescriptor messageDescriptor) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = this.getNodeFactory().getDefaultNode();
        this.getMutableModel().setRoot(debuggerTreeNodeImpl);
        DebuggerTreeNodeImpl debuggerTreeNodeImpl2 = debuggerTreeNodeImpl.add(messageDescriptor);
        this.treeChanged();
        this.expandPath(new TreePath(debuggerTreeNodeImpl2.getPath()));
    }

    public void showMessage(String string) {
        this.showMessage(new MessageDescriptor(string));
    }

    public final void treeChanged() {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = (DebuggerTreeNodeImpl)this.getModel().getRoot();
        if (debuggerTreeNodeImpl != null) {
            this.getMutableModel().nodeStructureChanged(debuggerTreeNodeImpl);
            this.restoreState();
        }
    }

    protected abstract void build(DebuggerContextImpl var1);

    public void rebuild(final DebuggerContextImpl debuggerContextImpl) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        if (debugProcessImpl == null) {
            return;
        }
        this.f = debuggerContextImpl;
        this.saveState();
        debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                DebuggerTree.this.getNodeFactory().setHistoryByContext(debuggerContextImpl);
            }

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.NORMAL;
            }
        });
        this.build(debuggerContextImpl);
    }

    public void saveState() {
        this.saveState((DebuggerTreeNodeImpl)this.getModel().getRoot());
    }

    public void onEditorShown(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        this.e = debuggerTreeNodeImpl;
        this.hideTooltip();
    }

    public void onEditorHidden(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
        if (this.e != null) {
            assert (this.e == debuggerTreeNodeImpl);
            this.e = null;
        }
    }

    @Override
    public JComponent createToolTip(MouseEvent mouseEvent) {
        return this.e != null ? null : super.createToolTip(mouseEvent);
    }

    public DebuggerContextImpl getDebuggerContext() {
        return this.f;
    }

    public void hideTooltip() {
        this.myTipManager.hideTooltip();
    }

    private class BuildThreadGroupCommand
    extends DebuggerCommandImpl {
        private final DebuggerTreeNodeImpl b;
        protected final List<DebuggerTreeNodeImpl> myChildren = new LinkedList<DebuggerTreeNodeImpl>();

        public BuildThreadGroupCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
            this.b = debuggerTreeNodeImpl;
        }

        @Override
        protected void action() throws Exception {
            EvaluationContextImpl evaluationContextImpl;
            ArrayList<ThreadReferenceProxyImpl> arrayList;
            ThreadGroupReferenceProxyImpl threadGroupReferenceProxyImpl;
            ThreadGroupDescriptorImpl threadGroupDescriptorImpl;
            block15: {
                block14: {
                    threadGroupDescriptorImpl = (ThreadGroupDescriptorImpl)this.b.getDescriptor();
                    threadGroupReferenceProxyImpl = threadGroupDescriptorImpl.getThreadGroupReference();
                    arrayList = new ArrayList<ThreadReferenceProxyImpl>(threadGroupReferenceProxyImpl.threads());
                    arrayList.sort(ThreadReferenceProxyImpl.ourComparator);
                    DebuggerContextImpl debuggerContextImpl = DebuggerTree.this.getDebuggerContext();
                    SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
                    try {
                        try {
                            if (suspendContextImpl == null || suspendContextImpl.isResumed()) break block14;
                        }
                        catch (Exception exception) {
                            throw BuildThreadGroupCommand.b(exception);
                        }
                        evaluationContextImpl = debuggerContextImpl.createEvaluationContext();
                        break block15;
                    }
                    catch (Exception exception) {
                        throw BuildThreadGroupCommand.b(exception);
                    }
                }
                evaluationContextImpl = null;
            }
            EvaluationContextImpl evaluationContextImpl2 = evaluationContextImpl;
            boolean bl2 = ThreadsViewSettings.getInstance().SHOW_CURRENT_THREAD;
            for (ThreadGroupReferenceProxyImpl object : threadGroupReferenceProxyImpl.threadGroups()) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl;
                block16: {
                    if (object == null) continue;
                    debuggerTreeNodeImpl = DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getThreadGroupDescriptor(threadGroupDescriptorImpl, object), evaluationContextImpl2);
                    try {
                        try {
                            if (!bl2 || !((ThreadGroupDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).isCurrent()) break block16;
                        }
                        catch (Exception exception) {
                            throw BuildThreadGroupCommand.b(exception);
                        }
                        this.myChildren.add(0, debuggerTreeNodeImpl);
                        continue;
                    }
                    catch (Exception exception) {
                        throw BuildThreadGroupCommand.b(exception);
                    }
                }
                this.myChildren.add(debuggerTreeNodeImpl);
            }
            ArrayList arrayList2 = new ArrayList();
            for (ThreadReferenceProxyImpl threadReferenceProxyImpl : arrayList) {
                DebuggerTreeNodeImpl debuggerTreeNodeImpl;
                block17: {
                    if (threadReferenceProxyImpl == null) continue;
                    debuggerTreeNodeImpl = DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getThreadDescriptor(threadGroupDescriptorImpl, threadReferenceProxyImpl), evaluationContextImpl2);
                    try {
                        try {
                            if (!bl2 || !((ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).isCurrent()) break block17;
                        }
                        catch (Exception exception) {
                            throw BuildThreadGroupCommand.b(exception);
                        }
                        arrayList2.add(0, debuggerTreeNodeImpl);
                        continue;
                    }
                    catch (Exception exception) {
                        throw BuildThreadGroupCommand.b(exception);
                    }
                }
                arrayList2.add(debuggerTreeNodeImpl);
            }
            this.myChildren.addAll(arrayList2);
            this.updateUI(true);
        }

        protected void updateUI(boolean bl2) {
            DebuggerInvocationUtil.swingInvokeLater(DebuggerTree.this.getProject(), () -> {
                this.b.removeAllChildren();
                for (DebuggerTreeNodeImpl debuggerTreeNodeImpl : this.myChildren) {
                    this.b.add(debuggerTreeNodeImpl);
                }
                this.b.childrenChanged(bl2);
            });
        }

        private static Exception b(Exception exception) {
            return exception;
        }
    }

    private class BuildThreadCommand
    extends BuildNodeCommand {
        public BuildThreadCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
            super(debuggerTreeNodeImpl, ((ThreadDescriptorImpl)debuggerTreeNodeImpl.getDescriptor()).getThreadReference());
        }

        /*
         * Loose catch block
         */
        @Override
        public void threadAction() {
            block9: {
                ThreadDescriptorImpl threadDescriptorImpl = (ThreadDescriptorImpl)this.getNode().getDescriptor();
                ThreadReferenceProxyImpl threadReferenceProxyImpl = threadDescriptorImpl.getThreadReference();
                try {
                    if (threadReferenceProxyImpl.isCollected() || !this.getDebuggerContext().getDebugProcess().getSuspendManager().isSuspended(threadReferenceProxyImpl)) break block9;
                }
                catch (EvaluateException evaluateException) {
                    throw BuildThreadCommand.a(evaluateException);
                }
                int n2 = threadReferenceProxyImpl.status();
                if (n2 == -1) break block9;
                try {
                    block10: {
                        if (n2 == 5) break block9;
                        break block10;
                        catch (EvaluateException evaluateException) {
                            throw BuildThreadCommand.a(evaluateException);
                        }
                    }
                    if (n2 == 0) break block9;
                }
                catch (EvaluateException evaluateException) {
                    throw BuildThreadCommand.a(evaluateException);
                }
                try {
                    for (StackFrameProxyImpl stackFrameProxyImpl : threadReferenceProxyImpl.frames()) {
                        this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(DebuggerTree.this.myNodeManager.getStackFrameDescriptor(threadDescriptorImpl, stackFrameProxyImpl), this.getDebuggerContext().createEvaluationContext()));
                    }
                }
                catch (EvaluateException evaluateException) {
                    this.myChildren.clear();
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(evaluateException.getMessage()));
                    d.debug((Throwable)evaluateException);
                }
            }
            this.updateUI(true);
        }

        private static EvaluateException a(EvaluateException evaluateException) {
            return evaluateException;
        }
    }

    private class BuildStaticNodeCommand
    extends BuildNodeCommand {
        public BuildStaticNodeCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
            super(debuggerTreeNodeImpl);
        }

        @Override
        public void threadAction() {
            StaticDescriptorImpl staticDescriptorImpl = (StaticDescriptorImpl)this.getNode().getDescriptor();
            ReferenceType referenceType = staticDescriptorImpl.getType();
            List<Field> list = referenceType.allFields();
            for (Field field : list) {
                if (!field.isStatic()) continue;
                FieldDescriptorImpl fieldDescriptorImpl = DebuggerTree.this.myNodeManager.getFieldDescriptor(staticDescriptorImpl, null, field);
                EvaluationContextImpl evaluationContextImpl = this.getDebuggerContext().createEvaluationContext();
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = DebuggerTree.this.myNodeManager.createNode(fieldDescriptorImpl, evaluationContextImpl);
                this.myChildren.add(debuggerTreeNodeImpl);
            }
            this.updateUI(true);
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    private class BuildValueNodeCommand
    extends BuildNodeCommand
    implements ChildrenBuilder {
        public BuildValueNodeCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
            super(debuggerTreeNodeImpl);
        }

        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
            try {
                if (suspendContextImpl == null) {
                    BuildValueNodeCommand.c(0);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw BuildValueNodeCommand.c(objectCollectedException);
            }
            DebuggerTreeNodeImpl debuggerTreeNodeImpl = this.getNode();
            ValueDescriptorImpl valueDescriptorImpl = (ValueDescriptorImpl)debuggerTreeNodeImpl.getDescriptor();
            try {
                NodeRenderer nodeRenderer = valueDescriptorImpl.getRenderer(suspendContextImpl.getDebugProcess());
                nodeRenderer.buildChildren(valueDescriptorImpl.getValue(), this, this.getDebuggerContext().createEvaluationContext());
            }
            catch (ObjectCollectedException objectCollectedException) {
                String string = objectCollectedException.getMessage();
                DebuggerInvocationUtil.swingInvokeLater(DebuggerTree.this.getProject(), () -> {
                    debuggerTreeNodeImpl.removeAllChildren();
                    debuggerTreeNodeImpl.add(DebuggerTree.this.getNodeFactory().createMessageNode(new MessageDescriptor(DebuggerBundle.message((String)"error.cannot.build.node.children.object.collected", (Object[])new Object[]{string}))));
                    debuggerTreeNodeImpl.childrenChanged(false);
                });
            }
        }

        @Override
        public NodeManagerImpl getNodeManager() {
            return DebuggerTree.this.myNodeManager;
        }

        @Override
        public NodeManagerImpl getDescriptorManager() {
            return DebuggerTree.this.myNodeManager;
        }

        @Override
        public ValueDescriptorImpl getParentDescriptor() {
            return (ValueDescriptorImpl)this.getNode().getDescriptor();
        }

        @Override
        public void initChildrenArrayRenderer(ArrayRenderer arrayRenderer, int n2) {
        }

        @Override
        public void setChildren(List<DebuggerTreeNode> list) {
            for (DebuggerTreeNode debuggerTreeNode : list) {
                try {
                    if (!(debuggerTreeNode instanceof DebuggerTreeNodeImpl)) continue;
                    this.myChildren.add((DebuggerTreeNodeImpl)debuggerTreeNode);
                }
                catch (ObjectCollectedException objectCollectedException) {
                    throw BuildValueNodeCommand.c(objectCollectedException);
                }
            }
            this.updateUI(false);
        }

        public void addChildren(@NotNull XValueChildrenList xValueChildrenList, boolean bl2) {
            try {
                if (xValueChildrenList == null) {
                    BuildValueNodeCommand.c(1);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw BuildValueNodeCommand.c(objectCollectedException);
            }
        }

        public void tooManyChildren(int n2) {
        }

        public void setAlreadySorted(boolean bl2) {
        }

        public void setErrorMessage(@NotNull String string) {
            try {
                if (string == null) {
                    BuildValueNodeCommand.c(2);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw BuildValueNodeCommand.c(objectCollectedException);
            }
        }

        public void setErrorMessage(@NotNull String string, @Nullable XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink) {
            try {
                if (string == null) {
                    BuildValueNodeCommand.c(3);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw BuildValueNodeCommand.c(objectCollectedException);
            }
        }

        public void setMessage(@NotNull String string, @Nullable Icon icon, @NotNull SimpleTextAttributes simpleTextAttributes, @Nullable XDebuggerTreeNodeHyperlink xDebuggerTreeNodeHyperlink) {
            try {
                if (string == null) {
                    BuildValueNodeCommand.c(4);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw BuildValueNodeCommand.c(objectCollectedException);
            }
            try {
                if (simpleTextAttributes == null) {
                    BuildValueNodeCommand.c(5);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw BuildValueNodeCommand.c(objectCollectedException);
            }
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void c(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static ObjectCollectedException c(ObjectCollectedException objectCollectedException) {
            return objectCollectedException;
        }
    }

    protected class BuildStackFrameCommand
    extends BuildNodeCommand {
        public BuildStackFrameCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
            super(debuggerTreeNodeImpl);
        }

        /*
         * Could not resolve type clashes
         * Loose catch block
         */
        @Override
        public void threadAction() {
            try {
                Object object;
                Object object2;
                Pair<Method, Value> pair2;
                EvaluationContextImpl evaluationContextImpl;
                DebuggerContextImpl debuggerContextImpl;
                StackFrameDescriptorImpl stackFrameDescriptorImpl;
                block29: {
                    boolean bl2;
                    Logger logger;
                    stackFrameDescriptorImpl = (StackFrameDescriptorImpl)this.getNode().getDescriptor();
                    StackFrameProxyImpl stackFrameProxyImpl = stackFrameDescriptorImpl.getFrameProxy();
                    debuggerContextImpl = this.getDebuggerContext();
                    evaluationContextImpl = debuggerContextImpl.createEvaluationContext();
                    try {
                        if (!debuggerContextImpl.isEvaluationPossible()) {
                            this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(MessageDescriptor.EVALUATION_NOT_POSSIBLE, evaluationContextImpl));
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                    }
                    Location location = stackFrameProxyImpl.location();
                    try {
                        logger = d;
                        bl2 = location != null;
                    }
                    catch (EvaluateException evaluateException) {
                        throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                    }
                    logger.assertTrue(bl2);
                    ObjectReference objectReference = stackFrameProxyImpl.thisObject();
                    NodeDescriptorImpl nodeDescriptorImpl = objectReference != null ? DebuggerTree.this.myNodeManager.getThisDescriptor(stackFrameDescriptorImpl, objectReference) : DebuggerTree.this.myNodeManager.getStaticDescriptor(stackFrameDescriptorImpl, location.method().declaringType());
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createNode(nodeDescriptorImpl, evaluationContextImpl));
                    ClassRenderer classRenderer = NodeRendererSettings.getInstance().getClassRenderer();
                    if (!classRenderer.SHOW_VAL_FIELDS_AS_LOCAL_VARIABLES) break block29;
                    try {
                        block32: {
                            if (objectReference == null) break block29;
                            break block32;
                            catch (EvaluateException evaluateException) {
                                throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                            }
                        }
                        if (!evaluationContextImpl.getDebugProcess().getVirtualMachineProxy().canGetSyntheticAttribute()) break block29;
                    }
                    catch (EvaluateException evaluateException) {
                        throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                    }
                    pair2 = objectReference.referenceType();
                    if (!(pair2 instanceof ClassType)) break block29;
                    try {
                        block33: {
                            if (!pair2.equals((Object)location.declaringType())) break block29;
                            break block33;
                            catch (EvaluateException evaluateException) {
                                throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                            }
                        }
                        if (!pair2.name().contains("$")) break block29;
                    }
                    catch (EvaluateException evaluateException) {
                        throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                    }
                    object2 = (ClassType)pair2;
                    for (Mirror mirror : object2.fields()) {
                        try {
                            if (!DebuggerUtils.isSynthetic((TypeComponent)mirror) || !StringUtil.startsWith((CharSequence)mirror.name(), (CharSequence)"val$")) continue;
                        }
                        catch (EvaluateException evaluateException) {
                            throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                        }
                        object = DebuggerTree.this.myNodeManager.getFieldDescriptor(stackFrameDescriptorImpl, objectReference, (Field)mirror);
                        this.myChildren.add(DebuggerTree.this.myNodeManager.createNode((NodeDescriptor)object, evaluationContextImpl));
                    }
                }
                try {
                    try {
                        this.buildVariables(stackFrameDescriptorImpl, evaluationContextImpl);
                        if (XDebuggerSettingsManager.getInstance().getDataViewSettings().isSortValues()) {
                            this.myChildren.sort(NodeManagerImpl.getNodeComparator());
                        }
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw BuildStackFrameCommand.c(invalidStackFrameException);
                    }
                }
                catch (EvaluateException evaluateException) {
                    this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(new MessageDescriptor(evaluateException.getMessage())));
                }
                pair2 = debuggerContextImpl.getDebugProcess().getLastExecutedMethod();
                if (pair2 != null) {
                    object2 = DebuggerTree.this.myNodeManager.getMethodReturnValueDescriptor(stackFrameDescriptorImpl, (Method)pair2.getFirst(), (Value)pair2.getSecond());
                    this.myChildren.add(1, DebuggerTree.this.myNodeManager.createNode((NodeDescriptor)object2, evaluationContextImpl));
                }
                for (Object object3 : DebuggerUtilsEx.getEventDescriptors(this.getSuspendContext())) {
                    Mirror mirror;
                    mirror = (Event)object3.getSecond();
                    if (!(mirror instanceof ExceptionEvent) || (object = ((ExceptionEvent)mirror).exception()) == null) continue;
                    ValueDescriptorImpl valueDescriptorImpl = DebuggerTree.this.myNodeManager.getThrownExceptionObjectDescriptor(stackFrameDescriptorImpl, (ObjectReference)object);
                    DebuggerTreeNodeImpl debuggerTreeNodeImpl = DebuggerTree.this.myNodeManager.createNode(valueDescriptorImpl, evaluationContextImpl);
                    this.myChildren.add(1, debuggerTreeNodeImpl);
                }
            }
            catch (EvaluateException evaluateException) {
                this.myChildren.clear();
                this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(new MessageDescriptor(evaluateException.getMessage())));
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                d.info((Throwable)invalidStackFrameException);
                this.myChildren.clear();
                this.notifyCancelled();
            }
            catch (InternalException internalException) {
                block31: {
                    try {
                        if (internalException.errorCode() != 35) break block31;
                        this.myChildren.add(DebuggerTree.this.myNodeManager.createMessageNode(new MessageDescriptor(DebuggerBundle.message((String)"error.corrupt.debug.info", (Object[])new Object[]{internalException.getMessage()}))));
                    }
                    catch (EvaluateException evaluateException) {
                        throw BuildStackFrameCommand.c((Exception)((Object)evaluateException));
                    }
                }
                throw internalException;
            }
            this.updateUI(true);
        }

        protected void buildVariables(StackFrameDescriptorImpl stackFrameDescriptorImpl, EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
            StackFrameProxyImpl stackFrameProxyImpl = stackFrameDescriptorImpl.getFrameProxy();
            for (LocalVariableProxyImpl localVariableProxyImpl : stackFrameProxyImpl.visibleVariables()) {
                LocalVariableDescriptorImpl localVariableDescriptorImpl = DebuggerTree.this.myNodeManager.getLocalVariableDescriptor(stackFrameDescriptorImpl, localVariableProxyImpl);
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = DebuggerTree.this.myNodeManager.createNode(localVariableDescriptorImpl, evaluationContextImpl);
                this.myChildren.add(debuggerTreeNodeImpl);
            }
        }

        private static Exception c(Exception exception) {
            return exception;
        }
    }

    public abstract class BuildNodeCommand
    extends DebuggerContextCommandImpl {
        private final DebuggerTreeNodeImpl h;
        protected final List<DebuggerTreeNodeImpl> myChildren;

        protected BuildNodeCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl) {
            this(debuggerTreeNodeImpl, null);
        }

        protected BuildNodeCommand(DebuggerTreeNodeImpl debuggerTreeNodeImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            super(DebuggerTree.this.getDebuggerContext(), threadReferenceProxyImpl);
            this.myChildren = new LinkedList<DebuggerTreeNodeImpl>();
            this.h = debuggerTreeNodeImpl;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.NORMAL;
        }

        public DebuggerTreeNodeImpl getNode() {
            return this.h;
        }

        protected void updateUI(boolean bl2) {
            DebuggerInvocationUtil.swingInvokeLater(DebuggerTree.this.getProject(), () -> {
                this.h.removeAllChildren();
                for (DebuggerTreeNodeImpl debuggerTreeNodeImpl : this.myChildren) {
                    this.h.add(debuggerTreeNodeImpl);
                }
                this.h.childrenChanged(bl2);
            });
        }
    }

    protected static abstract class RefreshDebuggerTreeCommand
    extends SuspendContextCommandImpl {
        private final DebuggerContextImpl d;

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.NORMAL;
        }

        public RefreshDebuggerTreeCommand(DebuggerContextImpl debuggerContextImpl) {
            super(debuggerContextImpl.getSuspendContext());
            this.d = debuggerContextImpl;
        }

        public final DebuggerContextImpl getDebuggerContext() {
            return this.d;
        }
    }
}

