/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.impl.watch;

import com.intellij.codeInspection.SmartHashMap;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.HashMap;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.sun.jdi.InconsistentDebugInfoException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public abstract class NodeDescriptorImpl
implements NodeDescriptor {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl");
    public static final String UNKNOWN_VALUE_MESSAGE = "";
    public boolean myIsExpanded = false;
    public boolean myIsSelected = false;
    public boolean myIsVisible = false;
    public boolean myIsSynthetic = false;
    private EvaluateException d;
    private String a = "";
    private Map<Key, Object> b;
    private static final Key<Map<ObjectReference, ValueMarkup>> c = new Key("ValueMarkupMap");

    public String getName() {
        return null;
    }

    public <T> T getUserData(Key<T> key) {
        try {
            if (this.b == null) {
                return null;
            }
        }
        catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
            throw NodeDescriptorImpl.b(inconsistentDebugInfoException);
        }
        return (T)this.b.get(key);
    }

    public <T> void putUserData(Key<T> key, T t2) {
        try {
            if (this.b == null) {
                this.b = new SmartHashMap();
            }
        }
        catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
            throw NodeDescriptorImpl.b(inconsistentDebugInfoException);
        }
        this.b.put(key, t2);
    }

    public void updateRepresentation(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) {
        this.updateRepresentationNoNotify(evaluationContextImpl, descriptorLabelListener);
        descriptorLabelListener.labelChanged();
    }

    protected void updateRepresentationNoNotify(EvaluationContextImpl evaluationContextImpl, DescriptorLabelListener descriptorLabelListener) {
        try {
            try {
                this.d = null;
                this.a = this.calcRepresentation(evaluationContextImpl, descriptorLabelListener);
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.inconsistent.debug.info", (Object[])new Object[0]));
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.invalid.stackframe", (Object[])new Object[0]));
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                throw vMDisconnectedException;
            }
            catch (RuntimeException runtimeException) {
                try {
                    if (runtimeException.getCause() instanceof InterruptedException) {
                        throw runtimeException;
                    }
                }
                catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                    throw NodeDescriptorImpl.b(inconsistentDebugInfoException);
                }
                LOG.error((Throwable)runtimeException);
                throw new EvaluateException("Internal error, see logs for more details");
            }
        }
        catch (EvaluateException evaluateException) {
            this.setFailed(evaluateException);
        }
    }

    protected abstract String calcRepresentation(EvaluationContextImpl var1, DescriptorLabelListener var2) throws EvaluateException;

    public void displayAs(NodeDescriptor nodeDescriptor) {
        if (nodeDescriptor instanceof NodeDescriptorImpl) {
            HashMap hashMap;
            NodeDescriptorImpl nodeDescriptorImpl = (NodeDescriptorImpl)nodeDescriptor;
            try {
                this.myIsExpanded = nodeDescriptorImpl.myIsExpanded;
                this.myIsSelected = nodeDescriptorImpl.myIsSelected;
                this.myIsVisible = nodeDescriptorImpl.myIsVisible;
                NodeDescriptorImpl nodeDescriptorImpl2 = this;
                hashMap = nodeDescriptorImpl.b != null ? new HashMap(nodeDescriptorImpl.b) : null;
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                throw NodeDescriptorImpl.b(inconsistentDebugInfoException);
            }
            try {
                nodeDescriptorImpl2.b = hashMap;
                if (this.b != null) {
                    this.b.remove(OnDemandRenderer.ON_DEMAND_CALCULATED);
                }
            }
            catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
                throw NodeDescriptorImpl.b(inconsistentDebugInfoException);
            }
        }
    }

    public abstract boolean isExpandable();

    public abstract void setContext(EvaluationContextImpl var1);

    public EvaluateException getEvaluateException() {
        return this.d;
    }

    public String getLabel() {
        return this.a;
    }

    public String toString() {
        return this.getLabel();
    }

    protected String setFailed(EvaluateException evaluateException) {
        this.d = evaluateException;
        return evaluateException.getMessage();
    }

    protected String setLabel(String string) {
        this.a = string;
        return this.a;
    }

    public void clear() {
        this.d = null;
        this.a = UNKNOWN_VALUE_MESSAGE;
    }

    public void setAncestor(NodeDescriptor nodeDescriptor) {
        this.displayAs(nodeDescriptor);
    }

    @Nullable
    public static Map<ObjectReference, ValueMarkup> getMarkupMap(DebugProcess debugProcess) {
        try {
            if (debugProcess == null) {
                return null;
            }
        }
        catch (InconsistentDebugInfoException inconsistentDebugInfoException) {
            throw NodeDescriptorImpl.b(inconsistentDebugInfoException);
        }
        java.util.HashMap hashMap = (java.util.HashMap)debugProcess.getUserData(c);
        if (hashMap == null) {
            hashMap = new java.util.HashMap();
            debugProcess.putUserData(c, hashMap);
        }
        return hashMap;
    }

    private static InconsistentDebugInfoException b(InconsistentDebugInfoException inconsistentDebugInfoException) {
        return inconsistentDebugInfoException;
    }
}

