/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ArrayAction;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.memory.utils.ErrorsValueGroup;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.settings.ViewsGeneralSettings;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class ArrayRenderer
extends NodeRendererImpl {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.ui.tree.render.ArrayRenderer");
    @NonNls
    public static final String UNIQUE_ID = "ArrayRenderer";
    public int START_INDEX = 0;
    public int END_INDEX = Integer.MAX_VALUE;
    public int ENTRIES_LIMIT = 100;
    private boolean c = false;

    public ArrayRenderer() {
        this.myProperties.setEnabled(true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    @NonNls
    public String getName() {
        return "Array";
    }

    @Override
    public void setName(String string) {
        b.assertTrue(false);
    }

    @Override
    public ArrayRenderer clone() {
        return (ArrayRenderer)super.clone();
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        return ClassRenderer.calcLabel(valueDescriptor);
    }

    public void setForced(boolean bl2) {
        this.c = bl2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        int n2;
        int n3;
        boolean bl2;
        block33: {
            block34: {
                int n4;
                int n5;
                block31: {
                    ArrayReference arrayReference;
                    NodeDescriptorFactory nodeDescriptorFactory;
                    NodeManagerImpl nodeManagerImpl;
                    block30: {
                        DebuggerManagerThreadImpl.assertIsManagerThread();
                        nodeManagerImpl = (NodeManagerImpl)childrenBuilder.getNodeManager();
                        nodeDescriptorFactory = childrenBuilder.getDescriptorManager();
                        arrayReference = (ArrayReference)value;
                        n5 = arrayReference.length();
                        try {
                            try {
                                if (n5 <= 0) return;
                                if (this.c) break block30;
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                            }
                            childrenBuilder.initChildrenArrayRenderer(this, n5);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                        }
                    }
                    try {
                        if (this.ENTRIES_LIMIT <= 0) {
                            this.ENTRIES_LIMIT = 1;
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                    }
                    n4 = 0;
                    bl2 = false;
                    n3 = Math.min(n5 - 1, this.END_INDEX);
                    try {
                        try {
                            try {
                                if (n5 <= this.START_INDEX) break block31;
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                            }
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                    }
                    for (n2 = this.START_INDEX; n2 <= n3; ++n2) {
                        if (ViewsGeneralSettings.getInstance().HIDE_NULL_ARRAY_ELEMENTS && ArrayRenderer.a(arrayReference, n2)) {
                            bl2 = true;
                            continue;
                        }
                        DebuggerTreeNodeImpl debuggerTreeNodeImpl = nodeManagerImpl.createNode(nodeDescriptorFactory.getArrayItemDescriptor(childrenBuilder.getParentDescriptor(), arrayReference, n2), evaluationContext);
                        try {
                            childrenBuilder.addChildren(Collections.singletonList(debuggerTreeNodeImpl), false);
                            if (++n4 < this.ENTRIES_LIMIT) continue;
                            break;
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                        }
                    }
                }
                try {
                    try {
                        try {
                            childrenBuilder.addChildren(Collections.emptyList(), true);
                            if (n4 != 0) break block33;
                            if (this.START_INDEX != 0) break block34;
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                        }
                        if (n5 - 1 > this.END_INDEX) break block34;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                    }
                    childrenBuilder.setMessage(DebuggerBundle.message((String)"message.node.all.elements.null", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
                    return;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                }
            }
            childrenBuilder.setMessage(DebuggerBundle.message((String)"message.node.all.array.elements.null", (Object[])new Object[]{this.START_INDEX, this.END_INDEX}), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
            return;
        }
        try {
            if (bl2) {
                childrenBuilder.setMessage(DebuggerBundle.message((String)"message.node.elements.null.hidden", (Object[])new Object[0]), null, SimpleTextAttributes.REGULAR_ATTRIBUTES, null);
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
        }
        try {
            try {
                if (this.c) return;
                if (n2 >= n3) return;
            }
            catch (IncorrectOperationException incorrectOperationException) {
                throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
            }
            childrenBuilder.tooManyChildren(n3 - n2);
            return;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
        }
    }

    private static boolean a(ArrayReference arrayReference, int n2) {
        try {
            boolean bl2;
            try {
                bl2 = ArrayElementDescriptorImpl.getArrayElement(arrayReference, n2) == null;
            }
            catch (EvaluateException evaluateException) {
                throw ArrayRenderer.b((Exception)((Object)evaluateException));
            }
            return bl2;
        }
        catch (EvaluateException evaluateException) {
            return false;
        }
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) {
        b.assertTrue(debuggerTreeNode.getDescriptor() instanceof ArrayElementDescriptorImpl, (Object)debuggerTreeNode.getDescriptor().getClass().getName());
        ArrayElementDescriptorImpl arrayElementDescriptorImpl = (ArrayElementDescriptorImpl)debuggerTreeNode.getDescriptor();
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)debuggerTreeNode.getProject()).getElementFactory();
        try {
            LanguageLevel languageLevel = LanguageLevelProjectExtension.getInstance((Project)debuggerTreeNode.getProject()).getLanguageLevel();
            return psiElementFactory.createExpressionFromText("this[" + arrayElementDescriptorImpl.getIndex() + "]", (PsiElement)psiElementFactory.getArrayClass(languageLevel));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            b.error((Throwable)incorrectOperationException);
            return null;
        }
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!(value instanceof ArrayReference) || ((ArrayReference)value).length() <= 0) break block4;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw ArrayRenderer.b((Exception)((Object)incorrectOperationException));
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public boolean isApplicable(Type type) {
        return type instanceof ArrayType;
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    public static class Filtered
    extends ArrayRenderer {
        private final XExpression d;
        public static final XDebuggerTreeNodeHyperlink FILTER_HYPERLINK = new XDebuggerTreeNodeHyperlink(" clear"){

            public void onClick(MouseEvent mouseEvent) {
                TreeNode treeNode;
                XDebuggerTree xDebuggerTree = (XDebuggerTree)mouseEvent.getSource();
                TreePath treePath = xDebuggerTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null && (treeNode = ((TreeNode)treePath.getLastPathComponent()).getParent()) instanceof XValueNodeImpl) {
                    XValueNodeImpl xValueNodeImpl = (XValueNodeImpl)treeNode;
                    ArrayAction.setArrayRenderer(NodeRendererSettings.getInstance().getArrayRenderer(), xValueNodeImpl, DebuggerManagerEx.getInstanceEx(xDebuggerTree.getProject()).getContext());
                }
                mouseEvent.consume();
            }
        };

        public Filtered(XExpression xExpression) {
            this.d = xExpression;
        }

        public XExpression getExpression() {
            return this.d;
        }

        @Override
        public void buildChildren(Value value, ChildrenBuilder childrenBuilder, final EvaluationContext evaluationContext) {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            NodeManagerImpl nodeManagerImpl = (NodeManagerImpl)childrenBuilder.getNodeManager();
            NodeDescriptorFactory nodeDescriptorFactory = childrenBuilder.getDescriptorManager();
            try {
                childrenBuilder.setMessage(DebuggerBundle.message((String)"message.node.filtered", (Object[])new Object[0]) + " " + this.d.getExpression(), AllIcons.General.Filter, SimpleTextAttributes.REGULAR_ATTRIBUTES, FILTER_HYPERLINK);
                if (this.ENTRIES_LIMIT <= 0) {
                    this.ENTRIES_LIMIT = 1;
                }
            }
            catch (EvaluateException evaluateException) {
                throw Filtered.a(evaluateException);
            }
            final ArrayReference arrayReference = (ArrayReference)value;
            int n2 = arrayReference.length();
            if (n2 > 0) {
                childrenBuilder.initChildrenArrayRenderer(this, n2);
                CachedEvaluator cachedEvaluator = new CachedEvaluator(){

                    @Override
                    protected String getClassName() {
                        return ((ArrayType)arrayReference.type()).componentTypeName();
                    }

                    @Override
                    protected PsiElement overrideContext(PsiElement psiElement) {
                        return ContextUtil.getContextElement((StackFrameContext)evaluationContext);
                    }
                };
                cachedEvaluator.setReferenceExpression(TextWithImportsImpl.fromXExpression(this.d));
                int n3 = 0;
                if (n2 - 1 >= this.START_INDEX) {
                    ErrorsValueGroup errorsValueGroup = null;
                    for (int i2 = this.START_INDEX; i2 < n2; ++i2) {
                        try {
                            if (!DebuggerUtilsEx.evaluateBoolean(cachedEvaluator.getEvaluator(evaluationContext.getProject()), (EvaluationContextImpl)evaluationContext.createEvaluationContext(arrayReference.getValue(i2)))) continue;
                            DebuggerTreeNodeImpl debuggerTreeNodeImpl = nodeManagerImpl.createNode(nodeDescriptorFactory.getArrayItemDescriptor(childrenBuilder.getParentDescriptor(), arrayReference, i2), evaluationContext);
                            childrenBuilder.addChildren(Collections.singletonList(debuggerTreeNodeImpl), false);
                            ++n3;
                            continue;
                        }
                        catch (EvaluateException evaluateException) {
                            if (errorsValueGroup == null) {
                                errorsValueGroup = new ErrorsValueGroup();
                                childrenBuilder.addChildren(XValueChildrenList.bottomGroup((XValueGroup)errorsValueGroup), false);
                            }
                            JavaValue javaValue = JavaValue.create(null, (ValueDescriptorImpl)((Object)nodeDescriptorFactory.getArrayItemDescriptor(childrenBuilder.getParentDescriptor(), arrayReference, i2)), (EvaluationContextImpl)evaluationContext, nodeManagerImpl, false);
                            errorsValueGroup.addErrorValue(evaluateException.getMessage(), javaValue);
                        }
                    }
                }
                childrenBuilder.addChildren(Collections.emptyList(), true);
            }
        }

        private static EvaluateException a(EvaluateException evaluateException) {
            return evaluateException;
        }
    }
}

