/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class CompoundNodeRenderer
extends NodeRendererImpl {
    @NonNls
    public static final String UNIQUE_ID = "CompoundNodeRenderer";
    private ValueLabelRenderer b;
    private ChildrenRenderer c;
    protected final NodeRendererSettings myRendererSettings;

    public CompoundNodeRenderer(NodeRendererSettings nodeRendererSettings, String string, ValueLabelRenderer valueLabelRenderer, ChildrenRenderer childrenRenderer) {
        super(string);
        this.myRendererSettings = nodeRendererSettings;
        this.b = valueLabelRenderer;
        this.c = childrenRenderer;
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public CompoundNodeRenderer clone() {
        ChildrenRenderer childrenRenderer;
        ValueLabelRenderer valueLabelRenderer;
        CompoundNodeRenderer compoundNodeRenderer = (CompoundNodeRenderer)super.clone();
        try {
            CompoundNodeRenderer compoundNodeRenderer2 = compoundNodeRenderer;
            valueLabelRenderer = this.b != null ? (ValueLabelRenderer)this.b.clone() : null;
        }
        catch (InvalidDataException invalidDataException) {
            throw CompoundNodeRenderer.b(invalidDataException);
        }
        try {
            compoundNodeRenderer2.b = valueLabelRenderer;
            CompoundNodeRenderer compoundNodeRenderer3 = compoundNodeRenderer;
            childrenRenderer = this.c != null ? (ChildrenRenderer)this.c.clone() : null;
        }
        catch (InvalidDataException invalidDataException) {
            throw CompoundNodeRenderer.b(invalidDataException);
        }
        compoundNodeRenderer3.c = childrenRenderer;
        return compoundNodeRenderer;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        this.getChildrenRenderer().buildChildren(value, childrenBuilder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
        return this.getChildrenRenderer().getChildValueExpression(debuggerTreeNode, debuggerContext);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        return this.getChildrenRenderer().isExpandable(value, evaluationContext, nodeDescriptor);
    }

    @Override
    public boolean isApplicable(Type type) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (!this.getLabelRenderer().isApplicable(type) || !this.getChildrenRenderer().isApplicable(type)) break block4;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw CompoundNodeRenderer.b(invalidDataException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (InvalidDataException invalidDataException) {
                    throw CompoundNodeRenderer.b(invalidDataException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        return this.getLabelRenderer().calcLabel(valueDescriptor, evaluationContext, descriptorLabelListener);
    }

    public ValueLabelRenderer getLabelRenderer() {
        return this.b;
    }

    public ChildrenRenderer getChildrenRenderer() {
        return this.c;
    }

    public void setLabelRenderer(ValueLabelRenderer valueLabelRenderer) {
        this.b = valueLabelRenderer;
    }

    public void setChildrenRenderer(ChildrenRenderer childrenRenderer) {
        this.c = childrenRenderer;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        List list = element.getChildren("Renderer");
        if (list != null) {
            for (Element element2 : list) {
                String string = element2.getAttributeValue("role");
                try {
                    if (string == null) {
                        continue;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw CompoundNodeRenderer.b(invalidDataException);
                }
                try {
                    if ("label".equals(string)) {
                        this.b = (ValueLabelRenderer)this.myRendererSettings.readRenderer(element2);
                        continue;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw CompoundNodeRenderer.b(invalidDataException);
                }
                try {
                    if (!"children".equals(string)) continue;
                    this.c = (ChildrenRenderer)this.myRendererSettings.readRenderer(element2);
                }
                catch (InvalidDataException invalidDataException) {
                    throw CompoundNodeRenderer.b(invalidDataException);
                }
            }
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        Element element2;
        super.writeExternal(element);
        if (this.b != null) {
            element2 = this.myRendererSettings.writeRenderer(this.b);
            element2.setAttribute("role", "label");
            element.addContent(element2);
        }
        if (this.c != null) {
            element2 = this.myRendererSettings.writeRenderer(this.c);
            element2.setAttribute("role", "children");
            element.addContent(element2);
        }
    }

    private static InvalidDataException b(InvalidDataException invalidDataException) {
        return invalidDataException;
    }
}

