/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeManager;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.TypeRenderer;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class ExpressionChildrenRenderer
extends TypeRenderer
implements ChildrenRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ExpressionChildrenRenderer";
    private static final Key<Value> f = new Key("EXPRESSION_VALUE");
    private static final Key<NodeRenderer> b = new Key("LAST_CHILDREN_RENDERER");
    private CachedEvaluator c = this.createCachedEvaluator();
    private CachedEvaluator e = this.createCachedEvaluator();
    private NodeRenderer d;

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public ExpressionChildrenRenderer clone() {
        ExpressionChildrenRenderer expressionChildrenRenderer = (ExpressionChildrenRenderer)super.clone();
        expressionChildrenRenderer.c = this.createCachedEvaluator();
        expressionChildrenRenderer.setChildrenExpandable(this.getChildrenExpandable());
        expressionChildrenRenderer.e = this.createCachedEvaluator();
        expressionChildrenRenderer.setChildrenExpression(this.getChildrenExpression());
        return expressionChildrenRenderer;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        NodeManager nodeManager = childrenBuilder.getNodeManager();
        try {
            ValueDescriptor valueDescriptor = childrenBuilder.getParentDescriptor();
            Value value2 = this.a(evaluationContext.createEvaluationContext(value), valueDescriptor);
            NodeRenderer nodeRenderer = ExpressionChildrenRenderer.a(value2, valueDescriptor);
            nodeRenderer.buildChildren(value2, childrenBuilder, evaluationContext);
        }
        catch (EvaluateException evaluateException) {
            ArrayList<DebuggerTreeNode> arrayList = new ArrayList<DebuggerTreeNode>();
            arrayList.add(nodeManager.createMessageNode(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + evaluateException.getMessage()));
            childrenBuilder.setChildren(arrayList);
        }
    }

    @Nullable
    public static NodeRenderer getLastChildrenRenderer(ValueDescriptor valueDescriptor) {
        return (NodeRenderer)valueDescriptor.getUserData(b);
    }

    public static void setPreferableChildrenRenderer(ValueDescriptor valueDescriptor, NodeRenderer nodeRenderer) {
        valueDescriptor.putUserData(b, nodeRenderer);
    }

    public static Value getLastChildrenValue(NodeDescriptor nodeDescriptor) {
        return (Value)nodeDescriptor.getUserData(f);
    }

    private Value a(EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) throws EvaluateException {
        ExpressionEvaluator expressionEvaluator = this.e.getEvaluator(evaluationContext.getProject());
        Value value = expressionEvaluator.evaluate(evaluationContext);
        DebuggerUtilsEx.keep(value, evaluationContext);
        nodeDescriptor.putUserData(f, (Object)value);
        return value;
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
        TextWithImports textWithImports = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPRESSION");
        try {
            if (textWithImports != null) {
                this.setChildrenExpression(textWithImports);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ExpressionChildrenRenderer.b((Exception)((Object)invalidDataException));
        }
        TextWithImports textWithImports2 = DebuggerUtils.getInstance().readTextWithImports(element, "CHILDREN_EXPANDABLE");
        try {
            if (textWithImports2 != null) {
                this.c.setReferenceExpression(textWithImports2);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ExpressionChildrenRenderer.b((Exception)((Object)invalidDataException));
        }
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPANDABLE", this.getChildrenExpandable());
        DebuggerUtils.getInstance().writeTextWithImports(element, "CHILDREN_EXPRESSION", this.getChildrenExpression());
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
        Value value = ExpressionChildrenRenderer.getLastChildrenValue(debuggerTreeNode.getParent().getDescriptor());
        try {
            if (value == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]));
            }
        }
        catch (EvaluateException evaluateException) {
            throw ExpressionChildrenRenderer.b((Exception)((Object)evaluateException));
        }
        NodeRenderer nodeRenderer = ExpressionChildrenRenderer.a(value, (ValueDescriptor)debuggerTreeNode.getParent().getDescriptor());
        PsiExpression psiExpression = this.e.getPsiExpression(debuggerTreeNode.getProject());
        try {
            if (psiExpression == null) {
                return null;
            }
        }
        catch (EvaluateException evaluateException) {
            throw ExpressionChildrenRenderer.b((Exception)((Object)evaluateException));
        }
        return DebuggerTreeNodeExpression.substituteThis(nodeRenderer.getChildValueExpression(debuggerTreeNode, debuggerContext), (PsiExpression)psiExpression.copy(), value);
    }

    private static NodeRenderer a(Value value, ValueDescriptor valueDescriptor) {
        NodeRenderer nodeRenderer;
        block9: {
            Type type;
            block11: {
                block10: {
                    nodeRenderer = ExpressionChildrenRenderer.getLastChildrenRenderer(valueDescriptor);
                    try {
                        try {
                            block8: {
                                try {
                                    try {
                                        if (nodeRenderer == null || value == null) break block8;
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        throw ExpressionChildrenRenderer.b((Exception)((Object)invalidDataException));
                                    }
                                    if (nodeRenderer.isApplicable(value.type())) break block9;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw ExpressionChildrenRenderer.b((Exception)((Object)invalidDataException));
                                }
                            }
                            if (value == null) break block10;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ExpressionChildrenRenderer.b((Exception)((Object)invalidDataException));
                        }
                        type = value.type();
                        break block11;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ExpressionChildrenRenderer.b((Exception)((Object)invalidDataException));
                    }
                }
                type = null;
            }
            nodeRenderer = DebugProcessImpl.getDefaultRenderer(type);
            ExpressionChildrenRenderer.setPreferableChildrenRenderer(valueDescriptor, nodeRenderer);
        }
        return nodeRenderer;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        Value value2;
        EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
        if (!StringUtil.isEmpty((String)this.c.getReferenceExpression().getText())) {
            try {
                value2 = this.c.getEvaluator(evaluationContext2.getProject()).evaluate(evaluationContext2);
                if (value2 instanceof BooleanValue) {
                    return ((BooleanValue)value2).booleanValue();
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        try {
            value2 = this.a(evaluationContext2, nodeDescriptor);
            NodeRenderer nodeRenderer = DebugProcessImpl.getDefaultRenderer(value.type());
            return nodeRenderer.isExpandable(value2, evaluationContext2, nodeDescriptor);
        }
        catch (EvaluateException evaluateException) {
            return true;
        }
    }

    public TextWithImports getChildrenExpression() {
        return this.e.getReferenceExpression();
    }

    public void setChildrenExpression(TextWithImports textWithImports) {
        this.e.setReferenceExpression(textWithImports);
    }

    public TextWithImports getChildrenExpandable() {
        return this.c.getReferenceExpression();
    }

    public void setChildrenExpandable(TextWithImports textWithImports) {
        this.c.setReferenceExpression(textWithImports);
    }

    @Override
    public void setClassName(String string) {
        super.setClassName(string);
        this.e.clear();
        this.c.clear();
    }

    public NodeRenderer getPredictedRenderer() {
        return this.d;
    }

    public void setPredictedRenderer(NodeRenderer nodeRenderer) {
        this.d = nodeRenderer;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

