/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.debugger.ui.tree.render.OnDemandRenderer;
import com.intellij.debugger.ui.tree.render.ToStringCommand;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.sun.jdi.ClassType;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ToStringRenderer
extends NodeRendererImpl
implements OnDemandRenderer {
    @NonNls
    public static final String UNIQUE_ID = "ToStringRenderer";
    private boolean b = false;
    private boolean d;
    private ClassFilter[] c = ClassFilter.EMPTY_ARRAY;

    public ToStringRenderer() {
        super("unnamed", true);
    }

    @Override
    public String getUniqueId() {
        return UNIQUE_ID;
    }

    @Override
    public String getName() {
        return "toString";
    }

    @Override
    public void setName(String string) {
    }

    @Override
    public ToStringRenderer clone() {
        ClassFilter[] classFilterArray;
        ToStringRenderer toStringRenderer = (ToStringRenderer)super.clone();
        try {
            classFilterArray = this.c.length > 0 ? new ClassFilter[this.c.length] : ClassFilter.EMPTY_ARRAY;
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        ClassFilter[] classFilterArray2 = classFilterArray;
        try {
            for (int i2 = 0; i2 < classFilterArray2.length; ++i2) {
                classFilterArray2[i2] = this.c[i2].clone();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        toStringRenderer.c = classFilterArray2;
        return toStringRenderer;
    }

    @Override
    public String calcLabel(final ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, final DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
        try {
            if (!this.isShowValue(valueDescriptor, evaluationContext)) {
                return "";
            }
        }
        catch (EvaluateException evaluateException) {
            throw ToStringRenderer.b((Exception)((Object)evaluateException));
        }
        final Value value = valueDescriptor.getValue();
        BatchEvaluator.getBatchEvaluator(evaluationContext.getDebugProcess()).invoke(new ToStringCommand(evaluationContext, value){

            @Override
            public void evaluationResult(String string) {
                valueDescriptor.setValueLabel(StringUtil.notNullize((String)string));
                descriptorLabelListener.labelChanged();
            }

            @Override
            public void evaluationError(String string) {
                String string2 = value != null ? string + " " + DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.tostring", (Object[])new Object[]{value.type().name()}) : string;
                valueDescriptor.setValueLabelFailed(new EvaluateException(string2, null));
                descriptorLabelListener.labelChanged();
            }
        });
        return XDebuggerUIConstants.COLLECTING_DATA_MESSAGE;
    }

    @Override
    @NotNull
    public String getLinkText() {
        String string;
        try {
            string = DebuggerBundle.message((String)"message.node.toString", (Object[])new Object[0]);
            if (string == null) {
                ToStringRenderer.b(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        return string;
    }

    public boolean isUseClassFilters() {
        return this.b;
    }

    public void setUseClassFilters(boolean bl2) {
        this.b = bl2;
    }

    @Override
    public boolean isOnDemand(EvaluationContext evaluationContext, ValueDescriptor valueDescriptor) {
        block7: {
            try {
                block6: {
                    try {
                        try {
                            if (this.d) break block6;
                            if (!this.b) break block7;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ToStringRenderer.b(illegalStateException);
                        }
                        if (this.a(valueDescriptor.getType())) break block7;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ToStringRenderer.b(illegalStateException);
                    }
                }
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                throw ToStringRenderer.b(illegalStateException);
            }
        }
        return OnDemandRenderer.super.isOnDemand(evaluationContext, valueDescriptor);
    }

    @Override
    public boolean isApplicable(Type type) {
        try {
            if (!(type instanceof ReferenceType)) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        try {
            if ("java.lang.String".equals(type.name())) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        return ToStringRenderer.b(type);
    }

    private static boolean b(Type type) {
        if (type instanceof ClassType) {
            boolean bl2;
            block6: {
                block5: {
                    Method method = ((ClassType)type).concreteMethodByName("toString", "()Ljava/lang/String;");
                    try {
                        try {
                            if (method == null || "java.lang.Object".equals(method.declaringType().name())) break block5;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ToStringRenderer.b(illegalStateException);
                        }
                        bl2 = true;
                        break block6;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ToStringRenderer.b(illegalStateException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder childrenBuilder, EvaluationContext evaluationContext) {
        DebugProcessImpl.getDefaultRenderer(value).buildChildren(value, childrenBuilder, evaluationContext);
    }

    @Override
    public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
        return DebugProcessImpl.getDefaultRenderer(((ValueDescriptor)debuggerTreeNode.getParent().getDescriptor()).getType()).getChildValueExpression(debuggerTreeNode, debuggerContext);
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor nodeDescriptor) {
        return DebugProcessImpl.getDefaultRenderer(value).isExpandable(value, evaluationContext, nodeDescriptor);
    }

    @Override
    public void readExternal(Element element) {
        super.readExternal(element);
        this.d = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"ON_DEMAND"));
        this.b = Boolean.parseBoolean(JDOMExternalizerUtil.readField((Element)element, (String)"USE_CLASS_FILTERS"));
        this.c = DebuggerUtilsEx.readFilters(element.getChildren("filter"));
    }

    @Override
    public void writeExternal(Element element) {
        try {
            super.writeExternal(element);
            if (this.d) {
                JDOMExternalizerUtil.writeField((Element)element, (String)"ON_DEMAND", (String)"true");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        try {
            if (this.b) {
                JDOMExternalizerUtil.writeField((Element)element, (String)"USE_CLASS_FILTERS", (String)"true");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        DebuggerUtilsEx.writeFilters(element, "filter", this.c);
    }

    public ClassFilter[] getClassFilters() {
        return this.c;
    }

    public void setClassFilters(ClassFilter[] classFilterArray) {
        ClassFilter[] classFilterArray2;
        try {
            ToStringRenderer toStringRenderer = this;
            classFilterArray2 = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
        }
        catch (IllegalStateException illegalStateException) {
            throw ToStringRenderer.b(illegalStateException);
        }
        toStringRenderer.c = classFilterArray2;
    }

    private boolean a(Type type) {
        if (type instanceof ReferenceType) {
            for (ClassFilter classFilter : this.c) {
                try {
                    try {
                        if (!classFilter.isEnabled() || !DebuggerUtils.instanceOf((Type)type, (String)classFilter.getPattern())) continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ToStringRenderer.b(illegalStateException);
                    }
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ToStringRenderer.b(illegalStateException);
                }
            }
        }
        return DebuggerUtilsEx.isFiltered(type.name(), this.c);
    }

    public boolean isOnDemand() {
        return this.d;
    }

    public void setOnDemand(boolean bl2) {
        this.d = bl2;
    }

    @Override
    public boolean hasOverhead() {
        return true;
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/tree/render/ToStringRenderer", "getLinkText"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

