/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer;

import com.intellij.designer.DesignerToolWindowContent;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.ComponentTreeBuilder;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.propertyTable.PropertyTablePanel;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;

public final class DesignerToolWindow
implements DesignerToolWindowContent {
    private final Splitter a;
    private ComponentTree d = new ComponentTree();
    private ComponentTreeBuilder c;
    private PropertyTablePanel b;

    public DesignerToolWindow(Project project2, boolean bl2) {
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Object)this.d));
        jScrollPane.setBorder(IdeBorderFactory.createBorder((int)8));
        jScrollPane.setPreferredSize(new Dimension(250, -1));
        this.d.initQuickFixManager(jScrollPane.getViewport());
        this.b = new PropertyTablePanel(project2);
        this.a = new Splitter(true, 0.42f){

            public void doLayout() {
                super.doLayout();
                JComponent jComponent = this.getFirstComponent();
                JComponent jComponent2 = this.getSecondComponent();
                if (jComponent == null || jComponent2 == null) {
                    return;
                }
                int n2 = jComponent.getHeight();
                int n3 = this.getDivider().getHeight();
                int n4 = this.getSize().height;
                if (n2 + n3 + jComponent2.getHeight() != n4) {
                    Rectangle rectangle = jComponent2.getBounds();
                    rectangle.height = n4 - n2 - n3;
                    jComponent2.setBounds(rectangle);
                }
            }
        };
        this.a.setDividerWidth(3);
        this.a.setShowDividerControls(false);
        this.a.setShowDividerIcon(false);
        this.a.setFirstComponent((JComponent)jScrollPane);
        this.a.setSecondComponent((JComponent)this.b);
        if (bl2) {
            this.a.addComponentListener((ComponentListener)new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    boolean bl2;
                    Dimension dimension = DesignerToolWindow.this.a.getSize();
                    boolean bl3 = bl2 = dimension.width < dimension.height;
                    if (DesignerToolWindow.this.a.getOrientation() != bl2) {
                        DesignerToolWindow.this.a.setOrientation(bl2);
                    }
                }
            });
        }
    }

    void update(DesignerEditorPanel designerEditorPanel) {
        this.a();
        this.d.newModel();
        if (designerEditorPanel == null) {
            this.d.setDesignerPanel(null);
            this.b.setArea(null, null);
        } else {
            this.d.setDesignerPanel(designerEditorPanel);
            this.c = new ComponentTreeBuilder(this.d, designerEditorPanel);
            this.b.setArea(designerEditorPanel, this.c.getTreeArea());
        }
    }

    public void dispose() {
        this.a();
        this.a.dispose();
        this.d = null;
        this.b = null;
    }

    private void a() {
        if (this.c != null) {
            Disposer.dispose((Disposable)this.c);
            this.c = null;
        }
    }

    Splitter getToolWindowPanel() {
        return this.a;
    }

    AnAction[] createActions() {
        AnAction anAction = new AnAction("Expand All", null, AllIcons.Actions.Expandall){

            public void actionPerformed(AnActionEvent anActionEvent) {
                if (DesignerToolWindow.this.c != null) {
                    TreeUtil.expandAll((JTree)((Object)DesignerToolWindow.this.d));
                }
            }
        };
        AnAction anAction2 = new AnAction("Collapse All", null, AllIcons.Actions.Collapseall){

            public void actionPerformed(AnActionEvent anActionEvent) {
                if (DesignerToolWindow.this.c != null) {
                    TreeUtil.collapseAll((JTree)((Object)DesignerToolWindow.this.d), (int)1);
                }
            }
        };
        return new AnAction[]{anAction, anAction2};
    }

    public ComponentTree getComponentTree() {
        return this.d;
    }

    public RadPropertyTable getPropertyTable() {
        return this.b.getPropertyTable();
    }

    @Override
    public void expandFromState() {
        if (this.c != null) {
            this.c.expandFromState();
        }
    }

    @Override
    public void refresh(boolean bl2) {
        if (this.c != null) {
            if (bl2) {
                this.c.selectFromSurface();
            } else {
                this.c.queueUpdate();
            }
        }
    }

    @Override
    public void updateInspections() {
        if (this.d != null) {
            this.d.updateInspections();
        }
        if (this.b != null) {
            this.b.getPropertyTable().updateInspections();
        }
    }
}

