/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.DesignerToolWindowManager;
import com.intellij.designer.actions.CommonEditActionsProvider;
import com.intellij.designer.actions.DeselectAllAction;
import com.intellij.designer.actions.MorphingAction;
import com.intellij.designer.actions.SelectAllAction;
import com.intellij.designer.actions.SelectSameTypeAction;
import com.intellij.designer.actions.SelectSiblingsAction;
import com.intellij.designer.actions.StartInplaceEditing;
import com.intellij.designer.actions.WrapInAction;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.RadPropertyTable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class DesignerActionPanel
implements DataProvider {
    public static final String TOOLBAR = "DesignerToolbar";
    private final DefaultActionGroup f;
    private final DefaultActionGroup b = new DefaultActionGroup();
    private final DefaultActionGroup d = new DefaultActionGroup();
    private final DefaultActionGroup g = new DefaultActionGroup();
    private final DefaultActionGroup e = new DefaultActionGroup();
    protected final JComponent myToolbar;
    protected final DesignerEditorPanel myDesigner;
    private final CommonEditActionsProvider a;
    private final JComponent c;

    public DesignerActionPanel(DesignerEditorPanel designerEditorPanel, JComponent jComponent) {
        this.myDesigner = designerEditorPanel;
        this.a = new CommonEditActionsProvider(designerEditorPanel);
        this.c = jComponent;
        DesignerActionPanel.createInplaceEditingAction(this.c).setDesignerPanel(designerEditorPanel);
        this.f = this.createActionGroup();
        this.myToolbar = this.createToolbar();
        ActionManager actionManager = ActionManager.getInstance();
        this.g.add(actionManager.getAction("$Cut"));
        this.g.add(actionManager.getAction("$Copy"));
        this.g.add(actionManager.getAction("$Paste"));
        this.g.addSeparator();
        this.g.add(actionManager.getAction("$Delete"));
        this.g.addSeparator();
        this.g.add((AnAction)this.a(designerEditorPanel));
        this.g.addSeparator();
        this.g.add((AnAction)this.e);
        designerEditorPanel.getSurfaceArea().addSelectionListener(new ComponentSelectionListener(){

            @Override
            public void selectionChanged(EditableArea editableArea) {
                DesignerActionPanel.this.a(editableArea.getSelection());
            }
        });
    }

    protected DefaultActionGroup createActionGroup() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)this.b);
        defaultActionGroup.add((AnAction)this.d);
        return defaultActionGroup;
    }

    protected JComponent createToolbar() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar actionToolbar = actionManager.createActionToolbar(TOOLBAR, (ActionGroup)this.f, true);
        actionToolbar.setLayoutPolicy(1);
        JComponent jComponent = actionToolbar.getComponent();
        jComponent.setBorder(IdeBorderFactory.createBorder((int)8));
        jComponent.setVisible(false);
        return jComponent;
    }

    @NotNull
    private ActionGroup a(DesignerEditorPanel designerEditorPanel) {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup("_Select", true);
        AnAction anAction = new AnAction("Select Parent", "Select Parent", null){

            public void actionPerformed(AnActionEvent anActionEvent) {
                DesignerActionPanel.this.myDesigner.getToolProvider().processKeyEvent(new KeyEvent(DesignerActionPanel.this.myDesigner.getSurfaceArea().getNativeComponent(), 401, 0L, 0, 27, '\u001b'), DesignerActionPanel.this.myDesigner.getSurfaceArea());
            }
        };
        anAction.registerCustomShortcutSet(27, 0, null);
        EditableArea editableArea = designerEditorPanel.getSurfaceArea();
        SelectSiblingsAction selectSiblingsAction = new SelectSiblingsAction(editableArea);
        SelectSameTypeAction selectSameTypeAction = new SelectSameTypeAction(editableArea);
        DeselectAllAction deselectAllAction = new DeselectAllAction(editableArea);
        AnAction anAction2 = this.createSelectAllAction(editableArea);
        try {
            this.registerAction(anAction2, "$SelectAll");
            defaultActionGroup2.add(anAction);
            defaultActionGroup2.add((AnAction)selectSiblingsAction);
            defaultActionGroup2.add((AnAction)selectSameTypeAction);
            defaultActionGroup2.addSeparator();
            defaultActionGroup2.add(anAction2);
            defaultActionGroup2.add((AnAction)deselectAllAction);
            defaultActionGroup = defaultActionGroup2;
            if (defaultActionGroup == null) {
                DesignerActionPanel.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DesignerActionPanel.b(illegalStateException);
        }
        return defaultActionGroup;
    }

    public AnAction createSelectAllAction(EditableArea editableArea) {
        return new SelectAllAction(editableArea);
    }

    public static StartInplaceEditing createInplaceEditingAction(JComponent jComponent) {
        StartInplaceEditing startInplaceEditing = new StartInplaceEditing();
        startInplaceEditing.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), jComponent);
        return startInplaceEditing;
    }

    public void registerAction(AnAction anAction, @NonNls String string) {
        anAction.registerCustomShortcutSet(ActionManager.getInstance().getAction(string).getShortcutSet(), this.c);
    }

    public JComponent getToolbarComponent() {
        return this.myToolbar;
    }

    public DefaultActionGroup getActionGroup() {
        return this.b;
    }

    public DefaultActionGroup getPopupGroup() {
        return this.g;
    }

    protected DefaultActionGroup getDynamicActionGroup() {
        return this.d;
    }

    protected JComponent getShortcuts() {
        return this.c;
    }

    public void update() {
        block4: {
            boolean bl2 = this.myToolbar.isVisible();
            boolean bl3 = DesignerActionPanel.a(this.f);
            try {
                try {
                    this.myToolbar.setVisible(bl3);
                    if (!bl2 || !bl3) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DesignerActionPanel.b(illegalStateException);
                }
                ((JComponent)this.myToolbar.getParent()).revalidate();
            }
            catch (IllegalStateException illegalStateException) {
                throw DesignerActionPanel.b(illegalStateException);
            }
        }
    }

    private static boolean a(DefaultActionGroup defaultActionGroup) {
        try {
            if (defaultActionGroup.getChildrenCount() == 0) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DesignerActionPanel.b(illegalStateException);
        }
        for (AnAction anAction : defaultActionGroup.getChildren(null)) {
            block8: {
                try {
                    try {
                        if (!(anAction instanceof DefaultActionGroup)) break block8;
                        if (!DesignerActionPanel.a((DefaultActionGroup)anAction)) continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw DesignerActionPanel.b(illegalStateException);
                    }
                    return true;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DesignerActionPanel.b(illegalStateException);
                }
            }
            return true;
        }
        return false;
    }

    private void a(List<RadComponent> list) {
        block6: {
            boolean bl2 = DesignerActionPanel.a(this.d);
            if (this.d.getChildrenCount() > 0) {
                for (AnAction anAction : this.d.getChildActionsOrStubs()) {
                    anAction.unregisterCustomShortcutSet(this.c);
                }
                this.d.removeAll();
            }
            try {
                try {
                    this.addSelectionActions(list, this.d);
                    if (!bl2 && !DesignerActionPanel.a(this.d)) break block6;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DesignerActionPanel.b(illegalStateException);
                }
                this.update();
            }
            catch (IllegalStateException illegalStateException) {
                throw DesignerActionPanel.b(illegalStateException);
            }
        }
    }

    protected void addSelectionActions(List<RadComponent> list, DefaultActionGroup defaultActionGroup) {
        for (RadComponent radComponent : RadComponent.getParents(list)) {
            radComponent.getLayout().addSelectionActions(this.myDesigner, defaultActionGroup, this.c, list);
        }
        for (RadComponent radComponent : list) {
            radComponent.addSelectionActions(this.myDesigner, defaultActionGroup, this.c, list);
        }
    }

    public ActionGroup getPopupActions(EditableArea editableArea) {
        try {
            if (this.e.getChildrenCount() > 0) {
                this.e.removeAll();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DesignerActionPanel.b(illegalStateException);
        }
        WrapInAction.fill(this.myDesigner, this.e, editableArea);
        MorphingAction.fill(this.myDesigner, this.e, editableArea);
        return this.g;
    }

    public Object getData(@NonNls String string) {
        block10: {
            block9: {
                try {
                    try {
                        try {
                            if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(string) || PlatformDataKeys.CUT_PROVIDER.is(string)) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw DesignerActionPanel.b(illegalStateException);
                        }
                        if (PlatformDataKeys.COPY_PROVIDER.is(string)) break block9;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw DesignerActionPanel.b(illegalStateException);
                    }
                    if (!PlatformDataKeys.PASTE_PROVIDER.is(string)) break block10;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DesignerActionPanel.b(illegalStateException);
                }
            }
            RadPropertyTable radPropertyTable = DesignerToolWindowManager.getInstance(this.myDesigner).getPropertyTable();
            Component component = IdeFocusManager.getInstance((Project)this.myDesigner.getProject()).getFocusOwner();
            try {
                if (!UIUtil.isAncestor((Component)((Object)radPropertyTable), (Component)component)) {
                    return this.a;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw DesignerActionPanel.b(illegalStateException);
            }
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/actions/DesignerActionPanel", "createSelectActionGroup"));
    }

    private static IllegalStateException b(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

