/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.ArrayList;
import java.util.List;

public class MorphingAction
extends AnAction {
    private final DesignerEditorPanel b;
    private final EditableArea d;
    private final List<RadComponent> c;
    private final MetaModel a;

    public MorphingAction(DesignerEditorPanel designerEditorPanel, EditableArea editableArea, List<RadComponent> list, MetaModel metaModel) {
        super(metaModel.getTag(), null, metaModel.getIcon());
        this.b = designerEditorPanel;
        this.d = editableArea;
        this.c = list;
        this.a = metaModel;
    }

    public void update(AnActionEvent anActionEvent) {
        PaletteItem paletteItem = this.a.getPaletteItem();
        anActionEvent.getPresentation().setEnabled(paletteItem == null || paletteItem.isEnabled());
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        this.b.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
            ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>();
            for (RadComponent radComponent : this.c) {
                RadComponent radComponent2 = radComponent.morphingTo(this.a);
                try {
                    if (radComponent2 == null) continue;
                    arrayList.add(radComponent2);
                }
                catch (Exception exception) {
                    throw MorphingAction.b(exception);
                }
            }
            this.d.setSelection(arrayList);
        }), "Run Morphing action", true);
    }

    public static void fill(DesignerEditorPanel designerEditorPanel, DefaultActionGroup defaultActionGroup, EditableArea editableArea) {
        RadComponent radComponent2;
        List<RadComponent> list = editableArea.getSelection();
        if (list.isEmpty()) {
            return;
        }
        MetaModel metaModel = null;
        for (RadComponent radComponent2 : list) {
            if (metaModel == null) {
                metaModel = radComponent2.getMetaModel();
                continue;
            }
            if (metaModel == radComponent2.getMetaModel()) continue;
            return;
        }
        if (metaModel == null) {
            return;
        }
        List<MetaModel> list2 = metaModel.getMorphingModels();
        if (list2.isEmpty()) {
            return;
        }
        radComponent2 = new DefaultActionGroup("Morphing", true);
        for (MetaModel metaModel2 : list2) {
            radComponent2.add(new MorphingAction(designerEditorPanel, editableArea, list, metaModel2));
        }
        defaultActionGroup.add((AnAction)radComponent2);
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

