/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.actions;

import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.model.MetaModel;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.model.WrapInProvider;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.ThrowableRunnable;
import java.util.List;
import java.util.Set;

public class WrapInAction
extends AnAction {
    private final DesignerEditorPanel e;
    private final EditableArea b;
    private final WrapInProvider a;
    private final RadComponent c;
    private final List<RadComponent> d;
    private final MetaModel f;

    public WrapInAction(DesignerEditorPanel designerEditorPanel, EditableArea editableArea, WrapInProvider wrapInProvider, RadComponent radComponent, List<RadComponent> list, MetaModel metaModel) {
        super(metaModel.getTag(), null, metaModel.getIcon());
        this.e = designerEditorPanel;
        this.b = editableArea;
        this.a = wrapInProvider;
        this.c = radComponent;
        this.d = list;
        this.f = metaModel;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        this.e.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> this.b.select(this.a.wrapIn(this.c, this.d, this.f))), "Run Wrap In action", true);
    }

    public static void fill(DesignerEditorPanel designerEditorPanel, DefaultActionGroup defaultActionGroup, EditableArea editableArea) {
        Object object;
        List<RadComponent> list = editableArea.getSelection();
        if (list.isEmpty()) {
            return;
        }
        Set<RadComponent> set = RadComponent.getParents(list);
        if (set.size() != 1) {
            return;
        }
        RadComponent radComponent = set.iterator().next();
        if (list.size() > 1 && (object = radComponent.getLayout()) != null && !((RadLayout)object).isWrapIn(list)) {
            return;
        }
        object = designerEditorPanel.getWrapInProvider();
        if (object == null) {
            return;
        }
        List<MetaModel> list2 = ((WrapInProvider)object).getModels();
        if (list2.isEmpty()) {
            return;
        }
        DefaultActionGroup defaultActionGroup2 = new DefaultActionGroup("Wrap In", true);
        for (MetaModel metaModel : list2) {
            defaultActionGroup2.add((AnAction)new WrapInAction(designerEditorPanel, editableArea, (WrapInProvider)object, radComponent, list, metaModel));
        }
    }
}

