/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.componentTree;

import com.intellij.designer.clipboard.SimpleTransferable;
import com.intellij.designer.componentTree.ComponentTree;
import com.intellij.designer.componentTree.TreeTransfer;
import com.intellij.designer.designSurface.ComponentTargetFilter;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.CreationTool;
import com.intellij.designer.designSurface.tools.ToolProvider;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.model.RadLayout;
import com.intellij.designer.palette.PaletteItem;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.ArrayUtil;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;

public class TreeDropListener
extends DropTargetAdapter {
    private final EditableArea d;
    private final ToolProvider g;
    private final Class[] h;
    private final OperationContext j = new OperationContext();
    private DropTargetDragEvent b;
    private EditOperation a;
    private RadComponent i;
    private boolean c;
    private boolean f;
    private static final Cursor e = Cursors.getMoveCursor();

    public TreeDropListener(ComponentTree componentTree, EditableArea editableArea, ToolProvider toolProvider) {
        this((JComponent)((Object)componentTree), editableArea, toolProvider, TreeDropListener.class, PaletteItem.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            componentTree.setDragEnabled(true);
            componentTree.setTransferHandler(new TreeTransfer(TreeDropListener.class));
        }
    }

    public TreeDropListener(JComponent jComponent, EditableArea editableArea, ToolProvider toolProvider, Class ... classArray) {
        this.d = editableArea;
        this.j.setArea(editableArea);
        this.g = toolProvider;
        this.h = classArray;
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            jComponent.setDropTarget(new DropTarget(jComponent, this));
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
        this.f();
        this.b(false);
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.b = dropTargetDragEvent;
        this.b();
        this.g();
        this.d();
        this.e();
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(dropTargetDropEvent.getDropAction());
        this.f();
        this.a();
        this.b(true);
        dropTargetDropEvent.dropComplete(true);
    }

    private void e() {
        if (this.a != null) {
            this.a.showFeedback();
        }
        this.f = true;
    }

    private void f() {
        if (this.f) {
            this.f = false;
            if (this.a != null) {
                this.a.eraseFeedback();
            }
        }
    }

    /*
     * Loose catch block
     */
    private void b() {
        block10: {
            block11: {
                this.j.setLocation(this.c());
                if (this.j.getComponents() != null) break block10;
                try {
                    block12: {
                        if (ArrayUtil.contains((Object)SimpleTransferable.getData(this.b.getTransferable(), Class.class), (Object[])this.h)) break block11;
                        break block12;
                        catch (Throwable throwable) {
                            throw TreeDropListener.b(throwable);
                        }
                    }
                    this.j.setComponents(Collections.emptyList());
                    return;
                }
                catch (Throwable throwable) {
                    throw TreeDropListener.b(throwable);
                }
            }
            if (this.g.getActiveTool() instanceof CreationTool) {
                this.j.setType("create_children");
                CreationTool creationTool = (CreationTool)this.g.getActiveTool();
                try {
                    this.j.setComponents(Collections.singletonList(creationTool.getFactory().create()));
                }
                catch (Throwable throwable) {
                    this.j.setComponents(Collections.emptyList());
                    this.g.loadDefaultTool();
                }
                return;
            }
            List<RadComponent> list = RadComponent.getPureSelection(this.d.getSelection());
            RadComponent radComponent = null;
            for (RadComponent radComponent2 : list) {
                if (radComponent == null) {
                    radComponent = radComponent2.getParent();
                    continue;
                }
                if (radComponent == radComponent2.getParent()) continue;
                list = Collections.emptyList();
                break;
            }
            this.j.setComponents(list);
            this.j.resetMoveAddEnabled();
            for (RadComponent radComponent2 : list) {
                radComponent2.processDropOperation(this.j);
            }
        }
    }

    private void g() {
        if (this.j.getComponents().isEmpty()) {
            return;
        }
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>(this.j.getComponents());
        if (!this.j.isCreate()) {
            for (RadComponent object2 : this.j.getComponents()) {
                object2.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        arrayList.add(radComponent);
                    }
                }, true);
            }
        }
        final EditOperation[] editOperationArray = new EditOperation[1];
        ComponentTargetFilter componentTargetFilter = new ComponentTargetFilter(){

            @Override
            public boolean preFilter(RadComponent radComponent) {
                return TreeDropListener.this.j.isCreate() || !arrayList.contains((Object)radComponent);
            }

            @Override
            public boolean resultFilter(RadComponent radComponent) {
                if (!TreeDropListener.this.j.isCreate()) {
                    if (TreeDropListener.this.j.getComponents().get(0).getParent() == radComponent) {
                        TreeDropListener.this.j.setType("move_children");
                    } else {
                        TreeDropListener.this.j.setType("add_children");
                    }
                }
                if (TreeDropListener.this.i == radComponent) {
                    return true;
                }
                RadLayout radLayout = radComponent.getLayout();
                if (radLayout != null) {
                    editOperationArray[0] = radLayout.processChildOperation(TreeDropListener.this.j);
                }
                return editOperationArray[0] != null;
            }
        };
        Point point = this.c();
        RadComponent radComponent = this.d.findTarget(point.x, point.y, componentTargetFilter);
        if (radComponent != this.i) {
            if (this.a != null) {
                this.f();
            }
            this.i = radComponent;
            this.a = editOperationArray[0];
        }
        if (radComponent == null) {
            if (!this.j.isCreate()) {
                this.j.setType(null);
            }
        } else {
            this.a.setComponents(this.j.getComponents());
        }
    }

    private Point c() {
        return this.b.getLocation();
    }

    private void d() {
        if (this.a != null) {
            if (this.j.isMove()) {
                this.a(this.j.isMoveEnabled() && this.a.canExecute());
            } else if (this.j.isAdd()) {
                this.a(this.j.isAddEnabled() && this.a.canExecute());
            } else if (this.j.isCreate()) {
                this.a(this.a.canExecute());
            } else {
                this.a(false);
            }
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl2) {
        this.c = bl2;
        if (bl2) {
            this.b.acceptDrag(this.b.getDropAction());
            this.d.setCursor(this.j.isCreate() ? Cursors.getCopyCursor() : e);
        } else {
            this.b.rejectDrag();
            this.d.setCursor(Cursors.getSystemNoCursor());
        }
    }

    private void a() {
        if (this.c) {
            this.g.execute(Collections.singletonList(this.a), this.j.getMessage());
            if (this.j.isCreate()) {
                this.d.setSelection(this.j.getComponents());
            }
        }
    }

    private void b(boolean bl2) {
        this.j.setComponents(null);
        this.b = null;
        this.a = null;
        this.i = null;
        this.c = false;
        if (bl2 || !this.j.isCreate()) {
            this.j.setType(null);
            this.g.loadDefaultTool();
        }
        this.d.setCursor(null);
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }
}

