/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.designSurface.AbstractEditOperation;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.feedbacks.LineInsertFeedback;
import com.intellij.designer.designSurface.feedbacks.RectangleFeedback;
import com.intellij.designer.model.RadComponent;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFlowBaseOperation
extends AbstractEditOperation {
    protected final boolean myHorizontal;
    protected RectangleFeedback myFirstInsertFeedback;
    protected LineInsertFeedback myInsertFeedback;
    protected Rectangle myBounds;
    protected RadComponent myChildTarget;
    protected boolean myInsertBefore;

    public AbstractFlowBaseOperation(RadComponent radComponent, OperationContext operationContext, boolean bl2) {
        super(radComponent, operationContext);
        this.myHorizontal = bl2;
    }

    protected void createFeedback() {
        if (this.myFirstInsertFeedback == null) {
            FeedbackLayer feedbackLayer = this.myContext.getArea().getFeedbackLayer();
            this.myBounds = this.myContainer.getBounds(feedbackLayer);
            this.createFirstInsertFeedback();
            this.createInsertFeedback();
            if (this.getChildren().isEmpty()) {
                feedbackLayer.add(this.myFirstInsertFeedback);
            } else {
                feedbackLayer.add(this.myInsertFeedback);
            }
            feedbackLayer.repaint();
        }
    }

    protected List<RadComponent> getChildren() {
        return this.myContainer.getChildren();
    }

    protected abstract void createInsertFeedback();

    protected abstract void createFirstInsertFeedback();

    @Override
    public void showFeedback() {
        this.createFeedback();
        List<RadComponent> list = this.getChildren();
        if (!list.isEmpty()) {
            FeedbackLayer feedbackLayer = this.myContext.getArea().getFeedbackLayer();
            Point point = this.myContext.getLocation();
            this.myChildTarget = null;
            if (this.myHorizontal) {
                this.handleHorizontal(list, feedbackLayer, point);
            } else {
                this.handleVertical(list, feedbackLayer, point);
            }
            if (this.myChildTarget == null) {
                this.myChildTarget = this.a();
            }
            Rectangle rectangle = this.getBounds(this.myChildTarget, feedbackLayer);
            this.myInsertBefore = this.myHorizontal ? (double)point.x < rectangle.getCenterX() : (double)point.y < rectangle.getCenterY();
            this.setInsertFeedbackBounds(rectangle);
            feedbackLayer.repaint();
        }
    }

    protected void handleHorizontal(List<RadComponent> list, FeedbackLayer feedbackLayer, Point point) {
        for (RadComponent radComponent : list) {
            Rectangle rectangle = this.getBounds(radComponent, feedbackLayer);
            if (rectangle.x > point.x || !((double)point.x <= rectangle.getMaxX())) continue;
            this.myChildTarget = radComponent;
            break;
        }
    }

    protected void handleVertical(List<RadComponent> list, FeedbackLayer feedbackLayer, Point point) {
        for (RadComponent radComponent : list) {
            Rectangle rectangle = this.getBounds(radComponent, feedbackLayer);
            if (rectangle.y > point.y || !((double)point.y <= rectangle.getMaxY())) continue;
            this.myChildTarget = radComponent;
            break;
        }
    }

    protected void setInsertFeedbackBounds(Rectangle rectangle) {
        if (this.myHorizontal) {
            if (this.myInsertBefore) {
                this.myInsertFeedback.setLocation(rectangle.x, this.myBounds.y);
            } else {
                this.myInsertFeedback.setLocation(rectangle.x + rectangle.width, this.myBounds.y);
            }
        } else if (this.myInsertBefore) {
            this.myInsertFeedback.setLocation(this.myBounds.x, rectangle.y);
        } else {
            this.myInsertFeedback.setLocation(this.myBounds.x, rectangle.y + rectangle.height);
        }
    }

    protected Rectangle getBounds(RadComponent radComponent, FeedbackLayer feedbackLayer) {
        return radComponent.getBounds(feedbackLayer);
    }

    private RadComponent a() {
        Point point = this.myContext.getLocation();
        List<RadComponent> list = this.getChildren();
        RadComponent radComponent = list.get(list.size() - 1);
        Rectangle rectangle = radComponent.getBounds(this.myContext.getArea().getFeedbackLayer());
        if (this.myHorizontal) {
            if ((double)point.x >= rectangle.getMaxX()) {
                return radComponent;
            }
            return list.get(0);
        }
        if ((double)point.y >= rectangle.getMaxY()) {
            return radComponent;
        }
        return list.get(0);
    }

    @Override
    public void eraseFeedback() {
        if (this.myFirstInsertFeedback != null) {
            FeedbackLayer feedbackLayer = this.myContext.getArea().getFeedbackLayer();
            feedbackLayer.remove(this.myFirstInsertFeedback);
            feedbackLayer.remove(this.myInsertFeedback);
            feedbackLayer.repaint();
            this.myFirstInsertFeedback = null;
            this.myInsertFeedback = null;
        }
    }

    @Override
    public boolean canExecute() {
        if (this.myContext.isMove()) {
            if (this.myComponents.contains((Object)this.myChildTarget)) {
                return false;
            }
            List<RadComponent> list = this.getChildren();
            int n2 = list.indexOf((Object)this.myChildTarget) + (this.myInsertBefore ? -1 : 1);
            if (0 <= n2 && n2 < list.size()) {
                return !this.myComponents.contains((Object)list.get(n2));
            }
        }
        return true;
    }

    @Override
    public void execute() throws Exception {
        block7: {
            block8: {
                block6: {
                    try {
                        try {
                            if (this.myChildTarget != null && !this.myInsertBefore) break block6;
                        }
                        catch (Exception exception) {
                            throw AbstractFlowBaseOperation.b(exception);
                        }
                        this.execute(this.myChildTarget);
                        break block7;
                    }
                    catch (Exception exception) {
                        throw AbstractFlowBaseOperation.b(exception);
                    }
                }
                List<RadComponent> list = this.getChildren();
                int n2 = list.indexOf((Object)this.myChildTarget) + 1;
                try {
                    if (n2 >= list.size()) break block8;
                    this.execute(list.get(n2));
                    break block7;
                }
                catch (Exception exception) {
                    throw AbstractFlowBaseOperation.b(exception);
                }
            }
            this.execute(null);
        }
    }

    protected abstract void execute(@Nullable RadComponent var1) throws Exception;

    private static Exception b(Exception exception) {
        return exception;
    }
}

