/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.ComponentSelectionListener;
import com.intellij.designer.designSurface.DesignerEditorPanel;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.feedbacks.LineMarginBorder;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ThrowableRunnable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class InplaceEditingLayer
extends JComponent {
    private static final Logger h = Logger.getInstance((String)"#com.intellij.designer.designSurface.InplaceEditingLayer");
    private final FocusWatcher e = new FocusWatcher(){

        protected void focusLostImpl(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (focusEvent.isTemporary() || component != null && SwingUtilities.isDescendingFrom(component, this.getTopComponent())) {
                return;
            }
            ApplicationManager.getApplication().invokeLater(() -> InplaceEditingLayer.this.a(true), ModalityState.NON_MODAL);
        }
    };
    private final ComponentSelectionListener i = new ComponentSelectionListener(){

        @Override
        public void selectionChanged(EditableArea editableArea) {
            InplaceEditingLayer.this.a(true);
        }
    };
    private PropertyEditorListener b = new PropertyEditorListener(){

        public void valueCommitted(PropertyEditor propertyEditor, boolean bl2, boolean bl3) {
            InplaceEditingLayer.this.a(true);
        }

        public void editingCanceled(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.a(false);
        }

        public void preferredSizeChanged(PropertyEditor propertyEditor) {
            InplaceEditingLayer.this.b();
        }
    };
    private RadComponent d;
    private List<Property> c;
    private List<PropertyEditor> g;
    private final DesignerEditorPanel f;
    private JComponent j;
    private int a;

    public InplaceEditingLayer(DesignerEditorPanel designerEditorPanel) {
        this.f = designerEditorPanel;
    }

    public void startEditing(@Nullable InplaceContext inplaceContext) {
        try {
            block13: {
                JComponent jComponent;
                JComponent jComponent2;
                block12: {
                    List<RadComponent> list = this.f.getSurfaceArea().getSelection();
                    if (list.size() != 1) {
                        return;
                    }
                    this.d = list.get(0);
                    this.c = this.d.getInplaceProperties();
                    if (this.c.isEmpty()) {
                        this.d = null;
                        this.c = null;
                        return;
                    }
                    this.j = new JPanel((LayoutManager)new GridLayoutManager(this.c.size(), 2));
                    this.j.setBorder(new LineMarginBorder(5, 5, 5, 5));
                    new AnAction(){

                        public void actionPerformed(AnActionEvent anActionEvent) {
                            InplaceEditingLayer.this.a(false);
                        }
                    }.registerCustomShortcutSet(CommonShortcuts.ESCAPE, this.j);
                    this.g = new ArrayList<PropertyEditor>();
                    jComponent2 = null;
                    Font font = null;
                    if (inplaceContext == null) {
                        inplaceContext = new InplaceContext();
                    }
                    int n2 = 0;
                    for (Property object2 : this.c) {
                        jComponent = new JLabel(object2.getName() + ":");
                        if (font == null) {
                            font = jComponent.getFont().deriveFont(1);
                        }
                        jComponent.setFont(font);
                        this.j.add((Component)jComponent, new GridConstraints(n2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
                        PropertyEditor propertyEditor = object2.getEditor();
                        this.g.add(propertyEditor);
                        JComponent jComponent3 = propertyEditor.getComponent((PropertiesContainer)this.d, (PropertyContext)this.f, object2.getValue((PropertiesContainer)this.d), inplaceContext);
                        this.j.add((Component)jComponent3, new GridConstraints(n2++, 1, 1, 1, 0, 1, 2, 0, null, null, null));
                        if (jComponent2 != null) continue;
                        jComponent2 = propertyEditor.getPreferredFocusedComponent();
                    }
                    for (PropertyEditor propertyEditor : this.g) {
                        propertyEditor.addPropertyEditorListener(this.b);
                    }
                    Rectangle rectangle = this.d.getBounds(this);
                    Dimension dimension = this.j.getPreferredSize();
                    this.a = Math.max(dimension.width, rectangle.width);
                    this.j.setBounds(rectangle.x, rectangle.y, this.a, dimension.height);
                    this.add(this.j);
                    this.f.getSurfaceArea().addSelectionListener(this.i);
                    if (jComponent2 == null) {
                        jComponent2 = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.j);
                    }
                    if (jComponent2 == null) {
                        jComponent2 = this.j;
                    }
                    try {
                        if (!jComponent2.requestFocusInWindow()) break block12;
                        this.e.install((Component)this.j);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw InplaceEditingLayer.b(throwable);
                    }
                }
                this.grabFocus();
                jComponent = jComponent2;
                ApplicationManager.getApplication().invokeLater(() -> {
                    jComponent.requestFocusInWindow();
                    this.e.install((Component)this.j);
                });
            }
            this.enableEvents(16L);
            this.repaint();
        }
        catch (Throwable throwable) {
            h.error(throwable);
        }
    }

    private void a(boolean bl2) {
        this.f.getSurfaceArea().removeSelectionListener(this.i);
        if (this.j != null) {
            if (bl2) {
                this.f.getToolProvider().execute((ThrowableRunnable<Exception>)((ThrowableRunnable)() -> {
                    int n2 = this.c.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        Property property = this.c.get(i2);
                        Object object = property.getValue((PropertiesContainer)this.d);
                        Object object2 = this.g.get(i2).getValue();
                        try {
                            if (Comparing.equal((Object)object, (Object)object2)) continue;
                            property.setValue((PropertiesContainer)this.d, object2);
                            continue;
                        }
                        catch (Exception exception) {
                            throw InplaceEditingLayer.b(exception);
                        }
                    }
                }), DesignerBundle.message("command.set.property.value", new Object[0]), true);
            }
            for (PropertyEditor propertyEditor : this.g) {
                propertyEditor.removePropertyEditorListener(this.b);
            }
            this.c();
            this.e.deinstall((Component)this.j);
            this.j = null;
        }
        this.d = null;
        this.c = null;
        this.g = null;
        this.f.getPreferredFocusedComponent().requestFocusInWindow();
        this.disableEvents(16L);
        this.repaint();
    }

    private void b() {
        this.j.revalidate();
        Dimension dimension = this.j.getPreferredSize();
        this.j.setSize(Math.max(dimension.width, this.a), this.j.getHeight());
        this.j.revalidate();
        this.repaint();
    }

    private void c() {
        LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent((JComponent)this.f.getPreferredFocusedComponent());
        try {
            this.remove(this.j);
        }
        finally {
            LayoutFocusTraversalPolicyExt.setOverridenDefaultComponent(null);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.j != null && (501 == mouseEvent.getID() || 502 == mouseEvent.getID())) {
            this.a(true);
        }
        super.processMouseEvent(mouseEvent);
    }

    public boolean isEditing() {
        return this.j != null;
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }
}

