/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.FeedbackLayer;
import com.intellij.designer.designSurface.feedbacks.AlphaFeedback;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.model.RadComponentVisitor;
import com.intellij.designer.utils.Cursors;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JComponent;

public class MarqueeTracker
extends InputTool {
    private static final Color f = new Color(47, 67, 96);
    private static final int j = 1;
    private static final int k = 2;
    private JComponent h;
    private int i;
    private boolean g;

    public MarqueeTracker() {
        this.setDefaultCursor(Cursors.CROSS);
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    public void setSelectBackground(boolean bl2) {
        this.g = bl2;
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (n2 == 1 || n2 == 2) {
            if (this.myState == 1) {
                this.myState = 2;
                if (this.myInputEvent.isControlDown()) {
                    this.i = 1;
                } else if (this.myInputEvent.isShiftDown()) {
                    this.i = 2;
                }
            }
        } else {
            this.myState = 4;
            this.eraseFeedback();
        }
        if (n2 != 3) {
            this.refreshCursor();
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 3) {
            this.myState = 0;
            this.eraseFeedback();
            this.a();
        } else if (this.g) {
            this.a();
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 2) {
            this.myState = 3;
            this.refreshCursor();
        }
        if (this.myState == 3) {
            this.b();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2;
        try {
            bl2 = keyEvent.getModifiers() != this.myModifiers;
        }
        catch (Exception exception) {
            throw MarqueeTracker.c(exception);
        }
        boolean bl3 = bl2;
        try {
            super.keyPressed(keyEvent, editableArea);
            if (bl3) {
                this.b();
            }
        }
        catch (Exception exception) {
            throw MarqueeTracker.c(exception);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2;
        try {
            bl2 = keyEvent.getModifiers() != this.myModifiers;
        }
        catch (Exception exception) {
            throw MarqueeTracker.c(exception);
        }
        boolean bl3 = bl2;
        try {
            super.keyReleased(keyEvent, editableArea);
            if (bl3) {
                this.b();
            }
        }
        catch (Exception exception) {
            throw MarqueeTracker.c(exception);
        }
    }

    @Override
    public void deactivate() {
        if (this.myState == 3) {
            this.eraseFeedback();
        }
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 3) {
            return this.getDefaultCursor();
        }
        if (this.myState == 4) {
            return this.getDisabledCursor();
        }
        return null;
    }

    private void b() {
        FeedbackLayer feedbackLayer = this.myArea.getFeedbackLayer();
        if (this.h == null) {
            this.h = new AlphaFeedback(f);
            feedbackLayer.add(this.h);
        }
        this.h.setBounds(this.c());
        if (ApplicationManager.getApplication().isInternal()) {
            Dimension dimension = this.h.getSize();
            this.myArea.setDescription("Size [" + dimension.width + " : " + dimension.height + "]");
        }
        feedbackLayer.repaint();
    }

    protected void eraseFeedback() {
        if (this.h != null) {
            FeedbackLayer feedbackLayer = this.myArea.getFeedbackLayer();
            feedbackLayer.remove(this.h);
            feedbackLayer.repaint();
            this.h = null;
        }
    }

    private Rectangle c() {
        if (this.isAltOptionPressed()) {
            int n2 = Math.abs(this.myStartScreenX - this.myCurrentScreenX);
            int n3 = Math.abs(this.myStartScreenY - this.myCurrentScreenY);
            return new Rectangle(this.myStartScreenX - n2, this.myStartScreenY - n3, 2 * n2, 2 * n3);
        }
        return new Rectangle(this.myStartScreenX, this.myStartScreenY, 0, 0).union(new Rectangle(this.myCurrentScreenX, this.myCurrentScreenY, 0, 0));
    }

    private void a() {
        final Rectangle rectangle = this.c();
        final ArrayList<RadComponent> arrayList = new ArrayList<RadComponent>();
        RadComponent radComponent = this.myArea.getRootComponent();
        if (radComponent != null) {
            radComponent.accept(new RadComponentVisitor(){

                @Override
                public void endVisit(RadComponent radComponent) {
                    if (rectangle.contains(radComponent.getBounds(MarqueeTracker.this.myArea.getNativeComponent())) && !radComponent.isBackground()) {
                        arrayList.add(radComponent);
                    }
                }
            }, true);
            if (arrayList.isEmpty() && this.g) {
                radComponent.accept(new RadComponentVisitor(){

                    @Override
                    public void endVisit(RadComponent radComponent) {
                        if (arrayList.isEmpty() && radComponent.getBounds(MarqueeTracker.this.myArea.getNativeComponent()).contains(rectangle.x, rectangle.y) && radComponent.isBackground()) {
                            arrayList.add(radComponent);
                        }
                    }
                }, true);
            }
        }
        if (this.i == 1) {
            ArrayList<RadComponent> arrayList2 = new ArrayList<RadComponent>(this.myArea.getSelection());
            for (RadComponent radComponent2 : arrayList) {
                int n2 = arrayList2.indexOf((Object)radComponent2);
                if (n2 == -1) {
                    arrayList2.add(radComponent2);
                    continue;
                }
                arrayList2.remove(n2);
            }
            this.myArea.setSelection(arrayList2);
        } else if (this.i == 2) {
            for (RadComponent radComponent3 : arrayList) {
                this.myArea.appendSelection(radComponent3);
            }
        } else {
            this.myArea.setSelection(arrayList);
        }
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

