/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.DesignerBundle;
import com.intellij.designer.designSurface.EditOperation;
import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.OperationContext;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.utils.Cursors;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ResizeTracker
extends InputTool {
    private final int f;
    private final String j;
    private OperationContext h;
    private List<EditOperation> i;
    private boolean g;

    public ResizeTracker(int n2, Object object, @Nullable String string) {
        this.f = n2;
        this.j = string;
        this.h = new OperationContext(object);
        this.h.setResizeDirection(n2);
        this.setDefaultCursor(Cursors.getResizeCursor(n2));
        this.setDisabledCursor(Cursors.getNoCursor());
    }

    @Override
    @Nullable
    protected String getDescription() {
        return this.j;
    }

    @Override
    public void deactivate() {
        this.b();
        this.h = null;
        this.i = null;
        super.deactivate();
    }

    @Override
    protected Cursor calculateCursor() {
        if (this.myState == 2) {
            return this.getDefaultCursor();
        }
        return super.calculateCursor();
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (n2 == 1) {
            if (this.myState == 1) {
                this.myState = 2;
            }
        } else {
            this.myState = 4;
            this.b();
            this.setExecuteEnabled(false);
        }
    }

    @Override
    protected void handleButtonUp(int n2) {
        if (this.myState == 3) {
            this.myState = 0;
            this.b();
            this.d();
        }
    }

    @Override
    protected void handleDragStarted() {
        if (this.myState == 2) {
            this.myState = 3;
        }
    }

    @Override
    protected void handleDragInProgress() {
        if (this.myState == 3) {
            this.a();
            this.f();
            this.c();
        }
    }

    private void f() {
        for (EditOperation editOperation : this.g()) {
            editOperation.showFeedback();
        }
        this.g = true;
    }

    private void b() {
        if (this.g) {
            this.g = false;
            for (EditOperation editOperation : this.g()) {
                editOperation.eraseFeedback();
            }
        }
    }

    private void d() {
        if (this.myExecuteEnabled) {
            ArrayList<EditOperation> arrayList = new ArrayList<EditOperation>();
            for (EditOperation editOperation : this.g()) {
                if (!editOperation.canExecute()) continue;
                arrayList.add(editOperation);
            }
            this.myToolProvider.execute(arrayList, DesignerBundle.message("command.tool_operation", new Object[0]));
        }
    }

    private void c() {
        for (EditOperation editOperation : this.g()) {
            if (!editOperation.canExecute()) continue;
            this.setExecuteEnabled(true);
            return;
        }
        this.setExecuteEnabled(false);
    }

    private void a() {
        this.h.setArea(this.myArea);
        this.h.setInputEvent(this.myInputEvent);
        this.h.setModifiers(this.myModifiers);
        Point point = new Point();
        Dimension dimension = new Dimension();
        int n2 = this.moveDeltaWidth();
        if ((this.f & 4) != 0) {
            point.x += n2;
            dimension.width -= n2;
        } else if ((this.f & 8) != 0) {
            dimension.width += n2;
        }
        int n3 = this.moveDeltaHeight();
        if ((this.f & 1) != 0) {
            point.y += n3;
            dimension.height -= n3;
        } else if ((this.f & 2) != 0) {
            dimension.height += n3;
        }
        this.h.setMoveDelta(point);
        this.h.setSizeDelta(dimension);
        this.h.setLocation(this.getLocation());
    }

    private List<EditOperation> g() {
        if (this.i == null) {
            this.h.setComponents(new ArrayList<RadComponent>(this.myArea.getSelection()));
            this.i = new ArrayList<EditOperation>();
            for (RadComponent radComponent : this.h.getComponents()) {
                RadComponent radComponent2 = radComponent.getParent();
                EditOperation editOperation = radComponent2 == null ? this.myArea.processRootOperation(this.h) : radComponent2.getLayout().processChildOperation(this.h);
                if (editOperation == null) continue;
                this.i.add(editOperation);
                editOperation.setComponent(radComponent);
            }
        }
        return this.i;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        block8: {
            boolean bl2;
            block7: {
                boolean bl3;
                try {
                    bl3 = keyEvent.getModifiers() != this.myModifiers;
                }
                catch (Exception exception) {
                    throw ResizeTracker.c(exception);
                }
                bl2 = bl3;
                try {
                    super.keyPressed(keyEvent, editableArea);
                    if (keyEvent.getKeyCode() != 27) break block7;
                    this.myToolProvider.loadDefaultTool();
                    break block8;
                }
                catch (Exception exception) {
                    throw ResizeTracker.c(exception);
                }
            }
            try {
                if (bl2) {
                    this.e();
                }
            }
            catch (Exception exception) {
                throw ResizeTracker.c(exception);
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        boolean bl2;
        try {
            bl2 = keyEvent.getModifiers() != this.myModifiers;
        }
        catch (Exception exception) {
            throw ResizeTracker.c(exception);
        }
        boolean bl3 = bl2;
        try {
            super.keyReleased(keyEvent, editableArea);
            if (bl3) {
                this.e();
            }
        }
        catch (Exception exception) {
            throw ResizeTracker.c(exception);
        }
    }

    private void e() {
        if (this.h != null) {
            this.a();
            this.f();
            this.c();
        }
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

