/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.tools;

import com.intellij.designer.designSurface.EditableArea;
import com.intellij.designer.designSurface.ZoomType;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.designSurface.tools.MarqueeTracker;
import com.intellij.designer.designSurface.tools.ResizeTracker;
import com.intellij.designer.model.RadComponent;
import com.intellij.designer.propertyTable.InplaceContext;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SelectionTool
extends InputTool {
    private InputTool f;

    @Override
    public void deactivate() {
        this.a();
        super.deactivate();
    }

    @Override
    public void refreshCursor() {
        if (this.f == null) {
            super.refreshCursor();
        }
    }

    @Override
    protected void handleButtonDown(int n2) {
        if (this.myState == 1) {
            Object object;
            this.myState = 2;
            this.a();
            if (this.handleTracker()) {
                return;
            }
            if (!this.myArea.isTree() && (object = this.myArea.findTargetTool(this.myCurrentScreenX, this.myCurrentScreenY)) != null) {
                this.a((InputTool)object);
                if (object instanceof ResizeTracker) {
                    this.myArea.showSelection(false);
                }
                return;
            }
            object = this.myArea.findTarget(this.myCurrentScreenX, this.myCurrentScreenY, null);
            if (object == null || ((RadComponent)((Object)object)).isBackground()) {
                if (!this.myArea.isTree()) {
                    MarqueeTracker marqueeTracker = new MarqueeTracker();
                    marqueeTracker.setSelectBackground(object != null && ((RadComponent)((Object)object)).isBackground());
                    this.a(marqueeTracker);
                }
            } else {
                Point point = ((RadComponent)((Object)object)).convertPoint(this.myArea.getNativeComponent(), this.myCurrentScreenX, this.myCurrentScreenY);
                this.a(((RadComponent)((Object)object)).getDragTracker(point, this.myInputEvent, this.myArea.isTree()));
            }
        }
    }

    protected boolean handleTracker() {
        if (!this.myArea.isTree() && this.myInputEvent.isAltDown()) {
            this.a(new MarqueeTracker());
            return true;
        }
        return false;
    }

    @Override
    protected void handleButtonUp(int n2) {
        this.myState = 1;
        this.a(null);
        this.handleMove();
    }

    @Override
    protected void handlePopup() {
        ActionManager actionManager = ActionManager.getInstance();
        ActionPopupMenu actionPopupMenu = actionManager.createActionPopupMenu(this.myArea.getPopupPlace(), this.myArea.getPopupActions());
        MouseEvent mouseEvent = (MouseEvent)this.myInputEvent;
        actionPopupMenu.getComponent().show(this.myArea.getNativeComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    protected void handleDoubleClick(int n2) {
        if (n2 == 1 && this.myToolProvider != null && !this.myArea.isTree()) {
            this.myToolProvider.startInplaceEditing(null);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    protected void handleMove() {
        block9: {
            InputTool inputTool;
            block7: {
                block8: {
                    if (this.myState != 1) break block9;
                    inputTool = this.myArea.findTargetTool(this.myCurrentScreenX, this.myCurrentScreenY);
                    if (inputTool != null) break block7;
                    try {
                        block10: {
                            this.refreshCursor();
                            if (!ApplicationManager.getApplication().isInternal()) break block8;
                            break block10;
                            catch (Exception exception) {
                                throw SelectionTool.c(exception);
                            }
                        }
                        this.myArea.setDescription("Location (" + this.myCurrentScreenX + " x " + this.myCurrentScreenY + ")");
                        break block9;
                    }
                    catch (Exception exception) {
                        throw SelectionTool.c(exception);
                    }
                }
                this.myArea.setDescription(null);
                break block9;
            }
            if (this.myInputEvent instanceof MouseEvent) {
                try {
                    inputTool.mouseMove((MouseEvent)this.myInputEvent, this.myArea);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.myArea.setCursor(inputTool.getDefaultCursor());
            this.myArea.setDescription(inputTool.getDescription());
        }
    }

    private void a(@Nullable InputTool inputTool) {
        if (this.f != inputTool) {
            this.a();
            this.f = inputTool;
            this.refreshCursor();
            if (this.f != null) {
                this.myToolProvider.hideInspections();
                this.f.setToolProvider(this.myToolProvider);
                this.f.setArea(this.myArea);
                this.f.myModifiers = this.myModifiers;
                this.f.activate();
            }
        }
    }

    private void a() {
        if (this.f != null) {
            this.f.deactivate();
            this.f = null;
            if (this.myArea != null) {
                this.myArea.showSelection(true);
            }
        }
    }

    @Override
    public void mouseDown(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        try {
            super.mouseDown(mouseEvent, editableArea);
            if (this.f != null) {
                this.f.mouseDown(mouseEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
    }

    @Override
    public void mouseUp(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        try {
            if (this.f != null) {
                this.f.mouseUp(mouseEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
        super.mouseUp(mouseEvent, editableArea);
    }

    @Override
    public void mouseMove(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        try {
            if (this.f != null) {
                this.f.mouseMove(mouseEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
        super.mouseMove(mouseEvent, editableArea);
    }

    @Override
    public void mouseDrag(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        try {
            if (this.f != null) {
                this.f.mouseDrag(mouseEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
        super.mouseDrag(mouseEvent, editableArea);
    }

    @Override
    public void mousePopup(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        try {
            if (this.f != null) {
                this.f.mousePopup(mouseEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
        super.mousePopup(mouseEvent, editableArea);
    }

    @Override
    public void mouseDoubleClick(MouseEvent mouseEvent, EditableArea editableArea) throws Exception {
        try {
            super.mouseDoubleClick(mouseEvent, editableArea);
            if (this.f != null) {
                this.f.mouseDoubleClick(mouseEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        block7: {
            List<RadComponent> list;
            block6: {
                try {
                    super.keyTyped(keyEvent, editableArea);
                    if (this.f == null) break block6;
                    this.f.keyPressed(keyEvent, editableArea);
                    break block7;
                }
                catch (Exception exception) {
                    throw SelectionTool.c(exception);
                }
            }
            if (keyEvent.getKeyCode() == 27 && !(list = editableArea.getSelection()).isEmpty()) {
                RadComponent radComponent = list.get(0).getParent();
                try {
                    if (radComponent != null) {
                        editableArea.select(radComponent);
                    }
                }
                catch (Exception exception) {
                    throw SelectionTool.c(exception);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        block7: {
            block6: {
                try {
                    super.keyTyped(keyEvent, editableArea);
                    if (this.f == null) break block6;
                    this.f.keyTyped(keyEvent, editableArea);
                    break block7;
                }
                catch (Exception exception) {
                    throw SelectionTool.c(exception);
                }
            }
            try {
                try {
                    if (this.myToolProvider == null || editableArea.isTree()) break block7;
                }
                catch (Exception exception) {
                    throw SelectionTool.c(exception);
                }
                this.handleKeyTyped(keyEvent);
            }
            catch (Exception exception) {
                throw SelectionTool.c(exception);
            }
        }
    }

    protected void handleKeyTyped(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        switch (c2) {
            case '+': 
            case '-': 
            case '0': 
            case '1': {
                ZoomType zoomType = c2 == '-' ? ZoomType.OUT : (c2 == '+' ? ZoomType.IN : (c2 == '0' ? ZoomType.FIT : ZoomType.ACTUAL));
                if (!this.myToolProvider.isZoomSupported()) break;
                this.myToolProvider.zoom(zoomType);
                keyEvent.consume();
                return;
            }
        }
        if (Character.isLetterOrDigit(c2) && (keyEvent.getModifiers() & 0xE) == 0) {
            this.myToolProvider.startInplaceEditing(new InplaceContext(c2));
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent, EditableArea editableArea) throws Exception {
        try {
            super.keyReleased(keyEvent, editableArea);
            if (this.f != null) {
                this.f.keyReleased(keyEvent, editableArea);
            }
        }
        catch (Exception exception) {
            throw SelectionTool.c(exception);
        }
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

