/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathsList;
import com.intellij.util.lang.UrlClassLoader;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;

public class TestClassCollector {
    private static final Logger a = Logger.getInstance(TestClassCollector.class);

    /*
     * Loose catch block
     */
    public static String[] collectClassFQNames(final String string, @Nullable Path path, JavaTestConfigurationBase javaTestConfigurationBase, Function<ClassLoader, Predicate<Class<?>>> function) {
        Module module2 = ((JavaRunConfigurationModule)javaTestConfigurationBase.getConfigurationModule()).getModule();
        final ClassLoader classLoader = TestClassCollector.createUsersClassLoader(javaTestConfigurationBase);
        final HashSet hashSet = new HashSet();
        try {
            String string2 = string.replace('.', '/');
            Enumeration<URL> enumeration = classLoader.getResources(string2);
            final Predicate<Class<?>> predicate = function.apply(classLoader);
            while (enumeration.hasMoreElements()) {
                Path path2;
                block12: {
                    URL uRL = enumeration.nextElement();
                    try {
                        if ("jar".equals(uRL.getProtocol())) {
                            continue;
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw TestClassCollector.b((RuntimeException)((Object)processCanceledException));
                    }
                    path2 = Paths.get(uRL.toURI());
                    if (path == null) break block12;
                    try {
                        if (!path2.startsWith(path)) {
                            continue;
                        }
                        break block12;
                        catch (ProcessCanceledException processCanceledException) {
                            throw TestClassCollector.b((RuntimeException)((Object)processCanceledException));
                        }
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw TestClassCollector.b((RuntimeException)((Object)processCanceledException));
                    }
                }
                final String string3 = path2.getFileSystem().getSeparator();
                Files.walkFileTree(path2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    /*
                     * Loose catch block
                     */
                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        FileVisitResult fileVisitResult;
                        block10: {
                            ProgressManager.checkCanceled();
                            fileVisitResult = super.visitFile(path, basicFileAttributes);
                            File file = path.toFile();
                            String string4 = file.getName();
                            if (!string4.endsWith(".class")) break block10;
                            try {
                                Class<?> clazz;
                                String string2;
                                block9: {
                                    block8: {
                                        int n2;
                                        block11: {
                                            Path path22 = path2.relativize(path.getParent());
                                            String string32 = StringUtil.getQualifiedName((String)path22.toString().replace(string3, "."), (String)FileUtil.getNameWithoutExtension((String)string4));
                                            string2 = StringUtil.getQualifiedName((String)string, (String)string32);
                                            clazz = Class.forName(string2, false, classLoader);
                                            n2 = clazz.getModifiers();
                                            if (Modifier.isAbstract(n2)) break block8;
                                            if (!Modifier.isPublic(n2)) break block8;
                                            break block11;
                                            catch (Throwable throwable) {
                                                throw 1.b(throwable);
                                            }
                                        }
                                        try {
                                            block12: {
                                                if (!clazz.isMemberClass()) break block9;
                                                break block12;
                                                catch (Throwable throwable) {
                                                    throw 1.b(throwable);
                                                }
                                            }
                                            if (Modifier.isStatic(n2)) break block9;
                                        }
                                        catch (Throwable throwable) {
                                            throw 1.b(throwable);
                                        }
                                    }
                                    return fileVisitResult;
                                }
                                if (!predicate.test(clazz)) break block10;
                                hashSet.add(string2);
                            }
                            catch (Throwable throwable) {
                                a.info("error processing: " + string4 + " of " + path2.toString(), throwable);
                            }
                        }
                        return fileVisitResult;
                    }

                    private static Throwable b(Throwable throwable) {
                        return throwable;
                    }
                });
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw processCanceledException;
        }
        catch (Throwable throwable) {
            a.error(throwable);
        }
        return ArrayUtil.toStringArray(hashSet);
    }

    public static ClassLoader createUsersClassLoader(JavaTestConfigurationBase javaTestConfigurationBase) {
        Module module2 = ((JavaRunConfigurationModule)javaTestConfigurationBase.getConfigurationModule()).getModule();
        ArrayList<URL> arrayList = new ArrayList<URL>();
        PathsList pathsList = (PathsList)ReadAction.compute(() -> {
            OrderEnumerator orderEnumerator;
            block5: {
                block4: {
                    try {
                        try {
                            if (module2 != null && javaTestConfigurationBase.getTestSearchScope() != TestSearchScope.WHOLE_PROJECT) break block4;
                        }
                        catch (RuntimeException runtimeException) {
                            throw TestClassCollector.b(runtimeException);
                        }
                        orderEnumerator = OrderEnumerator.orderEntries((Project)javaTestConfigurationBase.getProject());
                        break block5;
                    }
                    catch (RuntimeException runtimeException) {
                        throw TestClassCollector.b(runtimeException);
                    }
                }
                orderEnumerator = OrderEnumerator.orderEntries((Module)module2);
            }
            return orderEnumerator.runtimeOnly().recursively().getPathsList();
        });
        for (VirtualFile virtualFile : pathsList.getVirtualFiles()) {
            try {
                arrayList.add(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                a.info((Throwable)malformedURLException);
            }
        }
        return UrlClassLoader.build().allowLock().useCache().urls(arrayList).get();
    }

    @Nullable
    public static Path getRootPath(Module module2, boolean bl2) {
        CompilerModuleExtension compilerModuleExtension;
        if (bl2 && (compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module2)) != null) {
            VirtualFile virtualFile = compilerModuleExtension.getCompilerOutputPathForTests();
            try {
                if (virtualFile != null) {
                    return Paths.get(VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile).toURI());
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw TestClassCollector.b((RuntimeException)((Object)processCanceledException));
            }
        }
        return null;
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

