/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Set;

public abstract class AbstractExcludeFromRunAction<T extends ModuleBasedConfiguration<JavaRunConfigurationModule>>
extends AnAction {
    private static final Logger a = Logger.getInstance(AbstractExcludeFromRunAction.class);

    protected abstract Set<String> getPattern(T var1);

    protected abstract boolean isPatternBasedConfiguration(RunConfiguration var1);

    public void actionPerformed(AnActionEvent anActionEvent) {
        DataContext dataContext = anActionEvent.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        a.assertTrue(project2 != null);
        ModuleBasedConfiguration moduleBasedConfiguration = (ModuleBasedConfiguration)RunConfiguration.DATA_KEY.getData(dataContext);
        a.assertTrue(moduleBasedConfiguration != null);
        GlobalSearchScope globalSearchScope = ((JavaRunConfigurationModule)moduleBasedConfiguration.getConfigurationModule()).getSearchScope();
        AbstractTestProxy abstractTestProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext);
        a.assertTrue(abstractTestProxy != null);
        String string = ((PsiClass)abstractTestProxy.getLocation(project2, globalSearchScope).getPsiElement()).getQualifiedName();
        this.getPattern(moduleBasedConfiguration).remove(string);
    }

    public void update(AnActionEvent anActionEvent) {
        PsiElement psiElement;
        Location location;
        AbstractTestProxy abstractTestProxy;
        RunConfiguration runConfiguration;
        Presentation presentation = anActionEvent.getPresentation();
        presentation.setVisible(false);
        DataContext dataContext = anActionEvent.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 != null && this.isPatternBasedConfiguration(runConfiguration = (RunConfiguration)RunConfiguration.DATA_KEY.getData(dataContext)) && (abstractTestProxy = (AbstractTestProxy)AbstractTestProxy.DATA_KEY.getData(dataContext)) != null && (location = abstractTestProxy.getLocation(project2, ((JavaRunConfigurationModule)((ModuleBasedConfiguration)runConfiguration).getConfigurationModule()).getSearchScope())) != null && (psiElement = location.getPsiElement()) instanceof PsiClass && this.getPattern((ModuleBasedConfiguration)runConfiguration).contains(((PsiClass)psiElement).getQualifiedName())) {
            presentation.setVisible(true);
        }
    }
}

