/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.impl.RunnerAndConfigurationSettingsImpl;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.hash.HashSet;
import org.jetbrains.annotations.Nullable;

public abstract class JavaRuntimeConfigurationProducerBase
extends RuntimeConfigurationProducer {
    protected JavaRuntimeConfigurationProducerBase(ConfigurationType configurationType) {
        super(configurationType);
    }

    protected static PsiMethod getContainingMethod(PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiMethod)) {
            psiElement = psiElement.getParent();
        }
        return (PsiMethod)psiElement;
    }

    @Nullable
    public static PsiPackage checkPackage(PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return null;
        }
        Project project2 = psiElement.getProject();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        if (psiElement instanceof PsiPackage) {
            PsiDirectory[] psiDirectoryArray;
            PsiPackage psiPackage = (PsiPackage)psiElement;
            for (PsiDirectory psiDirectory : psiDirectoryArray = psiPackage.getDirectories(GlobalSearchScope.projectScope((Project)project2))) {
                if (!JavaRuntimeConfigurationProducerBase.a(psiDirectory, projectFileIndex)) continue;
                return psiPackage;
            }
            return null;
        }
        if (psiElement instanceof PsiDirectory) {
            Module module2;
            PsiDirectory psiDirectory = (PsiDirectory)psiElement;
            if (JavaRuntimeConfigurationProducerBase.a(psiDirectory, projectFileIndex)) {
                return JavaDirectoryService.getInstance().getPackage(psiDirectory);
            }
            VirtualFile virtualFile = psiDirectory.getVirtualFile();
            if (virtualFile.equals(projectFileIndex.getContentRootForFile(virtualFile)) && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project2)) != null) {
                for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
                    if (!virtualFile.equals(contentEntry.getFile())) continue;
                    SourceFolder[] sourceFolderArray = contentEntry.getSourceFolders();
                    HashSet hashSet = new HashSet();
                    for (SourceFolder sourceFolder : sourceFolderArray) {
                        hashSet.add(sourceFolder.getPackagePrefix());
                    }
                    if (hashSet.size() != 1) {
                        return null;
                    }
                    return JavaPsiFacade.getInstance((Project)project2).findPackage((String)hashSet.iterator().next());
                }
            }
            return null;
        }
        return null;
    }

    private static boolean a(PsiDirectory psiDirectory, ProjectFileIndex projectFileIndex) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        return projectFileIndex.getSourceRootForFile(virtualFile) != null;
    }

    protected TestSearchScope setupPackageConfiguration(ConfigurationContext configurationContext, Project project2, ModuleBasedConfiguration moduleBasedConfiguration, TestSearchScope testSearchScope) {
        if (testSearchScope != TestSearchScope.WHOLE_PROJECT && !this.setupConfigurationModule(configurationContext, moduleBasedConfiguration)) {
            return TestSearchScope.WHOLE_PROJECT;
        }
        return testSearchScope;
    }

    protected boolean setupConfigurationModule(@Nullable ConfigurationContext configurationContext, ModuleBasedConfiguration moduleBasedConfiguration) {
        if (configurationContext != null) {
            RunnerAndConfigurationSettingsImpl runnerAndConfigurationSettingsImpl = ((RunManagerImpl)configurationContext.getRunManager()).getConfigurationTemplate(this.getConfigurationFactory());
            Module module2 = configurationContext.getModule();
            Module module3 = ((ModuleBasedConfiguration)runnerAndConfigurationSettingsImpl.getConfiguration()).getConfigurationModule().getModule();
            if (module3 != null) {
                moduleBasedConfiguration.setModule(module3);
                return true;
            }
            Module module4 = this.findModule(moduleBasedConfiguration, module2);
            if (module4 != null) {
                moduleBasedConfiguration.setModule(module4);
                return true;
            }
        }
        return false;
    }

    protected Module findModule(ModuleBasedConfiguration moduleBasedConfiguration, Module module2) {
        if (moduleBasedConfiguration.getConfigurationModule().getModule() == null && module2 != null) {
            return module2;
        }
        return null;
    }
}

