/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.SingleClassConfiguration;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementAdapter;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.UndoRefactoringElementListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefactoringListeners {
    public static RefactoringElementListener getListener(PsiPackage psiPackage, Accessor<PsiPackage> accessor) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PsiPackage psiPackage2 = accessor.getPsiElement(); psiPackage2 != null; psiPackage2 = psiPackage2.getParentPackage()) {
            if (psiPackage2.equals(psiPackage)) {
                return new RefactorPackage(accessor, stringBuilder.toString());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '.');
            }
            stringBuilder.insert(0, psiPackage2.getName());
        }
        return null;
    }

    public static RefactoringElementListener getListeners(PsiClass psiClass, Accessor<PsiClass> accessor) {
        PsiClass psiClass2 = accessor.getPsiElement();
        if (psiClass2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        PsiClass psiClass3 = psiClass2;
        while (psiClass3 != null) {
            if (psiClass3.equals(psiClass)) {
                return new RefactorClass(accessor, stringBuilder.toString());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, '$');
            }
            stringBuilder.insert(0, psiClass3.getName());
            psiClass3 = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiClass3, PsiClass.class, (boolean)true);
        }
        return null;
    }

    public static RefactoringElementListener getClassOrPackageListener(PsiElement psiElement, Accessor<PsiClass> accessor) {
        if (psiElement instanceof PsiClass) {
            return RefactoringListeners.getListeners((PsiClass)psiElement, accessor);
        }
        if (psiElement instanceof PsiPackage) {
            PsiClass psiClass = accessor.getPsiElement();
            if (psiClass == null) {
                return null;
            }
            return RefactoringListeners.getListener((PsiPackage)psiElement, new ClassPackageAccessor(accessor));
        }
        return null;
    }

    private static class ClassPackageAccessor
    implements Accessor<PsiPackage> {
        private final PsiPackage c;
        private final Module b;
        private final Accessor<PsiClass> d;
        private final String a;

        public ClassPackageAccessor(Accessor<PsiClass> accessor) {
            String string;
            String string2;
            this.d = accessor;
            PsiClass psiClass = this.d.getPsiElement();
            psiClass = (PsiClass)psiClass.getOriginalElement();
            this.c = JavaDirectoryService.getInstance().getPackage(psiClass.getContainingFile().getContainingDirectory());
            this.b = JavaExecutionUtil.findModule((PsiClass)psiClass);
            String string3 = psiClass.getQualifiedName();
            String string4 = string2 = this.c != null ? this.c.getQualifiedName() : null;
            this.a = string3 != null && string2 != null && string3.startsWith(string2) ? (StringUtil.startsWithChar((CharSequence)(string = string3.substring(string2.length())), (char)'.') ? string.substring(1) : string) : null;
        }

        @Override
        public PsiPackage getPsiElement() {
            return this.c;
        }

        @Override
        public void setPsiElement(PsiPackage psiPackage) {
            if (this.a == null) {
                return;
            }
            String string = this.a(psiPackage.getQualifiedName());
            PsiClass psiClass = JUnitUtil.findPsiClass(string, this.b, psiPackage.getProject());
            if (psiClass != null) {
                this.d.setPsiElement(psiClass);
            } else {
                this.d.setName(string);
            }
        }

        @Override
        public void setName(String string) {
            this.d.setName(this.a(string));
        }

        private String a(String string) {
            if (string.length() > 0) {
                return string + '.' + this.a;
            }
            return this.a;
        }
    }

    public static class RefactorPackageByClass
    extends RenameElement<PsiClass> {
        public RefactorPackageByClass(Accessor<PsiClass> accessor) {
            super(accessor, "*");
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String string) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(string.replace('$', '.').replace("\\*", psiClass.getName()), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            String string = psiClass.getQualifiedName();
            return string != null ? StringUtil.getPackageName((String)string) : null;
        }
    }

    private static class RefactorClass
    extends RenameElement<PsiClass> {
        public RefactorClass(Accessor<PsiClass> accessor, String string) {
            super(accessor, string);
        }

        @Override
        @Nullable
        public PsiClass findNewElement(PsiClass psiClass, String string) {
            Module module2 = JavaExecutionUtil.findModule((PsiClass)psiClass);
            if (module2 == null) {
                return null;
            }
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass(string.replace('$', '.'), GlobalSearchScope.moduleScope((Module)module2));
        }

        @Override
        public String getQualifiedName(PsiClass psiClass) {
            return psiClass.getQualifiedName();
        }
    }

    private static class RefactorPackage
    extends RenameElement<PsiPackage> {
        public RefactorPackage(Accessor<PsiPackage> accessor, String string) {
            super(accessor, string);
        }

        @Override
        public PsiPackage findNewElement(PsiPackage psiPackage, String string) {
            return JavaPsiFacade.getInstance((Project)psiPackage.getProject()).findPackage(string);
        }

        @Override
        public String getQualifiedName(PsiPackage psiPackage) {
            return psiPackage.getQualifiedName();
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    private static abstract class RenameElement<T extends PsiElement>
    extends RefactoringElementAdapter
    implements UndoRefactoringElementListener {
        private final Accessor<T> a;
        private final String b;

        public RenameElement(Accessor<T> accessor, String string) {
            this.a = accessor;
            this.b = string;
        }

        public void elementRenamedOrMoved(@NotNull PsiElement psiElement) {
            block7: {
                String string;
                block6: {
                    try {
                        if (psiElement == null) {
                            RenameElement.a(0);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RenameElement.a(illegalArgumentException);
                    }
                    PsiElement psiElement2 = psiElement;
                    string = this.getQualifiedName(psiElement2);
                    if (this.b.length() > 0) {
                        string = string + "." + this.b;
                        psiElement2 = this.findNewElement(psiElement2, string);
                    }
                    try {
                        if (psiElement2 == null) break block6;
                        this.a.setPsiElement(psiElement2);
                        break block7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RenameElement.a(illegalArgumentException);
                    }
                }
                this.a.setName(string);
            }
        }

        @Nullable
        protected abstract T findNewElement(T var1, String var2);

        protected abstract String getQualifiedName(T var1);

        public void undoElementMovedOrRenamed(@NotNull PsiElement psiElement, @NotNull String string) {
            try {
                if (psiElement == null) {
                    RenameElement.a(1);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw RenameElement.a(illegalArgumentException);
            }
            try {
                if (string == null) {
                    RenameElement.a(2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw RenameElement.a(illegalArgumentException);
            }
            this.a.setName(string);
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void a(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }

    public static class SingleClassConfigurationAccessor
    implements Accessor<PsiClass> {
        private final SingleClassConfiguration a;

        public SingleClassConfigurationAccessor(SingleClassConfiguration singleClassConfiguration) {
            this.a = singleClassConfiguration;
        }

        @Override
        public PsiClass getPsiElement() {
            return this.a.getMainClass();
        }

        @Override
        public void setPsiElement(PsiClass psiClass) {
            this.a.setMainClass(psiClass);
        }

        @Override
        public void setName(String string) {
            this.a.setMainClassName(string);
        }
    }

    public static interface Accessor<T extends PsiElement> {
        public void setName(String var1);

        public T getPsiElement();

        public void setPsiElement(T var1);
    }
}

