/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.util.Function;
import java.util.HashSet;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class ResetConfigurationModuleAdapter
extends HyperlinkAdapter {
    private static final Logger a = Logger.getInstance((String)("#" + ResetConfigurationModuleAdapter.class));
    private final Project b;
    private final boolean d;
    private final ToolWindowManager c;
    private final String f;
    private final ModuleBasedConfiguration e;

    public ResetConfigurationModuleAdapter(ModuleBasedConfiguration moduleBasedConfiguration, Project project2, boolean bl2, ToolWindowManager toolWindowManager, String string) {
        this.b = project2;
        this.d = bl2;
        this.c = toolWindowManager;
        this.f = string;
        this.e = moduleBasedConfiguration;
    }

    public static <T extends ModuleBasedConfiguration<JavaRunConfigurationModule>> boolean tryWithAnotherModule(T t2, boolean bl2) {
        PsiDirectory[] psiDirectoryArray;
        String string = ((CommonJavaRunConfigurationParameters)t2).getPackage();
        if (string == null) {
            return false;
        }
        Project project2 = t2.getProject();
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)project2).findPackage(string);
        if (psiPackage == null) {
            return false;
        }
        Module module3 = ((JavaRunConfigurationModule)t2.getConfigurationModule()).getModule();
        if (module3 == null) {
            return false;
        }
        HashSet<Module> hashSet = new HashSet<Module>();
        for (Object object : psiDirectoryArray = psiPackage.getDirectories()) {
            Module module4 = ModuleUtilCore.findModuleForFile((VirtualFile)object.getVirtualFile(), (Project)project2);
            if (module3 == module4 || module4 == null) continue;
            hashSet.add(module4);
        }
        if (!hashSet.isEmpty()) {
            Object object;
            String string2 = bl2 ? ToolWindowId.DEBUG : ToolWindowId.RUN;
            ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project2);
            Function function = module2 -> {
                String string = module2.getName();
                return "<a href=\"" + string + "\">" + string + "</a>";
            };
            object = "Tests were not found in module \"" + module3.getName() + "\".\nUse ";
            object = hashSet.size() == 1 ? (String)object + "module \"" + (String)function.fun(hashSet.iterator().next()) + "\" " : (String)object + "one of\n" + StringUtil.join(hashSet, (Function)function, (String)"\n") + "\n";
            object = (String)object + "instead";
            toolWindowManager.notifyByBalloon(string2, MessageType.WARNING, (String)object, null, (HyperlinkListener)((Object)new ResetConfigurationModuleAdapter(t2, project2, bl2, toolWindowManager, string2)));
            return true;
        }
        return false;
    }

    protected void hyperlinkActivated(HyperlinkEvent hyperlinkEvent) {
        Module module2 = ModuleManager.getInstance((Project)this.b).findModuleByName(hyperlinkEvent.getDescription());
        if (module2 != null) {
            this.e.getConfigurationModule().setModule(module2);
            try {
                Executor executor = this.d ? DefaultDebugExecutor.getDebugExecutorInstance() : DefaultRunExecutor.getRunExecutorInstance();
                ExecutionEnvironmentBuilder.create((Project)this.b, (Executor)executor, (RunProfile)this.e).contentToReuse(null).buildAndExecute();
                Balloon balloon = this.c.getToolWindowBalloon(this.f);
                try {
                    if (balloon != null) {
                        balloon.hide();
                    }
                }
                catch (ExecutionException executionException) {
                    throw ResetConfigurationModuleAdapter.b(executionException);
                }
            }
            catch (ExecutionException executionException) {
                a.error((Throwable)executionException);
            }
        }
    }

    private static ExecutionException b(ExecutionException executionException) {
        return executionException;
    }
}

