/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JreComboboxEditor;
import com.intellij.execution.ui.JreProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.OrderEntryAppearanceService;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedComboBoxModel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.StatusText;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JrePathEditor
extends JPanel
implements PanelWithAnchor {
    private static final String g = "Default";
    private final ComboboxWithBrowseButton d;
    private final JBLabel i = new JBLabel(ExecutionBundle.message((String)"run.configuration.jre.label", (Object[])new Object[0]));
    private final JreComboboxEditor f;
    private final DefaultJreItem b;
    private DefaultJreSelector h;
    private JComponent a;
    private final SortedComboBoxModel<JreComboBoxItem> c = new SortedComboBoxModel((jreComboBoxItem, jreComboBoxItem2) -> {
        int n2 = Comparing.compare((int)jreComboBoxItem.getOrder(), (int)jreComboBoxItem2.getOrder());
        try {
            if (n2 != 0) {
                return n2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JrePathEditor.a(illegalArgumentException);
        }
        return jreComboBoxItem.getPresentableText().compareToIgnoreCase(jreComboBoxItem2.getPresentableText());
    });
    private String e;

    public JrePathEditor(DefaultJreSelector defaultJreSelector) {
        this();
        this.setDefaultJreSelector(defaultJreSelector);
    }

    public JrePathEditor() {
        String string;
        this.b = new DefaultJreItem();
        this.c.add((Object)this.b);
        Sdk[] sdkArray = ProjectJdkTable.getInstance().getAllJdks();
        for (Sdk sdk : sdkArray) {
            this.c.add((Object)new SdkAsJreItem(sdk));
        }
        HashSet hashSet = new HashSet();
        for (JreProvider jreProvider : (ComboBox)JreProvider.EP_NAME.getExtensions()) {
            string = jreProvider.getJrePath();
            try {
                if (StringUtil.isEmpty((String)string)) continue;
                hashSet.add(string);
                this.c.add((Object)new CustomJreItem(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JrePathEditor.a(illegalArgumentException);
            }
        }
        for (JreProvider jreProvider : sdkArray) {
            File file;
            string = jreProvider.getHomePath();
            if (!SystemInfo.isMac && (file = new File(jreProvider.getHomePath(), "jre")).isDirectory()) {
                string = file.getPath();
            }
            try {
                if (!hashSet.add(string)) continue;
                this.c.add((Object)new CustomJreItem(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JrePathEditor.a(illegalArgumentException);
            }
        }
        ComboBox comboBox = new ComboBox(this.c, 100);
        comboBox.setEditable(true);
        comboBox.setRenderer((ListCellRenderer)new ColoredListCellRenderer<JreComboBoxItem>(){

            protected void customizeCellRenderer(@NotNull JList<? extends JreComboBoxItem> jList, JreComboBoxItem jreComboBoxItem, int n2, boolean bl2, boolean bl3) {
                try {
                    if (jList == null) {
                        1.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                try {
                    if (jreComboBoxItem != null) {
                        jreComboBoxItem.render((SimpleColoredComponent)this, bl2);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/execution/ui/JrePathEditor$1", "customizeCellRenderer"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
        this.f = new JreComboboxEditor(this.c);
        this.f.getEditorComponent().setTextToTriggerEmptyTextStatus(g);
        comboBox.setEditor((ComboBoxEditor)this.f);
        this.d = new ComboboxWithBrowseButton((JComboBox)comboBox);
        this.d.addBrowseFolderListener(ExecutionBundle.message((String)"run.configuration.select.alternate.jre.label", (Object[])new Object[0]), ExecutionBundle.message((String)"run.configuration.select.jre.dir.label", (Object[])new Object[0]), null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, JreComboboxEditor.TEXT_COMPONENT_ACCESSOR);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gap 10, fill, flowx"));
        this.add((Component)this.i, "shrinkx");
        this.add((Component)this.d, "growx, pushx");
        InsertPathAction.addTo((JTextComponent)this.f.getEditorComponent());
        this.setAnchor((JComponent)this.i);
        this.updateUI();
    }

    @Nullable
    public String getJrePathOrName() {
        JreComboBoxItem jreComboBoxItem = this.c();
        try {
            if (jreComboBoxItem instanceof DefaultJreItem) {
                return this.e;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JrePathEditor.a(illegalArgumentException);
        }
        return jreComboBoxItem.getPathOrName();
    }

    public boolean isAlternativeJreSelected() {
        boolean bl2;
        try {
            bl2 = !(this.c() instanceof DefaultJreItem);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JrePathEditor.a(illegalArgumentException);
        }
        return bl2;
    }

    private JreComboBoxItem c() {
        return (JreComboBoxItem)this.d.getComboBox().getEditor().getItem();
    }

    public void setDefaultJreSelector(DefaultJreSelector defaultJreSelector) {
        this.h = defaultJreSelector;
        this.h.addChangeListener(() -> this.b());
    }

    public void setPathOrName(@Nullable String string, boolean bl2) {
        JreComboBoxItem jreComboBoxItem = this.b;
        if (!StringUtil.isEmpty((String)string)) {
            this.e = string;
            JreComboBoxItem jreComboBoxItem2 = this.a(string);
            if (bl2) {
                jreComboBoxItem = jreComboBoxItem2;
            }
        }
        ((JComboBox)this.d.getChildComponent()).setSelectedItem(jreComboBoxItem);
        this.b();
    }

    private void b() {
        StatusText statusText = this.f.getEmptyText();
        statusText.clear();
        statusText.appendText(g, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        statusText.appendText(this.h.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private JreComboBoxItem a(@NotNull String string) {
        try {
            if (string == null) {
                JrePathEditor.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JrePathEditor.a(illegalArgumentException);
        }
        for (JreComboBoxItem jreComboBoxItem : this.c.getItems()) {
            try {
                block10: {
                    try {
                        try {
                            if (jreComboBoxItem instanceof CustomJreItem && FileUtil.pathsEqual((String)string, (String)((CustomJreItem)jreComboBoxItem).a)) break block10;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw JrePathEditor.a(illegalArgumentException);
                        }
                        if (!string.equals(jreComboBoxItem.getPathOrName())) continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw JrePathEditor.a(illegalArgumentException);
                    }
                }
                return jreComboBoxItem;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw JrePathEditor.a(illegalArgumentException);
            }
        }
        CustomJreItem customJreItem = new CustomJreItem(string);
        this.c.add((Object)customJreItem);
        return customJreItem;
    }

    public JComponent getAnchor() {
        return this.a;
    }

    public void setAnchor(JComponent jComponent) {
        this.a = jComponent;
        this.i.setAnchor(jComponent);
    }

    public void addActionListener(ActionListener actionListener) {
        this.d.getComboBox().addActionListener(actionListener);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathOrName", "com/intellij/execution/ui/JrePathEditor", "findOrAddCustomJre"));
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private class DefaultJreItem
    implements JreComboBoxItem {
        private DefaultJreItem() {
        }

        @Override
        public void render(SimpleColoredComponent simpleColoredComponent, boolean bl2) {
            simpleColoredComponent.append(JrePathEditor.g);
            if (JrePathEditor.this.h != null) {
                simpleColoredComponent.append(JrePathEditor.this.h.getDescriptionString(), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }

        @Override
        public String getPresentableText() {
            return JrePathEditor.g;
        }

        @Override
        public String getPathOrName() {
            return null;
        }

        @Override
        public int getOrder() {
            return 0;
        }
    }

    static class CustomJreItem
    implements JreComboBoxItem {
        private final String a;

        public CustomJreItem(String string) {
            this.a = string;
        }

        @Override
        public void render(SimpleColoredComponent simpleColoredComponent, boolean bl2) {
            simpleColoredComponent.append(this.getPresentableText());
            simpleColoredComponent.setIcon(AllIcons.Nodes.Folder);
        }

        @Override
        public String getPresentableText() {
            return FileUtil.toSystemDependentName((String)this.a);
        }

        @Override
        public String getPathOrName() {
            return this.a;
        }

        @Override
        public int getOrder() {
            return 2;
        }
    }

    private static class SdkAsJreItem
    implements JreComboBoxItem {
        private final Sdk a;

        public SdkAsJreItem(Sdk sdk) {
            this.a = sdk;
        }

        @Override
        public void render(SimpleColoredComponent simpleColoredComponent, boolean bl2) {
            OrderEntryAppearanceService.getInstance().forJdk(this.a, false, bl2, true).customize(simpleColoredComponent);
        }

        @Override
        public String getPresentableText() {
            return this.a.getName();
        }

        @Override
        public String getPathOrName() {
            return this.a.getName();
        }

        @Override
        public int getOrder() {
            return 1;
        }
    }

    static interface JreComboBoxItem {
        public void render(SimpleColoredComponent var1, boolean var2);

        public String getPresentableText();

        @Nullable
        public String getPathOrName();

        public int getOrder();
    }
}

