/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.profiler.ui;

import com.intellij.ide.profiler.ui.AbstractDrawGraphics2DComponent;
import com.intellij.ide.profiler.ui.ChartNodeRenderer;
import com.intellij.ide.profiler.ui.model.AbstractRenderableCallUsage;
import com.intellij.ide.profiler.ui.model.ChartNode;
import com.intellij.ide.profiler.ui.model.Range;
import com.intellij.ide.profiler.ui.model.WithRenderableText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.UtilKt;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\u0018\u0000  *\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004:\u0004 !\"#B-\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J\u001e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J\u0014\u0010\u001c\u001a\u00020\u00122\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J\u000e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000fR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent;", "T", "Lcom/intellij/ide/profiler/ui/model/AbstractRenderableCallUsage;", "", "Lcom/intellij/ide/profiler/ui/AbstractDrawGraphics2DComponent;", "root", "Lcom/intellij/ide/profiler/ui/model/ChartNode;", "renderer", "Lcom/intellij/ide/profiler/ui/ChartNodeRenderer;", "orientation", "Lcom/intellij/ide/profiler/ui/TreeChartComponent$Orientation;", "(Lcom/intellij/ide/profiler/ui/model/ChartNode;Lcom/intellij/ide/profiler/ui/ChartNodeRenderer;Lcom/intellij/ide/profiler/ui/TreeChartComponent$Orientation;)V", "rect", "Ljava/awt/geom/Rectangle2D$Double;", "xRange", "Lcom/intellij/ide/profiler/ui/model/Range;", "yRange", "draw", "", "g", "Ljava/awt/Graphics2D;", "size", "Ljava/awt/Dimension;", "rangeToPosition", "", "v", "renderChartNode", "node", "setData", "data", "setXRange", "range", "Companion", "MyKeyListener", "MyMouseListener", "Orientation", "platform-ultimate"})
public final class TreeChartComponent<T extends AbstractRenderableCallUsage<? extends String>>
extends AbstractDrawGraphics2DComponent {
    private Range i;
    private Range f;
    private final Rectangle2D.Double l;
    private ChartNode<T> j;
    private final ChartNodeRenderer<T> g;
    private final Orientation k;
    private static final String b = "No data available.";
    private static final String e = "X range width is zero: Please use a wider range.";
    private static final int d = 2;
    private static final int c = 5;
    private static final Logger h;
    public static final Companion Companion;

    public final void setData(@NotNull ChartNode<T> chartNode) {
        Intrinsics.checkParameterIsNotNull(chartNode, (String)"data");
        this.j = chartNode;
    }

    public final void setXRange(@NotNull Range range) {
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        this.i = range;
    }

    @Override
    protected void draw(@NotNull Graphics2D graphics2D, @NotNull Dimension dimension) {
        Intrinsics.checkParameterIsNotNull((Object)graphics2D, (String)"g");
        Intrinsics.checkParameterIsNotNull((Object)dimension, (String)"size");
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartNode<T> chartNode = this.j;
        if (UtilKt.isNullOrEmpty((Collection)(chartNode != null ? chartNode.getChildren() : null))) {
            graphics2D.drawString(TreeChartComponent.Companion.c(), dimension.width / 2 - this.getDefaultFontMetrics().stringWidth(TreeChartComponent.Companion.c()), dimension.height / 2);
            return;
        }
        if (this.i.getLength() == 0.0) {
            graphics2D.drawString(TreeChartComponent.Companion.e(), dimension.width / 2 - this.getDefaultFontMetrics().stringWidth(TreeChartComponent.Companion.e()), dimension.height / 2);
            return;
        }
        Stack stack = new Stack();
        ChartNode<T> chartNode2 = this.j;
        if (chartNode2 == null) {
            Intrinsics.throwNpe();
        }
        stack.addAll(chartNode2.getChildren());
        while (!stack.isEmpty()) {
            ChartNode chartNode3;
            ChartNode chartNode4 = chartNode3 = (ChartNode)stack.pop();
            Intrinsics.checkExpressionValueIsNotNull((Object)chartNode4, (String)"n");
            this.a(graphics2D, chartNode4);
            stack.addAll(chartNode3.getChildren());
        }
    }

    private final void a(Graphics2D graphics2D, ChartNode<T> chartNode) {
        Rectangle2D.Double double_;
        if ((double)chartNode.getStart() > this.i.getMax() || (double)chartNode.getEnd() < this.i.getMin()) {
            return;
        }
        double d2 = RangesKt.coerceAtLeast((double)this.a(chartNode.getStart()), (double)0.0);
        double d3 = RangesKt.coerceAtMost((double)this.a(chartNode.getEnd()), (double)this.getWidth());
        double d4 = d3 - d2;
        Rectangle2D.Double double_2 = double_ = this.l;
        double_2.x = d2;
        double_2.y = (double)((this.getDefaultFontMetrics().getHeight() + TreeChartComponent.Companion.b()) * chartNode.getDepth()) - this.f.getMin();
        double_2.width = d4 - (double)TreeChartComponent.Companion.b();
        double_2.height = this.getDefaultFontMetrics().getHeight();
        if (Intrinsics.areEqual((Object)((Object)this.k), (Object)((Object)Orientation.BOTTOM_UP))) {
            this.l.y = (double)this.getHeight() - this.l.y - this.l.height;
        }
        T t2 = chartNode.getData();
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        this.g.render(graphics2D, (WithRenderableText)t2, this.l);
    }

    private final double a(double d2) {
        double d3 = -this.i.getMin();
        double d4 = (double)this.getWidth() / (this.i.getMax() - this.i.getMin());
        return (d2 + d3) * d4;
    }

    public TreeChartComponent(@Nullable ChartNode<T> chartNode, @NotNull ChartNodeRenderer<? super T> chartNodeRenderer, @NotNull Orientation orientation) {
        Intrinsics.checkParameterIsNotNull(chartNodeRenderer, (String)"renderer");
        Intrinsics.checkParameterIsNotNull((Object)((Object)orientation), (String)"orientation");
        super(null, 1, null);
        this.j = chartNode;
        this.g = chartNodeRenderer;
        this.k = orientation;
        this.i = new Range(0.0, 0.0);
        this.f = new Range(0.0, 0.0);
        this.l = new Rectangle2D.Double();
        this.addKeyListener(new MyKeyListener());
        this.addMouseListener(new MyMouseListener());
        this.setFocusable(true);
    }

    public /* synthetic */ TreeChartComponent(ChartNode chartNode, ChartNodeRenderer chartNodeRenderer, Orientation orientation, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            orientation = Orientation.BOTTOM_UP;
        }
        this(chartNode, chartNodeRenderer, orientation);
    }

    static {
        Companion = new Companion(null);
        b = b;
        e = e;
        d = 2;
        c = 5;
        h = Logger.getInstance((String)"#com.intellij.ide.profiler.ui.TreeChartComponent");
    }

    public static final /* synthetic */ void access$setXRange$p(TreeChartComponent treeChartComponent, @NotNull Range range) {
        treeChartComponent.i = range;
    }

    public static final /* synthetic */ void access$setYRange$p(TreeChartComponent treeChartComponent, @NotNull Range range) {
        treeChartComponent.f = range;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent$MyKeyListener;", "Ljava/awt/event/KeyListener;", "(Lcom/intellij/ide/profiler/ui/TreeChartComponent;)V", "keyPressed", "", "e", "Ljava/awt/event/KeyEvent;", "keyReleased", "keyTyped", "platform-ultimate"})
    private final class MyKeyListener
    implements KeyListener {
        @Override
        public void keyTyped(@NotNull KeyEvent keyEvent) {
            Intrinsics.checkParameterIsNotNull((Object)keyEvent, (String)"e");
        }

        @Override
        public void keyPressed(@NotNull KeyEvent keyEvent) {
            Intrinsics.checkParameterIsNotNull((Object)keyEvent, (String)"e");
        }

        @Override
        public void keyReleased(@NotNull KeyEvent keyEvent) {
            Intrinsics.checkParameterIsNotNull((Object)keyEvent, (String)"e");
            switch (keyEvent.getKeyCode()) {
                case 45: {
                    double d2 = TreeChartComponent.this.i.getLength() / (double)Companion.d();
                    TreeChartComponent.this.i.set(TreeChartComponent.this.i.getMin() - d2, TreeChartComponent.this.i.getMax() + d2);
                    TreeChartComponent.this.repaint();
                    break;
                }
                case 61: {
                    double d3 = TreeChartComponent.this.i.getLength() / (double)Companion.d();
                    TreeChartComponent.this.i.set(TreeChartComponent.this.i.getMin() + d3, TreeChartComponent.this.i.getMax() - d3);
                    TreeChartComponent.this.repaint();
                    break;
                }
                case 37: {
                    double d4 = TreeChartComponent.this.i.getLength() / (double)Companion.d();
                    TreeChartComponent.this.i.set(TreeChartComponent.this.i.getMin() - d4, TreeChartComponent.this.i.getMax() - d4);
                    TreeChartComponent.this.repaint();
                    break;
                }
                case 39: {
                    double d5 = TreeChartComponent.this.i.getLength() / (double)Companion.d();
                    TreeChartComponent.this.i.set(TreeChartComponent.this.i.getMin() + d5, TreeChartComponent.this.i.getMax() + d5);
                    TreeChartComponent.this.repaint();
                    break;
                }
                case 38: {
                    Range range = TreeChartComponent.this.f;
                    range.setMin(range.getMin() + (double)50);
                    TreeChartComponent.this.repaint();
                    break;
                }
                case 40: {
                    Range range = TreeChartComponent.this.f;
                    range.setMin(range.getMin() - (double)50);
                    TreeChartComponent.this.repaint();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent$MyMouseListener;", "Ljava/awt/event/MouseListener;", "(Lcom/intellij/ide/profiler/ui/TreeChartComponent;)V", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseEntered", "mouseExited", "mousePressed", "mouseReleased", "platform-ultimate"})
    private final class MyMouseListener
    implements MouseListener {
        @Override
        public void mouseClicked(@NotNull MouseEvent mouseEvent) {
            Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
            if (!TreeChartComponent.this.hasFocus()) {
                TreeChartComponent.this.requestFocusInWindow();
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent mouseEvent) {
            Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent mouseEvent) {
            Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent mouseEvent) {
            Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
        }

        @Override
        public void mouseExited(@NotNull MouseEvent mouseEvent) {
            Intrinsics.checkParameterIsNotNull((Object)mouseEvent, (String)"e");
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent$Orientation;", "", "(Ljava/lang/String;I)V", "TOP_DOWN", "BOTTOM_UP", "platform-ultimate"})
    public static final class Orientation
    extends Enum<Orientation> {
        public static final /* enum */ Orientation TOP_DOWN;
        public static final /* enum */ Orientation BOTTOM_UP;
        private static final /* synthetic */ Orientation[] a;

        static {
            Orientation[] orientationArray = new Orientation[2];
            Orientation[] orientationArray2 = orientationArray;
            orientationArray[0] = TOP_DOWN = new Orientation();
            orientationArray[1] = BOTTOM_UP = new Orientation();
            a = orientationArray;
        }

        public static Orientation[] values() {
            return (Orientation[])a.clone();
        }

        public static Orientation valueOf(String string) {
            return Enum.valueOf(Orientation.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0082D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lcom/intellij/ide/profiler/ui/TreeChartComponent$Companion;", "", "()V", "ACTION_MOVEMENT_FACTOR", "", "getACTION_MOVEMENT_FACTOR", "()I", "BORDER_PLUS_PADDING", "getBORDER_PLUS_PADDING", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "NO_HTREE", "", "getNO_HTREE", "()Ljava/lang/String;", "NO_RANGE", "getNO_RANGE", "platform-ultimate"})
    public static final class Companion {
        private final String c() {
            return b;
        }

        private final String e() {
            return e;
        }

        private final int b() {
            return d;
        }

        private final int d() {
            return c;
        }

        private final Logger a() {
            return h;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

