/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.profiler.ui.model;

import java.util.LinkedList;
import java.util.List;

public class Range {
    protected double myMin;
    protected double myMax;

    public Range(double d2, double d3) {
        this.myMin = d2;
        this.myMax = d3;
    }

    public Range() {
        this.clear();
    }

    public void setMin(double d2) {
        this.myMin = d2;
    }

    public void setMax(double d2) {
        this.myMax = d2;
    }

    public void set(double d2, double d3) {
        this.setMin(d2);
        this.setMax(d3);
    }

    public void set(Range range) {
        this.set(range.getMin(), range.getMax());
    }

    public double getMin() {
        return this.myMin;
    }

    public double getMax() {
        return this.myMax;
    }

    public double getLength() {
        return Math.abs(this.getMax() - this.getMin());
    }

    public boolean isPoint() {
        return this.getMax() == this.getMin();
    }

    public boolean isEmpty() {
        return this.myMin > this.myMax;
    }

    public boolean contains(double d2) {
        return this.myMin <= d2 && d2 <= this.myMax;
    }

    public void clear() {
        this.myMax = -1.7976931348623157E308;
        this.myMin = Double.MAX_VALUE;
    }

    public double clamp(double d2) {
        return Math.min(Math.max(this.getMin(), d2), this.getMax());
    }

    public void shift(double d2) {
        this.set(this.getMin() + d2, this.getMax() + d2);
    }

    public List<Range> subtract(Range range) {
        LinkedList<Range> linkedList = new LinkedList<Range>();
        Range range2 = this.getIntersection(range);
        if (range2.isEmpty()) {
            linkedList.add(this);
        } else {
            Range range3 = new Range(this.myMin, range2.getMin());
            Range range4 = new Range(range2.getMax(), this.myMax);
            if (!range3.isPoint()) {
                linkedList.add(range3);
            }
            if (!range4.isPoint()) {
                linkedList.add(range4);
            }
        }
        return linkedList;
    }

    public Range getIntersection(Range range) {
        if (this.isEmpty() || range.isEmpty() || range.getMin() > this.getMax() || range.getMax() < this.getMin()) {
            return new Range();
        }
        return new Range(Math.max(this.getMin(), range.getMin()), Math.min(this.getMax(), range.getMax()));
    }

    public void expand(double d2, double d3) {
        this.set(Math.min(d2, this.myMin), Math.max(d3, this.myMax));
    }
}

