/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ProgressIndicatorWrapper;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.DetectedSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.impl.ProjectFromSourcesBuilderImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import com.intellij.util.text.StringFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleInsight {
    private static final Logger e = Logger.getInstance((String)"#com.intellij.ide.util.importProject.ModuleInsight");
    @NotNull
    protected final ProgressIndicatorWrapper myProgress;
    private final Set<File> h = new HashSet<File>();
    private final List<DetectedSourceRoot> l = new ArrayList<DetectedSourceRoot>();
    private final Set<String> c = new HashSet<String>();
    private final Map<File, Set<String>> f = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> i = new HashMap<File, Set<String>>();
    private final Map<File, Set<String>> a = new HashMap<File, Set<String>>();
    private final StringInterner k = new StringInterner();
    private List<ModuleDescriptor> g;
    private List<LibraryDescriptor> b;
    private final Set<String> d;
    private final Set<String> j;

    public ModuleInsight(@Nullable ProgressIndicator progressIndicator, Set<String> set, Set<String> set2) {
        this.d = set;
        this.j = set2;
        this.myProgress = new ProgressIndicatorWrapper(progressIndicator);
        this.setRoots(Collections.emptyList(), Collections.emptyList(), Collections.emptySet());
    }

    public final void setRoots(List<File> list, List<? extends DetectedSourceRoot> list2, Set<String> set) {
        this.g = null;
        this.b = null;
        this.h.clear();
        this.h.addAll(list);
        this.l.clear();
        this.l.addAll(list2);
        this.c.clear();
        this.c.addAll(set);
        this.a.clear();
        this.k.clear();
    }

    @Nullable
    public List<LibraryDescriptor> getSuggestedLibraries() {
        return this.b;
    }

    @Nullable
    public List<ModuleDescriptor> getSuggestedModules() {
        return this.g;
    }

    public void scanModules() {
        this.myProgress.setIndeterminate(true);
        HashMap<File, ModuleDescriptor> hashMap = new HashMap<File, ModuleDescriptor>();
        try {
            Object object;
            HashSet<String> hashSet;
            File file;
            this.myProgress.pushState();
            ArrayList<DetectedSourceRoot> arrayList = new ArrayList<DetectedSourceRoot>();
            for (DetectedSourceRoot detectedSourceRoot : this.getSourceRootsToScan()) {
                file = detectedSourceRoot.getDirectory();
                try {
                    if (this.isIgnoredName(file)) {
                        continue;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
                this.myProgress.setText("Scanning " + file.getPath());
                hashSet = new HashSet();
                this.f.put(file, hashSet);
                object = new HashSet();
                this.addExportedPackages(file, (Set<String>)object);
                this.a(file, ProjectFromSourcesBuilderImpl.getPackagePrefix(detectedSourceRoot), hashSet, (Set<String>)object);
                hashSet.removeAll((Collection<?>)object);
                arrayList.add(detectedSourceRoot);
            }
            this.myProgress.popState();
            this.myProgress.pushState();
            this.myProgress.setText("Building modules layout...");
            for (DetectedSourceRoot detectedSourceRoot : arrayList) {
                File file2;
                file = detectedSourceRoot.getDirectory();
                try {
                    file2 = this.isEntryPointRoot(file) ? file : file.getParentFile();
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
                hashSet = file2;
                object = (ModuleDescriptor)hashMap.get(hashSet);
                try {
                    if (object != null) {
                        ((ModuleDescriptor)object).addSourceRoot((File)((Object)hashSet), detectedSourceRoot);
                        continue;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
                object = this.createModuleDescriptor((File)((Object)hashSet), (Collection<DetectedSourceRoot>)Collections.singletonList(detectedSourceRoot));
                hashMap.put((File)((Object)hashSet), (ModuleDescriptor)object);
            }
            this.a(hashMap);
            this.myProgress.popState();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
        this.addModules(hashMap.values());
    }

    protected void addExportedPackages(File file, Set<String> set) {
        this.i.put(file, set);
    }

    protected boolean isIgnoredName(File file) {
        return this.c.contains(file.getName());
    }

    protected void addModules(Collection<ModuleDescriptor> collection) {
        block4: {
            block3: {
                try {
                    if (this.g != null) break block3;
                    this.g = new ArrayList<ModuleDescriptor>(collection);
                    break block4;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
            }
            this.g.addAll(collection);
        }
        HashSet<String> hashSet = new HashSet<String>(this.d);
        for (ModuleDescriptor moduleDescriptor : collection) {
            String string = ModuleInsight.b(hashSet, moduleDescriptor.getName());
            moduleDescriptor.setName(string);
            hashSet.add(string);
        }
    }

    @NotNull
    protected List<DetectedSourceRoot> getSourceRootsToScan() {
        List<DetectedSourceRoot> list;
        try {
            list = Collections.unmodifiableList(this.l);
            if (list == null) {
                ModuleInsight.a(0);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw ModuleInsight.b((Exception)((Object)processCanceledException));
        }
        return list;
    }

    protected boolean isEntryPointRoot(File file) {
        return this.h.contains(file);
    }

    protected abstract ModuleDescriptor createModuleDescriptor(File var1, Collection<DetectedSourceRoot> var2);

    private void a(Map<File, ModuleDescriptor> map) {
        Set<File> set = map.keySet();
        for (File file : set) {
            ModuleDescriptor moduleDescriptor = map.get(file);
            this.myProgress.setText2("Building library dependencies for module " + moduleDescriptor.getName());
            this.a(moduleDescriptor);
            this.myProgress.setText2("Building module dependencies for module " + moduleDescriptor.getName());
            block5: for (File file2 : set) {
                ModuleDescriptor moduleDescriptor2 = map.get(file2);
                try {
                    if (moduleDescriptor.equals(moduleDescriptor2)) {
                        continue;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
                Collection<? extends DetectedProjectRoot> collection = moduleDescriptor2.getSourceRoots();
                for (DetectedProjectRoot detectedProjectRoot : moduleDescriptor.getSourceRoots()) {
                    Set<String> set2 = this.f.get(detectedProjectRoot.getDirectory());
                    for (DetectedProjectRoot detectedProjectRoot2 : collection) {
                        try {
                            if (!ContainerUtil.intersects(set2, (Collection)this.i.get(detectedProjectRoot2.getDirectory()))) continue;
                            moduleDescriptor.addDependencyOn(moduleDescriptor2);
                            continue block5;
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            throw ModuleInsight.b((Exception)((Object)processCanceledException));
                        }
                    }
                }
            }
        }
    }

    private void a(ModuleDescriptor moduleDescriptor) {
        block2: for (File file : this.a.keySet()) {
            Set<String> set = this.a.get(file);
            for (DetectedProjectRoot detectedProjectRoot : moduleDescriptor.getSourceRoots()) {
                try {
                    if (!ContainerUtil.intersects((Collection)this.f.get(detectedProjectRoot.getDirectory()), set)) continue;
                    moduleDescriptor.addLibraryFile(file);
                    continue block2;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scanLibraries() {
        this.myProgress.setIndeterminate(true);
        this.myProgress.pushState();
        try {
            try {
                for (File serializable2 : this.h) {
                    this.myProgress.setText("Scanning for libraries " + serializable2.getPath());
                    this.a(serializable2);
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                // empty catch block
            }
            this.myProgress.setText("Building initial libraries layout...");
            List<LibraryDescriptor> list = ModuleInsight.a(this.a.keySet());
            HashSet<String> hashSet = new HashSet<String>(this.j);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string;
                HashSet<String> hashSet2;
                LibraryDescriptor libraryDescriptor = (LibraryDescriptor)iterator.next();
                Collection<File> collection = libraryDescriptor.getJars();
                try {
                    hashSet2 = hashSet;
                    string = collection.size() == 1 ? FileUtil.getNameWithoutExtension((File)collection.iterator().next()) : libraryDescriptor.getName();
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
                String string2 = ModuleInsight.b(hashSet2, string);
                libraryDescriptor.setName(string2);
                hashSet.add(string2);
            }
            this.b = list;
        }
        finally {
            this.myProgress.popState();
        }
    }

    public abstract boolean isApplicableRoot(DetectedProjectRoot var1);

    private static String b(Set<String> set, String string) {
        String string2 = string;
        int n2 = 1;
        while (set.contains(string2)) {
            string2 = string + n2++;
        }
        return string2;
    }

    public void merge(ModuleDescriptor moduleDescriptor, ModuleDescriptor moduleDescriptor2) {
        for (File object : moduleDescriptor2.getContentRoots()) {
            File file = ModuleInsight.a(moduleDescriptor, object);
            Collection<DetectedSourceRoot> collection = moduleDescriptor2.getSourceRoots(object);
            for (DetectedSourceRoot detectedSourceRoot : collection) {
                moduleDescriptor.addSourceRoot(file, detectedSourceRoot);
            }
        }
        for (File file : moduleDescriptor2.getLibraryFiles()) {
            moduleDescriptor.addLibraryFile(file);
        }
        for (ModuleDescriptor moduleDescriptor3 : moduleDescriptor2.getDependencies()) {
            try {
                if (moduleDescriptor.equals(moduleDescriptor3)) continue;
                moduleDescriptor.addDependencyOn(moduleDescriptor3);
            }
            catch (ProcessCanceledException processCanceledException) {
                throw ModuleInsight.b((Exception)((Object)processCanceledException));
            }
        }
        this.g.remove(moduleDescriptor2);
        for (ModuleDescriptor moduleDescriptor4 : this.g) {
            try {
                try {
                    if (!moduleDescriptor4.getDependencies().contains(moduleDescriptor2)) continue;
                    moduleDescriptor4.removeDependencyOn(moduleDescriptor2);
                    if (moduleDescriptor4.equals(moduleDescriptor)) continue;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
                moduleDescriptor4.addDependencyOn(moduleDescriptor);
            }
            catch (ProcessCanceledException processCanceledException) {
                throw ModuleInsight.b((Exception)((Object)processCanceledException));
            }
        }
    }

    public LibraryDescriptor splitLibrary(LibraryDescriptor libraryDescriptor, String string, Collection<File> collection) {
        LibraryDescriptor libraryDescriptor2 = new LibraryDescriptor(string, collection);
        try {
            this.b.add(libraryDescriptor2);
            libraryDescriptor.removeJars(collection);
            if (libraryDescriptor.getJars().size() == 0) {
                this.removeLibrary(libraryDescriptor);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw ModuleInsight.b((Exception)((Object)processCanceledException));
        }
        return libraryDescriptor2;
    }

    @Nullable
    public ModuleDescriptor splitModule(ModuleDescriptor moduleDescriptor, String string, Collection<File> collection) {
        ModuleDescriptor moduleDescriptor2;
        block17: {
            block16: {
                moduleDescriptor2 = null;
                for (File object3 : collection) {
                    block15: {
                        HashSet<DetectedSourceRoot> hashSet;
                        block12: {
                            HashSet<DetectedSourceRoot> hashSet2;
                            File file;
                            ModuleInsight moduleInsight;
                            block14: {
                                block13: {
                                    hashSet = moduleDescriptor.removeContentRoot(object3);
                                    try {
                                        try {
                                            if (moduleDescriptor2 != null) break block12;
                                            moduleInsight = this;
                                            file = object3;
                                            if (hashSet == null) break block13;
                                        }
                                        catch (ProcessCanceledException processCanceledException) {
                                            throw ModuleInsight.b((Exception)((Object)processCanceledException));
                                        }
                                        hashSet2 = hashSet;
                                        break block14;
                                    }
                                    catch (ProcessCanceledException processCanceledException) {
                                        throw ModuleInsight.b((Exception)((Object)processCanceledException));
                                    }
                                }
                                hashSet2 = new HashSet<DetectedSourceRoot>();
                            }
                            moduleDescriptor2 = moduleInsight.createModuleDescriptor(file, hashSet2);
                            continue;
                        }
                        try {
                            if (hashSet == null || hashSet.size() <= 0) break block15;
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            throw ModuleInsight.b((Exception)((Object)processCanceledException));
                        }
                        for (Object object : hashSet) {
                            moduleDescriptor2.addSourceRoot(object3, (DetectedSourceRoot)object);
                        }
                        continue;
                    }
                    moduleDescriptor2.addContentRoot(object3);
                }
                try {
                    if (moduleDescriptor2 == null) break block16;
                    moduleDescriptor2.setName(string);
                    this.g.add(moduleDescriptor2);
                    break block17;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
            }
            return null;
        }
        HashMap hashMap = new HashMap();
        for (ModuleDescriptor moduleDescriptor3 : this.g) {
            Object object;
            Set<File> set = moduleDescriptor3.getContentRoots();
            object = set.iterator();
            while (object.hasNext()) {
                File file = (File)object.next();
                hashMap.put(file, moduleDescriptor3);
            }
            moduleDescriptor3.clearModuleDependencies();
            moduleDescriptor3.clearLibraryFiles();
        }
        this.a(hashMap);
        return moduleDescriptor2;
    }

    public void removeLibrary(LibraryDescriptor libraryDescriptor) {
        this.b.remove(libraryDescriptor);
    }

    public void moveJarsToLibrary(LibraryDescriptor libraryDescriptor, Collection<File> collection, LibraryDescriptor libraryDescriptor2) {
        try {
            libraryDescriptor2.addJars(collection);
            libraryDescriptor.removeJars(collection);
            if (libraryDescriptor.getJars().size() == 0) {
                this.removeLibrary(libraryDescriptor);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw ModuleInsight.b((Exception)((Object)processCanceledException));
        }
    }

    public Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor moduleDescriptor) {
        return ModuleInsight.getLibraryDependencies(moduleDescriptor, this.b);
    }

    public static Collection<LibraryDescriptor> getLibraryDependencies(ModuleDescriptor moduleDescriptor, @Nullable List<LibraryDescriptor> list) {
        HashSet<LibraryDescriptor> hashSet = new HashSet<LibraryDescriptor>();
        if (list != null) {
            for (LibraryDescriptor libraryDescriptor : list) {
                try {
                    if (!ContainerUtil.intersects(libraryDescriptor.getJars(), moduleDescriptor.getLibraryFiles())) continue;
                    hashSet.add(libraryDescriptor);
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                }
            }
        }
        return hashSet;
    }

    private static File a(ModuleDescriptor moduleDescriptor, File file) {
        Set<File> set = moduleDescriptor.getContentRoots();
        for (File file2 : set) {
            try {
                if (FileUtil.isAncestor((File)file2, (File)file, (boolean)false)) {
                    return file2;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw ModuleInsight.b((Exception)((Object)processCanceledException));
            }
            if (!FileUtil.isAncestor((File)file, (File)file2, (boolean)true)) continue;
            Collection<DetectedSourceRoot> collection = moduleDescriptor.getSourceRoots(file2);
            moduleDescriptor.removeContentRoot(file2);
            moduleDescriptor.addContentRoot(file);
            for (DetectedSourceRoot detectedSourceRoot : collection) {
                moduleDescriptor.addSourceRoot(file, detectedSourceRoot);
            }
            return file;
        }
        moduleDescriptor.addContentRoot(file);
        return file;
    }

    private static List<LibraryDescriptor> a(Set<File> set) {
        HashMap<File, LibraryDescriptor> hashMap = new HashMap<File, LibraryDescriptor>();
        for (File file : set) {
            File file2 = file.getParentFile();
            LibraryDescriptor libraryDescriptor = (LibraryDescriptor)hashMap.get(file2);
            if (libraryDescriptor == null) {
                libraryDescriptor = new LibraryDescriptor(file2.getName(), new HashSet<File>());
                hashMap.put(file2, libraryDescriptor);
            }
            libraryDescriptor.addJars(Collections.singleton(file));
        }
        return new ArrayList<LibraryDescriptor>(hashMap.values());
    }

    private void a(File file, String string, Set<String> set, Set<String> set2) {
        try {
            if (this.isIgnoredName(file)) {
                return;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw ModuleInsight.b((Exception)((Object)processCanceledException));
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.myProgress.checkCanceled();
            boolean bl2 = false;
            for (File file2 : fileArray) {
                block12: {
                    String string2;
                    StringBuilder stringBuilder;
                    block14: {
                        block13: {
                            try {
                                try {
                                    if (!file2.isDirectory()) break block12;
                                    stringBuilder = new StringBuilder().append(string);
                                    if (!string.isEmpty()) break block13;
                                }
                                catch (ProcessCanceledException processCanceledException) {
                                    throw ModuleInsight.b((Exception)((Object)processCanceledException));
                                }
                                string2 = "";
                                break block14;
                            }
                            catch (ProcessCanceledException processCanceledException) {
                                throw ModuleInsight.b((Exception)((Object)processCanceledException));
                            }
                        }
                        string2 = ".";
                    }
                    String string3 = stringBuilder.append(string2).append(file2.getName()).toString();
                    this.a(file2, string3, set, set2);
                    continue;
                }
                if (!this.isSourceFile(file2)) continue;
                bl2 = true;
                this.a(file2, set);
            }
            try {
                if (bl2) {
                    set2.add((String)this.k.intern((Object)string));
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw ModuleInsight.b((Exception)((Object)processCanceledException));
            }
        }
    }

    protected abstract boolean isSourceFile(File var1);

    private void a(File file, Set<String> set) {
        this.myProgress.setText2(file.getName());
        try {
            char[] cArray = FileUtil.loadFileText((File)file);
            this.scanSourceFileForImportedPackages(StringFactory.createShared((char[])cArray), (Consumer<String>)((Consumer)string -> set.add((String)this.k.intern(string))));
        }
        catch (IOException iOException) {
            e.info((Throwable)iOException);
        }
    }

    protected abstract void scanSourceFileForImportedPackages(CharSequence var1, Consumer<String> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(File file) {
        try {
            if (this.isIgnoredName(file)) {
                return;
            }
        }
        catch (IOException iOException) {
            throw ModuleInsight.b(iOException);
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            this.myProgress.checkCanceled();
            for (File file2 : fileArray) {
                try {
                    if (file2.isDirectory()) {
                        this.a(file2);
                        continue;
                    }
                }
                catch (IOException iOException) {
                    throw ModuleInsight.b(iOException);
                }
                String string2 = file2.getName();
                try {
                    if (!this.isLibraryFile(string2) || this.a.containsKey(file2)) continue;
                }
                catch (IOException iOException) {
                    throw ModuleInsight.b(iOException);
                }
                HashSet hashSet = new HashSet();
                this.a.put(file2, hashSet);
                this.myProgress.pushState();
                this.myProgress.setText2(file2.getName());
                try {
                    this.scanLibraryForDeclaredPackages(file2, (Consumer<String>)((Consumer)string -> {
                        try {
                            if (!hashSet.contains(string)) {
                                hashSet.add(this.k.intern(string));
                            }
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            throw ModuleInsight.b((Exception)((Object)processCanceledException));
                        }
                    }));
                }
                catch (IOException iOException) {
                    e.info((Throwable)iOException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    e.info((Throwable)illegalArgumentException);
                }
                catch (InternalError internalError) {
                    e.info((Throwable)internalError);
                }
                finally {
                    this.myProgress.popState();
                }
            }
        }
    }

    protected abstract boolean isLibraryFile(String var1);

    protected abstract void scanLibraryForDeclaredPackages(File var1, Consumer<String> var2) throws IOException;

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/importProject/ModuleInsight", "getSourceRootsToScan"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

