/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.util.newProjectWizard.LoadingProjectTemplate;
import com.intellij.ide.util.newProjectWizard.SelectTemplateSettings;
import com.intellij.ide.util.newProjectWizard.TemplatesGroup;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.templates.RemoteTemplatesFactory;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.util.containers.MultiMap;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectTypesList
implements Disposable {
    private final JBList c;
    private final CollectionListModel<TemplateItem> b;
    private MinusculeMatcher e;
    private Pair<TemplateItem, Integer> d;
    private TemplateItem a;

    public ProjectTypesList(JBList jBList, MultiMap<TemplatesGroup, ProjectTemplate> multiMap, final WizardContext wizardContext) {
        this.c = jBList;
        new ListSpeedSearch((JList)this.c){

            protected String getElementText(Object object) {
                return super.getElementText(object);
            }
        }.setComparator(new SpeedSearchComparator(false));
        List<TemplateItem> list = this.a(multiMap);
        TemplatesGroup templatesGroup = new TemplatesGroup("Loading Templates...", "", null, 0, null, null, null);
        this.a = new TemplateItem(new LoadingProjectTemplate(), templatesGroup){

            @Override
            Icon getIcon() {
                return null;
            }

            @Override
            String getDescription() {
                return "";
            }
        };
        list.add(this.a);
        this.b = new CollectionListModel(list);
        final RemoteTemplatesFactory remoteTemplatesFactory = new RemoteTemplatesFactory();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(wizardContext.getProject(), "Loading Templates"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(@NotNull ProgressIndicator progressIndicator) {
                try {
                    if (progressIndicator == null) {
                        3.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 3.a(illegalArgumentException);
                }
                try {
                    ProjectTypesList.this.c.setPaintBusy(true);
                    String[] stringArray = remoteTemplatesFactory.getGroups();
                    ArrayList<TemplateItem> arrayList = new ArrayList<TemplateItem>();
                    for (String string : stringArray) {
                        ProjectTemplate[] projectTemplateArray;
                        TemplatesGroup templatesGroup = new TemplatesGroup(string, "", remoteTemplatesFactory.getGroupIcon(string), 0, null, null, null);
                        for (ProjectTemplate projectTemplate : projectTemplateArray = remoteTemplatesFactory.createTemplates(string, wizardContext)) {
                            arrayList.add(new TemplateItem(projectTemplate, templatesGroup));
                        }
                    }
                    SwingUtilities.invokeLater(() -> {
                        int n2 = ProjectTypesList.this.c.getSelectedIndex();
                        ProjectTypesList.this.b.remove((Object)ProjectTypesList.this.a);
                        ProjectTypesList.this.b.add(arrayList);
                        ProjectTypesList.this.c.setSelectedIndex(n2);
                    });
                }
                finally {
                    ProjectTypesList.this.c.setPaintBusy(false);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/ide/util/newProjectWizard/ProjectTypesList$3", "run"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
        this.c.setCellRenderer((ListCellRenderer)new GroupedItemsListRenderer((ListItemDescriptor)new ListItemDescriptorAdapter(){

            @Nullable
            public String getTextFor(Object object) {
                return ((TemplateItem)object).getName();
            }

            @Nullable
            public Icon getIconFor(Object object) {
                return ((TemplateItem)object).getIcon();
            }

            public boolean hasSeparatorAboveOf(Object object) {
                TemplateItem templateItem = (TemplateItem)object;
                int n2 = ProjectTypesList.this.b.getElementIndex((Object)templateItem);
                return n2 == 0 || !((TemplateItem)ProjectTypesList.this.b.getElementAt(n2 - 1)).getGroupName().equals(templateItem.getGroupName());
            }

            @Nullable
            public String getCaptionAboveOf(Object object) {
                return ((TemplateItem)object).getGroupName();
            }
        }));
        this.c.setModel(this.b);
    }

    void installKeyAction(JComponent jComponent) {
        new AnAction(){

            public void actionPerformed(AnActionEvent anActionEvent) {
                InputEvent inputEvent = anActionEvent.getInputEvent();
                if (inputEvent instanceof KeyEvent) {
                    int n2 = ProjectTypesList.this.c.getSelectedIndex();
                    switch (((KeyEvent)inputEvent).getKeyCode()) {
                        case 38: {
                            int n3 = n2 == 0 ? ProjectTypesList.this.c.getItemsCount() - 1 : n2 - 1;
                            ProjectTypesList.this.c.setSelectedIndex(n3);
                            ProjectTypesList.this.c.ensureIndexIsVisible(n3);
                            break;
                        }
                        case 40: {
                            int n4 = n2 < ProjectTypesList.this.c.getItemsCount() - 1 ? n2 + 1 : 0;
                            ProjectTypesList.this.c.setSelectedIndex(n4);
                            ProjectTypesList.this.c.ensureIndexIsVisible(n4);
                        }
                    }
                }
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Integer[]{38, 40}), jComponent);
    }

    void resetSelection() {
        if (this.c.getSelectedIndex() != -1) {
            return;
        }
        SelectTemplateSettings selectTemplateSettings = SelectTemplateSettings.getInstance();
        if (selectTemplateSettings.getLastGroup() == null || !this.setSelectedTemplate(selectTemplateSettings.getLastGroup(), selectTemplateSettings.getLastTemplate())) {
            this.c.setSelectedIndex(0);
        }
    }

    void saveSelection() {
        TemplateItem templateItem = (TemplateItem)this.c.getSelectedValue();
        if (templateItem != null) {
            SelectTemplateSettings.getInstance().setLastTemplate(templateItem.getGroupName(), templateItem.getName());
        }
    }

    private List<TemplateItem> a(MultiMap<TemplatesGroup, ProjectTemplate> multiMap) {
        ArrayList<TemplateItem> arrayList = new ArrayList<TemplateItem>();
        ArrayList arrayList2 = new ArrayList(multiMap.keySet());
        Collections.sort(arrayList2);
        for (TemplatesGroup templatesGroup : arrayList2) {
            for (ProjectTemplate projectTemplate : multiMap.get((Object)templatesGroup)) {
                TemplateItem templateItem = new TemplateItem(projectTemplate, templatesGroup);
                arrayList.add(templateItem);
            }
        }
        return arrayList;
    }

    @Nullable
    public ProjectTemplate getSelectedTemplate() {
        Object object = this.c.getSelectedValue();
        return object instanceof TemplateItem ? ((TemplateItem)object).a : null;
    }

    public boolean setSelectedTemplate(@Nullable String string, @Nullable String string2) {
        for (int i2 = 0; i2 < this.c.getModel().getSize(); ++i2) {
            Object e2 = this.c.getModel().getElementAt(i2);
            if (!(e2 instanceof TemplateItem) || !((TemplateItem)e2).b.getName().equals(string) || !((TemplateItem)e2).getName().equals(string2)) continue;
            this.c.setSelectedIndex(i2);
            this.c.ensureIndexIsVisible(i2);
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    class TemplateItem {
        private final ProjectTemplate a;
        private final TemplatesGroup b;

        TemplateItem(ProjectTemplate projectTemplate, TemplatesGroup templatesGroup) {
            this.a = projectTemplate;
            this.b = templatesGroup;
        }

        String getName() {
            return this.a.getName();
        }

        public String getGroupName() {
            return this.b.getName();
        }

        Icon getIcon() {
            return this.a.createModuleBuilder().getNodeIcon();
        }

        protected int getMatchingDegree() {
            if (ProjectTypesList.this.e == null) {
                return Integer.MAX_VALUE;
            }
            String string = this.getName() + " " + this.getGroupName();
            String string2 = this.getDescription();
            if (string2 != null) {
                string = string + " " + StringUtil.stripHtml((String)string2, (boolean)false);
            }
            int n2 = ProjectTypesList.this.e.matchingDegree(string);
            if (ProjectTypesList.this.d == null || n2 > (Integer)((ProjectTypesList)ProjectTypesList.this).d.second) {
                ProjectTypesList.this.d = Pair.create((Object)this, (Object)n2);
            }
            return n2;
        }

        @Nullable
        String getDescription() {
            return this.a.getDescription();
        }

        public String toString() {
            return this.getName() + " " + this.getGroupName();
        }
    }
}

