/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.configurationStore;

import com.intellij.ProjectTopics;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectFilteringStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalProjectStorage;
import com.intellij.openapi.externalSystem.configurationStore.ExternalSystemStreamProviderFactoryKt;
import com.intellij.openapi.externalSystem.configurationStore.ModuleFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.configurationStore.ProjectFileSystemExternalSystemStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.roots.ProjectModelElement;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JB\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/openapi/externalSystem/configurationStore/ExternalSystemStreamProviderFactory;", "Lcom/intellij/configurationStore/StreamProviderFactory;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "getFileStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ProjectFileSystemExternalSystemStorage;", "isReimportOnMissedExternalStorageScheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "isStorageFlushInProgress", "", "moduleStorage", "Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "getModuleStorage", "()Lcom/intellij/openapi/externalSystem/configurationStore/ModuleFileSystemExternalSystemStorage;", "customizeStorageSpecs", "", "Lcom/intellij/openapi/components/Storage;", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "componentManager", "Lcom/intellij/openapi/components/ComponentManager;", "stateSpec", "Lcom/intellij/openapi/components/State;", "storages", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "readModuleData", "Lorg/jdom/Element;", "name", "", "external-system-impl"})
public final class ExternalSystemStreamProviderFactory
implements StreamProviderFactory {
    @NotNull
    private final ModuleFileSystemExternalSystemStorage a;
    @NotNull
    private final ProjectFileSystemExternalSystemStorage b;
    private boolean d;
    private final AtomicBoolean e;
    private final Project c;

    @NotNull
    public final ModuleFileSystemExternalSystemStorage getModuleStorage() {
        return this.a;
    }

    @NotNull
    public final ProjectFileSystemExternalSystemStorage getFileStorage() {
        return this.b;
    }

    @Nullable
    public List<Storage> customizeStorageSpecs(@NotNull PersistentStateComponent<?> persistentStateComponent, @NotNull ComponentManager componentManager, @NotNull State state, @NotNull List<Storage> list, @NotNull StateStorageOperation stateStorageOperation) {
        Object object;
        String string;
        Project project2;
        Intrinsics.checkParameterIsNotNull(persistentStateComponent, (String)"component");
        Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"componentManager");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"stateSpec");
        Intrinsics.checkParameterIsNotNull(list, (String)"storages");
        Intrinsics.checkParameterIsNotNull((Object)stateStorageOperation, (String)"operation");
        ComponentManager componentManager2 = componentManager;
        if (!(componentManager2 instanceof Project)) {
            componentManager2 = null;
        }
        if ((project2 = (Project)componentManager2) == null) {
            Project project3 = ((Module)componentManager).getProject();
            project2 = project3;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"(componentManager as Module).project");
        }
        Project project4 = project2;
        if (list.size() == 1 && Intrinsics.areEqual((Object)((Storage)CollectionsKt.first(list)).value(), (Object)"$WORKSPACE_FILE$") || !ProjectUtilCore.isExternalStorageEnabled((Project)project4)) {
            return null;
        }
        if (componentManager instanceof Project) {
            Storage storage = (Storage)CollectionsKt.firstOrNull(list);
            String string2 = string = storage != null ? storage.value() : null;
            if (Intrinsics.areEqual((Object)string, (Object)"libraries")) {
                ArrayList<FileStorageAnnotation> arrayList = new ArrayList<FileStorageAnnotation>(list.size() + 1);
                arrayList.add(new FileStorageAnnotation("" + string + ".xml", false, ExternalProjectFilteringStorage.class));
                arrayList.addAll((Collection)list);
                return arrayList;
            }
        }
        if (!(persistentStateComponent instanceof ProjectModelElement)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)stateStorageOperation, (Object)StateStorageOperation.WRITE) && ((ProjectModelElement)persistentStateComponent).getExternalSource() == null) {
            return null;
        }
        if (componentManager instanceof Project) {
            object = list.get(0).value();
            string = new FileStorageAnnotation((String)object, false, ExternalProjectStorage.class);
        } else {
            string = ExternalSystemStreamProviderFactoryKt.access$getEXTERNAL_MODULE_STORAGE_ANNOTATION$p();
        }
        if (state.externalStorageOnly()) {
            return CollectionsKt.listOf((Object)string);
        }
        object = new ArrayList(list.size() + 1);
        ((ArrayList)object).add(string);
        ((ArrayList)object).addAll((Collection)list);
        return (List)object;
    }

    @Nullable
    public final Element readModuleData(@NotNull String string) {
        Element element;
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"name");
        if (!this.a.getHasSomeData() && this.e.compareAndSet(false, true) && !this.c.isInitialized()) {
            StartupManager.getInstance((Project)this.c).runWhenProjectIsInitialized(new Runnable(this){
                final /* synthetic */ ExternalSystemStreamProviderFactory this$0;

                public final void run() {
                    ExternalProjectsManager externalProjectsManager = ExternalProjectsManager.getInstance((Project)ExternalSystemStreamProviderFactory.access$getProject$p(this.this$0));
                    externalProjectsManager.runWhenInitialized(new Runnable(externalProjectsManager){
                        final /* synthetic */ ExternalProjectsManager $externalProjectsManager;

                        public final void run() {
                            this.$externalProjectsManager.getExternalProjectsWatcher().markDirtyAllExternalProjects();
                        }
                        {
                            this.$externalProjectsManager = externalProjectsManager;
                        }
                    });
                }
                {
                    this.this$0 = externalSystemStreamProviderFactory;
                }
            });
        }
        if ((element = this.a.read(string)) != null) {
            // empty if block
        }
        return element;
    }

    public ExternalSystemStreamProviderFactory(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.c = project2;
        this.a = new ModuleFileSystemExternalSystemStorage(this.c);
        this.b = new ProjectFileSystemExternalSystemStorage(this.c);
        this.e = new AtomicBoolean(false);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.c).subscribe(ProjectEx.ProjectSaved.TOPIC, (Object)new ProjectEx.ProjectSaved(){

            public final void saved(@NotNull Project project2) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"it");
                if (project2 == c && !d && this.getModuleStorage().isDirty()) {
                    d = true;
                    ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public final void run() {
                            try {
                                Logger logger = ExternalSystemStreamProviderFactoryKt.access$getLOG$p();
                                try {
                                    this.getModuleStorage().forceSave();
                                }
                                catch (ProcessCanceledException processCanceledException) {
                                }
                                catch (Throwable throwable) {
                                    logger.error(throwable);
                                }
                            }
                            finally {
                                d = false;
                            }
                        }
                    });
                }
            }
        });
        this.c.getMessageBus().connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                String string = module2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
                moduleFileSystemExternalSystemStorage.remove(string);
            }

            public void modulesRenamed(@NotNull Project project2, @NotNull List<Module> list, @NotNull Function<Module, String> function) {
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                Intrinsics.checkParameterIsNotNull(list, (String)"modules");
                Intrinsics.checkParameterIsNotNull(function, (String)"oldNameProvider");
                for (Module module2 : list) {
                    ModuleFileSystemExternalSystemStorage moduleFileSystemExternalSystemStorage = this.getModuleStorage();
                    Object object = function.fun((Object)module2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"oldNameProvider.`fun`(module)");
                    String string = (String)object;
                    String string2 = module2.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"module.name");
                    moduleFileSystemExternalSystemStorage.rename(string, string2);
                }
            }
        });
    }

    @Nullable
    public StreamProvider createProvider(@NotNull ComponentManager componentManager, @NotNull StateStorageManager stateStorageManager) {
        Intrinsics.checkParameterIsNotNull((Object)componentManager, (String)"componentManager");
        Intrinsics.checkParameterIsNotNull((Object)stateStorageManager, (String)"storageManager");
        return StreamProviderFactory.DefaultImpls.createProvider((StreamProviderFactory)this, (ComponentManager)componentManager, (StateStorageManager)stateStorageManager);
    }
}

