/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectNode
extends ExternalSystemNode<ProjectData> {
    private String h;
    private boolean i = false;

    public ProjectNode(ExternalProjectsView externalProjectsView, DataNode<ProjectData> dataNode) {
        super(externalProjectsView, null, dataNode);
        this.updateProject();
    }

    protected void update(PresentationData presentationData) {
        super.update(presentationData);
        presentationData.setIcon(this.getUiAware().getProjectIcon());
    }

    public ExternalSystemNode getGroup() {
        return (ExternalSystemNode)this.getParent();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode> doBuildChildren() {
        List list;
        List list2;
        block9: {
            List<ExternalSystemNode> list3;
            block10: {
                List<ExternalSystemNode> list4 = super.doBuildChildren();
                list2 = ContainerUtil.filter(list4, externalSystemNode -> externalSystemNode.isVisible());
                try {
                    try {
                        try {
                            if (list2.size() != 1 || !((ExternalSystemNode)list2.get(0)).getName().equals(this.getName())) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw ProjectNode.b(illegalStateException);
                        }
                        this.i = true;
                        list3 = ((ExternalSystemNode)list2.get(0)).doBuildChildren();
                        if (list3 != null) break block10;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ProjectNode.b(illegalStateException);
                    }
                    ProjectNode.b(0);
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectNode.b(illegalStateException);
                }
            }
            return list3;
        }
        try {
            this.i = false;
            list = list2;
            if (list == null) {
                ProjectNode.b(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectNode.b(illegalStateException);
        }
        return list;
    }

    public boolean isSingleModuleProject() {
        this.getChildren();
        return this.i;
    }

    void updateProject() {
        this.h = this.a();
        this.getStructure().updateFrom(this.getParent());
    }

    public String getName() {
        String string;
        ProjectData projectData = (ProjectData)this.getData();
        try {
            string = projectData != null ? projectData.getExternalName() : "unspecified";
        }
        catch (IllegalStateException illegalStateException) {
            throw ProjectNode.b(illegalStateException);
        }
        return string;
    }

    @Override
    protected void doUpdate() {
        String string;
        block3: {
            string = null;
            ProjectData projectData = (ProjectData)this.getData();
            if (projectData != null) {
                AbstractExternalSystemSettings abstractExternalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.getExternalProjectsView().getProject(), (ProjectSystemId)((ProjectData)this.getData()).getOwner());
                ExternalProjectSettings externalProjectSettings = abstractExternalSystemSettings.getLinkedProjectSettings(projectData.getLinkedExternalProjectPath());
                try {
                    if (externalProjectSettings == null || !externalProjectSettings.isUseAutoImport()) break block3;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectNode.b(illegalStateException);
                }
                string = "auto-import enabled";
            }
        }
        this.setNameAndTooltip(this.getName(), this.h, string);
    }

    protected SimpleTextAttributes getPlainAttributes() {
        return super.getPlainAttributes();
    }

    private String a() {
        String string;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2;
        block7: {
            block6: {
                String string2;
                StringBuilder stringBuilder3;
                stringBuilder2 = new StringBuilder();
                ProjectData projectData = (ProjectData)this.getData();
                try {
                    stringBuilder3 = stringBuilder2.append("<table><tr><td nowrap><table><tr><td nowrap>Project:</td><td nowrap>").append(this.getName()).append("</td></tr>");
                    string2 = projectData != null ? "<tr><td nowrap>Location:</td><td nowrap>" + projectData.getLinkedExternalProjectPath() + "</td></tr>" : "";
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectNode.b(illegalStateException);
                }
                try {
                    try {
                        stringBuilder = stringBuilder3.append(string2);
                        if (projectData == null || StringUtil.isEmptyOrSpaces((String)projectData.getDescription())) break block6;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw ProjectNode.b(illegalStateException);
                    }
                    string = "<tr><td colspan='2' nowrap><hr align='center' width='90%' />" + projectData.getDescription() + "</td></tr>";
                    break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    throw ProjectNode.b(illegalStateException);
                }
            }
            string = "";
        }
        stringBuilder.append(string).append("</td></tr></table></td></tr>");
        this.a(stringBuilder2);
        stringBuilder2.append("</table>");
        return stringBuilder2.toString();
    }

    private void a(StringBuilder stringBuilder) {
    }

    @Override
    protected void setNameAndTooltip(String string, @Nullable String string2, SimpleTextAttributes simpleTextAttributes) {
        super.setNameAndTooltip(string, string2, simpleTextAttributes);
    }

    @Override
    @Nullable
    @NonNls
    protected String getMenuId() {
        return "ExternalSystemView.ProjectMenu";
    }

    private static /* synthetic */ void b(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/view/ProjectNode", "doBuildChildren"));
    }

    private static IllegalStateException b(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

