/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderEventManager;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.Magnificator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class GraphEventManager
extends GraphBuilderEventManager {
    private final Graph2DView g;
    private final EditMode a;
    private final ViewMode b = new NavigationMode();
    private final MagnifierViewMode e = new MagnifierViewMode();
    private volatile boolean d = false;
    private volatile boolean h = false;
    private final List<GraphBuilderListener> f = new ArrayList<GraphBuilderListener>();
    private final GraphBuilder c;
    private boolean i = false;

    GraphEventManager(EditMode editMode, GraphBuilder graphBuilder) {
        this.c = graphBuilder;
        this.g = graphBuilder.getView();
        this.a = editMode;
        this.e.setMagnifierRadius(150);
        Disposer.register((Disposable)graphBuilder, (Disposable)this);
        JComponent jComponent = this.g.getCanvasComponent();
        jComponent.addMouseMotionListener((MouseMotionListener)((Object)this));
        jComponent.addKeyListener((KeyListener)((Object)this));
        jComponent.addMouseWheelListener((MouseWheelListener)((Object)this));
        jComponent.addFocusListener((FocusListener)((Object)this));
        jComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (GraphEventManager.this.i) {
                    GraphEventManager.this.i = false;
                    GraphEventManager.this.a(GraphBuilderEvent.NODES_MOVED, false);
                }
            }
        });
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown() && !mouseEvent.isAltDown()) {
            this.a();
        } else if (mouseEvent.isAltDown() && !mouseEvent.isControlDown()) {
            this.c();
        } else {
            if (!this.i) {
                this.i = true;
                this.a(GraphBuilderEvent.NODES_MOVED, true);
            }
            this.b();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!mouseEvent.isAltDown() && this.h || !mouseEvent.isControlDown() && this.d) {
            this.b();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n2 = keyEvent.getKeyCode();
        boolean bl2 = keyEvent.isAltDown();
        boolean bl3 = keyEvent.isControlDown();
        if (bl3 && GraphEventManager.b(n2)) {
            this.a(n2);
        } else if (n2 == 17 && !bl2) {
            this.a();
        } else if (n2 == 18 && !bl3) {
            this.c();
        } else {
            this.b();
        }
    }

    private void a(int n2) {
        Graph2D graph2D = this.g.getGraph2D();
        List list = GraphViewUtil.getSelectedNodes((Graph2D)graph2D);
        if (list.size() > 0) {
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, true);
            for (Node node : list) {
                NodeRealizer nodeRealizer = graph2D.getRealizer(node);
                nodeRealizer.setX(nodeRealizer.getX() + (double)(3 * (n2 == 37 ? -1 : (n2 == 39 ? 1 : 0))));
                nodeRealizer.setY(nodeRealizer.getY() + (double)(3 * (n2 == 38 ? -1 : (n2 == 40 ? 1 : 0))));
            }
            graph2D.updateViews();
            this.a(GraphBuilderEvent.NODES_MOVED_BY_KEYBOARD, false);
        }
    }

    private static boolean b(int n2) {
        return n2 == 37 || n2 == 39 || n2 == 40 || n2 == 38;
    }

    private synchronized void a() {
        if (!this.d) {
            this.g.setDrawingMode(Graph2DView.NORMAL_MODE);
            this.a.setEditing(false);
            this.a.reactivateParent();
            this.d = true;
            this.g.removeViewMode((ViewMode)(this.h ? this.e : this.a));
            this.h = false;
            this.g.addViewMode(this.b);
        }
    }

    private synchronized void c() {
        if (!this.h) {
            this.h = true;
            double d2 = this.g.getZoom();
            d2 = d2 < 1.0 ? 1.5 / d2 : 2.0 * d2;
            this.e.setMagnifierZoomFactor(d2);
            this.g.removeViewMode((ViewMode)(this.d ? this.b : this.a));
            this.d = false;
            this.g.addViewMode((ViewMode)this.e);
        }
    }

    private synchronized void b() {
        if (this.d) {
            this.a(GraphBuilderEvent.GRAPH_MOVED, false);
            this.d = false;
            this.g.removeViewMode(this.b);
            this.g.addViewMode((ViewMode)this.a);
        } else if (this.h) {
            this.h = false;
            this.g.removeViewMode((ViewMode)this.e);
            this.g.updateView();
            this.g.addViewMode((ViewMode)this.a);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 18) {
            this.b();
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n2 = mouseWheelEvent.getWheelRotation();
        if (n2 == 0) {
            return;
        }
        if (mouseWheelEvent.isControlDown()) {
            double d2 = this.g.getZoom() - (double)n2 * 0.1;
            Magnificator magnificator = (Magnificator)UIUtil.getParentOfType(Magnificator.class, (Component)this.g.getCanvasComponent());
            if (magnificator != null) {
                magnificator.magnify(d2 / this.g.getZoom(), mouseWheelEvent.getPoint());
            }
        }
    }

    public double zoomView(double d2) {
        this.a(GraphBuilderEvent.ZOOM_CHANGED, true);
        double d3 = Math.min(10.0, Math.max(d2, 0.1));
        this.g.setZoom(d3);
        this.g.updateView();
        this.a(GraphBuilderEvent.ZOOM_CHANGED, false);
        return d3;
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        this.b();
    }

    public void subscribe(GraphBuilderListener graphBuilderListener) {
        if (!this.f.contains(graphBuilderListener)) {
            this.f.add(graphBuilderListener);
        }
    }

    public void dispose() {
        this.f.clear();
    }

    private void a(GraphBuilderEvent graphBuilderEvent, boolean bl2) {
        for (GraphBuilderListener graphBuilderListener : this.f) {
            if (bl2) {
                graphBuilderListener.beforeActionPerformed(this.c, graphBuilderEvent);
                continue;
            }
            graphBuilderListener.actionPerformed(this.c, graphBuilderEvent);
        }
    }
}

