/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.impl.storage.ClasspathStorageProvider;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanelImpl;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ClasspathEditor
extends ModuleElementsEditor
implements ModuleRootListener {
    public static final String NAME = ProjectBundle.message((String)"modules.classpath.title", (Object[])new Object[0]);
    private ClasspathPanelImpl b;
    private ClasspathFormatPanel a;

    public ClasspathEditor(ModuleConfigurationState moduleConfigurationState) {
        super(moduleConfigurationState);
        Disposable disposable = Disposer.newDisposable();
        moduleConfigurationState.getProject().getMessageBus().connect(disposable).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)this);
        this.registerDisposable(disposable);
    }

    public boolean isModified() {
        boolean bl2;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (super.isModified()) break block6;
                                if (this.a == null) break block7;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw ClasspathEditor.a(illegalArgumentException);
                            }
                            if (!this.a.c()) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ClasspathEditor.a(illegalArgumentException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ClasspathEditor.a(illegalArgumentException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public String getHelpTopic() {
        return "projectStructure.modules.dependencies";
    }

    public String getDisplayName() {
        return NAME;
    }

    public void saveData() {
        this.b.stopEditing();
    }

    public void apply() throws ConfigurationException {
        try {
            if (this.a != null) {
                this.a.b();
            }
        }
        catch (ConfigurationException configurationException) {
            throw ClasspathEditor.a((Exception)((Object)configurationException));
        }
    }

    public void canApply() throws ConfigurationException {
        try {
            super.canApply();
            if (this.a != null) {
                this.a.canApply();
            }
        }
        catch (ConfigurationException configurationException) {
            throw ClasspathEditor.a((Exception)((Object)configurationException));
        }
    }

    public JComponent createComponentImpl() {
        this.b = new ClasspathPanelImpl(this.getState());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.add((Component)this.b, "Center");
        ModuleJdkConfigurable moduleJdkConfigurable = new ModuleJdkConfigurable(this, ProjectStructureConfigurable.getInstance(this.myProject).getProjectJdksModel()){

            @Override
            protected ModifiableRootModel getRootModel() {
                return ClasspathEditor.this.getState().getRootModel();
            }
        };
        jPanel.add((Component)moduleJdkConfigurable.createComponent(), "North");
        moduleJdkConfigurable.reset();
        this.registerDisposable(moduleJdkConfigurable);
        ClasspathStorageProvider[] classpathStorageProviderArray = (ClasspathStorageProvider[])ClasspathStorageProvider.EXTENSION_POINT_NAME.getExtensions();
        try {
            if (classpathStorageProviderArray.length > 0) {
                this.a = new ClasspathFormatPanel(classpathStorageProviderArray, this.getModel());
                jPanel.add((Component)this.a, "South");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ClasspathEditor.a(illegalArgumentException);
        }
        return jPanel;
    }

    public void selectOrderEntry(@NotNull OrderEntry orderEntry) {
        try {
            if (orderEntry == null) {
                ClasspathEditor.a(0);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ClasspathEditor.a(illegalArgumentException);
        }
        this.b.selectOrderEntry(orderEntry);
    }

    public void moduleStateChanged() {
        try {
            if (this.b != null) {
                this.b.initFromModel();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ClasspathEditor.a(illegalArgumentException);
        }
    }

    public void rootsChanged(ModuleRootEvent moduleRootEvent) {
        try {
            if (this.b != null) {
                this.b.rootsChanged();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ClasspathEditor.a(illegalArgumentException);
        }
    }

    public void setSdk(Sdk sdk) {
        block6: {
            ModifiableRootModel modifiableRootModel;
            block5: {
                modifiableRootModel = this.getModel();
                try {
                    if (sdk == null) break block5;
                    modifiableRootModel.setSdk(sdk);
                    break block6;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ClasspathEditor.a(illegalArgumentException);
                }
            }
            modifiableRootModel.inheritSdk();
        }
        try {
            if (this.b != null) {
                this.b.forceInitFromModel();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ClasspathEditor.a(illegalArgumentException);
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/openapi/roots/ui/configuration/ClasspathEditor", "selectOrderEntry"));
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    private static class ClasspathFormatPanel
    extends JPanel {
        private final ModifiableRootModel a;
        private final JComboBox<String> b;

        private ClasspathFormatPanel(ClasspathStorageProvider[] classpathStorageProviderArray, ModifiableRootModel modifiableRootModel) {
            super(new GridBagLayout());
            this.a = modifiableRootModel;
            this.add((Component)new JLabel(ProjectBundle.message((String)"project.roots.classpath.format.label", (Object[])new Object[0])), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insets((int)10, (int)6, (int)6, (int)0), 0, 0));
            final LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("default", ProjectBundle.message((String)"project.roots.classpath.format.default.descr", (Object[])new Object[0]));
            for (ClasspathStorageProvider classpathStorageProvider : classpathStorageProviderArray) {
                linkedHashMap.put(classpathStorageProvider.getID(), classpathStorageProvider.getDescription());
            }
            this.b = new ComboBox((Object[])ArrayUtil.toStringArray(linkedHashMap.keySet()));
            this.b.setRenderer((ListCellRenderer<String>)new ListCellRendererWrapper<String>(){

                public void customize(JList jList, String string, int n2, boolean bl2, boolean bl3) {
                    this.setText((String)linkedHashMap.get(string));
                }
            });
            this.b.setSelectedItem(this.d());
            this.add(this.b, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.insets((int)6, (int)6, (int)6, (int)0), 0, 0));
        }

        private String a() {
            return (String)this.b.getSelectedItem();
        }

        private String d() {
            return ClassPathStorageUtil.getStorageType((Module)this.a.getModule());
        }

        private boolean c() {
            return !this.a().equals(this.d());
        }

        public void canApply() throws ConfigurationException {
            ClasspathStorageProvider classpathStorageProvider = ClasspathStorage.getProvider((String)this.a());
            try {
                if (classpathStorageProvider != null) {
                    classpathStorageProvider.assertCompatible((ModuleRootModel)this.a);
                }
            }
            catch (ConfigurationException configurationException) {
                throw ClasspathFormatPanel.b(configurationException);
            }
        }

        private void b() throws ConfigurationException {
            this.canApply();
            ClasspathStorage.setStorageType((ModuleRootModel)this.a, (String)this.a());
        }

        private static ConfigurationException b(ConfigurationException configurationException) {
            return configurationException;
        }
    }
}

