/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.openapi.roots.ui.configuration.TableItem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JavadocEditor
extends ModuleElementsEditor {
    private JTable b;
    private static final String a = ProjectBundle.message((String)"module.javadoc.title", (Object[])new Object[0]);

    public JavadocEditor(ModuleConfigurationState moduleConfigurationState) {
        super(moduleConfigurationState);
    }

    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }

    public String getDisplayName() {
        return a;
    }

    public void saveData() {
        TableUtil.stopEditing((JTable)this.b);
        int n2 = this.b.getRowCount();
        String[] stringArray = ArrayUtil.newStringArray((int)n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            TableItem tableItem = ((MyTableModel)this.b.getModel()).getTableItemAt(i2);
            stringArray[i2] = tableItem.getUrl();
        }
        ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(stringArray);
        this.fireConfigurationChanged();
    }

    public JComponent createComponentImpl() {
        DefaultTableModel defaultTableModel = this.createModel();
        this.b = new JBTable((TableModel)defaultTableModel);
        this.b.setIntercellSpacing(new Dimension(0, 0));
        this.b.setDefaultRenderer(TableItem.class, (TableCellRenderer)((Object)new MyRenderer()));
        this.b.setShowGrid(false);
        this.b.setDragEnabled(false);
        this.b.setShowHorizontalLines(false);
        this.b.setShowVerticalLines(false);
        this.b.getSelectionModel().setSelectionMode(2);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.b).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleJavaPathDescriptor();
                fileChooserDescriptor.setTitle(ProjectBundle.message((String)"module.javadoc.add.path.title", (Object[])new Object[0]));
                fileChooserDescriptor.setDescription(ProjectBundle.message((String)"module.javadoc.add.path.prompt", (Object[])new Object[0]));
                VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Component)JavadocEditor.this.b, (Project)JavadocEditor.this.myProject, null);
                MyTableModel myTableModel = (MyTableModel)JavadocEditor.this.b.getModel();
                boolean bl2 = false;
                for (VirtualFile virtualFile : virtualFileArray) {
                    if (virtualFile == null) continue;
                    myTableModel.addTableItem(new TableItem(virtualFile));
                    bl2 = true;
                }
                if (bl2) {
                    JavadocEditor.this.saveData();
                    TableUtil.selectRows((JTable)JavadocEditor.this.b, (int[])new int[]{myTableModel.getRowCount() - 1});
                }
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(ProjectBundle.message((String)"module.javadoc.add.url.button", (Object[])new Object[0]), IconUtil.getAddLinkIcon()){

            public void actionPerformed(AnActionEvent anActionEvent) {
                VirtualFile[] virtualFileArray = new VirtualFile[]{Util.showSpecifyJavadocUrlDialog((JComponent)JavadocEditor.this.b)};
                MyTableModel myTableModel = (MyTableModel)JavadocEditor.this.b.getModel();
                boolean bl2 = false;
                for (VirtualFile virtualFile : virtualFileArray) {
                    if (virtualFile == null) continue;
                    myTableModel.addTableItem(new TableItem(virtualFile));
                    bl2 = true;
                }
                if (bl2) {
                    JavadocEditor.this.saveData();
                    TableUtil.selectRows((JTable)JavadocEditor.this.b, (int[])new int[]{myTableModel.getRowCount() - 1});
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                List list = TableUtil.removeSelectedItems((JTable)JavadocEditor.this.b);
                if (list.size() > 0) {
                    JavadocEditor.this.saveData();
                }
            }
        }).setButtonComparator(new String[]{"Add", ProjectBundle.message((String)"module.javadoc.add.url.button", (Object[])new Object[0]), "Remove"}).createPanel();
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        jPanel2.add((Component)new JBLabel(ProjectBundle.message((String)"project.roots.javadoc.tab.description", (Object[])new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER), "North");
        return jPanel2;
    }

    protected DefaultTableModel createModel() {
        String[] stringArray;
        MyTableModel myTableModel = new MyTableModel();
        for (String string : stringArray = ((JavaModuleExternalPaths)this.getModel().getModuleExtension(JavaModuleExternalPaths.class)).getJavadocUrls()) {
            myTableModel.addTableItem(new TableItem(string));
        }
        return myTableModel;
    }

    public void moduleStateChanged() {
        if (this.b != null) {
            DefaultTableModel defaultTableModel = this.createModel();
            this.b.setModel(defaultTableModel);
        }
    }

    private static class MyTableModel
    extends DefaultTableModel
    implements ItemRemovable {
        private MyTableModel() {
        }

        @Override
        public String getColumnName(int n2) {
            return null;
        }

        public Class getColumnClass(int n2) {
            return TableItem.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return false;
        }

        public TableItem getTableItemAt(int n2) {
            return (TableItem)this.getValueAt(n2, 0);
        }

        public void addTableItem(TableItem tableItem) {
            this.addRow(new Object[]{tableItem});
        }
    }

    private static class MyRenderer
    extends ColoredTableCellRenderer {
        private static final Border a = BorderFactory.createEmptyBorder(1, 1, 1, 1);

        private MyRenderer() {
        }

        protected void customizeCellRenderer(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            this.setPaintFocusBorder(false);
            this.setFocusBorderAroundIcon(true);
            this.setBorder(a);
            TableItem tableItem = (TableItem)object;
            if (tableItem != null) {
                tableItem.getCellAppearance().customize((SimpleColoredComponent)this);
            }
        }
    }
}

