/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.AnnotationsEditor;
import com.intellij.openapi.roots.ui.configuration.BuildElementsEditor;
import com.intellij.openapi.roots.ui.configuration.JavadocEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleConfigurationState;
import com.intellij.openapi.roots.ui.configuration.ModuleElementsEditor;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class OutputEditor
extends ModuleElementsEditor {
    public static final String NAME = ProjectBundle.message((String)"project.roots.path.tab.title", (Object[])new Object[0]);
    private final BuildElementsEditor b;
    private final JavadocEditor c;
    private final AnnotationsEditor d;
    private final List<ModuleElementsEditor> a;

    protected OutputEditor(ModuleConfigurationState moduleConfigurationState) {
        super(moduleConfigurationState);
        this.b = new BuildElementsEditor(moduleConfigurationState);
        this.c = new JavadocEditor(moduleConfigurationState);
        this.d = new AnnotationsEditor(moduleConfigurationState);
        this.a = Arrays.asList(new ModuleElementsEditor[]{this.b, this.c, this.d});
        this.a.forEach(moduleElementsEditor -> moduleElementsEditor.addListener(() -> ((OutputEditor)this).fireConfigurationChanged()));
    }

    protected JComponent createComponentImpl() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new EmptyBorder(UIUtil.PANEL_SMALL_INSETS));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0);
        jPanel.add((Component)this.b.createComponentImpl(), gridBagConstraints);
        JPanel jPanel2 = (JPanel)this.c.createComponentImpl();
        jPanel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.c.getDisplayName(), (boolean)false));
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JPanel jPanel3 = (JPanel)this.d.createComponentImpl();
        jPanel3.setBorder((Border)IdeBorderFactory.createTitledBorder((String)this.d.getDisplayName(), (boolean)false));
        jPanel.add((Component)jPanel3, gridBagConstraints);
        return jPanel;
    }

    public void saveData() {
        super.saveData();
        this.a.forEach(ModuleConfigurationEditor::saveData);
    }

    public String getDisplayName() {
        return NAME;
    }

    public void moduleStateChanged() {
        super.moduleStateChanged();
        this.a.forEach(ModuleConfigurationEditor::moduleStateChanged);
    }

    public void moduleCompileOutputChanged(String string, String string2) {
        super.moduleCompileOutputChanged(string, string2);
        this.a.forEach(moduleElementsEditor -> moduleElementsEditor.moduleCompileOutputChanged(string, string2));
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "projectStructure.modules.paths";
    }
}

